/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.ErrorEstimate;
import visad.Gridded1DSet;
import visad.GriddedSet;
import visad.MathType;
import visad.SetException;
import visad.Unit;
import visad.VisADException;

public class Gridded2DSet
extends GriddedSet {
    public int D;
    public int p;
    public float n;
    public float b;
    public float x;
    public float z;
    private int r = -1;
    private int o = -1;

    public Gridded2DSet(MathType mathType, float[][] fArray, int n2, int n3) throws VisADException {
        this(mathType, fArray, n2, n3, null, null, null);
    }

    public Gridded2DSet(MathType mathType, float[][] fArray, int n2, int n3, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray) throws VisADException {
        this(mathType, fArray, n2, n3, coordinateSystem, unitArray, errorEstimateArray, true, true);
    }

    public Gridded2DSet(MathType mathType, float[][] fArray, int n2, int n3, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, boolean bl2) throws VisADException {
        this(mathType, fArray, n2, n3, coordinateSystem, unitArray, errorEstimateArray, true, true);
    }

    public Gridded2DSet(MathType mathType, float[][] fArray, int n2, int n3, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, boolean bl2, boolean bl3) throws VisADException {
        super(mathType, fArray, Gridded2DSet.a(n2, n3), coordinateSystem, unitArray, errorEstimateArray, bl2);
        this.n = this.j[0];
        this.b = this.l[0];
        this.D = this.i[0];
        this.x = this.j[1];
        this.z = this.l[1];
        this.p = this.i[1];
        if (this.k != null && this.i[0] > 1 && this.i[1] > 1) {
            boolean bl4 = this.v = (this.k[0][1] - this.k[0][0]) * (this.k[1][this.D + 1] - this.k[1][1]) - (this.k[1][1] - this.k[1][0]) * (this.k[0][this.D + 1] - this.k[0][1]) > 0.0f;
            if (bl3) {
                int n4 = 0;
                while (n4 < this.B) {
                    if (this.k[0][n4] != this.k[0][n4]) {
                        throw new SetException("Gridded2DSet: samples value #" + n4 + " may not be missing");
                    }
                    ++n4;
                }
                int n5 = 0;
                while (n5 < this.p - 1) {
                    int n6 = 0;
                    while (n6 < this.D - 1) {
                        float[] fArray2 = new float[2];
                        float[] fArray3 = new float[2];
                        float[] fArray4 = new float[2];
                        float[] fArray5 = new float[2];
                        int n7 = 0;
                        while (n7 < 2) {
                            fArray2[n7] = this.k[n7][n5 * this.D + n6];
                            fArray3[n7] = this.k[n7][n5 * this.D + n6 + 1];
                            fArray4[n7] = this.k[n7][(n5 + 1) * this.D + n6];
                            fArray5[n7] = this.k[n7][(n5 + 1) * this.D + n6 + 1];
                            ++n7;
                        }
                        if ((fArray3[0] - fArray2[0]) * (fArray5[1] - fArray3[1]) - (fArray3[1] - fArray2[1]) * (fArray5[0] - fArray3[0]) > 0.0f != this.v || (fArray5[0] - fArray3[0]) * (fArray4[1] - fArray5[1]) - (fArray5[1] - fArray3[1]) * (fArray4[0] - fArray5[0]) > 0.0f != this.v || (fArray4[0] - fArray5[0]) * (fArray2[1] - fArray4[1]) - (fArray4[1] - fArray5[1]) * (fArray2[0] - fArray4[0]) > 0.0f != this.v || (fArray2[0] - fArray4[0]) * (fArray3[1] - fArray2[1]) - (fArray2[1] - fArray4[1]) * (fArray3[0] - fArray2[0]) > 0.0f != this.v) {
                            throw new SetException("Gridded2DSet: samples do not form a valid grid (" + n6 + "," + n5 + ")");
                        }
                        ++n6;
                    }
                    ++n5;
                }
            }
        }
    }

    public Gridded2DSet(MathType mathType, float[][] fArray, int n2, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray) throws VisADException {
        this(mathType, fArray, n2, coordinateSystem, unitArray, errorEstimateArray, true);
    }

    public Gridded2DSet(MathType mathType, float[][] fArray, int n2, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, boolean bl2) throws VisADException {
        super(mathType, fArray, Gridded1DSet.c(n2), coordinateSystem, unitArray, errorEstimateArray, bl2);
        if (this.y != 2) {
            throw new SetException("Gridded2DSet Domain dimension should be 2, not " + this.y);
        }
        this.n = this.j[0];
        this.b = this.l[0];
        this.D = this.i[0];
        this.x = this.j[1];
        this.z = this.l[1];
    }

    public static int[] a(int n2, int n3) {
        int[] nArray = new int[]{n2, n3};
        return nArray;
    }

    public float[][] b(int[] nArray) throws VisADException {
        int n2 = nArray.length;
        if (this.k == null) {
            float[][] fArray = new float[this.u][n2];
            int n3 = 0;
            while (n3 < n2) {
                int n4;
                int n5;
                if (0 <= nArray[n3] && nArray[n3] < this.B) {
                    n5 = nArray[n3] % this.D;
                    n4 = nArray[n3] / this.D;
                } else {
                    n5 = -1;
                    n4 = -1;
                }
                fArray[0][n3] = n5;
                fArray[1][n3] = n4;
                ++n3;
            }
            return this.c(fArray);
        }
        float[][] fArray = new float[2][n2];
        int n6 = 0;
        while (n6 < n2) {
            if (0 <= nArray[n6] && nArray[n6] < this.B) {
                fArray[0][n6] = this.k[0][nArray[n6]];
                fArray[1][n6] = this.k[1][nArray[n6]];
            } else {
                fArray[0][n6] = Float.NaN;
                fArray[1][n6] = Float.NaN;
            }
            ++n6;
        }
        return fArray;
    }

    public int[] b(float[][] fArray) throws VisADException {
        if (fArray.length != this.y) {
            throw new SetException("Gridded2DSet.valueToIndex: value dimension " + fArray.length + " not equal to Domain dimension " + this.y);
        }
        int n2 = fArray[0].length;
        int[] nArray = new int[n2];
        float[][] fArray2 = this.f(fArray);
        float[] fArray3 = fArray2[0];
        float[] fArray4 = fArray2[1];
        int n3 = 0;
        while (n3 < n2) {
            float f2 = fArray3[n3];
            float f3 = fArray4[n3];
            nArray[n3] = f2 != f2 || f3 != f3 ? -1 : (int)((double)f2 + 0.5) + this.D * (int)((double)f3 + 0.5);
            ++n3;
        }
        return nArray;
    }

    public float[][] c(float[][] fArray) throws VisADException {
        if (fArray.length != this.u) {
            throw new SetException("Gridded2DSet.gridToValue: grid dimension " + fArray.length + " not equal to Manifold dimension " + this.u);
        }
        if (this.u < 2) {
            throw new SetException("Gridded2DSet.gridToValue: Manifold dimension must be 2, not " + this.u);
        }
        if (this.i[0] < 2 || this.i[1] < 2) {
            throw new SetException("Gridded2DSet.gridToValue: requires all grid dimensions to be > 1");
        }
        int n2 = Math.min(fArray[0].length, fArray[1].length);
        float[][] fArray2 = new float[2][n2];
        int n3 = 0;
        while (n3 < n2) {
            float f2 = fArray[0][n3];
            float f3 = fArray[1][n3];
            if ((double)f2 < -0.5 || (double)f3 < -0.5 || (double)f2 > (double)this.D - 0.5 || (double)f3 > (double)this.p - 0.5) {
                fArray2[1][n3] = Float.NaN;
                fArray2[0][n3] = Float.NaN;
            } else {
                int n4;
                int n5 = (int)f2;
                int n6 = (int)f3;
                if (n5 < 0) {
                    n5 = 0;
                }
                if (n5 > this.D - 2) {
                    n5 = this.D - 2;
                }
                if (n6 < 0) {
                    n6 = 0;
                }
                if (n6 > this.p - 2) {
                    n6 = this.p - 2;
                }
                int[][] nArrayArray = new int[][]{{this.D * n6 + n5, this.D * (n6 + 1) + n5}, {this.D * n6 + n5 + 1, this.D * (n6 + 1) + n5 + 1}};
                if (f2 + f3 - (float)n5 - (float)n6 - 1.0f <= 0.0f) {
                    n4 = 0;
                    while (n4 < 2) {
                        fArray2[n4][n3] = this.k[n4][nArrayArray[0][0]] + (f2 - (float)n5) * (this.k[n4][nArrayArray[1][0]] - this.k[n4][nArrayArray[0][0]]) + (f3 - (float)n6) * (this.k[n4][nArrayArray[0][1]] - this.k[n4][nArrayArray[0][0]]);
                        ++n4;
                    }
                } else {
                    n4 = 0;
                    while (n4 < 2) {
                        fArray2[n4][n3] = this.k[n4][nArrayArray[1][1]] + ((float)(1 + n5) - f2) * (this.k[n4][nArrayArray[0][1]] - this.k[n4][nArrayArray[1][1]]) + ((float)(1 + n6) - f3) * (this.k[n4][nArrayArray[1][0]] - this.k[n4][nArrayArray[1][1]]);
                        ++n4;
                    }
                }
            }
            ++n3;
        }
        return fArray2;
    }

    public float[][] f(float[][] fArray) throws VisADException {
        if (fArray.length < this.y) {
            throw new SetException("Gridded2DSet.valueToGrid: value dimension " + fArray.length + " not equal to Domain dimension " + this.y);
        }
        if (this.u < 2) {
            throw new SetException("Gridded2DSet.valueToGrid: Manifold dimension must be 2, not " + this.u);
        }
        if (this.i[0] < 2 || this.i[1] < 2) {
            throw new SetException("Gridded2DSet.valueToGrid: requires all grid dimensions to be > 1");
        }
        int n2 = Math.min(fArray[0].length, fArray[1].length);
        float[][] fArray2 = new float[this.u][n2];
        if (this.r < 0 || this.r >= this.D || this.o < 0 || this.o >= this.p) {
            this.r = (this.D - 1) / 2;
            this.o = (this.p - 1) / 2;
        }
        boolean bl2 = true;
        int n3 = 0;
        while (n3 < n2) {
            if (n3 != 0 && fArray2[0][n3 - 1] != fArray2[0][n3 - 1]) {
                this.r = (this.D - 1) / 2;
                this.o = (this.p - 1) / 2;
            }
            fArray2[1][n3] = Float.NaN;
            fArray2[0][n3] = Float.NaN;
            int n4 = 0;
            while (n4 < 2 * (this.D + this.p)) {
                int n5;
                int n6;
                boolean bl3;
                boolean bl4;
                boolean bl5;
                float f2;
                float f3;
                float f4;
                float[] fArray3;
                float[] fArray4;
                float[] fArray5;
                float[] fArray6 = new float[]{this.k[0][this.o * this.D + this.r], this.k[1][this.o * this.D + this.r]};
                float[] fArray7 = new float[]{this.k[0][this.o * this.D + this.r + 1], this.k[1][this.o * this.D + this.r + 1]};
                float[] fArray8 = new float[]{this.k[0][(this.o + 1) * this.D + this.r], this.k[1][(this.o + 1) * this.D + this.r]};
                float[] fArray9 = new float[]{this.k[0][(this.o + 1) * this.D + this.r + 1], this.k[1][(this.o + 1) * this.D + this.r + 1]};
                float[] fArray10 = new float[]{fArray8[0] - fArray7[0], fArray8[1] - fArray7[1]};
                float[] fArray11 = new float[]{fArray[0][n3] - fArray7[0], fArray[1][n3] - fArray7[1]};
                float[] fArray12 = new float[]{fArray[0][n3] - fArray8[0], fArray[1][n3] - fArray8[1]};
                if (bl2) {
                    fArray5 = new float[]{fArray7[0] - fArray6[0], fArray7[1] - fArray6[1]};
                    fArray4 = new float[]{fArray6[0] - fArray8[0], fArray6[1] - fArray8[1]};
                    fArray3 = new float[]{fArray[0][n3] - fArray6[0], fArray[1][n3] - fArray6[1]};
                    f4 = fArray5[0] * fArray3[1] - fArray5[1] * fArray3[0];
                    f3 = fArray10[0] * fArray11[1] - fArray10[1] * fArray11[0];
                    f2 = fArray4[0] * fArray12[1] - fArray4[1] * fArray12[0];
                    boolean bl6 = f4 == 0.0f || f4 > 0.0f == this.v ? true : (bl5 = false);
                    boolean bl7 = f3 == 0.0f || f3 > 0.0f == this.v ? true : (bl4 = false);
                    bl3 = f2 == 0.0f || f2 > 0.0f == this.v;
                    n6 = this.r++;
                    n5 = this.o--;
                    if (bl5 || bl4) {
                        if (!bl4 && !bl3) {
                            --this.r;
                            ++this.o;
                        } else if (!bl5 && !bl3) {
                            --this.r;
                            --this.o;
                        } else if (!bl5) {
                            --this.o;
                        } else if (!bl3) {
                            --this.r;
                        }
                    }
                    if (this.r < 0) {
                        this.r = 0;
                    }
                    if (this.r > this.D - 2) {
                        this.r = this.D - 2;
                    }
                    if (this.o < 0) {
                        this.o = 0;
                    }
                    if (this.o > this.p - 2) {
                        this.o = this.p - 2;
                    }
                    if (this.r == n6 && this.o == n5 && bl4) {
                        fArray2[0][n3] = ((fArray[0][n3] - fArray6[0]) * (fArray8[1] - fArray6[1]) + (fArray6[1] - fArray[1][n3]) * (fArray8[0] - fArray6[0])) / ((fArray7[0] - fArray6[0]) * (fArray8[1] - fArray6[1]) + (fArray6[1] - fArray7[1]) * (fArray8[0] - fArray6[0])) + (float)this.r;
                        fArray2[1][n3] = ((fArray[0][n3] - fArray6[0]) * (fArray7[1] - fArray6[1]) + (fArray6[1] - fArray[1][n3]) * (fArray7[0] - fArray6[0])) / ((fArray8[0] - fArray6[0]) * (fArray7[1] - fArray6[1]) + (fArray6[1] - fArray8[1]) * (fArray7[0] - fArray6[0])) + (float)this.o;
                        break;
                    }
                    bl2 = false;
                } else {
                    fArray5 = new float[]{fArray9[0] - fArray7[0], fArray9[1] - fArray7[1]};
                    fArray4 = new float[]{fArray8[0] - fArray9[0], fArray8[1] - fArray9[1]};
                    fArray3 = new float[]{fArray[0][n3] - fArray9[0], fArray[1][n3] - fArray9[1]};
                    f4 = fArray5[0] * fArray11[1] - fArray5[1] * fArray11[0];
                    f3 = fArray4[0] * fArray3[1] - fArray4[1] * fArray3[0];
                    f2 = fArray10[0] * fArray12[1] - fArray10[1] * fArray12[0];
                    boolean bl8 = f4 == 0.0f || f4 > 0.0f == this.v ? true : (bl5 = false);
                    boolean bl9 = f3 == 0.0f || f3 > 0.0f == this.v ? true : (bl4 = false);
                    bl3 = f2 == 0.0f || f2 < 0.0f == this.v;
                    n6 = this.r++;
                    n5 = this.o--;
                    if (bl5 || bl3) {
                        if (!bl4 && !bl3) {
                            --this.r;
                            ++this.o;
                        } else if (!bl5 && !bl4) {
                            ++this.r;
                            ++this.o;
                        } else if (!bl5) {
                            ++this.r;
                        } else if (!bl4) {
                            ++this.o;
                        }
                    }
                    if (this.r < 0) {
                        this.r = 0;
                    }
                    if (this.r > this.D - 2) {
                        this.r = this.D - 2;
                    }
                    if (this.o < 0) {
                        this.o = 0;
                    }
                    if (this.o > this.p - 2) {
                        this.o = this.p - 2;
                    }
                    if (this.r == n6 && this.o == n5 && bl3) {
                        fArray2[0][n3] = ((fArray9[0] - fArray[0][n3]) * (fArray7[1] - fArray9[1]) + (fArray[1][n3] - fArray9[1]) * (fArray7[0] - fArray9[0])) / ((fArray8[0] - fArray9[0]) * (fArray7[1] - fArray9[1]) - (fArray8[1] - fArray9[1]) * (fArray7[0] - fArray9[0])) + (float)this.r + 1.0f;
                        fArray2[1][n3] = ((fArray8[1] - fArray9[1]) * (fArray9[0] - fArray[0][n3]) + (fArray8[0] - fArray9[0]) * (fArray[1][n3] - fArray9[1])) / ((fArray7[0] - fArray9[0]) * (fArray8[1] - fArray9[1]) - (fArray8[0] - fArray9[0]) * (fArray7[1] - fArray9[1])) + (float)this.o + 1.0f;
                        break;
                    }
                    bl2 = true;
                }
                if ((double)fArray2[0][n3] >= (double)this.D - 0.5 || (double)fArray2[1][n3] >= (double)this.p - 0.5 || (double)fArray2[0][n3] <= -0.5 || (double)fArray2[1][n3] <= -0.5) {
                    fArray2[1][n3] = Float.NaN;
                    fArray2[0][n3] = Float.NaN;
                }
                ++n4;
            }
            ++n3;
        }
        return fArray2;
    }

    public Object c(MathType mathType) throws VisADException {
        if (this.u == 2) {
            return new Gridded2DSet(mathType, this.k, this.D, this.p, this.w, this.q, this.C);
        }
        return new Gridded2DSet(mathType, this.k, this.D, this.w, this.q, this.C);
    }
}

