/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.ErrorEstimate;
import visad.Gridded2DSet;
import visad.GriddedDoubleSet;
import visad.MathType;
import visad.Set;
import visad.SetException;
import visad.Unit;
import visad.VisADException;

public class Gridded2DDoubleSet
extends Gridded2DSet
implements GriddedDoubleSet {
    public double[] Low = new double[2];
    public double[] Hi = new double[2];
    public double LowX;
    public double HiX;
    public double LowY;
    public double HiY;
    public double[][] Samples;
    private int r = -1;
    private int o = -1;

    public Gridded2DDoubleSet(MathType mathType, float[][] fArray, int n2, int n3) throws VisADException {
        this(mathType, Set.d(fArray), n2, n3, null, null, null, true);
    }

    public Gridded2DDoubleSet(MathType mathType, float[][] fArray, int n2, int n3, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray) throws VisADException {
        this(mathType, Set.d(fArray), n2, n3, coordinateSystem, unitArray, errorEstimateArray, true);
    }

    public Gridded2DDoubleSet(MathType mathType, float[][] fArray, int n2, int n3, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, boolean bl2) throws VisADException {
        this(mathType, Set.d(fArray), n2, n3, coordinateSystem, unitArray, errorEstimateArray, bl2);
    }

    public Gridded2DDoubleSet(MathType mathType, float[][] fArray, int n2, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray) throws VisADException {
        this(mathType, Set.d(fArray), n2, coordinateSystem, unitArray, errorEstimateArray, true);
    }

    public Gridded2DDoubleSet(MathType mathType, float[][] fArray, int n2, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, boolean bl2) throws VisADException {
        this(mathType, Set.d(fArray), n2, coordinateSystem, unitArray, errorEstimateArray, bl2);
    }

    public Gridded2DDoubleSet(MathType mathType, double[][] dArray, int n2, int n3, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, boolean bl2) throws VisADException {
        super(mathType, null, n2, n3, coordinateSystem, unitArray, errorEstimateArray, bl2);
        if (dArray == null) {
            throw new SetException("Gridded2DDoubleSet: samples are null");
        }
        this.a(dArray, bl2);
        this.LowX = this.Low[0];
        this.HiX = this.Hi[0];
        this.D = this.i[0];
        this.LowY = this.Low[1];
        this.HiY = this.Hi[1];
        this.p = this.i[1];
        if (this.Samples != null && this.i[0] > 1 && this.i[1] > 1) {
            int n4 = 0;
            while (n4 < this.B) {
                if (this.Samples[0][n4] != this.Samples[0][n4]) {
                    throw new SetException("Gridded2DDoubleSet: samples values may not be missing");
                }
                ++n4;
            }
            this.v = (this.Samples[0][1] - this.Samples[0][0]) * (this.Samples[1][this.D + 1] - this.Samples[1][1]) - (this.Samples[1][1] - this.Samples[1][0]) * (this.Samples[0][this.D + 1] - this.Samples[0][1]) > 0.0;
            int n5 = 0;
            while (n5 < this.p - 1) {
                int n6 = 0;
                while (n6 < this.D - 1) {
                    double[] dArray2 = new double[2];
                    double[] dArray3 = new double[2];
                    double[] dArray4 = new double[2];
                    double[] dArray5 = new double[2];
                    int n7 = 0;
                    while (n7 < 2) {
                        dArray2[n7] = this.Samples[n7][n5 * this.D + n6];
                        dArray3[n7] = this.Samples[n7][n5 * this.D + n6 + 1];
                        dArray4[n7] = this.Samples[n7][(n5 + 1) * this.D + n6];
                        dArray5[n7] = this.Samples[n7][(n5 + 1) * this.D + n6 + 1];
                        ++n7;
                    }
                    if ((dArray3[0] - dArray2[0]) * (dArray5[1] - dArray3[1]) - (dArray3[1] - dArray2[1]) * (dArray5[0] - dArray3[0]) > 0.0 != this.v || (dArray5[0] - dArray3[0]) * (dArray4[1] - dArray5[1]) - (dArray5[1] - dArray3[1]) * (dArray4[0] - dArray5[0]) > 0.0 != this.v || (dArray4[0] - dArray5[0]) * (dArray2[1] - dArray4[1]) - (dArray4[1] - dArray5[1]) * (dArray2[0] - dArray4[0]) > 0.0 != this.v || (dArray2[0] - dArray4[0]) * (dArray3[1] - dArray2[1]) - (dArray2[1] - dArray4[1]) * (dArray3[0] - dArray2[0]) > 0.0 != this.v) {
                        throw new SetException("Gridded2DDoubleSet: samples do not form a valid grid (" + n6 + "," + n5 + ")");
                    }
                    ++n6;
                }
                ++n5;
            }
        }
    }

    public Gridded2DDoubleSet(MathType mathType, double[][] dArray, int n2) throws VisADException {
        this(mathType, dArray, n2, null, null, null);
    }

    public Gridded2DDoubleSet(MathType mathType, double[][] dArray, int n2, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray) throws VisADException {
        this(mathType, dArray, n2, coordinateSystem, unitArray, errorEstimateArray, true);
    }

    public Gridded2DDoubleSet(MathType mathType, double[][] dArray, int n2, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, boolean bl2) throws VisADException {
        super(mathType, null, n2, coordinateSystem, unitArray, errorEstimateArray, bl2);
        if (dArray == null) {
            throw new SetException("Gridded2DDoubleSet: samples are null");
        }
        this.a(dArray, bl2);
        this.LowX = this.Low[0];
        this.HiX = this.Hi[0];
        this.D = this.i[0];
        this.LowY = this.Low[1];
        this.HiY = this.Hi[1];
    }

    public float[][] a(boolean bl2) throws VisADException {
        return Set.c(this.Samples);
    }

    public float[][] b(int[] nArray) throws VisADException {
        return Set.c(this.a(nArray));
    }

    public int[] b(float[][] fArray) throws VisADException {
        return this.b(Set.d(fArray));
    }

    public float[][] c(float[][] fArray) throws VisADException {
        return Set.c(this.d(Set.d(fArray)));
    }

    public float[][] f(float[][] fArray) throws VisADException {
        return Set.c(this.e(Set.d(fArray)));
    }

    public void a(float[][] fArray, int[][] nArray, float[][] fArray2) throws VisADException {
        int n2 = fArray2.length;
        double[][] dArrayArray = new double[n2][];
        int n3 = 0;
        while (n3 < n2) {
            dArrayArray[n3] = new double[fArray2[n3].length];
            ++n3;
        }
        this.a(Set.d(fArray), nArray, dArrayArray);
        int n4 = 0;
        while (n4 < n2) {
            System.arraycopy(dArrayArray[n4], 0, fArray2[n4], 0, dArrayArray.length);
            ++n4;
        }
    }

    public double[][] l() throws VisADException {
        return this.b(true);
    }

    public double[][] b(boolean bl2) throws VisADException {
        return bl2 ? Set.a(this.Samples) : this.Samples;
    }

    public double[][] a(int[] nArray) throws VisADException {
        int n2 = nArray.length;
        if (this.Samples == null) {
            double[][] dArray = new double[this.u][n2];
            int n3 = 0;
            while (n3 < n2) {
                int n4;
                int n5;
                if (0 <= nArray[n3] && nArray[n3] < this.B) {
                    n5 = nArray[n3] % this.D;
                    n4 = nArray[n3] / this.D;
                } else {
                    n5 = -1;
                    n4 = -1;
                }
                dArray[0][n3] = n5;
                dArray[1][n3] = n4;
                ++n3;
            }
            return this.d(dArray);
        }
        double[][] dArray = new double[2][n2];
        int n6 = 0;
        while (n6 < n2) {
            if (0 <= nArray[n6] && nArray[n6] < this.B) {
                dArray[0][n6] = this.Samples[0][nArray[n6]];
                dArray[1][n6] = this.Samples[1][nArray[n6]];
            } else {
                dArray[0][n6] = Double.NaN;
                dArray[1][n6] = Double.NaN;
            }
            ++n6;
        }
        return dArray;
    }

    public int[] b(double[][] dArray) throws VisADException {
        if (dArray.length != this.y) {
            throw new SetException("Gridded2DDoubleSet.doubleToIndex: value dimension " + dArray.length + " not equal to Domain dimension " + this.y);
        }
        int n2 = dArray[0].length;
        int[] nArray = new int[n2];
        double[][] dArray2 = this.e(dArray);
        double[] dArray3 = dArray2[0];
        double[] dArray4 = dArray2[1];
        int n3 = 0;
        while (n3 < n2) {
            double d2 = dArray3[n3];
            double d3 = dArray4[n3];
            nArray[n3] = d2 != d2 || d3 != d3 ? -1 : (int)(d2 + 0.5) + this.D * (int)(d3 + 0.5);
            ++n3;
        }
        return nArray;
    }

    public double[][] d(double[][] dArray) throws VisADException {
        if (dArray.length != this.u) {
            throw new SetException("Gridded2DDoubleSet.gridToDouble: bad dimension");
        }
        if (this.u < 2) {
            throw new SetException("Gridded2DDoubleSet.gridToDouble: ManifoldDimension must be 2");
        }
        if (this.i[0] < 2 || this.i[1] < 2) {
            throw new SetException("Gridded2DDoubleSet.gridToDouble: requires all grid dimensions to be > 1");
        }
        int n2 = Math.min(dArray[0].length, dArray[1].length);
        double[][] dArray2 = new double[2][n2];
        int n3 = 0;
        while (n3 < n2) {
            double d2 = dArray[0][n3];
            double d3 = dArray[1][n3];
            if (d2 < -0.5 || d3 < -0.5 || d2 > (double)this.D - 0.5 || d3 > (double)this.p - 0.5) {
                dArray2[1][n3] = Double.NaN;
                dArray2[0][n3] = Double.NaN;
            } else {
                int n4;
                int n5 = (int)d2;
                int n6 = (int)d3;
                if (n5 < 0) {
                    n5 = 0;
                }
                if (n5 > this.D - 2) {
                    n5 = this.D - 2;
                }
                if (n6 < 0) {
                    n6 = 0;
                }
                if (n6 > this.p - 2) {
                    n6 = this.p - 2;
                }
                int[][] nArrayArray = new int[][]{{this.D * n6 + n5, this.D * (n6 + 1) + n5}, {this.D * n6 + n5 + 1, this.D * (n6 + 1) + n5 + 1}};
                if (d2 + d3 - (double)n5 - (double)n6 - 1.0 <= 0.0) {
                    n4 = 0;
                    while (n4 < 2) {
                        dArray2[n4][n3] = this.Samples[n4][nArrayArray[0][0]] + (d2 - (double)n5) * (this.Samples[n4][nArrayArray[1][0]] - this.Samples[n4][nArrayArray[0][0]]) + (d3 - (double)n6) * (this.Samples[n4][nArrayArray[0][1]] - this.Samples[n4][nArrayArray[0][0]]);
                        ++n4;
                    }
                } else {
                    n4 = 0;
                    while (n4 < 2) {
                        dArray2[n4][n3] = this.Samples[n4][nArrayArray[1][1]] + ((double)(1 + n5) - d2) * (this.Samples[n4][nArrayArray[0][1]] - this.Samples[n4][nArrayArray[1][1]]) + ((double)(1 + n6) - d3) * (this.Samples[n4][nArrayArray[1][0]] - this.Samples[n4][nArrayArray[1][1]]);
                        ++n4;
                    }
                }
            }
            ++n3;
        }
        return dArray2;
    }

    public double[][] e(double[][] dArray) throws VisADException {
        if (dArray.length < this.y) {
            throw new SetException("Gridded2DDoubleSet.doubleToGrid: bad dimension");
        }
        if (this.u < 2) {
            throw new SetException("Gridded2DDoubleSet.doubleToGrid: ManifoldDimension must be 2");
        }
        if (this.i[0] < 2 || this.i[1] < 2) {
            throw new SetException("Gridded2DDoubleSet.doubleToGrid: requires all grid dimensions to be > 1");
        }
        int n2 = Math.min(dArray[0].length, dArray[1].length);
        double[][] dArray2 = new double[this.u][n2];
        if (this.r < 0 || this.r >= this.D || this.o < 0 || this.o >= this.p) {
            this.r = (this.D - 1) / 2;
            this.o = (this.p - 1) / 2;
        }
        boolean bl2 = true;
        int n3 = 0;
        while (n3 < n2) {
            if (n3 != 0 && dArray2[0][n3 - 1] != dArray2[0][n3 - 1]) {
                this.r = (this.D - 1) / 2;
                this.o = (this.p - 1) / 2;
            }
            dArray2[1][n3] = Double.NaN;
            dArray2[0][n3] = Double.NaN;
            int n4 = 0;
            while (n4 < 2 * (this.D + this.p)) {
                int n5;
                int n6;
                boolean bl3;
                boolean bl4;
                boolean bl5;
                double d2;
                double d3;
                double d4;
                double[] dArray3;
                double[] dArray4;
                double[] dArray5;
                double[] dArray6 = new double[]{this.Samples[0][this.o * this.D + this.r], this.Samples[1][this.o * this.D + this.r]};
                double[] dArray7 = new double[]{this.Samples[0][this.o * this.D + this.r + 1], this.Samples[1][this.o * this.D + this.r + 1]};
                double[] dArray8 = new double[]{this.Samples[0][(this.o + 1) * this.D + this.r], this.Samples[1][(this.o + 1) * this.D + this.r]};
                double[] dArray9 = new double[]{this.Samples[0][(this.o + 1) * this.D + this.r + 1], this.Samples[1][(this.o + 1) * this.D + this.r + 1]};
                double[] dArray10 = new double[]{dArray8[0] - dArray7[0], dArray8[1] - dArray7[1]};
                double[] dArray11 = new double[]{dArray[0][n3] - dArray7[0], dArray[1][n3] - dArray7[1]};
                double[] dArray12 = new double[]{dArray[0][n3] - dArray8[0], dArray[1][n3] - dArray8[1]};
                if (bl2) {
                    dArray5 = new double[]{dArray7[0] - dArray6[0], dArray7[1] - dArray6[1]};
                    dArray4 = new double[]{dArray6[0] - dArray8[0], dArray6[1] - dArray8[1]};
                    dArray3 = new double[]{dArray[0][n3] - dArray6[0], dArray[1][n3] - dArray6[1]};
                    d4 = dArray5[0] * dArray3[1] - dArray5[1] * dArray3[0];
                    d3 = dArray10[0] * dArray11[1] - dArray10[1] * dArray11[0];
                    d2 = dArray4[0] * dArray12[1] - dArray4[1] * dArray12[0];
                    boolean bl6 = d4 == 0.0 || d4 > 0.0 == this.v ? true : (bl5 = false);
                    boolean bl7 = d3 == 0.0 || d3 > 0.0 == this.v ? true : (bl4 = false);
                    bl3 = d2 == 0.0 || d2 > 0.0 == this.v;
                    n6 = this.r++;
                    n5 = this.o--;
                    if (bl5 || bl4) {
                        if (!bl4 && !bl3) {
                            --this.r;
                            ++this.o;
                        } else if (!bl5 && !bl3) {
                            --this.r;
                            --this.o;
                        } else if (!bl5) {
                            --this.o;
                        } else if (!bl3) {
                            --this.r;
                        }
                    }
                    if (this.r < 0) {
                        this.r = 0;
                    }
                    if (this.r > this.D - 2) {
                        this.r = this.D - 2;
                    }
                    if (this.o < 0) {
                        this.o = 0;
                    }
                    if (this.o > this.p - 2) {
                        this.o = this.p - 2;
                    }
                    if (this.r == n6 && this.o == n5 && bl4) {
                        dArray2[0][n3] = ((dArray[0][n3] - dArray6[0]) * (dArray8[1] - dArray6[1]) + (dArray6[1] - dArray[1][n3]) * (dArray8[0] - dArray6[0])) / ((dArray7[0] - dArray6[0]) * (dArray8[1] - dArray6[1]) + (dArray6[1] - dArray7[1]) * (dArray8[0] - dArray6[0])) + (double)this.r;
                        dArray2[1][n3] = ((dArray[0][n3] - dArray6[0]) * (dArray7[1] - dArray6[1]) + (dArray6[1] - dArray[1][n3]) * (dArray7[0] - dArray6[0])) / ((dArray8[0] - dArray6[0]) * (dArray7[1] - dArray6[1]) + (dArray6[1] - dArray8[1]) * (dArray7[0] - dArray6[0])) + (double)this.o;
                        break;
                    }
                    bl2 = false;
                } else {
                    dArray5 = new double[]{dArray9[0] - dArray7[0], dArray9[1] - dArray7[1]};
                    dArray4 = new double[]{dArray8[0] - dArray9[0], dArray8[1] - dArray9[1]};
                    dArray3 = new double[]{dArray[0][n3] - dArray9[0], dArray[1][n3] - dArray9[1]};
                    d4 = dArray5[0] * dArray11[1] - dArray5[1] * dArray11[0];
                    d3 = dArray4[0] * dArray3[1] - dArray4[1] * dArray3[0];
                    d2 = dArray10[0] * dArray12[1] - dArray10[1] * dArray12[0];
                    boolean bl8 = d4 == 0.0 || d4 > 0.0 == this.v ? true : (bl5 = false);
                    boolean bl9 = d3 == 0.0 || d3 > 0.0 == this.v ? true : (bl4 = false);
                    bl3 = d2 == 0.0 || d2 < 0.0 == this.v;
                    n6 = this.r++;
                    n5 = this.o--;
                    if (bl5 || bl3) {
                        if (!bl4 && !bl3) {
                            --this.r;
                            ++this.o;
                        } else if (!bl5 && !bl4) {
                            ++this.r;
                            ++this.o;
                        } else if (!bl5) {
                            ++this.r;
                        } else if (!bl4) {
                            ++this.o;
                        }
                    }
                    if (this.r < 0) {
                        this.r = 0;
                    }
                    if (this.r > this.D - 2) {
                        this.r = this.D - 2;
                    }
                    if (this.o < 0) {
                        this.o = 0;
                    }
                    if (this.o > this.p - 2) {
                        this.o = this.p - 2;
                    }
                    if (this.r == n6 && this.o == n5 && bl3) {
                        dArray2[0][n3] = ((dArray9[0] - dArray[0][n3]) * (dArray7[1] - dArray9[1]) + (dArray[1][n3] - dArray9[1]) * (dArray7[0] - dArray9[0])) / ((dArray8[0] - dArray9[0]) * (dArray7[1] - dArray9[1]) - (dArray8[1] - dArray9[1]) * (dArray7[0] - dArray9[0])) + (double)this.r + 1.0;
                        dArray2[1][n3] = ((dArray8[1] - dArray9[1]) * (dArray9[0] - dArray[0][n3]) + (dArray8[0] - dArray9[0]) * (dArray[1][n3] - dArray9[1])) / ((dArray7[0] - dArray9[0]) * (dArray8[1] - dArray9[1]) - (dArray8[0] - dArray9[0]) * (dArray7[1] - dArray9[1])) + (double)this.o + 1.0;
                        break;
                    }
                    bl2 = true;
                }
                if (dArray2[0][n3] >= (double)this.D - 0.5 || dArray2[1][n3] >= (double)this.p - 0.5 || dArray2[0][n3] <= -0.5 || dArray2[1][n3] <= -0.5) {
                    dArray2[1][n3] = Double.NaN;
                    dArray2[0][n3] = Double.NaN;
                }
                ++n4;
            }
            ++n3;
        }
        return dArray2;
    }

    public void a(double[][] dArray, int[][] nArray, double[][] dArray2) throws VisADException {
        if (dArray.length != this.y) {
            throw new SetException("Gridded2DDoubleSet.doubleToInterp: value dimension " + dArray.length + " not equal to Domain dimension " + this.y);
        }
        int n2 = dArray[0].length;
        if (nArray.length != n2) {
            throw new SetException("Gridded2DDoubleSet.valueToInterp: indices length " + nArray.length + " doesn't match value[0] length " + dArray[0].length);
        }
        if (dArray2.length != n2) {
            throw new SetException("Gridded2DDoubleSet.valueToInterp: weights length " + dArray2.length + " doesn't match value[0] length " + dArray[0].length);
        }
        double[][] dArray3 = this.e(dArray);
        int[] nArray2 = new int[this.u];
        double[] dArray4 = new double[this.u];
        int[] nArray3 = new int[this.u];
        nArray3[0] = 1;
        int n3 = 1;
        while (n3 < this.u) {
            nArray3[n3] = nArray3[n3 - 1] * this.i[n3 - 1];
            ++n3;
        }
        int n4 = 0;
        while (n4 < n2) {
            double[] dArray5;
            int[] nArray4;
            int n5;
            int n6 = 1;
            if (Double.isNaN(dArray3[this.u - 1][n4])) {
                n5 = -1;
            } else {
                nArray2[this.u - 1] = (int)(dArray3[this.u - 1][n4] + 0.5);
                if (nArray2[this.u - 1] == this.i[this.u - 1]) {
                    int n7 = this.u - 1;
                    nArray2[n7] = nArray2[n7] - 1;
                }
                dArray4[this.u - 1] = dArray3[this.u - 1][n4] - (double)nArray2[this.u - 1];
                if (!(nArray2[this.u - 1] == 0 && dArray4[this.u - 1] <= 0.0 || nArray2[this.u - 1] == this.i[this.u - 1] - 1 && dArray4[this.u - 1] >= 0.0)) {
                    n6 *= 2;
                }
                n5 = nArray2[this.u - 1];
            }
            n3 = this.u - 2;
            while (n3 >= 0 && n5 >= 0) {
                if (Double.isNaN(dArray3[n3][n4])) {
                    n5 = -1;
                } else {
                    nArray2[n3] = (int)(dArray3[n3][n4] + 0.5);
                    if (nArray2[n3] == this.i[n3]) {
                        int n8 = n3;
                        nArray2[n8] = nArray2[n8] - 1;
                    }
                    dArray4[n3] = dArray3[n3][n4] - (double)nArray2[n3];
                    if (!(nArray2[n3] == 0 && dArray4[n3] <= 0.0 || nArray2[n3] == this.i[n3] - 1 && dArray4[n3] >= 0.0)) {
                        n6 *= 2;
                    }
                    n5 = nArray2[n3] + this.i[n3] * n5;
                }
                --n3;
            }
            if (n5 < 0) {
                nArray4 = null;
                dArray5 = null;
            } else {
                nArray4 = new int[n6];
                dArray5 = new double[n6];
                nArray4[0] = n5;
                dArray5[0] = 1.0;
                int n9 = 1;
                n3 = 0;
                while (n3 < this.u) {
                    if (!(nArray2[n3] == 0 && dArray4[n3] <= 0.0 || nArray2[n3] == this.i[n3] - 1 && dArray4[n3] >= 0.0)) {
                        double d2;
                        double d3;
                        int n10;
                        if (dArray4[n3] >= 0.0) {
                            n10 = nArray3[n3];
                            d3 = 1.0 - dArray4[n3];
                            d2 = dArray4[n3];
                        } else {
                            n10 = -nArray3[n3];
                            d3 = 1.0 + dArray4[n3];
                            d2 = -dArray4[n3];
                        }
                        int n11 = 0;
                        while (n11 < n9) {
                            nArray4[n11 + n9] = nArray4[n11] + n10;
                            dArray5[n11 + n9] = dArray5[n11] * d2;
                            int n12 = n11++;
                            dArray5[n12] = dArray5[n12] * d3;
                        }
                        n9 *= 2;
                    }
                    ++n3;
                }
            }
            nArray[n4] = nArray4;
            dArray2[n4] = dArray5;
            ++n4;
        }
    }

    public void a(double[][] dArray, boolean bl2) throws VisADException {
        if (dArray.length != this.y) {
            throw new SetException("Gridded2DDoubleSet.init_doubles: samples  dimension " + dArray.length + " not equal to domain dimension " + this.y);
        }
        if (this.B == 0) {
            this.B = dArray[0].length;
        } else if (this.B != dArray[0].length) {
            throw new SetException("Gridded2DDoubleSet.init_doubles: samples[0] length " + dArray[0].length + " doesn't match expected length " + this.B);
        }
        this.Samples = bl2 ? new double[this.y][this.B] : dArray;
        int n2 = 0;
        while (n2 < this.y) {
            if (dArray[n2].length != this.B) {
                throw new SetException("Gridded2DDoubleSet.init_doubles: samples[" + n2 + "] length " + dArray[0].length + " doesn't match expected length " + this.B);
            }
            double[] dArray2 = dArray[n2];
            double[] dArray3 = this.Samples[n2];
            if (bl2) {
                System.arraycopy(dArray2, 0, dArray3, 0, this.B);
            }
            this.Low[n2] = Double.POSITIVE_INFINITY;
            this.Hi[n2] = Double.NEGATIVE_INFINITY;
            double d2 = 0.0;
            int n3 = 0;
            while (n3 < this.B) {
                if (dArray3[n3] == dArray3[n3] && !Double.isInfinite(dArray3[n3])) {
                    if (dArray3[n3] < this.Low[n2]) {
                        this.Low[n2] = dArray3[n3];
                    }
                    if (dArray3[n3] > this.Hi[n2]) {
                        this.Hi[n2] = dArray3[n3];
                    }
                } else {
                    dArray3[n3] = Double.NaN;
                }
                d2 += dArray3[n3];
                ++n3;
            }
            if (this.C[n2] != null) {
                this.C[n2] = new ErrorEstimate(this.C[n2].a(), d2 / (double)this.B, this.B, this.C[n2].d());
            }
            this.j[n2] = (float)this.Low[n2];
            this.l[n2] = (float)this.Hi[n2];
            ++n2;
        }
    }

    public void a(boolean[] blArray) {
        int n2 = Math.min(blArray.length, this.Samples[0].length);
        int n3 = 0;
        while (n3 < n2) {
            if (!blArray[n3]) {
                this.Samples[0][n3] = Double.NaN;
            }
            ++n3;
        }
    }

    public boolean j() {
        return this.Samples == null;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Gridded2DDoubleSet) || object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.f((Set)object)) {
            return false;
        }
        if (this.b((Set)object)) {
            return true;
        }
        if (!this.e((Set)object)) {
            return false;
        }
        try {
            if (this.y != ((Gridded2DDoubleSet)object).s() || this.u != ((Gridded2DDoubleSet)object).v() || this.B != ((Gridded2DDoubleSet)object).r()) {
                return false;
            }
            int n2 = 0;
            while (n2 < this.u) {
                if (this.i[n2] != ((Gridded2DDoubleSet)object).b(n2)) {
                    return false;
                }
                ++n2;
            }
            double[][] dArray = ((Gridded2DDoubleSet)object).b(false);
            if (this.Samples != null && dArray != null) {
                n2 = 0;
                while (n2 < this.y) {
                    int n3 = 0;
                    while (n3 < this.B) {
                        if (this.Samples[n2][n3] != dArray[n2][n3]) {
                            this.d((Set)object);
                            return false;
                        }
                        ++n3;
                    }
                    ++n2;
                }
            } else {
                double[][] dArray2 = this.b(false);
                if (dArray2 == null) {
                    if (dArray != null) {
                        return false;
                    }
                } else {
                    if (dArray == null) {
                        return false;
                    }
                    n2 = 0;
                    while (n2 < this.y) {
                        int n4 = 0;
                        while (n4 < this.B) {
                            if (dArray2[n2][n4] != dArray[n2][n4]) {
                                this.d((Set)object);
                                return false;
                            }
                            ++n4;
                        }
                        ++n2;
                    }
                }
            }
            this.a((Set)object);
            return true;
        }
        catch (VisADException visADException) {
            return false;
        }
    }

    public Object clone() {
        Gridded2DDoubleSet gridded2DDoubleSet = (Gridded2DDoubleSet)super.clone();
        if (this.Samples != null) {
            gridded2DDoubleSet.Samples = (double[][])this.Samples.clone();
            int n2 = 0;
            while (n2 < this.Samples.length) {
                gridded2DDoubleSet.Samples[n2] = (double[])this.Samples[n2].clone();
                ++n2;
            }
        }
        return gridded2DDoubleSet;
    }

    public Object c(MathType mathType) throws VisADException {
        return new Gridded2DDoubleSet(mathType, this.Samples, this.B, this.w, this.q, this.C);
    }
}

