/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.util.WeakHashMap;
import visad.CoordinateSystem;
import visad.ErrorEstimate;
import visad.Gridded1DSet;
import visad.GriddedDoubleSet;
import visad.MathType;
import visad.Set;
import visad.SetException;
import visad.Unit;
import visad.VisADException;

public class Gridded1DDoubleSet
extends Gridded1DSet
implements GriddedDoubleSet {
    public double[] Low;
    public double[] Hi;
    public double LowX;
    public double HiX;
    public double[][] Samples;
    private static final WeakHashMap p = new WeakHashMap();
    private int o;

    public Gridded1DDoubleSet(MathType mathType, float[][] fArray, int n2) throws VisADException {
        this(mathType, Set.d(fArray), n2, null, null, null, true);
    }

    public Gridded1DDoubleSet(MathType mathType, float[][] fArray, int n2, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray) throws VisADException {
        this(mathType, Set.d(fArray), n2, coordinateSystem, unitArray, errorEstimateArray, true);
    }

    public Gridded1DDoubleSet(MathType mathType, float[][] fArray, int n2, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, boolean bl2) throws VisADException {
        this(mathType, Set.d(fArray), n2, coordinateSystem, unitArray, errorEstimateArray, bl2);
    }

    public Gridded1DDoubleSet(MathType mathType, double[][] dArray, int n2, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray) throws VisADException {
        this(mathType, dArray, n2, coordinateSystem, unitArray, errorEstimateArray, true);
    }

    public Gridded1DDoubleSet(MathType mathType, double[][] dArray, int n2, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, boolean bl2) throws VisADException {
        block9: {
            super(mathType, null, n2, coordinateSystem, unitArray, errorEstimateArray, bl2);
            this.Low = new double[1];
            this.Hi = new double[1];
            this.o = -1;
            if (dArray == null) {
                throw new SetException("Gridded1DDoubleSet: samples are null");
            }
            this.a(dArray, bl2);
            this.LowX = this.Low[0];
            this.HiX = this.Hi[0];
            this.D = this.i[0];
            if (this.Samples == null || this.i[0] <= 1) break block9;
            int n3 = 0;
            while (n3 < this.B) {
                if (this.Samples[0][n3] != this.Samples[0][n3]) {
                    throw new SetException("Gridded1DDoubleSet: samples values may not be missing");
                }
                ++n3;
            }
            boolean bl3 = this.s = this.Samples[0][this.D - 1] > this.Samples[0][0];
            if (this.s) {
                int n4 = 1;
                while (n4 < this.D) {
                    if (this.Samples[0][n4] < this.Samples[0][n4 - 1]) {
                        throw new SetException("Gridded1DDoubleSet: samples do not form a valid grid (" + n4 + ")");
                    }
                    ++n4;
                }
            } else {
                int n5 = 1;
                while (n5 < this.D) {
                    if (this.Samples[0][n5] > this.Samples[0][n5 - 1]) {
                        throw new SetException("Gridded1DDoubleSet: samples do not form a valid grid (" + n5 + ")");
                    }
                    ++n5;
                }
            }
        }
    }

    public float[][] a(boolean bl2) throws VisADException {
        return Set.c(this.Samples);
    }

    public float[][] b(int[] nArray) throws VisADException {
        return Set.c(this.a(nArray));
    }

    public int[] b(float[][] fArray) throws VisADException {
        return this.b(Set.d(fArray));
    }

    public float[][] c(float[][] fArray) throws VisADException {
        return Set.c(this.d(Set.d(fArray)));
    }

    public float[][] f(float[][] fArray) throws VisADException {
        return Set.c(this.e(Set.d(fArray)));
    }

    public void a(float[][] fArray, int[][] nArray, float[][] fArray2) throws VisADException {
        int n2 = fArray2.length;
        double[][] dArrayArray = new double[n2][];
        this.a(Set.d(fArray), nArray, dArrayArray);
        int n3 = 0;
        while (n3 < n2) {
            if (dArrayArray[n3] != null) {
                fArray2[n3] = new float[dArrayArray[n3].length];
                int n4 = 0;
                while (n4 < dArrayArray[n3].length) {
                    fArray2[n3][n4] = (float)dArrayArray[n3][n4];
                    ++n4;
                }
            }
            ++n3;
        }
    }

    public float w() {
        return (float)this.LowX;
    }

    public float c() {
        return (float)this.HiX;
    }

    public double[][] l() throws VisADException {
        return this.b(true);
    }

    public double[][] b(boolean bl2) throws VisADException {
        return bl2 ? Set.a(this.Samples) : this.Samples;
    }

    public double[][] a(int[] nArray) throws VisADException {
        int n2 = nArray.length;
        if (this.Samples == null) {
            double[][] dArray = new double[this.u][n2];
            int n3 = 0;
            while (n3 < n2) {
                dArray[0][n3] = 0 <= nArray[n3] && nArray[n3] < this.B ? (double)nArray[n3] : -1.0;
                ++n3;
            }
            return this.d(dArray);
        }
        double[][] dArray = new double[1][n2];
        int n4 = 0;
        while (n4 < n2) {
            dArray[0][n4] = 0 <= nArray[n4] && nArray[n4] < this.B ? this.Samples[0][nArray[n4]] : Double.NaN;
            ++n4;
        }
        return dArray;
    }

    public int[] b(double[][] dArray) throws VisADException {
        if (dArray.length != this.y) {
            throw new SetException("Gridded1DDoubleSet.doubleToIndex: value dimension " + dArray.length + " not equal to Domain dimension " + this.y);
        }
        int n2 = dArray[0].length;
        int[] nArray = new int[n2];
        double[][] dArray2 = this.e(dArray);
        double[] dArray3 = dArray2[0];
        int n3 = 0;
        while (n3 < n2) {
            double d2 = dArray3[n3];
            nArray[n3] = Double.isNaN(d2) ? -1 : (int)(d2 + 0.5);
            ++n3;
        }
        return nArray;
    }

    public double[][] d(double[][] dArray) throws VisADException {
        if (dArray.length < this.y) {
            throw new SetException("Gridded1DDoubleSet.gridToDouble: grid dimension " + dArray.length + " not equal to Domain dimension " + this.y);
        }
        if (this.i[0] < 2) {
            throw new SetException("Gridded1DDoubleSet.gridToDouble: requires all grid dimensions to be > 1");
        }
        int n2 = dArray[0].length;
        double[][] dArray2 = new double[1][n2];
        int n3 = 0;
        while (n3 < n2) {
            double d2 = dArray[0][n3];
            if (d2 < -0.5 || d2 > (double)this.D - 0.5) {
                dArray2[0][n3] = Double.NaN;
            } else {
                int n4 = d2 < 0.0 ? 0 : (d2 >= (double)(this.D - 1) ? this.D - 2 : (int)d2);
                double d3 = d2 - (double)n4;
                dArray2[0][n3] = (1.0 - d3) * this.Samples[0][n4] + d3 * this.Samples[0][n4 + 1];
            }
            ++n3;
        }
        return dArray2;
    }

    public double[][] e(double[][] dArray) throws VisADException {
        if (dArray.length < this.y) {
            throw new SetException("Gridded1DDoubleSet.doubleToGrid: value dimension " + dArray.length + " not equal to Domain dimension " + this.y);
        }
        if (this.i[0] < 2) {
            throw new SetException("Gridded1DDoubleSet.doubleToGrid: requires all grid dimensions to be > 1");
        }
        double[] dArray2 = dArray[0];
        int n2 = dArray2.length;
        double[] dArray3 = this.Samples[0];
        double[][] dArray4 = new double[1][n2];
        if (this.o < 0 || this.o >= this.D) {
            this.o = (this.D - 1) / 2;
        }
        int n3 = 0;
        while (n3 < n2) {
            if (Double.isNaN(dArray2[n3])) {
                dArray4[0][n3] = Double.NaN;
            } else {
                double d2;
                int n4 = 0;
                int n5 = this.D - 1;
                while (n4 < n5) {
                    if ((dArray2[n3] - dArray3[this.o]) * (dArray2[n3] - dArray3[this.o + 1]) <= 0.0) break;
                    boolean bl2 = this.s ? dArray3[this.o + 1] < dArray2[n3] : dArray3[this.o + 1] > dArray2[n3];
                    if (bl2) {
                        n4 = this.o + 1;
                    } else {
                        boolean bl3 = this.s ? dArray3[this.o] > dArray2[n3] : dArray3[this.o] < dArray2[n3];
                        if (bl3) {
                            n5 = this.o;
                        }
                    }
                    if (n4 >= n5) continue;
                    this.o = (n4 + n5) / 2;
                }
                if ((d2 = (double)this.o + (dArray2[n3] - dArray3[this.o]) / (dArray3[this.o + 1] - dArray3[this.o])) > -0.5 && d2 < (double)this.D - 0.5) {
                    dArray4[0][n3] = d2;
                } else {
                    dArray4[0][n3] = Double.NaN;
                    this.o = (this.D - 1) / 2;
                }
            }
            ++n3;
        }
        return dArray4;
    }

    public void a(double[][] dArray, int[][] nArray, double[][] dArray2) throws VisADException {
        if (dArray.length != this.y) {
            throw new SetException("Gridded1DDoubleSet.doubleToInterp: value dimension " + dArray.length + " not equal to Domain dimension " + this.y);
        }
        int n2 = dArray[0].length;
        if (nArray.length != n2) {
            throw new SetException("Gridded1DDoubleinearLatLonSet.doubleToInterp: indices length " + nArray.length + " doesn't match value[0] length " + dArray[0].length);
        }
        if (dArray2.length != n2) {
            throw new SetException("Gridded1DDoubleSet.doubleToInterp: weights length " + dArray2.length + " doesn't match value[0] length " + dArray[0].length);
        }
        double[][] dArray3 = this.e(dArray);
        int[] nArray2 = new int[this.u];
        double[] dArray4 = new double[this.u];
        int[] nArray3 = new int[this.u];
        nArray3[0] = 1;
        int n3 = 1;
        while (n3 < this.u) {
            nArray3[n3] = nArray3[n3 - 1] * this.i[n3 - 1];
            ++n3;
        }
        int n4 = 0;
        while (n4 < n2) {
            double[] dArray5;
            int[] nArray4;
            int n5;
            int n6 = 1;
            if (Double.isNaN(dArray3[this.u - 1][n4])) {
                n5 = -1;
            } else {
                nArray2[this.u - 1] = (int)(dArray3[this.u - 1][n4] + 0.5);
                if (nArray2[this.u - 1] == this.i[this.u - 1]) {
                    int n7 = this.u - 1;
                    nArray2[n7] = nArray2[n7] - 1;
                }
                dArray4[this.u - 1] = dArray3[this.u - 1][n4] - (double)nArray2[this.u - 1];
                if (!(nArray2[this.u - 1] == 0 && dArray4[this.u - 1] <= 0.0 || nArray2[this.u - 1] == this.i[this.u - 1] - 1 && dArray4[this.u - 1] >= 0.0)) {
                    n6 *= 2;
                }
                n5 = nArray2[this.u - 1];
            }
            n3 = this.u - 2;
            while (n3 >= 0 && n5 >= 0) {
                if (Double.isNaN(dArray3[n3][n4])) {
                    n5 = -1;
                } else {
                    nArray2[n3] = (int)(dArray3[n3][n4] + 0.5);
                    if (nArray2[n3] == this.i[n3]) {
                        int n8 = n3;
                        nArray2[n8] = nArray2[n8] - 1;
                    }
                    dArray4[n3] = dArray3[n3][n4] - (double)nArray2[n3];
                    if (!(nArray2[n3] == 0 && dArray4[n3] <= 0.0 || nArray2[n3] == this.i[n3] - 1 && dArray4[n3] >= 0.0)) {
                        n6 *= 2;
                    }
                    n5 = nArray2[n3] + this.i[n3] * n5;
                }
                --n3;
            }
            if (n5 < 0) {
                nArray4 = null;
                dArray5 = null;
            } else {
                nArray4 = new int[n6];
                dArray5 = new double[n6];
                nArray4[0] = n5;
                dArray5[0] = 1.0;
                int n9 = 1;
                n3 = 0;
                while (n3 < this.u) {
                    if (!(nArray2[n3] == 0 && dArray4[n3] <= 0.0 || nArray2[n3] == this.i[n3] - 1 && dArray4[n3] >= 0.0)) {
                        double d2;
                        double d3;
                        int n10;
                        if (dArray4[n3] >= 0.0) {
                            n10 = nArray3[n3];
                            d3 = 1.0 - dArray4[n3];
                            d2 = dArray4[n3];
                        } else {
                            n10 = -nArray3[n3];
                            d3 = 1.0 + dArray4[n3];
                            d2 = -dArray4[n3];
                        }
                        int n11 = 0;
                        while (n11 < n9) {
                            nArray4[n11 + n9] = nArray4[n11] + n10;
                            dArray5[n11 + n9] = dArray5[n11] * d2;
                            int n12 = n11++;
                            dArray5[n12] = dArray5[n12] * d3;
                        }
                        n9 *= 2;
                    }
                    ++n3;
                }
            }
            nArray[n4] = nArray4;
            dArray2[n4] = dArray5;
            ++n4;
        }
    }

    public void a(double[][] dArray, boolean bl2) throws VisADException {
        if (dArray.length != this.y) {
            throw new SetException("Gridded1DDoubleSet.init_doubles: samples dimension " + dArray.length + " not equal to Domain dimension " + this.y);
        }
        if (this.B == 0) {
            this.B = dArray[0].length;
        } else if (this.B != dArray[0].length) {
            throw new SetException("Gridded1DDoubleSet.init_doubles: samples[0] length " + dArray[0].length + " doesn't match expected length " + this.B);
        }
        this.Samples = bl2 ? new double[this.y][this.B] : dArray;
        int n2 = 0;
        while (n2 < this.y) {
            if (dArray[n2].length != this.B) {
                throw new SetException("Gridded1DDoubleSet.init_doubles: samples[" + n2 + "] length " + dArray[0].length + " doesn't match expected length " + this.B);
            }
            double[] dArray2 = dArray[n2];
            double[] dArray3 = this.Samples[n2];
            if (bl2) {
                System.arraycopy(dArray2, 0, dArray3, 0, this.B);
            }
            this.Low[n2] = Double.POSITIVE_INFINITY;
            this.Hi[n2] = Double.NEGATIVE_INFINITY;
            double d2 = 0.0;
            int n3 = 0;
            while (n3 < this.B) {
                if (dArray3[n3] == dArray3[n3] && !Double.isInfinite(dArray3[n3])) {
                    if (dArray3[n3] < this.Low[n2]) {
                        this.Low[n2] = dArray3[n3];
                    }
                    if (dArray3[n3] > this.Hi[n2]) {
                        this.Hi[n2] = dArray3[n3];
                    }
                } else {
                    dArray3[n3] = Double.NaN;
                }
                d2 += dArray3[n3];
                ++n3;
            }
            if (this.C[n2] != null) {
                this.C[n2] = new ErrorEstimate(this.C[n2].a(), d2 / (double)this.B, this.B, this.C[n2].d());
            }
            this.j[n2] = (float)this.Low[n2];
            this.l[n2] = (float)this.Hi[n2];
            ++n2;
        }
    }

    public void a(boolean[] blArray) {
        int n2 = Math.min(blArray.length, this.Samples[0].length);
        int n3 = 0;
        while (n3 < n2) {
            if (!blArray[n3]) {
                this.Samples[0][n3] = Double.NaN;
            }
            ++n3;
        }
    }

    public boolean j() {
        return this.Samples == null;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Gridded1DDoubleSet) || object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.f((Set)object)) {
            return false;
        }
        if (this.b((Set)object)) {
            return true;
        }
        if (!this.e((Set)object)) {
            return false;
        }
        try {
            if (this.y != ((Gridded1DDoubleSet)object).s() || this.u != ((Gridded1DDoubleSet)object).v() || this.B != ((Gridded1DDoubleSet)object).r()) {
                return false;
            }
            int n2 = 0;
            while (n2 < this.u) {
                if (this.i[n2] != ((Gridded1DDoubleSet)object).b(n2)) {
                    return false;
                }
                ++n2;
            }
            double[][] dArray = ((Gridded1DDoubleSet)object).b(false);
            if (this.Samples != null && dArray != null) {
                n2 = 0;
                while (n2 < this.y) {
                    int n3 = 0;
                    while (n3 < this.B) {
                        if (this.Samples[n2][n3] != dArray[n2][n3]) {
                            this.d((Set)object);
                            return false;
                        }
                        ++n3;
                    }
                    ++n2;
                }
            } else {
                double[][] dArray2 = this.b(false);
                if (dArray2 == null) {
                    if (dArray != null) {
                        return false;
                    }
                } else {
                    if (dArray == null) {
                        return false;
                    }
                    n2 = 0;
                    while (n2 < this.y) {
                        int n4 = 0;
                        while (n4 < this.B) {
                            if (dArray2[n2][n4] != dArray[n2][n4]) {
                                this.d((Set)object);
                                return false;
                            }
                            ++n4;
                        }
                        ++n2;
                    }
                }
            }
            this.a((Set)object);
            return true;
        }
        catch (VisADException visADException) {
            return false;
        }
    }

    public int hashCode() {
        if (!this.t) {
            this.d = this.m();
            this.d ^= this.y ^ this.u ^ this.B;
            int n2 = 0;
            while (n2 < this.u) {
                this.d ^= this.i[n2];
                ++n2;
            }
            if (this.Samples != null) {
                int n3 = 0;
                while (n3 < this.y) {
                    int n4 = 0;
                    while (n4 < this.B) {
                        this.d ^= new Double(this.Samples[n3][n4]).hashCode();
                        ++n4;
                    }
                    ++n3;
                }
            }
            this.t = true;
        }
        return this.d;
    }

    public Object clone() {
        Gridded1DDoubleSet gridded1DDoubleSet = (Gridded1DDoubleSet)super.clone();
        if (this.Samples != null) {
            gridded1DDoubleSet.Samples = (double[][])this.Samples.clone();
            int n2 = 0;
            while (n2 < this.Samples.length) {
                gridded1DDoubleSet.Samples[n2] = (double[])this.Samples[n2].clone();
                ++n2;
            }
        }
        return gridded1DDoubleSet;
    }

    public Object c(MathType mathType) throws VisADException {
        return new Gridded1DDoubleSet(mathType, this.Samples, this.B, this.w, this.q, this.C);
    }
}

