/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Arrays;
import visad.CommonUnit;
import visad.CoordinateSystem;
import visad.CoordinateSystemException;
import visad.Data;
import visad.DataImpl;
import visad.DataShadow;
import visad.DoubleSet;
import visad.ErrorEstimate;
import visad.Field;
import visad.FieldException;
import visad.FieldImpl;
import visad.FlatFieldIface;
import visad.FloatSet;
import visad.FunctionType;
import visad.GriddedSet;
import visad.MathType;
import visad.PromiscuousUnit;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.RealVectorType;
import visad.Set;
import visad.SetException;
import visad.SetType;
import visad.ShadowFunctionType;
import visad.ShadowRealTupleType;
import visad.ShadowTupleType;
import visad.ShadowType;
import visad.SimpleSet;
import visad.Tuple;
import visad.TupleIface;
import visad.TupleType;
import visad.TypeException;
import visad.Unit;
import visad.UnitException;
import visad.VisADException;

public class FlatField
extends FieldImpl
implements FlatFieldIface {
    private int e;
    private Set[] k;
    private int[] d;
    private CoordinateSystem m;
    private CoordinateSystem[] p;
    private boolean u;
    private Unit[] j;
    private ErrorEstimate[] x;
    private double[][] q;
    private float[][] n;
    private long[][] t;
    private int[][] s;
    private short[][] i;
    private byte[][] w;

    public FlatField(FunctionType functionType) throws VisADException {
        this(functionType, functionType.e().h(), null, null, null, null);
    }

    public FlatField(FunctionType functionType, Set set) throws VisADException {
        this(functionType, set, null, null, null, null);
    }

    public FlatField(FunctionType functionType, Set set, CoordinateSystem coordinateSystem, CoordinateSystem[] coordinateSystemArray, Set[] setArray, Unit[] unitArray) throws VisADException {
        super(functionType, set);
        int n2;
        int n3;
        if (!functionType.d()) {
            throw new FieldException("FlatField: FunctionType must be Flat");
        }
        MathType mathType = functionType.i();
        RealTupleType realTupleType = functionType.j();
        this.e = realTupleType.f();
        this.q = new double[this.e][];
        this.k = new Set[this.e];
        this.d = new int[this.e];
        if (setArray == null) {
            n3 = 0;
            while (n3 < this.e) {
                this.k[n3] = ((RealType)realTupleType.b(n3)).l();
                if (this.k[n3] == null) {
                    this.k[n3] = new FloatSet(new SetType(realTupleType.b(n3)));
                }
                ++n3;
            }
        } else {
            if (this.e != setArray.length) {
                throw new SetException("FlatField: range set dimensions don't match");
            }
            n3 = 0;
            while (n3 < this.e) {
                if (setArray[n3] == null || setArray[n3].s() != 1) {
                    throw new SetException("FlatField: each range set dimension must be 1");
                }
                ++n3;
            }
            n2 = 0;
            while (n2 < this.e) {
                this.k[n2] = realTupleType.b(n2).equals(((SetType)setArray[n2].e()).b()) ? setArray[n2] : (Set)setArray[n2].c(new SetType(realTupleType.b(n2)));
                ++n2;
            }
        }
        this.s();
        if (functionType.b()) {
            if (coordinateSystemArray != null) {
                throw new CoordinateSystemException("FlatField: Real Function Type requires single range coordinate system");
            }
            this.p = null;
            this.m = realTupleType.d();
            if (coordinateSystem != null) {
                if (!(mathType instanceof RealTupleType)) {
                    throw new CoordinateSystemException("FlatField: range_coord_sys supplied, but RangeType is not RealTupleType");
                }
                if (this.m == null || !this.m.c().equals(coordinateSystem.c())) {
                    throw new CoordinateSystemException("FlatField: range_coord_sys " + (coordinateSystem == null ? null : coordinateSystem.c()) + " must match" + " default range CoordinateSystem " + (this.m == null ? null : this.m.c()));
                }
                this.m = coordinateSystem;
            }
            if (unitArray == null) {
                this.j = this.m == null ? realTupleType.g() : this.m.b();
            } else {
                if (unitArray.length != this.e) {
                    throw new UnitException("FlatField: units dimension does not match");
                }
                this.j = new Unit[this.e];
                n2 = 0;
                while (n2 < this.e) {
                    RealType realType = (RealType)realTupleType.b(n2);
                    Unit unit = unitArray[n2];
                    this.j[n2] = unit == null || !realType.d() ? unit : unit.b();
                    ++n2;
                }
            }
            Unit[] unitArray2 = mathType instanceof RealTupleType ? ((RealTupleType)mathType).g() : new Unit[]{((RealType)mathType).e()};
            if (this.m != null && !Unit.a(this.m.b(), unitArray2)) {
                throw new UnitException("FlatField: RangeCoordinateSystem Units must be convertable with RangeType default Units");
            }
            if (this.m != null && !Unit.a(this.m.b(), this.j)) {
                throw new UnitException("FlatField: RangeUnits must be convertable with RangeCoordinateSystem Units");
            }
            if (!Unit.a(unitArray2, this.j)) {
                throw new UnitException("FlatField: RangeUnits must be convertable with RangeType default Units");
            }
        } else {
            Serializable serializable;
            int n4;
            if (coordinateSystem != null) {
                throw new CoordinateSystemException("FlatField: non-Real Function Type requires multiple range coordinate systems");
            }
            this.m = null;
            int n5 = ((TupleType)mathType).f();
            this.p = new CoordinateSystem[n5];
            int n6 = 0;
            while (n6 < n5) {
                MathType mathType2 = ((TupleType)mathType).b(n6);
                if (mathType2 instanceof RealTupleType) {
                    this.p[n6] = ((RealTupleType)mathType2).d();
                    if (coordinateSystemArray != null && coordinateSystemArray[n6] != null) {
                        if (this.p[n6] == null || this.p[n6].c() != coordinateSystemArray[n6].c()) {
                            throw new TypeException("FlatField: range_coord_syses must match Range DefaultCoordinateSystem");
                        }
                        this.p[n6] = coordinateSystemArray[n6];
                    }
                } else {
                    this.p[n6] = null;
                }
                ++n6;
            }
            if (unitArray == null) {
                this.j = realTupleType.g();
                n4 = 0;
                int n7 = 0;
                while (n7 < n5) {
                    if (this.p[n7] != null) {
                        Unit[] unitArray3 = this.p[n7].b();
                        int n8 = 0;
                        while (n8 < unitArray3.length) {
                            this.j[n4 + n8] = unitArray3[n8];
                            ++n8;
                        }
                    }
                    if ((serializable = ((TupleType)mathType).b(n7)) instanceof RealType) {
                        ++n4;
                    } else if (serializable instanceof RealTupleType) {
                        n4 += ((RealTupleType)serializable).f();
                    }
                    ++n7;
                }
            } else {
                if (unitArray.length != this.e) {
                    throw new UnitException("FlatField: units dimension does not match");
                }
                this.j = new Unit[this.e];
                n4 = 0;
                while (n4 < this.e) {
                    RealType realType = (RealType)realTupleType.b(n4);
                    serializable = unitArray[n4];
                    this.j[n4] = serializable == null || !realType.d() ? serializable : ((Unit)serializable).b();
                    ++n4;
                }
            }
            n4 = 0;
            int n9 = 0;
            while (n9 < n5) {
                Unit[] unitArray4;
                int n10;
                Unit[] unitArray5;
                MathType mathType3 = ((TupleType)mathType).b(n9);
                if (mathType3 instanceof RealTupleType) {
                    unitArray5 = ((RealTupleType)mathType3).g();
                    n10 = ((RealTupleType)mathType3).f();
                    unitArray4 = new Unit[n10];
                    int n11 = 0;
                    while (n11 < n10) {
                        unitArray4[n11] = this.j[n4 + n11];
                        ++n11;
                    }
                } else {
                    unitArray5 = new Unit[]{((RealType)mathType3).e()};
                    n10 = 1;
                    unitArray4 = new Unit[]{this.j[n4]};
                }
                if (this.p[n9] != null && !Unit.a(unitArray5, this.p[n9].b())) {
                    throw new UnitException("FlatField: RangeCoordinateSystems Units must be convertable with RangeType default Units");
                }
                if (this.p[n9] != null && !Unit.a(unitArray4, this.p[n9].b())) {
                    throw new UnitException("FlatField: RangeUnits must be convertable with RangeCoordinateSystems Units");
                }
                if (!Unit.a(unitArray5, unitArray4)) {
                    throw new UnitException("FlatField: RangeUnits must be convertable with RangeType default Units");
                }
                n4 += n10;
                ++n9;
            }
        }
        if (this.j == null) {
            this.j = new Unit[this.e];
        }
        this.x = new ErrorEstimate[this.e];
        this.u = true;
    }

    public CoordinateSystem[] u() throws TypeException {
        MathType mathType = ((FunctionType)this.a).i();
        if (!((FunctionType)this.a).b()) {
            throw new TypeException("FlatField.getRangeCoordinateSystem: Range is not Real, need DefaultCoordinateSystem index");
        }
        CoordinateSystem[] coordinateSystemArray = new CoordinateSystem[]{this.m};
        return coordinateSystemArray;
    }

    public CoordinateSystem[] b(int n2) throws TypeException {
        if (((FunctionType)this.a).b()) {
            throw new TypeException("FlatField.getRangeCoordinateSystem: Range is Real, cannot specify CoordinateSystem index");
        }
        CoordinateSystem[] coordinateSystemArray = new CoordinateSystem[]{this.p[n2]};
        return coordinateSystemArray;
    }

    public Unit[][] o() {
        Unit[][] unitArray = new Unit[this.j.length][1];
        int n2 = 0;
        while (n2 < this.j.length) {
            unitArray[n2][0] = this.j[n2];
            ++n2;
        }
        return unitArray;
    }

    public ErrorEstimate[] n() {
        ErrorEstimate[] errorEstimateArray = this.x;
        synchronized (errorEstimateArray) {
            ErrorEstimate[] errorEstimateArray2 = ErrorEstimate.a(this.x);
            return errorEstimateArray2;
        }
    }

    public void a(ErrorEstimate[] errorEstimateArray) throws FieldException {
        ErrorEstimate[] errorEstimateArray2 = this.x;
        synchronized (errorEstimateArray2) {
            if (errorEstimateArray == null) {
                int n2 = 0;
                while (n2 < this.e) {
                    this.x[n2] = null;
                    ++n2;
                }
            } else {
                if (errorEstimateArray.length != this.e) {
                    throw new FieldException("FlatField.setRangeErrors: errors dimension does not match");
                }
                int n3 = 0;
                while (n3 < this.e) {
                    this.x[n3] = errorEstimateArray[n3];
                    ++n3;
                }
            }
        }
    }

    public void a(Data[] dataArray, boolean bl2) throws VisADException, RemoteException {
        if (dataArray.length != this.r) {
            throw new FieldException("setSamples: bad Data[] length");
        }
        int n2 = 0;
        while (n2 < this.r) {
            this.a(n2, dataArray[n2]);
            ++n2;
        }
    }

    public void a(double[][] dArray) throws VisADException, RemoteException {
        this.a(dArray, null, true);
    }

    public void a(double[][] dArray, ErrorEstimate[] errorEstimateArray, boolean bl2) throws VisADException, RemoteException {
        if (dArray.length != this.e || errorEstimateArray != null && errorEstimateArray.length != this.e) {
            throw new FieldException("FlatField.setSamples: bad tuple length");
        }
        int n2 = 0;
        while (n2 < this.e) {
            if (dArray[n2].length != this.r) {
                throw new FieldException("setSamples: bad array length");
            }
            ++n2;
        }
        this.a(dArray, bl2);
        this.a(errorEstimateArray);
        this.f();
    }

    private void a(double[][] dArray, boolean bl2) throws VisADException {
        double[][] dArray2 = this.q;
        synchronized (dArray2) {
            this.s();
            int n2 = 0;
            while (n2 < this.e) {
                double[] dArray3 = dArray[n2];
                double[][] dArrayArray = new double[][]{dArray3};
                switch (this.d[n2]) {
                    case 1: {
                        Object[] objectArray;
                        if (bl2) {
                            this.q[n2] = new double[this.r];
                            objectArray = this.q[n2];
                            System.arraycopy(dArray3, 0, objectArray, 0, this.r);
                            break;
                        }
                        this.q[n2] = dArray3;
                        break;
                    }
                    case 2: {
                        this.n[n2] = new float[this.r];
                        Object[] objectArray = this.n[n2];
                        int n3 = 0;
                        while (n3 < this.r) {
                            objectArray[n3] = (float)dArray3[n3];
                            ++n3;
                        }
                        break;
                    }
                    case 6: {
                        int[] nArray = this.k[n2].b(Set.c(dArrayArray));
                        this.w[n2] = new byte[this.r];
                        byte[] byArray = this.w[n2];
                        int n4 = 0;
                        while (n4 < this.r) {
                            byArray[n4] = (byte)(nArray[n4] + -128 + 1);
                            ++n4;
                        }
                        break;
                    }
                    case 5: {
                        int[] nArray = this.k[n2].b(Set.c(dArrayArray));
                        this.i[n2] = new short[this.r];
                        short[] sArray = this.i[n2];
                        int n5 = 0;
                        while (n5 < this.r) {
                            sArray[n5] = (short)(nArray[n5] + Short.MIN_VALUE + 1);
                            ++n5;
                        }
                        break;
                    }
                    case 4: {
                        int[] nArray = this.k[n2].b(Set.c(dArrayArray));
                        this.s[n2] = new int[this.r];
                        int[] nArray2 = this.s[n2];
                        int n6 = 0;
                        while (n6 < this.r) {
                            nArray2[n6] = nArray[n6] + Integer.MIN_VALUE + 1;
                            ++n6;
                        }
                        break;
                    }
                    default: {
                        throw new SetException("FlatField.packValues: bad RangeMode");
                    }
                }
                ++n2;
            }
            this.h();
        }
    }

    public double[][] r() throws VisADException {
        return this.a(true);
    }

    private double[][] a(boolean bl2) throws SetException, VisADException {
        double[][] dArrayArray;
        double[][] dArray = this.q;
        synchronized (dArray) {
            if (this.j()) {
                double[][] dArray2 = new double[this.e][this.r];
                int n2 = 0;
                while (n2 < this.e) {
                    int n3 = 0;
                    while (n3 < this.r) {
                        dArray2[n2][n3] = Double.NaN;
                        ++n3;
                    }
                    ++n2;
                }
                double[][] dArray3 = dArray2;
                return dArray3;
            }
            dArrayArray = new double[this.e][];
            int n4 = 0;
            while (n4 < this.e) {
                switch (this.d[n4]) {
                    case 1: {
                        Object[] objectArray;
                        double[] dArray4;
                        if (bl2) {
                            dArrayArray[n4] = new double[this.r];
                            dArray4 = dArrayArray[n4];
                            objectArray = this.q[n4];
                            System.arraycopy(objectArray, 0, dArray4, 0, this.r);
                            break;
                        }
                        dArrayArray[n4] = this.q[n4];
                        break;
                    }
                    case 2: {
                        dArrayArray[n4] = new double[this.r];
                        double[] dArray4 = dArrayArray[n4];
                        Object[] objectArray = this.n[n4];
                        int n5 = 0;
                        while (n5 < this.r) {
                            dArray4[n5] = objectArray[n5];
                            ++n5;
                        }
                        break;
                    }
                    case 6: {
                        int[] nArray = new int[this.r];
                        byte[] byArray = this.w[n4];
                        int n6 = 0;
                        while (n6 < this.r) {
                            nArray[n6] = byArray[n6] - -128 - 1;
                            ++n6;
                        }
                        double[][] dArray5 = Set.d(this.k[n4].b(nArray));
                        dArrayArray[n4] = dArray5[0];
                        break;
                    }
                    case 5: {
                        int[] nArray = new int[this.r];
                        short[] sArray = this.i[n4];
                        int n7 = 0;
                        while (n7 < this.r) {
                            nArray[n7] = sArray[n7] - Short.MIN_VALUE - 1;
                            ++n7;
                        }
                        double[][] dArray5 = Set.d(this.k[n4].b(nArray));
                        dArrayArray[n4] = dArray5[0];
                        break;
                    }
                    case 4: {
                        int[] nArray = new int[this.r];
                        int[] nArray2 = this.s[n4];
                        int n8 = 0;
                        while (n8 < this.r) {
                            nArray[n8] = nArray2[n8] - Integer.MIN_VALUE - 1;
                            ++n8;
                        }
                        double[][] dArray5 = Set.d(this.k[n4].b(nArray));
                        dArrayArray[n4] = dArray5[0];
                        break;
                    }
                    default: {
                        throw new SetException("FlatField.unpackValues: bad RangeMode");
                    }
                }
                ++n4;
            }
        }
        return dArrayArray;
    }

    private float[][] d(boolean bl2) throws VisADException {
        float[][] fArrayArray;
        double[][] dArray = this.q;
        synchronized (dArray) {
            if (this.j()) {
                float[][] fArray = new float[this.e][this.r];
                int n2 = 0;
                while (n2 < this.e) {
                    int n3 = 0;
                    while (n3 < this.r) {
                        fArray[n2][n3] = Float.NaN;
                        ++n3;
                    }
                    ++n2;
                }
                float[][] fArray2 = fArray;
                return fArray2;
            }
            fArrayArray = new float[this.e][];
            int n4 = 0;
            while (n4 < this.e) {
                switch (this.d[n4]) {
                    case 1: {
                        fArrayArray[n4] = new float[this.r];
                        float[] fArray = fArrayArray[n4];
                        double[] dArray2 = this.q[n4];
                        int n5 = 0;
                        while (n5 < this.r) {
                            fArray[n5] = (float)dArray2[n5];
                            ++n5;
                        }
                        break;
                    }
                    case 2: {
                        Object[] objectArray;
                        float[] fArray;
                        if (bl2) {
                            fArrayArray[n4] = new float[this.r];
                            fArray = fArrayArray[n4];
                            objectArray = this.n[n4];
                            System.arraycopy(objectArray, 0, fArray, 0, this.r);
                            break;
                        }
                        fArrayArray[n4] = this.n[n4];
                        break;
                    }
                    case 6: {
                        int[] nArray = new int[this.r];
                        Object[] objectArray = this.w[n4];
                        int n6 = 0;
                        while (n6 < this.r) {
                            nArray[n6] = objectArray[n6] - -128 - 1;
                            ++n6;
                        }
                        float[][] fArray = this.k[n4].b(nArray);
                        fArrayArray[n4] = fArray[0];
                        break;
                    }
                    case 5: {
                        int[] nArray = new int[this.r];
                        short[] sArray = this.i[n4];
                        int n7 = 0;
                        while (n7 < this.r) {
                            nArray[n7] = sArray[n7] - Short.MIN_VALUE - 1;
                            ++n7;
                        }
                        float[][] fArray = this.k[n4].b(nArray);
                        fArrayArray[n4] = fArray[0];
                        break;
                    }
                    case 4: {
                        int[] nArray = new int[this.r];
                        int[] nArray2 = this.s[n4];
                        int n8 = 0;
                        while (n8 < this.r) {
                            nArray[n8] = nArray2[n8] - Integer.MIN_VALUE - 1;
                            ++n8;
                        }
                        float[][] fArray = this.k[n4].b(nArray);
                        fArrayArray[n4] = fArray[0];
                        break;
                    }
                    default: {
                        throw new SetException("FlatField.unpackFloats: bad RangeMode");
                    }
                }
                ++n4;
            }
        }
        return fArrayArray;
    }

    private double[] c(int n2) throws VisADException {
        double[] dArray;
        double[][] dArray2 = this.q;
        synchronized (dArray2) {
            if (this.j()) {
                double[] dArray3 = new double[this.e];
                int n3 = 0;
                while (n3 < this.e) {
                    dArray3[n3] = Double.NaN;
                    ++n3;
                }
                double[] dArray4 = dArray3;
                return dArray4;
            }
            dArray = new double[this.e];
            int n4 = 0;
            while (n4 < this.e) {
                switch (this.d[n4]) {
                    case 1: {
                        dArray[n4] = this.q[n4][n2];
                        break;
                    }
                    case 2: {
                        dArray[n4] = this.n[n4][n2];
                        break;
                    }
                    case 6: {
                        int[] nArray = new int[1];
                        byte[] byArray = this.w[n4];
                        nArray[0] = byArray[n2] - -128 - 1;
                        double[][] dArray5 = Set.d(this.k[n4].b(nArray));
                        dArray[n4] = dArray5[0][0];
                        break;
                    }
                    case 5: {
                        int[] nArray = new int[1];
                        short[] sArray = this.i[n4];
                        nArray[0] = sArray[n2] - Short.MIN_VALUE - 1;
                        double[][] dArray5 = Set.d(this.k[n4].b(nArray));
                        dArray[n4] = dArray5[0][0];
                        break;
                    }
                    case 4: {
                        int[] nArray = new int[1];
                        int[] nArray2 = this.s[n4];
                        nArray[0] = nArray2[n2] - Integer.MIN_VALUE - 1;
                        double[][] dArray5 = Set.d(this.k[n4].b(nArray));
                        dArray[n4] = dArray5[0][0];
                        break;
                    }
                    default: {
                        throw new SetException("FlatField.unpackValues: bad RangeMode");
                    }
                }
                ++n4;
            }
        }
        return dArray;
    }

    public float[][] b(boolean bl2) throws VisADException {
        float[][] fArray = this.d(bl2);
        Unit[] unitArray = ((FunctionType)this.a).j().g();
        return Unit.a(fArray, this.j, unitArray);
    }

    public double[][] l() throws VisADException {
        return this.c(true);
    }

    public double[][] c(boolean bl2) throws VisADException {
        double[][] dArray = this.a(bl2);
        Unit[] unitArray = ((FunctionType)this.a).j().g();
        return Unit.a(dArray, this.j, unitArray);
    }

    public String[][] x() throws VisADException, RemoteException {
        return null;
    }

    public Unit[] w() {
        return ((FunctionType)this.a).j().g();
    }

    public Data d(int n2) throws VisADException, RemoteException {
        if (this.j() || n2 < 0 || n2 >= this.r) {
            return ((FunctionType)this.a).i().c();
        }
        double[][] dArray = new double[this.e][1];
        double[][] dArray2 = this.q;
        synchronized (dArray2) {
            int n3 = 0;
            while (n3 < this.e) {
                switch (this.d[n3]) {
                    case 1: {
                        dArray[n3][0] = this.q[n3][n2];
                        break;
                    }
                    case 2: {
                        dArray[n3][0] = this.n[n3][n2];
                        break;
                    }
                    case 6: {
                        int[] nArray = new int[]{this.w[n3][n2] - -128 - 1};
                        double[][] dArray3 = Set.d(this.k[n3].b(nArray));
                        dArray[n3] = dArray3[0];
                        break;
                    }
                    case 5: {
                        int[] nArray = new int[]{this.i[n3][n2] - Short.MIN_VALUE - 1};
                        double[][] dArray3 = Set.d(this.k[n3].b(nArray));
                        dArray[n3] = dArray3[0];
                        break;
                    }
                    case 4: {
                        int[] nArray = new int[]{this.s[n3][n2] - Integer.MIN_VALUE - 1};
                        double[][] dArray3 = Set.d(this.k[n3].b(nArray));
                        dArray[n3] = dArray3[0];
                        break;
                    }
                    default: {
                        throw new SetException("FlatField.getSample: bad RangeMode");
                    }
                }
                ++n3;
            }
        }
        MathType mathType = ((FunctionType)this.a).i();
        if (mathType instanceof RealType) {
            return new Real((RealType)mathType, dArray[0][0], this.j[0], this.x[0]);
        }
        if (mathType instanceof RealTupleType) {
            Real[] realArray = new Real[this.e];
            int n4 = 0;
            while (n4 < this.e) {
                MathType mathType2 = ((RealTupleType)mathType).b(n4);
                realArray[n4] = new Real((RealType)mathType2, dArray[n4][0], this.j[n4], this.x[n4]);
                ++n4;
            }
            return new RealTuple((RealTupleType)mathType, realArray, this.m);
        }
        int n5 = ((TupleType)mathType).f();
        int n6 = 0;
        Data[] dataArray = new Data[n5];
        int n7 = 0;
        while (n7 < n5) {
            MathType mathType3 = ((TupleType)mathType).b(n7);
            if (mathType3 instanceof RealType) {
                dataArray[n7] = new Real((RealType)mathType3, dArray[n6][0], this.j[n6], this.x[n6]);
                ++n6;
            } else {
                int n8 = ((RealTupleType)mathType3).f();
                Real[] realArray = new Real[n8];
                int n9 = 0;
                while (n9 < n8) {
                    RealType realType = (RealType)((RealTupleType)mathType3).b(n9);
                    realArray[n9] = new Real(realType, dArray[n6][0], this.j[n6], this.x[n6]);
                    ++n6;
                    ++n9;
                }
                dataArray[n7] = new RealTuple((RealTupleType)mathType3, realArray, this.p[n7]);
            }
            ++n7;
        }
        return new Tuple(dataArray);
    }

    public Data a(int n2, boolean bl2) throws VisADException, RemoteException {
        return this.d(n2);
    }

    public void a(int n2, Data data, boolean bl2) throws VisADException, RemoteException {
        this.a(n2, data);
    }

    public void a(int n2, Data data) throws VisADException, RemoteException {
        int n3;
        int n4;
        int n5;
        Object object;
        if (this.o == null) {
            throw new FieldException("Field.setSample: DomainSet undefined");
        }
        if (!((FunctionType)this.a).i().equals(data.e())) {
            throw new TypeException("Field.setSample: sample range type " + data.e() + " does not match expected type " + ((FunctionType)this.a).i());
        }
        if (n2 < 0 || n2 >= this.r) {
            return;
        }
        double[] dArray = new double[this.e];
        ErrorEstimate[] errorEstimateArray = new ErrorEstimate[this.e];
        if (data instanceof Real) {
            dArray[0] = ((Real)data).a();
            dArray = Unit.a(this.j[0], errorEstimateArray, ((Real)data).d(), ((Real)data).c(), dArray);
        } else if (data instanceof RealTuple) {
            object = new double[this.e][1];
            n5 = 0;
            while (n5 < this.e) {
                object[n5][0] = ((Real)((RealTuple)data).b(n5)).a();
                ++n5;
            }
            object = CoordinateSystem.b((RealTupleType)((FunctionType)this.a).i(), this.m, this.j, errorEstimateArray, (RealTupleType)data.e(), ((RealTuple)data).c(), ((RealTuple)data).a(), ((RealTuple)data).d(), object);
            n4 = 0;
            while (n4 < this.e) {
                dArray[n4] = object[n4][0];
                ++n4;
            }
        } else {
            object = ((FunctionType)this.a).i();
            n5 = ((TupleIface)data).h();
            n4 = 0;
            n3 = 0;
            while (n3 < n5) {
                Object object2;
                Data data2 = ((TupleIface)data).b(n3);
                if (data2 instanceof Real) {
                    double[] dArray2 = new double[]{((Real)data2).a()};
                    object2 = new ErrorEstimate[1];
                    dArray2 = Unit.a(this.j[0], (ErrorEstimate[])object2, ((Real)data2).d(), ((Real)data2).c(), dArray2);
                    dArray[n4] = dArray2[0];
                    errorEstimateArray[n4] = object2[0];
                    ++n4;
                } else {
                    int n6 = ((RealTuple)data2).h();
                    object2 = new double[n6][1];
                    Unit[] unitArray = new Unit[n6];
                    ErrorEstimate[] errorEstimateArray2 = ((RealTuple)data2).d();
                    int n7 = 0;
                    while (n7 < n6) {
                        object2[n7][0] = ((Real)((RealTuple)data2).b(n7)).a();
                        unitArray[n7] = this.j[n4 + n7];
                        ++n7;
                    }
                    object2 = CoordinateSystem.b((RealTupleType)((TupleType)object).b(n3), this.p[n3], unitArray, errorEstimateArray2, (RealTupleType)data2.e(), ((RealTuple)data2).c(), ((RealTuple)data2).a(), ((RealTuple)data2).d(), object2);
                    int n8 = 0;
                    while (n8 < n6) {
                        dArray[n4] = object2[n8][0];
                        errorEstimateArray[n4] = errorEstimateArray2[n8];
                        ++n4;
                        ++n8;
                    }
                }
                ++n3;
            }
        }
        object = new int[this.e];
        double[][] dArray3 = this.q;
        synchronized (dArray3) {
            n4 = 0;
            while (n4 < this.e) {
                object[n4] = (double[])(dArray[n4] == dArray[n4] ? 1 : 0);
                switch (this.d[n4]) {
                    case 1: {
                        if (this.q[n4] == null) {
                            this.q[n4] = new double[this.r];
                            n3 = 0;
                            while (n3 < this.r) {
                                this.q[n4][n3] = Double.NaN;
                                ++n3;
                            }
                        }
                        int n9 = n4;
                        object[n9] = object[n9] - (this.q[n4][n2] == this.q[n4][n2]);
                        this.q[n4][n2] = dArray[n4];
                        break;
                    }
                    case 2: {
                        if (this.n[n4] == null) {
                            this.n[n4] = new float[this.r];
                            n3 = 0;
                            while (n3 < this.r) {
                                this.n[n4][n3] = Float.NaN;
                                ++n3;
                            }
                        }
                        int n10 = n4;
                        object[n10] = object[n10] - (this.n[n4][n2] == this.n[n4][n2]);
                        this.n[n4][n2] = (float)dArray[n4];
                        break;
                    }
                    case 6: {
                        double[][] dArray4 = new double[1][1];
                        dArray4[0][0] = dArray[n4];
                        int[] nArray = this.k[n4].b(Set.c(dArray4));
                        if (this.w[n4] == null) {
                            this.w[n4] = new byte[this.r];
                            n3 = 0;
                            while (n3 < this.r) {
                                this.w[n4][n3] = -128;
                                ++n3;
                            }
                        }
                        int n11 = n4;
                        object[n11] = object[n11] - (this.w[n4][n2] != -128);
                        this.w[n4][n2] = (byte)(nArray[0] + -128 + 1);
                        break;
                    }
                    case 5: {
                        double[][] dArray4 = new double[1][1];
                        dArray4[0][0] = dArray[n4];
                        int[] nArray = this.k[n4].b(Set.c(dArray4));
                        if (this.i[n4] == null) {
                            this.i[n4] = new short[this.r];
                            n3 = 0;
                            while (n3 < this.r) {
                                this.i[n4][n3] = Short.MIN_VALUE;
                                ++n3;
                            }
                        }
                        int n12 = n4;
                        object[n12] = object[n12] - (this.i[n4][n2] != Short.MIN_VALUE);
                        this.i[n4][n2] = (short)(nArray[0] + Short.MIN_VALUE + 1);
                        break;
                    }
                    case 4: {
                        double[][] dArray4 = new double[1][1];
                        dArray4[0][0] = dArray[n4];
                        int[] nArray = this.k[n4].b(Set.c(dArray4));
                        if (this.s[n4] == null) {
                            this.s[n4] = new int[this.r];
                            n3 = 0;
                            while (n3 < this.r) {
                                this.s[n4][n3] = Integer.MIN_VALUE;
                                ++n3;
                            }
                        }
                        int n13 = n4;
                        object[n13] = object[n13] - (this.s[n4][n2] != Integer.MIN_VALUE);
                        this.s[n4][n2] = nArray[0] + Integer.MIN_VALUE + 1;
                        break;
                    }
                    default: {
                        throw new SetException("FlatField.setSample: bad RangeMode");
                    }
                }
                ++n4;
            }
            ErrorEstimate[] errorEstimateArray3 = this.x;
            synchronized (errorEstimateArray3) {
                int n14 = 0;
                while (n14 < this.e) {
                    this.x[n14] = new ErrorEstimate(this.x[n14], errorEstimateArray[n14], dArray[n14], (int)object[n14]);
                    ++n14;
                }
            }
        }
        this.h();
        this.f();
    }

    private void s() throws VisADException {
        double[][] dArray = this.q;
        synchronized (dArray) {
            int n2 = 0;
            while (n2 < this.e) {
                this.q[n2] = null;
                ++n2;
            }
            this.n = new float[this.e][];
            this.t = new long[this.e][];
            this.s = new int[this.e][];
            this.i = new short[this.e][];
            this.w = new byte[this.e][];
            int n3 = 0;
            while (n3 < this.e) {
                int n4;
                this.d[n3] = this.k[n3] instanceof DoubleSet ? 1 : (this.k[n3] instanceof FloatSet ? 2 : ((n4 = this.k[n3].r()) < 256 ? 6 : (n4 < 65536 ? 5 : 4)));
                ++n3;
            }
        }
    }

    public boolean j() {
        double[][] dArray = this.q;
        synchronized (dArray) {
            boolean bl2 = this.u;
            return bl2;
        }
    }

    public void h() {
        double[][] dArray = this.q;
        synchronized (dArray) {
            this.u = false;
        }
    }

    public Data a(Data data, int n2, MathType mathType, int n3, int n4) throws VisADException, RemoteException {
        if (mathType == null) {
            throw new TypeException("binary: new_type may not be null");
        }
        if (data instanceof Field) {
            int n5;
            CoordinateSystem[] coordinateSystemArray;
            int n6;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            int n7;
            Unit[] unitArray;
            Object object5;
            Object object6;
            Object object7;
            FunctionType functionType = (FunctionType)data.e();
            if (functionType.i().a(this.a)) {
                if (!functionType.a(mathType)) {
                    throw new TypeException("binary: new_type doesn't match return type");
                }
                return data.a(this, DataImpl.a(n2), mathType, n3, n4);
            }
            if (!this.a.a(data.e())) {
                throw new TypeException("FlatField.binary: types don't match");
            }
            if (!this.a.a(mathType)) {
                throw new TypeException();
            }
            if (!((Field)data).m()) {
                return this.d().a(data, n2, mathType, n3, n4);
            }
            data = data.i();
            if (this.j() || data.j()) {
                return mathType.c();
            }
            data = ((FlatField)data).a(this.o, n3, n4);
            double[][] dArray = this.r();
            double[][] dArray2 = ((FlatField)data).r();
            Unit[][] unitArray2 = ((FlatField)data).o();
            Unit[] unitArray3 = new Unit[unitArray2.length];
            int n8 = 0;
            while (n8 < unitArray2.length) {
                unitArray3[n8] = unitArray2[n8][0];
                ++n8;
            }
            ErrorEstimate[] errorEstimateArray = ((FlatField)data).n();
            if (unitArray3 == null) {
                unitArray3 = new Unit[this.e];
            }
            if (errorEstimateArray == null) {
                errorEstimateArray = new ErrorEstimate[this.e];
            }
            Unit[] unitArray4 = new Unit[this.e];
            ErrorEstimate[] errorEstimateArray2 = new ErrorEstimate[this.e];
            if (((FunctionType)this.a).b()) {
                object7 = ((FlatField)data).u();
                dArray2 = CoordinateSystem.a(((FunctionType)this.a).j(), this.m, unitArray4, errorEstimateArray2, ((FunctionType)data.e()).j(), (CoordinateSystem)object7[0], unitArray3, errorEstimateArray, dArray2);
            } else if (this.p != null) {
                object7 = (TupleType)((FunctionType)this.a).i();
                object6 = (TupleType)((FunctionType)data.e()).i();
                int n9 = ((TupleType)object7).f();
                int n10 = 0;
                int n11 = 0;
                while (n11 < n9) {
                    object5 = ((TupleType)object7).b(n11);
                    unitArray = ((TupleType)object6).b(n11);
                    if (object5 instanceof RealTupleType) {
                        n7 = ((RealTupleType)object5).f();
                        Object object8 = new double[n7][];
                        object4 = new Unit[n7];
                        object3 = new Unit[n7];
                        object2 = new ErrorEstimate[n7];
                        object = new ErrorEstimate[n7];
                        n6 = 0;
                        while (n6 < n7) {
                            object8[n6] = dArray2[n10 + n6];
                            object3[n6] = unitArray3[n10 + n6];
                            object[n6] = errorEstimateArray[n10 + n6];
                            ++n6;
                        }
                        coordinateSystemArray = ((FlatField)data).b(n11);
                        object8 = CoordinateSystem.a((RealTupleType)object5, this.p[n11], (Unit[])object4, (ErrorEstimate[])object2, (RealTupleType)unitArray, coordinateSystemArray[0], (Unit[])object3, object, object8);
                        n5 = 0;
                        while (n5 < n7) {
                            dArray2[n10 + n5] = object8[n5];
                            errorEstimateArray2[n10 + n5] = object2[n5];
                            unitArray4[n10 + n5] = object4[n5];
                            ++n5;
                        }
                        n10 += n7;
                    } else {
                        errorEstimateArray2[n10] = errorEstimateArray[n10];
                        unitArray4[n10] = unitArray3[n10];
                        ++n10;
                    }
                    ++n11;
                }
            }
            object7 = (Unit[])this.j.clone();
            object6 = unitArray4;
            double[][] dArray3 = dArray;
            double[][] dArray4 = dArray2;
            ErrorEstimate[] errorEstimateArray3 = (ErrorEstimate[])this.x.clone();
            object5 = errorEstimateArray2;
            unitArray = new Unit[this.e];
            switch (n2) {
                case 1: 
                case 2: 
                case 3: 
                case 9: 
                case 10: {
                    n7 = 0;
                    while (n7 < this.e) {
                        if (object7[n7] == null || object6[n7] == null) {
                            unitArray[n7] = null;
                        } else if (object7[n7] == CommonUnit.d) {
                            unitArray[n7] = ((Unit)object6[n7]).b();
                        } else if (object6[n7] == CommonUnit.d) {
                            unitArray[n7] = ((Unit)object7[n7]).b();
                        } else {
                            try {
                                boolean bl2;
                                unitArray[n7] = ((Unit)object7[n7]).b();
                                boolean bl3 = !unitArray[n7].d((Unit)object7[n7]);
                                boolean bl4 = bl2 = !unitArray[n7].d((Unit)object6[n7]);
                                if (bl3) {
                                    dArray3[n7] = unitArray[n7].a(dArray3[n7], (Unit)object7[n7]);
                                }
                                if (bl2) {
                                    dArray4[n7] = unitArray[n7].a(dArray4[n7], (Unit)object6[n7]);
                                }
                                if (n4 != 202 && errorEstimateArray3[n7] != null && object5[n7] != null) {
                                    double d2;
                                    if (bl3) {
                                        object3 = errorEstimateArray3[n7].d();
                                        if (object3 == null) {
                                            object3 = object7[n7];
                                        }
                                        double d3 = 0.5 * errorEstimateArray3[n7].a();
                                        double d4 = errorEstimateArray3[n7].c();
                                        double d5 = unitArray[n7].a(d4 + d3, (Unit)object3);
                                        d2 = unitArray[n7].a(d4 - d3, (Unit)object3);
                                        d4 = (d5 + d2) / 2.0;
                                        d3 = Math.abs(d5 - d2);
                                        errorEstimateArray3[n7] = new ErrorEstimate(d4, d3, unitArray[n7]);
                                    }
                                    if (bl2) {
                                        object3 = object5[n7].d();
                                        if (object3 == null) {
                                            object3 = object6[n7];
                                        }
                                        double d6 = 0.5 * object5[n7].a();
                                        double d7 = object5[n7].c();
                                        double d8 = unitArray[n7].a(d7 + d6, (Unit)object3);
                                        d2 = unitArray[n7].a(d7 - d6, (Unit)object3);
                                        d7 = (d8 + d2) / 2.0;
                                        d6 = Math.abs(d8 - d2);
                                        object5[n7] = new ErrorEstimate(d7, d6, unitArray[n7]);
                                    }
                                }
                            }
                            catch (UnitException unitException) {
                                unitArray[n7] = null;
                            }
                        }
                        switch (n2) {
                            case 1: {
                                int n12 = 0;
                                while (n12 < this.r) {
                                    double[] dArray5 = dArray3[n7];
                                    int n13 = n12;
                                    dArray5[n13] = dArray5[n13] + dArray4[n7][n12];
                                    ++n12;
                                }
                                break;
                            }
                            case 2: {
                                int n14 = 0;
                                while (n14 < this.r) {
                                    double[] dArray6 = dArray3[n7];
                                    int n15 = n14;
                                    dArray6[n15] = dArray6[n15] - dArray4[n7][n14];
                                    ++n14;
                                }
                                break;
                            }
                            case 3: {
                                int n16 = 0;
                                while (n16 < this.r) {
                                    dArray3[n7][n16] = dArray4[n7][n16] - dArray3[n7][n16];
                                    ++n16;
                                }
                                break;
                            }
                            case 9: {
                                int n17 = 0;
                                while (n17 < this.r) {
                                    dArray3[n7][n17] = Math.max(dArray3[n7][n17], dArray4[n7][n17]);
                                    ++n17;
                                }
                                break;
                            }
                            case 10: {
                                int n18 = 0;
                                while (n18 < this.r) {
                                    dArray3[n7][n18] = Math.min(dArray3[n7][n18], dArray4[n7][n18]);
                                    ++n18;
                                }
                                break;
                            }
                        }
                        ++n7;
                    }
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    int n19 = 0;
                    while (n19 < this.e) {
                        if (object7[n19] != null && !((Unit)(object4 = ((Unit)object7[n19]).b())).d((Unit)object7[n19])) {
                            dArray3[n19] = ((Unit)object4).a(dArray3[n19], (Unit)object7[n19]);
                            object7[n19] = object4;
                        }
                        if (object6[n19] != null && !((Unit)(object4 = ((Unit)object6[n19]).b())).d((Unit)object6[n19])) {
                            dArray4[n19] = ((Unit)object4).a(dArray4[n19], (Unit)object6[n19]);
                            object6[n19] = object4;
                        }
                        if (object7[n19] == null || object6[n19] == null) {
                            unitArray[n19] = null;
                        } else {
                            switch (n2) {
                                case 4: {
                                    unitArray[n19] = ((Unit)object7[n19]).d(CommonUnit.d) ? object6[n19] : (((Unit)object6[n19]).d(CommonUnit.d) ? object7[n19] : ((Unit)object7[n19]).e((Unit)object6[n19]));
                                    break;
                                }
                                case 5: {
                                    unitArray[n19] = ((Unit)object6[n19]).d(CommonUnit.d) ? object7[n19] : ((Unit)object7[n19]).b((Unit)object6[n19]);
                                    break;
                                }
                                case 6: {
                                    unitArray[n19] = ((Unit)object7[n19]).d(CommonUnit.d) ? object6[n19] : ((Unit)object6[n19]).b((Unit)object7[n19]);
                                }
                            }
                        }
                        switch (n2) {
                            case 4: {
                                int n20 = 0;
                                while (n20 < this.r) {
                                    double[] dArray7 = dArray3[n19];
                                    int n21 = n20;
                                    dArray7[n21] = dArray7[n21] * dArray4[n19][n20];
                                    ++n20;
                                }
                                break;
                            }
                            case 5: {
                                int n22 = 0;
                                while (n22 < this.r) {
                                    double[] dArray8 = dArray3[n19];
                                    int n23 = n22;
                                    dArray8[n23] = dArray8[n23] / dArray4[n19][n22];
                                    ++n22;
                                }
                                break;
                            }
                            case 6: {
                                int n24 = 0;
                                while (n24 < this.r) {
                                    dArray3[n19][n24] = dArray4[n19][n24] / dArray3[n19][n24];
                                    ++n24;
                                }
                                break;
                            }
                        }
                        ++n19;
                    }
                    break;
                }
                case 7: {
                    int n25 = 0;
                    while (n25 < this.e) {
                        if (object7[n25] != null && !((Unit)(object3 = ((Unit)object7[n25]).b())).d((Unit)object7[n25])) {
                            dArray3[n25] = ((Unit)object3).a(dArray3[n25], (Unit)object7[n25]);
                            object7[n25] = object3;
                        }
                        if (object6[n25] != null && !CommonUnit.d.d((Unit)object6[n25]) && !((Unit)(object3 = ((Unit)object6[n25]).b())).d((Unit)object6[n25])) {
                            dArray4[n25] = ((Unit)object3).a(dArray4[n25], (Unit)object6[n25]);
                            object6[n25] = object3;
                        }
                        unitArray[n25] = object7[n25] != null && (((Unit)object7[n25]).d(CommonUnit.d) || ((Unit)object7[n25]).d(CommonUnit.a)) ? object7[n25] : null;
                        int n26 = 0;
                        while (n26 < this.r) {
                            dArray3[n25][n26] = Math.pow(dArray3[n25][n26], dArray4[n25][n26]);
                            ++n26;
                        }
                        ++n25;
                    }
                    break;
                }
                case 8: {
                    int n27 = 0;
                    while (n27 < this.e) {
                        if (object6[n27] != null && !((Unit)(object2 = ((Unit)object6[n27]).b())).d((Unit)object6[n27])) {
                            dArray4[n27] = ((Unit)object2).a(dArray4[n27], (Unit)object6[n27]);
                            object6[n27] = object2;
                        }
                        if (object7[n27] != null && !CommonUnit.d.d((Unit)object7[n27]) && !((Unit)(object2 = ((Unit)object7[n27]).b())).d((Unit)object7[n27])) {
                            dArray3[n27] = ((Unit)object2).a(dArray3[n27], (Unit)object7[n27]);
                            object7[n27] = object2;
                        }
                        unitArray[n27] = object6[n27] != null && (((Unit)object6[n27]).d(CommonUnit.d) || ((Unit)object6[n27]).d(CommonUnit.a)) ? object6[n27] : null;
                        int n28 = 0;
                        while (n28 < this.r) {
                            dArray3[n27][n28] = Math.pow(dArray4[n27][n28], dArray3[n27][n28]);
                            ++n28;
                        }
                        ++n27;
                    }
                    break;
                }
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    int n29 = 0;
                    while (n29 < this.e) {
                        if (object7[n29] != null && object6[n29] != null) {
                            object = ((Unit)object7[n29]).b();
                            if (!object.d((Unit)object7[n29])) {
                                dArray3[n29] = object.a(dArray3[n29], (Unit)object7[n29]);
                                object7[n29] = object;
                            }
                            if (!object.d((Unit)object6[n29])) {
                                dArray4[n29] = object.a(dArray4[n29], (Unit)object6[n29]);
                                object6[n29] = object;
                            }
                        }
                        switch (n2) {
                            case 11: {
                                int n30 = 0;
                                while (n30 < this.r) {
                                    dArray3[n29][n30] = Math.atan2(dArray3[n29][n30], dArray4[n29][n30]);
                                    ++n30;
                                }
                                unitArray[n29] = CommonUnit.c;
                                break;
                            }
                            case 12: {
                                n6 = 0;
                                while (n6 < this.r) {
                                    dArray3[n29][n6] = 57.29577951308232 * Math.atan2(dArray3[n29][n6], dArray4[n29][n6]);
                                    ++n6;
                                }
                                unitArray[n29] = CommonUnit.g;
                                break;
                            }
                            case 13: {
                                int n31 = 0;
                                while (n31 < this.r) {
                                    dArray3[n29][n31] = Math.atan2(dArray4[n29][n31], dArray3[n29][n31]);
                                    ++n31;
                                }
                                unitArray[n29] = CommonUnit.c;
                                break;
                            }
                            case 14: {
                                n5 = 0;
                                while (n5 < this.r) {
                                    dArray3[n29][n5] = 57.29577951308232 * Math.atan2(dArray4[n29][n5], dArray3[n29][n5]);
                                    ++n5;
                                }
                                unitArray[n29] = CommonUnit.g;
                                break;
                            }
                            case 15: {
                                int n32 = 0;
                                while (n32 < this.r) {
                                    double[] dArray9 = dArray3[n29];
                                    int n33 = n32;
                                    dArray9[n33] = dArray9[n33] % dArray4[n29][n32];
                                    ++n32;
                                }
                                unitArray[n29] = object7[n29];
                                break;
                            }
                            case 16: {
                                int n34 = 0;
                                while (n34 < this.r) {
                                    dArray3[n29][n34] = dArray4[n29][n34] % dArray3[n29][n34];
                                    ++n34;
                                }
                                unitArray[n29] = object6[n29];
                            }
                        }
                        ++n29;
                    }
                    break;
                }
                default: {
                    throw new ArithmeticException("FlatField.binary: illegal operation");
                }
            }
            object = new ErrorEstimate[this.e];
            int n35 = 0;
            while (n35 < this.e) {
                object[n35] = n4 == 202 || errorEstimateArray3[n35] == null || object5[n35] == null ? null : new ErrorEstimate(dArray3[n35], unitArray[n35], n2, errorEstimateArray3[n35], object5[n35], n4);
                ++n35;
            }
            coordinateSystemArray = this.a(mathType, unitArray, (ErrorEstimate[])object);
            coordinateSystemArray.a(dArray3, false);
            coordinateSystemArray.h();
            return coordinateSystemArray;
        }
        if (data instanceof Real || data instanceof RealTuple || data instanceof TupleIface && ((TupleType)data.e()).b()) {
            int n36;
            int n37;
            Unit[] unitArray;
            Object object;
            Object object9;
            int n38;
            MathType mathType2 = ((FunctionType)this.a).i();
            if (!this.a.a(mathType)) {
                throw new TypeException("binary: new_type doesn't match return type");
            }
            if (this.j() || data.j()) {
                return mathType.c();
            }
            double[][] dArray = this.r();
            double[][] dArray10 = new double[this.e][1];
            Unit[] unitArray5 = new Unit[this.e];
            ErrorEstimate[] errorEstimateArray = new ErrorEstimate[this.e];
            if (data instanceof Real) {
                n38 = 0;
                while (n38 < this.e) {
                    dArray10[n38][0] = ((Real)data).a();
                    unitArray5[n38] = ((Real)data).d();
                    errorEstimateArray[n38] = ((Real)data).c();
                    ++n38;
                }
            } else if (data instanceof RealTuple) {
                n38 = 0;
                while (n38 < this.e) {
                    dArray10[n38][0] = ((Real)((RealTuple)data).b(n38)).a();
                    ++n38;
                }
                dArray10 = CoordinateSystem.a(((FunctionType)this.a).j(), this.m, unitArray5, errorEstimateArray, (RealTupleType)data.e(), ((RealTuple)data).c(), ((RealTuple)data).a(), ((RealTuple)data).d(), dArray10);
            } else {
                n38 = ((TupleIface)data).h();
                int n39 = 0;
                int n40 = 0;
                while (n40 < n38) {
                    object9 = ((TupleIface)data).b(n40);
                    if (object9 instanceof Real) {
                        dArray10[n39][0] = ((Real)object9).a();
                        unitArray5[n39] = ((Real)object9).d();
                        errorEstimateArray[n39] = ((Real)object9).c();
                        ++n39;
                    } else {
                        int n41 = ((TupleIface)object9).h();
                        object = new double[n41][1];
                        unitArray = new Unit[n41];
                        ErrorEstimate[] errorEstimateArray4 = new ErrorEstimate[n41];
                        n37 = 0;
                        while (n37 < n41) {
                            object[n37][0] = (ErrorEstimate)((Real)((TupleIface)object9).b(n37)).a();
                            ++n37;
                        }
                        object = CoordinateSystem.a((RealTupleType)((TupleType)mathType2).b(n40), this.p[n40], unitArray, errorEstimateArray4, (RealTupleType)object9.e(), ((RealTuple)object9).c(), ((RealTuple)object9).a(), ((RealTuple)object9).d(), (double[][])object);
                        n36 = 0;
                        while (n36 < n41) {
                            dArray10[n39 + n36][0] = (double)object[n36][0];
                            unitArray5[n39 + n36] = unitArray[n36];
                            errorEstimateArray[n39 + n36] = errorEstimateArray4[n36];
                            ++n36;
                        }
                        n39 += n41;
                    }
                    ++n40;
                }
            }
            Unit[] unitArray6 = (Unit[])this.j.clone();
            Unit[] unitArray7 = unitArray5;
            double[][] dArray11 = dArray;
            object9 = new double[dArray10.length];
            ErrorEstimate[] errorEstimateArray5 = (ErrorEstimate[])this.x.clone();
            object = errorEstimateArray;
            unitArray = new Unit[this.e];
            int n42 = 0;
            while (n42 < dArray10.length) {
                object9[n42] = dArray10[n42][0];
                ++n42;
            }
            switch (n2) {
                case 1: 
                case 2: 
                case 3: 
                case 9: 
                case 10: {
                    n37 = 0;
                    while (n37 < this.e) {
                        int n43;
                        if (unitArray6[n37] == null || unitArray7[n37] == null) {
                            unitArray[n37] = null;
                        } else if (unitArray6[n37] == CommonUnit.d) {
                            unitArray[n37] = unitArray7[n37].b();
                        } else if (unitArray7[n37] == CommonUnit.d) {
                            unitArray[n37] = unitArray6[n37].b();
                        } else {
                            try {
                                unitArray[n37] = unitArray6[n37].b();
                                boolean bl5 = !unitArray[n37].d(unitArray6[n37]);
                                int n44 = n43 = !unitArray[n37].d(unitArray7[n37]) ? 1 : 0;
                                if (bl5) {
                                    dArray11[n37] = unitArray[n37].a(dArray11[n37], unitArray6[n37]);
                                }
                                if (n43 != 0) {
                                    object9[n37] = unitArray[n37].a((double)object9[n37], unitArray7[n37]);
                                }
                                if (n4 != 202 && errorEstimateArray5[n37] != null && object[n37] != null) {
                                    double d9;
                                    double d10;
                                    double d11;
                                    if (bl5) {
                                        Unit unit = errorEstimateArray5[n37].d();
                                        if (unit == null) {
                                            unit = unitArray6[n37];
                                        }
                                        double d12 = 0.5 * errorEstimateArray5[n37].a();
                                        d11 = errorEstimateArray5[n37].c();
                                        d10 = unitArray[n37].a(d11 + d12, unit);
                                        d9 = unitArray[n37].a(d11 - d12, unit);
                                        d11 = (d10 + d9) / 2.0;
                                        d12 = Math.abs(d10 - d9);
                                        errorEstimateArray5[n37] = new ErrorEstimate(d11, d12, unitArray[n37]);
                                    }
                                    if (n43 != 0) {
                                        Unit unit = object[n37].d();
                                        if (unit == null) {
                                            unit = unitArray7[n37];
                                        }
                                        double d13 = 0.5 * object[n37].a();
                                        d11 = object[n37].c();
                                        d10 = unitArray[n37].a(d11 + d13, unit);
                                        d9 = unitArray[n37].a(d11 - d13, unit);
                                        d11 = (d10 + d9) / 2.0;
                                        d13 = Math.abs(d10 - d9);
                                        object[n37] = new ErrorEstimate(d11, d13, unitArray[n37]);
                                    }
                                }
                            }
                            catch (UnitException unitException) {
                                unitArray[n37] = null;
                            }
                        }
                        switch (n2) {
                            case 1: {
                                int n45 = 0;
                                while (n45 < this.r) {
                                    double[] dArray12 = dArray11[n37];
                                    int n46 = n45++;
                                    dArray12[n46] = dArray12[n46] + object9[n37];
                                }
                                break;
                            }
                            case 2: {
                                n43 = 0;
                                while (n43 < this.r) {
                                    double[] dArray13 = dArray11[n37];
                                    int n47 = n43++;
                                    dArray13[n47] = dArray13[n47] - object9[n37];
                                }
                                break;
                            }
                            case 3: {
                                int n48 = 0;
                                while (n48 < this.r) {
                                    dArray11[n37][n48] = (double)(object9[n37] - dArray11[n37][n48]);
                                    ++n48;
                                }
                                break;
                            }
                            case 9: {
                                int n49 = 0;
                                while (n49 < this.r) {
                                    dArray11[n37][n49] = Math.max(dArray11[n37][n49], (double)object9[n37]);
                                    ++n49;
                                }
                                break;
                            }
                            case 10: {
                                int n50 = 0;
                                while (n50 < this.r) {
                                    dArray11[n37][n50] = Math.min(dArray11[n37][n50], (double)object9[n37]);
                                    ++n50;
                                }
                                break;
                            }
                        }
                        ++n37;
                    }
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    n36 = 0;
                    while (n36 < this.e) {
                        Unit unit;
                        Unit unit2;
                        if (unitArray6[n36] != null && !(unit2 = unitArray6[n36].b()).d(unitArray6[n36])) {
                            dArray11[n36] = unit2.a(dArray11[n36], unitArray6[n36]);
                            unitArray6[n36] = unit2;
                        }
                        if (unitArray7[n36] != null && !(unit = unitArray7[n36].b()).d(unitArray7[n36])) {
                            object9[n36] = unit.a((double)object9[n36], unitArray7[n36]);
                            unitArray7[n36] = unit;
                        }
                        if (unitArray6[n36] == null || unitArray7[n36] == null) {
                            unitArray[n36] = null;
                        } else {
                            switch (n2) {
                                case 4: {
                                    unitArray[n36] = unitArray6[n36].d(CommonUnit.d) ? unitArray7[n36] : (unitArray7[n36].d(CommonUnit.d) ? unitArray6[n36] : unitArray6[n36].e(unitArray7[n36]));
                                    break;
                                }
                                case 5: {
                                    unitArray[n36] = unitArray7[n36].d(CommonUnit.d) ? unitArray6[n36] : unitArray6[n36].b(unitArray7[n36]);
                                    break;
                                }
                                case 6: {
                                    unitArray[n36] = unitArray6[n36].d(CommonUnit.d) ? unitArray7[n36] : unitArray7[n36].b(unitArray6[n36]);
                                }
                            }
                        }
                        switch (n2) {
                            case 4: {
                                int n51 = 0;
                                while (n51 < this.r) {
                                    double[] dArray14 = dArray11[n36];
                                    int n52 = n51++;
                                    dArray14[n52] = dArray14[n52] * object9[n36];
                                }
                                break;
                            }
                            case 5: {
                                int n53 = 0;
                                while (n53 < this.r) {
                                    double[] dArray15 = dArray11[n36];
                                    int n54 = n53++;
                                    dArray15[n54] = dArray15[n54] / object9[n36];
                                }
                                break;
                            }
                            case 6: {
                                int n55 = 0;
                                while (n55 < this.r) {
                                    dArray11[n36][n55] = (double)(object9[n36] / dArray11[n36][n55]);
                                    ++n55;
                                }
                                break;
                            }
                        }
                        ++n36;
                    }
                    break;
                }
                case 7: {
                    int n56 = 0;
                    while (n56 < this.e) {
                        Unit unit;
                        Unit unit3;
                        if (unitArray6[n56] != null && !(unit3 = unitArray6[n56].b()).d(unitArray6[n56])) {
                            dArray11[n56] = unit3.a(dArray11[n56], unitArray6[n56]);
                            unitArray6[n56] = unit3;
                        }
                        if (unitArray7[n56] != null && !CommonUnit.d.d(unitArray7[n56]) && !(unit = unitArray7[n56].b()).d(unitArray7[n56])) {
                            object9[n56] = unit.a((double)object9[n56], unitArray7[n56]);
                            unitArray7[n56] = unit;
                        }
                        unitArray[n56] = unitArray6[n56] != null && (unitArray6[n56].d(CommonUnit.d) || unitArray6[n56].d(CommonUnit.a)) ? unitArray6[n56] : null;
                        int n57 = 0;
                        while (n57 < this.r) {
                            dArray11[n56][n57] = Math.pow(dArray11[n56][n57], (double)object9[n56]);
                            ++n57;
                        }
                        ++n56;
                    }
                    break;
                }
                case 8: {
                    int n58 = 0;
                    while (n58 < this.e) {
                        Unit unit;
                        Unit unit4;
                        if (unitArray7[n58] != null && !(unit4 = unitArray7[n58].b()).d(unitArray7[n58])) {
                            object9[n58] = unit4.a((double)object9[n58], unitArray7[n58]);
                            unitArray7[n58] = unit4;
                        }
                        if (unitArray6[n58] != null && !CommonUnit.d.d(unitArray6[n58]) && !(unit = unitArray6[n58].b()).d(unitArray6[n58])) {
                            dArray11[n58] = unit.a(dArray11[n58], unitArray6[n58]);
                            unitArray6[n58] = unit;
                        }
                        unitArray[n58] = unitArray7[n58] != null && (unitArray7[n58].d(CommonUnit.d) || unitArray7[n58].d(CommonUnit.a)) ? unitArray7[n58] : null;
                        int n59 = 0;
                        while (n59 < this.r) {
                            dArray11[n58][n59] = Math.pow((double)object9[n58], dArray11[n58][n59]);
                            ++n59;
                        }
                        ++n58;
                    }
                    break;
                }
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    int n60 = 0;
                    while (n60 < this.e) {
                        if (unitArray6[n60] != null && unitArray7[n60] != null) {
                            Unit unit = unitArray6[n60].b();
                            if (!unit.d(unitArray6[n60])) {
                                dArray11[n60] = unit.a(dArray11[n60], unitArray6[n60]);
                                unitArray6[n60] = unit;
                            }
                            if (!unit.d(unitArray7[n60])) {
                                object9[n60] = unit.a((double)object9[n60], unitArray7[n60]);
                                unitArray7[n60] = unit;
                            }
                        }
                        switch (n2) {
                            case 11: {
                                int n61 = 0;
                                while (n61 < this.r) {
                                    dArray11[n60][n61] = Math.atan2(dArray11[n60][n61], (double)object9[n60]);
                                    ++n61;
                                }
                                unitArray[n60] = CommonUnit.c;
                                break;
                            }
                            case 12: {
                                int n62 = 0;
                                while (n62 < this.r) {
                                    dArray11[n60][n62] = 57.29577951308232 * Math.atan2(dArray11[n60][n62], (double)object9[n60]);
                                    ++n62;
                                }
                                unitArray[n60] = CommonUnit.g;
                                break;
                            }
                            case 13: {
                                int n63 = 0;
                                while (n63 < this.r) {
                                    dArray11[n60][n63] = Math.atan2((double)object9[n60], dArray11[n60][n63]);
                                    ++n63;
                                }
                                unitArray[n60] = CommonUnit.c;
                                break;
                            }
                            case 14: {
                                int n64 = 0;
                                while (n64 < this.r) {
                                    dArray11[n60][n64] = 57.29577951308232 * Math.atan2((double)object9[n60], dArray11[n60][n64]);
                                    ++n64;
                                }
                                unitArray[n60] = CommonUnit.g;
                                break;
                            }
                            case 15: {
                                int n65 = 0;
                                while (n65 < this.r) {
                                    double[] dArray16 = dArray11[n60];
                                    int n66 = n65++;
                                    dArray16[n66] = dArray16[n66] % object9[n60];
                                }
                                unitArray[n60] = unitArray6[n60];
                                break;
                            }
                            case 16: {
                                int n67 = 0;
                                while (n67 < this.r) {
                                    dArray11[n60][n67] = (double)(object9[n60] % dArray11[n60][n67]);
                                    ++n67;
                                }
                                unitArray[n60] = unitArray7[n60];
                            }
                        }
                        ++n60;
                    }
                    break;
                }
                default: {
                    throw new ArithmeticException("FlatField.binary: illegal operation");
                }
            }
            ErrorEstimate[] errorEstimateArray6 = new ErrorEstimate[this.e];
            int n68 = 0;
            while (n68 < this.e) {
                errorEstimateArray6[n68] = n4 == 202 || errorEstimateArray5[n68] == null || object[n68] == null ? null : new ErrorEstimate(dArray11[n68], unitArray[n68], n2, errorEstimateArray5[n68], object[n68], n4);
                ++n68;
            }
            FlatField flatField = this.a(mathType, unitArray, errorEstimateArray6);
            flatField.a(dArray11, false);
            flatField.h();
            return flatField;
        }
        throw new TypeException("Field.binary");
    }

    public Data a(int n2, MathType mathType, int n3, int n4) throws VisADException {
        int n5;
        if (this.j()) {
            return this.p();
        }
        if (mathType == null) {
            throw new TypeException("unary: new_type may not be null");
        }
        double[][] dArray = this.r();
        Unit[] unitArray = new Unit[this.e];
        Unit[] unitArray2 = (Unit[])this.j.clone();
        ErrorEstimate[] errorEstimateArray = (ErrorEstimate[])this.x.clone();
        FlatField.a(dArray, unitArray2, errorEstimateArray);
        switch (n2) {
            case 21: {
                int n6;
                double[] dArray2;
                n5 = 0;
                while (n5 < this.e) {
                    dArray2 = dArray[n5];
                    n6 = 0;
                    while (n6 < this.r) {
                        dArray2[n6] = Math.abs(dArray2[n6]);
                        ++n6;
                    }
                    unitArray[n5] = unitArray2[n5];
                    ++n5;
                }
                break;
            }
            case 22: {
                int n6;
                double[] dArray2;
                n5 = 0;
                while (n5 < this.e) {
                    dArray2 = dArray[n5];
                    n6 = 0;
                    while (n6 < this.r) {
                        dArray2[n6] = Math.acos(dArray2[n6]);
                        ++n6;
                    }
                    unitArray[n5] = CommonUnit.c;
                    ++n5;
                }
                break;
            }
            case 23: {
                int n6;
                double[] dArray2;
                n5 = 0;
                while (n5 < this.e) {
                    dArray2 = dArray[n5];
                    n6 = 0;
                    while (n6 < this.r) {
                        dArray2[n6] = 57.29577951308232 * Math.acos(dArray2[n6]);
                        ++n6;
                    }
                    unitArray[n5] = CommonUnit.g;
                    ++n5;
                }
                break;
            }
            case 24: {
                int n6;
                double[] dArray2;
                n5 = 0;
                while (n5 < this.e) {
                    dArray2 = dArray[n5];
                    n6 = 0;
                    while (n6 < this.r) {
                        dArray2[n6] = Math.asin(dArray2[n6]);
                        ++n6;
                    }
                    unitArray[n5] = CommonUnit.c;
                    ++n5;
                }
                break;
            }
            case 25: {
                int n6;
                double[] dArray2;
                n5 = 0;
                while (n5 < this.e) {
                    dArray2 = dArray[n5];
                    n6 = 0;
                    while (n6 < this.r) {
                        dArray2[n6] = 57.29577951308232 * Math.asin(dArray2[n6]);
                        ++n6;
                    }
                    unitArray[n5] = CommonUnit.g;
                    ++n5;
                }
                break;
            }
            case 26: {
                int n6;
                double[] dArray2;
                n5 = 0;
                while (n5 < this.e) {
                    dArray2 = dArray[n5];
                    n6 = 0;
                    while (n6 < this.r) {
                        dArray2[n6] = Math.atan(dArray2[n6]);
                        ++n6;
                    }
                    unitArray[n5] = CommonUnit.c;
                    ++n5;
                }
                break;
            }
            case 27: {
                int n6;
                double[] dArray2;
                n5 = 0;
                while (n5 < this.e) {
                    dArray2 = dArray[n5];
                    n6 = 0;
                    while (n6 < this.r) {
                        dArray2[n6] = 57.29577951308232 * Math.atan(dArray2[n6]);
                        ++n6;
                    }
                    unitArray[n5] = CommonUnit.g;
                    ++n5;
                }
                break;
            }
            case 28: {
                int n6;
                double[] dArray2;
                n5 = 0;
                while (n5 < this.e) {
                    dArray2 = dArray[n5];
                    n6 = 0;
                    while (n6 < this.r) {
                        dArray2[n6] = Math.ceil(dArray2[n6]);
                        ++n6;
                    }
                    unitArray[n5] = unitArray2[n5];
                    ++n5;
                }
                break;
            }
            case 29: {
                int n6;
                double[] dArray2;
                n5 = 0;
                while (n5 < this.e) {
                    dArray2 = dArray[n5];
                    if (CommonUnit.g.d(unitArray2[n5])) {
                        n6 = 0;
                        while (n6 < this.r) {
                            dArray2[n6] = Math.cos(Math.PI / 180 * dArray2[n6]);
                            ++n6;
                        }
                    } else {
                        n6 = 0;
                        while (n6 < this.r) {
                            dArray2[n6] = Math.cos(dArray2[n6]);
                            ++n6;
                        }
                    }
                    unitArray[n5] = CommonUnit.a.d(unitArray2[n5]) ? unitArray2[n5] : null;
                    ++n5;
                }
                break;
            }
            case 30: {
                int n6;
                double[] dArray2;
                n5 = 0;
                while (n5 < this.e) {
                    dArray2 = dArray[n5];
                    if (CommonUnit.c.d(unitArray2[n5])) {
                        n6 = 0;
                        while (n6 < this.r) {
                            dArray2[n6] = Math.cos(dArray2[n6]);
                            ++n6;
                        }
                    } else {
                        n6 = 0;
                        while (n6 < this.r) {
                            dArray2[n6] = Math.cos(Math.PI / 180 * dArray2[n6]);
                            ++n6;
                        }
                    }
                    unitArray[n5] = CommonUnit.a.d(unitArray2[n5]) ? unitArray2[n5] : null;
                    ++n5;
                }
                break;
            }
            case 31: {
                int n6;
                double[] dArray2;
                n5 = 0;
                while (n5 < this.e) {
                    dArray2 = dArray[n5];
                    n6 = 0;
                    while (n6 < this.r) {
                        dArray2[n6] = Math.exp(dArray2[n6]);
                        ++n6;
                    }
                    unitArray[n5] = CommonUnit.a.d(unitArray2[n5]) ? unitArray2[n5] : null;
                    ++n5;
                }
                break;
            }
            case 32: {
                int n6;
                double[] dArray2;
                n5 = 0;
                while (n5 < this.e) {
                    dArray2 = dArray[n5];
                    n6 = 0;
                    while (n6 < this.r) {
                        dArray2[n6] = Math.floor(dArray2[n6]);
                        ++n6;
                    }
                    unitArray[n5] = unitArray2[n5];
                    ++n5;
                }
                break;
            }
            case 33: {
                int n6;
                double[] dArray2;
                n5 = 0;
                while (n5 < this.e) {
                    dArray2 = dArray[n5];
                    n6 = 0;
                    while (n6 < this.r) {
                        dArray2[n6] = Math.log(dArray2[n6]);
                        ++n6;
                    }
                    unitArray[n5] = CommonUnit.a.d(unitArray2[n5]) ? unitArray2[n5] : null;
                    ++n5;
                }
                break;
            }
            case 34: {
                int n6;
                double[] dArray2;
                n5 = 0;
                while (n5 < this.e) {
                    dArray2 = dArray[n5];
                    n6 = 0;
                    while (n6 < this.r) {
                        dArray2[n6] = Math.rint(dArray2[n6]);
                        ++n6;
                    }
                    unitArray[n5] = unitArray2[n5];
                    ++n5;
                }
                break;
            }
            case 35: {
                int n6;
                double[] dArray2;
                n5 = 0;
                while (n5 < this.e) {
                    dArray2 = dArray[n5];
                    n6 = 0;
                    while (n6 < this.r) {
                        dArray2[n6] = Math.round(dArray2[n6]);
                        ++n6;
                    }
                    unitArray[n5] = unitArray2[n5];
                    ++n5;
                }
                break;
            }
            case 36: {
                int n6;
                double[] dArray2;
                n5 = 0;
                while (n5 < this.e) {
                    dArray2 = dArray[n5];
                    if (CommonUnit.g.d(unitArray2[n5])) {
                        n6 = 0;
                        while (n6 < this.r) {
                            dArray2[n6] = Math.sin(Math.PI / 180 * dArray2[n6]);
                            ++n6;
                        }
                    } else {
                        n6 = 0;
                        while (n6 < this.r) {
                            dArray2[n6] = Math.sin(dArray2[n6]);
                            ++n6;
                        }
                    }
                    unitArray[n5] = CommonUnit.a.d(unitArray2[n5]) ? unitArray2[n5] : null;
                    ++n5;
                }
                break;
            }
            case 37: {
                int n6;
                double[] dArray2;
                n5 = 0;
                while (n5 < this.e) {
                    dArray2 = dArray[n5];
                    if (CommonUnit.c.d(unitArray2[n5])) {
                        n6 = 0;
                        while (n6 < this.r) {
                            dArray2[n6] = Math.sin(dArray2[n6]);
                            ++n6;
                        }
                    } else {
                        n6 = 0;
                        while (n6 < this.r) {
                            dArray2[n6] = Math.sin(Math.PI / 180 * dArray2[n6]);
                            ++n6;
                        }
                    }
                    unitArray[n5] = CommonUnit.a.d(unitArray2[n5]) ? unitArray2[n5] : null;
                    ++n5;
                }
                break;
            }
            case 38: {
                int n6;
                double[] dArray2;
                n5 = 0;
                while (n5 < this.e) {
                    dArray2 = dArray[n5];
                    n6 = 0;
                    while (n6 < this.r) {
                        dArray2[n6] = Math.sqrt(dArray2[n6]);
                        ++n6;
                    }
                    if (unitArray2[n5] == null) {
                        unitArray[n5] = null;
                    } else {
                        try {
                            unitArray[n5] = unitArray2[n5].d();
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            unitArray[n5] = null;
                        }
                        catch (UnitException unitException) {
                            unitArray[n5] = null;
                        }
                    }
                    ++n5;
                }
                break;
            }
            case 39: {
                int n6;
                double[] dArray2;
                n5 = 0;
                while (n5 < this.e) {
                    dArray2 = dArray[n5];
                    if (CommonUnit.g.d(unitArray2[n5])) {
                        n6 = 0;
                        while (n6 < this.r) {
                            dArray2[n6] = Math.tan(Math.PI / 180 * dArray2[n6]);
                            ++n6;
                        }
                    } else {
                        n6 = 0;
                        while (n6 < this.r) {
                            dArray2[n6] = Math.tan(dArray2[n6]);
                            ++n6;
                        }
                    }
                    unitArray[n5] = CommonUnit.a.d(unitArray2[n5]) ? unitArray2[n5] : null;
                    ++n5;
                }
                break;
            }
            case 40: {
                int n6;
                double[] dArray2;
                n5 = 0;
                while (n5 < this.e) {
                    dArray2 = dArray[n5];
                    if (CommonUnit.c.d(unitArray2[n5])) {
                        n6 = 0;
                        while (n6 < this.r) {
                            dArray2[n6] = Math.tan(dArray2[n6]);
                            ++n6;
                        }
                    } else {
                        n6 = 0;
                        while (n6 < this.r) {
                            dArray2[n6] = Math.tan(Math.PI / 180 * dArray2[n6]);
                            ++n6;
                        }
                    }
                    unitArray[n5] = CommonUnit.a.d(unitArray2[n5]) ? unitArray2[n5] : null;
                    ++n5;
                }
                break;
            }
            case 41: {
                int n6;
                double[] dArray2;
                n5 = 0;
                while (n5 < this.e) {
                    dArray2 = dArray[n5];
                    n6 = 0;
                    while (n6 < this.r) {
                        dArray2[n6] = -dArray2[n6];
                        ++n6;
                    }
                    unitArray[n5] = unitArray2[n5];
                    ++n5;
                }
                break;
            }
            case 42: {
                n5 = 0;
                while (n5 < this.e) {
                    unitArray[n5] = unitArray2[n5];
                    ++n5;
                }
                break;
            }
        }
        ErrorEstimate[] errorEstimateArray2 = new ErrorEstimate[this.e];
        n5 = 0;
        while (n5 < this.e) {
            errorEstimateArray2[n5] = n4 == 202 || errorEstimateArray[n5] == null ? null : new ErrorEstimate(dArray[n5], unitArray[n5], n2, errorEstimateArray[n5], n4);
            ++n5;
        }
        FlatField flatField = this.a(mathType, unitArray, errorEstimateArray2);
        flatField.a(dArray, false);
        flatField.h();
        return flatField;
    }

    public static void a(double[][] dArray, Unit[] unitArray, ErrorEstimate[] errorEstimateArray) throws UnitException {
        int n2 = 0;
        while (n2 < dArray.length) {
            Unit unit = unitArray[n2];
            if (unit != null && !(unit instanceof PromiscuousUnit)) {
                Unit unit2 = unit.b();
                if (Unit.a(unit2, CommonUnit.a)) {
                    unit2 = CommonUnit.a;
                }
                if (!unit2.d(unit)) {
                    dArray[n2] = unit2.a(dArray[n2], unit);
                    if (errorEstimateArray[n2] != null) {
                        errorEstimateArray[n2] = new ErrorEstimate(unit2.a(errorEstimateArray[n2].c(), unit), errorEstimateArray[n2].a(), unit2);
                    }
                    unitArray[n2] = unit2;
                }
            }
            ++n2;
        }
    }

    public Field a(Set set, int n2, int n3) throws VisADException, RemoteException {
        int n4;
        double[] dArray;
        float[] fArray;
        int n5;
        Object object;
        Object object2;
        int n6;
        boolean bl2;
        ErrorEstimate[] errorEstimateArray;
        MathType mathType;
        if (this.o.equals(set)) {
            return this;
        }
        int n7 = this.o.s();
        if (n7 != set.s()) {
            throw new SetException("FlatField.resample: bad Set Dimension");
        }
        CoordinateSystem coordinateSystem = set.d();
        Unit[] unitArray = set.h();
        ErrorEstimate[] errorEstimateArray2 = n3 == 202 ? new ErrorEstimate[n7] : set.o();
        Set[] setArray = new Set[this.e];
        int n8 = 0;
        while (n8 < this.e) {
            mathType = new SetType(((FunctionType)this.a).j().b(n8));
            setArray[n8] = n2 == 100 ? this.k[n8] : new FloatSet(mathType);
            ++n8;
        }
        mathType = ((FunctionType)this.a).i();
        RealTupleType realTupleType = ((SetType)set.e()).b();
        FunctionType functionType = new FunctionType(realTupleType, mathType);
        FlatField flatField = new FlatField(functionType, set, this.m, this.p, setArray, this.j);
        if (this.j()) {
            return flatField;
        }
        ErrorEstimate[] errorEstimateArray3 = errorEstimateArray = n3 == 202 ? new ErrorEstimate[this.e] : this.x;
        int n9 = set.r();
        int[] nArray = set.n();
        float[][] fArray2 = set.b(nArray);
        ErrorEstimate[] errorEstimateArray4 = new ErrorEstimate[n7];
        float[][] fArray3 = fArray2;
        try {
            fArray2 = CoordinateSystem.b(((FunctionType)this.a).e(), this.l, this.v, errorEstimateArray4, ((SetType)set.e()).b(), coordinateSystem, unitArray, errorEstimateArray2, fArray2);
        }
        catch (UnitException unitException) {
            throw new VisADException("Sampling set is not compatible with domain");
        }
        boolean bl3 = fArray2 != fArray3;
        boolean bl4 = bl2 = n3 != 202;
        if (bl2) {
            n6 = 0;
            while (n6 < n7) {
                if (errorEstimateArray4[n6] == null) {
                    bl2 = false;
                }
                ++n6;
            }
            boolean bl5 = false;
            n6 = 0;
            while (n6 < this.e) {
                if (errorEstimateArray[n6] != null) {
                    bl5 = true;
                }
                ++n6;
            }
            if (!bl5) {
                bl2 = false;
            }
        }
        float[][] fArray4 = new float[this.e][n7];
        float[][] fArray5 = new float[1][1];
        if (bl2) {
            fArray5 = Set.c(ErrorEstimate.b(errorEstimateArray4));
        }
        float[][] fArray6 = null;
        if (bl2 || 10 * n9 > this.v()) {
            fArray6 = this.d(false);
        }
        double[][] dArray2 = new double[this.e][n9];
        if (n2 == 101 && this.o instanceof SimpleSet) {
            float f2;
            int n10;
            object2 = new int[n9][];
            object = new float[n9][];
            ((SimpleSet)this.o).a(fArray2, (int[][])object2, (float[][])object);
            if (fArray6 != null) {
                n5 = 0;
                while (n5 < this.e) {
                    fArray = fArray6[n5];
                    dArray = dArray2[n5];
                    n6 = 0;
                    while (n6 < n9) {
                        int n11;
                        float f3 = Float.NaN;
                        int n12 = n11 = object2[n6] == null ? 0 : ((int)object2[n6]).length;
                        if (n11 > 0) {
                            f3 = fArray[object2[n6][0]] * object[n6][0];
                            n10 = 1;
                            while (n10 < n11) {
                                f3 += fArray[object2[n6][n10]] * object[n6][n10];
                                ++n10;
                            }
                            dArray[nArray[n6]] = f3;
                        } else {
                            dArray[nArray[n6]] = Double.NaN;
                        }
                        ++n6;
                    }
                    ++n5;
                }
            } else {
                n6 = 0;
                while (n6 < n9) {
                    int n13;
                    int n14 = n13 = object2[n6] == null ? 0 : ((int)object2[n6]).length;
                    if (n13 > 0) {
                        double[][] dArrayArray = new double[n13][];
                        n10 = 0;
                        while (n10 < n13) {
                            dArrayArray[n10] = this.c((int)object2[n6][n10]);
                            ++n10;
                        }
                        n5 = 0;
                        while (n5 < this.e) {
                            f2 = (float)dArrayArray[0][n5] * object[n6][0];
                            n10 = 1;
                            while (n10 < n13) {
                                f2 += (float)dArrayArray[n10][n5] * object[n6][n10];
                                ++n10;
                            }
                            dArray2[n5][nArray[n6]] = f2;
                            ++n5;
                        }
                    } else {
                        n5 = 0;
                        while (n5 < this.e) {
                            dArray2[n5][nArray[n6]] = Double.NaN;
                            ++n5;
                        }
                    }
                    ++n6;
                }
            }
            if (bl2) {
                int[][] nArrayArray = new int[2 * n7][];
                float[][] fArrayArray = new float[2 * n7][];
                ((SimpleSet)this.o).a(fArray5, nArrayArray, fArrayArray);
                n5 = 0;
                while (n5 < this.e) {
                    n6 = 0;
                    while (n6 < n7) {
                        f2 = Float.NaN;
                        float f4 = Float.NaN;
                        n4 = nArrayArray[2 * n6].length;
                        if (n4 > 0) {
                            f2 = fArray6[n5][nArrayArray[2 * n6][0]] * fArrayArray[2 * n6][0];
                            n10 = 1;
                            while (n10 < n4) {
                                f2 += fArray6[n5][nArrayArray[2 * n6][n10]] * fArrayArray[2 * n6][n10];
                                ++n10;
                            }
                        }
                        if ((n4 = nArrayArray[2 * n6 + 1].length) > 0) {
                            f4 = fArray6[n5][nArrayArray[2 * n6 + 1][0]] * fArrayArray[2 * n6 + 1][0];
                            n10 = 1;
                            while (n10 < n4) {
                                f4 += fArray6[n5][nArrayArray[2 * n6 + 1][n10]] * fArrayArray[2 * n6 + 1][n10];
                                ++n10;
                            }
                        }
                        fArray4[n5][n6] = Math.abs(f4 - f2);
                        ++n6;
                    }
                    ++n5;
                }
            }
        } else {
            object2 = this.o.b(fArray2);
            if (fArray6 != null) {
                n5 = 0;
                while (n5 < this.e) {
                    fArray = fArray6[n5];
                    dArray = dArray2[n5];
                    n6 = 0;
                    while (n6 < n9) {
                        dArray[nArray[n6]] = object2[n6] >= 0 ? (double)fArray[object2[n6]] : Double.NaN;
                        ++n6;
                    }
                    ++n5;
                }
            } else {
                n6 = 0;
                while (n6 < n9) {
                    if (object2[n6] >= 0) {
                        object = this.c(object2[n6]);
                        n5 = 0;
                        while (n5 < this.e) {
                            dArray2[n5][nArray[n6]] = (float)object[n5];
                            ++n5;
                        }
                    } else {
                        n5 = 0;
                        while (n5 < this.e) {
                            dArray2[n5][nArray[n6]] = Double.NaN;
                            ++n5;
                        }
                    }
                    ++n6;
                }
            }
            if (bl2) {
                object = this.o.b(fArray5);
                n5 = 0;
                while (n5 < this.e) {
                    n6 = 0;
                    while (n6 < n7) {
                        float f5 = object[2 * n6] >= 0 ? fArray6[n5][object[2 * n6]] : Float.NaN;
                        float f6 = object[2 * n6 + 1] >= 0 ? fArray6[n5][object[2 * n6 + 1]] : Float.NaN;
                        fArray4[n5][n6] = Math.abs(f6 - f5);
                        ++n6;
                    }
                    ++n5;
                }
            }
        }
        if (bl2) {
            n5 = 0;
            while (n5 < this.e) {
                if (errorEstimateArray[n5] != null) {
                    float f7 = (float)errorEstimateArray[n5].a();
                    if (n3 == 200) {
                        f7 *= f7;
                        n6 = 0;
                        while (n6 < n7) {
                            f7 += fArray4[n5][n6] * fArray4[n5][n6];
                            ++n6;
                        }
                        f7 = (float)Math.sqrt(f7);
                    } else {
                        n6 = 0;
                        while (n6 < n7) {
                            f7 += fArray4[n5][n6];
                            ++n6;
                        }
                    }
                    errorEstimateArray3[n5] = new ErrorEstimate(dArray2[n5], (double)f7, this.j[n5]);
                }
                ++n5;
            }
        } else if (n3 != 202) {
            n5 = 0;
            while (n5 < this.e) {
                if (errorEstimateArray[n5] != null) {
                    errorEstimateArray3[n5] = new ErrorEstimate(dArray2[n5], errorEstimateArray[n5].a(), this.j[n5]);
                }
                ++n5;
            }
        }
        if (bl3) {
            errorEstimateArray = errorEstimateArray3;
            MathType mathType2 = ((FunctionType)this.a).i();
            if (mathType2 instanceof RealVectorType) {
                dArray2 = ((RealVectorType)mathType2).a(((FunctionType)this.a).e(), this.l, this.v, errorEstimateArray4, ((SetType)set.e()).b(), coordinateSystem, unitArray, this.m, errorEstimateArray, errorEstimateArray3, Set.d(fArray3), Set.d(fArray2), dArray2);
            } else if (mathType2 instanceof TupleType && !(mathType2 instanceof RealTupleType)) {
                int n15 = 0;
                int n16 = ((TupleType)mathType2).f();
                n5 = 0;
                while (n5 < n16) {
                    MathType mathType3 = ((TupleType)mathType2).b(n5);
                    if (mathType3 instanceof RealVectorType) {
                        int n17 = ((RealVectorType)mathType3).f();
                        Object object3 = new double[n17][];
                        n4 = 0;
                        while (n4 < n17) {
                            object3[n4] = dArray2[n15 + n4];
                            ++n4;
                        }
                        ErrorEstimate[] errorEstimateArray5 = new ErrorEstimate[n17];
                        int n18 = 0;
                        while (n18 < n17) {
                            errorEstimateArray5[n18] = errorEstimateArray[n15 + n18];
                            ++n18;
                        }
                        ErrorEstimate[] errorEstimateArray6 = errorEstimateArray5;
                        object3 = ((RealVectorType)mathType3).a(((FunctionType)this.a).e(), this.l, this.v, errorEstimateArray4, ((SetType)set.e()).b(), coordinateSystem, unitArray, this.p[n5], errorEstimateArray5, errorEstimateArray6, Set.d(fArray3), Set.d(fArray2), (double[][])object3);
                        int n19 = 0;
                        while (n19 < n17) {
                            dArray2[n15 + n19] = object3[n19];
                            ++n19;
                        }
                        int n20 = 0;
                        while (n20 < n17) {
                            errorEstimateArray3[n15 + n20] = errorEstimateArray6[n20];
                            ++n20;
                        }
                    }
                    n15 = mathType3 instanceof RealType ? ++n15 : (n15 += ((RealTupleType)mathType3).f());
                    ++n5;
                }
            }
        }
        flatField.a(dArray2, false);
        flatField.a(errorEstimateArray3);
        flatField.h();
        return flatField;
    }

    public Field d() throws VisADException, RemoteException {
        FieldImpl fieldImpl = new FieldImpl((FunctionType)this.a, this.o);
        if (this.j()) {
            return fieldImpl;
        }
        int n2 = 0;
        while (n2 < this.r) {
            fieldImpl.a(n2, this.d(n2));
            ++n2;
        }
        return fieldImpl;
    }

    public DataShadow a(ShadowType shadowType, DataShadow dataShadow) throws VisADException {
        int n2;
        Object object;
        boolean bl2;
        if (this.j()) {
            return dataShadow;
        }
        ShadowRealTupleType shadowRealTupleType = ((ShadowFunctionType)shadowType).h();
        int n3 = shadowRealTupleType.M();
        double[][] dArray = new double[2][n3];
        dataShadow = this.o.a(shadowRealTupleType, dataShadow, dArray, true);
        int[] nArray = ((ShadowFunctionType)shadowType).j();
        boolean bl3 = false;
        int n4 = 0;
        while (n4 < this.e) {
            if (nArray[n4] >= 0) {
                bl3 = true;
            }
            ++n4;
        }
        if (!bl3) {
            return dataShadow;
        }
        boolean bl4 = bl2 = this.m != null;
        if (this.p != null) {
            int n5 = 0;
            while (n5 < this.p.length) {
                bl2 |= this.p[n5] != null;
                ++n5;
            }
        }
        dArray = bl2 ? new double[2][this.e] : null;
        double[][] dArray2 = this.r();
        int n6 = 0;
        while (n6 < this.e) {
            object = dArray2[n6];
            n2 = nArray[n6];
            if (n2 >= 0 || bl2) {
                double d2 = Double.MAX_VALUE;
                double d3 = -1.7976931348623157E308;
                int n7 = 0;
                while (n7 < this.r) {
                    if (object[n7] == object[n7]) {
                        d2 = Math.min(d2, (double)object[n7]);
                        d3 = Math.max(d3, (double)object[n7]);
                    }
                    ++n7;
                }
                Unit unit = ((RealType)((FunctionType)this.a).j().b(n6)).e();
                if (unit != null && !unit.d(this.j[n6])) {
                    d2 = unit.a(d2, this.j[n6]);
                    d3 = unit.a(d3, this.j[n6]);
                }
                if (bl2) {
                    dArray[0][n6] = Math.min(dArray[0][n6], d2);
                    dArray[1][n6] = Math.max(dArray[1][n6], d3);
                }
                if (n2 >= 0 && n2 < dataShadow.b[0].length) {
                    dataShadow.b[0][n2] = Math.min(dataShadow.b[0][n2], d2);
                    dataShadow.b[1][n2] = Math.max(dataShadow.b[1][n2], d3);
                }
            }
            ++n6;
        }
        if (this.m != null) {
            object = (ShadowRealTupleType)((ShadowFunctionType)shadowType).v();
            ShadowRealTupleType shadowRealTupleType2 = ((ShadowRealTupleType)object).F();
            dataShadow = this.a((ShadowRealTupleType)object, this.m, this.j, dataShadow, shadowRealTupleType2, dArray);
        } else if (this.p != null) {
            object = (TupleType)((FunctionType)this.a).i();
            n2 = 0;
            int n8 = 0;
            while (n8 < this.p.length) {
                MathType mathType = ((TupleType)object).b(n8);
                if (mathType instanceof RealType) {
                    ++n2;
                } else {
                    int n9 = ((RealTupleType)mathType).f();
                    if (this.p[n8] != null) {
                        double[][] dArray3 = new double[2][n9];
                        Unit[] unitArray = new Unit[n9];
                        int n10 = 0;
                        while (n10 < n9) {
                            dArray3[0][n10] = dArray[0][n2];
                            dArray3[1][n10] = dArray[1][n2];
                            unitArray[n10] = this.j[n2];
                            ++n2;
                            ++n10;
                        }
                        ShadowRealTupleType shadowRealTupleType3 = (ShadowRealTupleType)((ShadowTupleType)((ShadowFunctionType)shadowType).v()).e(n8);
                        ShadowRealTupleType shadowRealTupleType4 = shadowRealTupleType3.F();
                        dataShadow = this.a(shadowRealTupleType3, this.p[n8], unitArray, dataShadow, shadowRealTupleType4, dArray3);
                    } else {
                        n2 += n9;
                    }
                }
                ++n8;
            }
        }
        return dataShadow;
    }

    public Data a(Data data, int n2) throws VisADException, RemoteException {
        if (this.j() || data == null || data.j()) {
            return this;
        }
        FlatField flatField = new FlatField((FunctionType)this.a, this.o, this.m, this.p, this.k, this.j);
        if (this.j()) {
            return flatField;
        }
        FlatField flatField2 = (FlatField)((FlatField)data).a(this.o, 100, 202);
        double[][] dArray = this.r();
        flatField.a(dArray, false);
        ErrorEstimate[] errorEstimateArray = new ErrorEstimate[this.e];
        double[][] dArray2 = flatField2.r();
        int n3 = 0;
        while (n3 < this.e) {
            double d2 = 0.0;
            int n4 = 0;
            while (n4 < dArray2[n3].length) {
                d2 += dArray2[n3][n4];
                ++n4;
            }
            double d3 = this.x[n3].a();
            double d4 = n2 == 200 ? Math.sqrt(d2 * d2 + d3 * d3) : Math.abs(d2 /= (double)dArray2.length) + Math.abs(d3);
            errorEstimateArray[n3] = new ErrorEstimate(dArray[n3], d4, this.j[n3]);
            ++n3;
        }
        flatField.a(errorEstimateArray);
        return flatField;
    }

    public boolean m() {
        return true;
    }

    private FlatField p() throws VisADException {
        return this.a(this.j, this.x);
    }

    private FlatField a(Unit[] unitArray, ErrorEstimate[] errorEstimateArray) throws VisADException {
        return this.a(null, unitArray, errorEstimateArray);
    }

    private FlatField a(MathType mathType, Unit[] unitArray, ErrorEstimate[] errorEstimateArray) throws VisADException {
        Serializable serializable;
        MathType mathType2 = mathType == null ? this.a : mathType;
        Set[] setArray = new Set[this.e];
        int n2 = 0;
        while (n2 < this.e) {
            serializable = new SetType(((FunctionType)mathType2).j().b(n2));
            setArray[n2] = new DoubleSet((MathType)serializable);
            ++n2;
        }
        serializable = new FlatField((FunctionType)mathType2, this.o, this.m, this.p, setArray, unitArray);
        double[][] dArray = this.r();
        super.a(dArray, false);
        ((FlatField)serializable).a(errorEstimateArray);
        ((FlatField)serializable).h();
        return serializable;
    }

    public Object clone() {
        FlatField flatField;
        try {
            flatField = (FlatField)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("Assertion failure");
        }
        double[][] dArray = this.q;
        synchronized (dArray) {
            if (!this.u) {
                try {
                    flatField.a(this.a(true), false);
                }
                catch (VisADException visADException) {
                    throw new RuntimeException(visADException.toString());
                }
                try {
                    flatField.a(this.x);
                }
                catch (FieldException fieldException) {
                    throw new Error("Assertion failure");
                }
            }
        }
        return flatField;
    }

    public String a() throws VisADException {
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = 8 / this.e;
        if (n2 < 1) {
            n2 = 1;
        }
        int n3 = this.o instanceof GriddedSet ? ((GriddedSet)this.o).b(0) : this.r;
        RealTupleType realTupleType = ((FunctionType)this.a).j();
        RealType[] realTypeArray = realTupleType.e();
        double[][] dArray = this.r();
        int n4 = n3;
        int n5 = 0;
        while (n5 < this.r) {
            int n6 = Math.min(n4, Math.min(n2, this.r - n5));
            int n7 = n5 + n6;
            int n8 = n5;
            while (n8 < n7) {
                Object object;
                if (n8 > n5) {
                    stringBuffer.append(", ");
                }
                if (this.e == 1) {
                    stringBuffer.append(new Real(realTypeArray[0], dArray[0][n8], this.j[0]).toString());
                } else if (((FunctionType)this.a).b()) {
                    object = "(" + new Real(realTypeArray[0], dArray[0][n8], this.j[0]);
                    int n9 = 1;
                    while (n9 < this.e) {
                        object = (String)object + ", " + new Real(realTypeArray[n9], dArray[n9][n8], this.j[n9]);
                        ++n9;
                    }
                    object = (String)object + ")";
                    stringBuffer.append((String)object);
                } else {
                    object = (TupleType)((FunctionType)this.a).i();
                    String string = "(";
                    int n10 = 0;
                    int n11 = 0;
                    while (n11 < ((TupleType)object).f()) {
                        MathType mathType;
                        if (n10 > 0) {
                            string = string + ", ";
                        }
                        if ((mathType = ((TupleType)object).b(n11)) instanceof RealType) {
                            string = string + new Real(realTypeArray[n10], dArray[n10][n8], this.j[n10]);
                            ++n10;
                        } else {
                            int n12 = ((TupleType)mathType).f();
                            string = string + "(" + new Real(realTypeArray[n10], dArray[n10][n8], this.j[n10]);
                            ++n10;
                            int n13 = 1;
                            while (n13 < n12) {
                                string = string + ", " + new Real(realTypeArray[n10], dArray[n10][n8], this.j[n10]);
                                ++n10;
                                ++n13;
                            }
                            string = string + ")";
                        }
                        ++n11;
                    }
                    string = string + ")";
                    stringBuffer.append(string);
                }
                ++n8;
            }
            stringBuffer.append("\n");
            n5 = n7;
            if ((n4 -= n6) > 0) continue;
            n4 = n3;
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        try {
            if (this.j()) {
                return "FlatField  missing\n";
            }
            return "FlatField\n    " + this.a + "\n" + this.a();
        }
        catch (VisADException visADException) {
            return visADException.toString();
        }
    }

    public String a(String string) throws VisADException {
        String string2 = string + "FlatField\n" + string + "  Type: " + this.a.toString() + "\n";
        string2 = this.o != null ? string2 + string + "  DomainSet:\n" + this.o.a(string + "    ") : string2 + string + "  DomainSet: undefined\n";
        int n2 = 0;
        while (n2 < this.e) {
            string2 = this.k[n2] != null ? string2 + string + "  RangeSet[" + n2 + "]:\n" + this.k[n2].a(string + "    ") : string2 + string + "  RangeSet[" + n2 + "]: undefined\n";
            ++n2;
        }
        if (this.j()) {
            return string2 + "  missing\n";
        }
        return string2 + this.a();
    }

    public boolean equals(Object object) {
        int n2;
        if (object == null || !(object instanceof FlatField)) {
            return false;
        }
        FlatField flatField = (FlatField)object;
        if (this.d == null || flatField.d == null) {
            if (this.d != null || flatField.d != null) {
                return false;
            }
        } else {
            if (this.d.length != flatField.d.length) {
                return false;
            }
            n2 = 0;
            while (n2 < this.d.length) {
                if (this.d[n2] != flatField.d[n2]) {
                    return false;
                }
                ++n2;
            }
        }
        if (this.k == null || flatField.k == null) {
            if (this.k != null || flatField.k != null) {
                return false;
            }
        } else {
            if (this.k.length != flatField.k.length) {
                return false;
            }
            n2 = 0;
            while (n2 < this.k.length) {
                if (!this.k[n2].equals(flatField.k[n2])) {
                    return false;
                }
                ++n2;
            }
        }
        n2 = 0;
        while (n2 < this.e) {
            switch (this.d[n2]) {
                case 1: {
                    if (Arrays.equals(this.q[n2], flatField.q[n2])) break;
                    return false;
                }
                case 2: {
                    if (Arrays.equals(this.n[n2], flatField.n[n2])) break;
                    return false;
                }
                case 6: {
                    if (Arrays.equals(this.w[n2], flatField.w[n2])) break;
                    return false;
                }
                case 5: {
                    if (Arrays.equals(this.i[n2], flatField.i[n2])) break;
                    return false;
                }
                case 4: {
                    if (Arrays.equals(this.s[n2], flatField.s[n2])) break;
                    return false;
                }
                default: {
                    return false;
                }
            }
            ++n2;
        }
        return super.equals(object);
    }
}

