/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.io.Serializable;
import visad.DelaunayClarkson;
import visad.DelaunayCustom;
import visad.DelaunayFast;
import visad.DelaunayWatson;
import visad.SetException;
import visad.UnimplementedException;
import visad.VisADError;
import visad.VisADException;

public abstract class Delaunay
implements Serializable {
    public int[][] c = null;
    public int[][] e = null;
    public int[][] b = null;
    public int[][] a = null;
    public int d = 0;
    private boolean f = false;

    public boolean a() {
        return this.f;
    }

    public Object clone() {
        try {
            return new DelaunayCustom(null, this.c, this.e, this.b, this.a, this.d);
        }
        catch (VisADException visADException) {
            throw new VisADError("Delaunay.clone: " + visADException.toString());
        }
    }

    public static Delaunay a(float[][] fArray, boolean bl2) throws VisADException {
        block11: {
            int n2;
            int n3 = 0;
            int n4 = 1;
            int n5 = 2;
            int n6 = fArray.length;
            if (n6 < 2) {
                throw new VisADException("Delaunay.factory: dimension must be 2 or higher");
            }
            if (n6 > 3) {
                n2 = n4;
            } else {
                int n7 = fArray[0].length;
                int n8 = 1;
                while (n8 < n6) {
                    n7 = Math.min(n7, fArray[n8].length);
                    ++n8;
                }
                n2 = n6 == 2 && !bl2 && n7 > 10000 ? n3 : (n7 > 3000 ? n4 : n5);
            }
            try {
                if (n2 == n3) {
                    DelaunayFast delaunayFast = new DelaunayFast(fArray);
                    delaunayFast.a(fArray, 1);
                    return delaunayFast;
                }
                if (n2 == n4) {
                    DelaunayClarkson delaunayClarkson = new DelaunayClarkson(fArray);
                    return delaunayClarkson;
                }
                if (n2 == n5) {
                    DelaunayWatson delaunayWatson = new DelaunayWatson(fArray);
                    return delaunayWatson;
                }
            }
            catch (Exception exception) {
                if (n2 == n4) break block11;
                try {
                    DelaunayClarkson delaunayClarkson = new DelaunayClarkson(fArray);
                    return delaunayClarkson;
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public void a(float[][] fArray, int n2) throws VisADException {
        int n3 = fArray.length;
        int n4 = n3 + 1;
        if (this.c[0].length != n4) {
            throw new SetException("Delaunay.improve: samples dimension does not match");
        }
        if (n3 > 2) {
            throw new UnimplementedException("Delaunay.improve: dimension must be 2!");
        }
        int n5 = this.c.length;
        int n6 = fArray[0].length;
        int n7 = 1;
        while (n7 < n3) {
            n6 = Math.min(n6, fArray[n7].length);
            ++n7;
        }
        float[] fArray2 = fArray[0];
        float[] fArray3 = fArray[1];
        boolean bl2 = false;
        int n8 = 0;
        while (n8 < n2) {
            bl2 = false;
            boolean[] blArray = new boolean[this.d];
            int n9 = 0;
            while (n9 < this.d) {
                blArray[n9] = true;
                ++n9;
            }
            int n10 = 0;
            while (n10 < n5) {
                int[] nArray = this.c[n10];
                int[] nArray2 = this.b[n10];
                int[] nArray3 = this.a[n10];
                int n11 = 0;
                while (n11 < 2) {
                    int n12 = nArray3[n11];
                    if (blArray[n12]) {
                        int n13 = nArray2[n11];
                        if (n13 >= 0) {
                            boolean bl3;
                            int[] nArray4 = this.c[n13];
                            int[] nArray5 = this.b[n13];
                            int[] nArray6 = this.a[n13];
                            int n14 = nArray5[0] == n10 ? 0 : (nArray5[1] == n10 ? 1 : 2);
                            int n15 = (n11 + 2) % 3;
                            int n16 = (n15 + 1) % 3;
                            int n17 = (n16 + 1) % 3;
                            int n18 = (n14 + 2) % 3;
                            float f2 = fArray2[nArray[n15]];
                            float f3 = fArray3[nArray[n15]];
                            float f4 = fArray2[nArray[n16]];
                            float f5 = fArray3[nArray[n16]];
                            float f6 = fArray2[nArray[n17]];
                            float f7 = fArray3[nArray[n17]];
                            float f8 = fArray2[nArray4[n18]];
                            float f9 = fArray3[nArray4[n18]];
                            float f10 = f2 - f4;
                            float f11 = f3 - f5;
                            float f12 = f2 - f6;
                            float f13 = f3 - f7;
                            float f14 = f8 - f4;
                            float f15 = f9 - f5;
                            float f16 = f8 - f6;
                            float f17 = f9 - f7;
                            float f18 = f10 * f12 + f11 * f13;
                            float f19 = f14 * f10 + f15 * f11;
                            float f20 = f12 * f16 + f13 * f17;
                            float f21 = f14 * f16 + f15 * f17;
                            boolean bl4 = f10 * f13 - f11 * f12 >= 0.0f;
                            boolean bl5 = f14 * f11 - f15 * f10 >= 0.0f;
                            boolean bl6 = f12 * f17 - f13 * f16 >= 0.0f;
                            boolean bl7 = f16 * f15 - f17 * f14 >= 0.0f;
                            boolean bl8 = bl3 = (bl4 ? 1 : 0) + (bl5 ? 1 : 0) + (bl6 ? 1 : 0) + (bl7 ? 1 : 0) < 2;
                            boolean bl9 = bl4 == bl3 ? true : (bl5 == bl3 ? false : (bl6 == bl3 ? false : (bl7 == bl3 ? true : (f18 < 0.0f && f21 < 0.0f || f19 > 0.0f && f20 > 0.0f ? true : (f19 < 0.0f && f20 < 0.0f || f18 > 0.0f && f21 > 0.0f ? false : (f18 < 0.0f ? f18 : f21) < (f19 < 0.0f ? f19 : f20))))));
                            if (bl9) {
                                int n19;
                                int n20;
                                int n21;
                                int n22;
                                int n23;
                                bl2 = true;
                                int n24 = nArray[n15];
                                int n25 = nArray[n16];
                                int n26 = nArray[n17];
                                int n27 = nArray4[n18];
                                int n28 = nArray2[n15];
                                int n29 = nArray2[n17];
                                int n30 = nArray3[n15];
                                int n31 = nArray3[n17];
                                if (nArray4[(n18 + 1) % 3] == nArray[n17]) {
                                    n23 = nArray5[n18];
                                    n22 = nArray5[(n18 + 2) % 3];
                                    n21 = nArray6[n18];
                                    n20 = nArray6[(n18 + 2) % 3];
                                } else {
                                    n23 = nArray5[(n18 + 2) % 3];
                                    n22 = nArray5[n18];
                                    n21 = nArray6[(n18 + 2) % 3];
                                    n20 = nArray6[n18];
                                }
                                nArray[0] = n24;
                                nArray[1] = n25;
                                nArray[2] = n27;
                                nArray4[0] = n24;
                                nArray4[1] = n27;
                                nArray4[2] = n26;
                                nArray2[0] = n28;
                                nArray2[1] = n22;
                                nArray2[2] = n13;
                                nArray5[0] = n10;
                                nArray5[1] = n23;
                                nArray5[2] = n29;
                                if (n29 >= 0) {
                                    n19 = this.b[n29][0] == n10 ? 0 : (this.b[n29][1] == n10 ? 1 : 2);
                                    this.b[n29][n19] = n13;
                                }
                                if (n22 >= 0) {
                                    n19 = this.b[n22][0] == n13 ? 0 : (this.b[n22][1] == n13 ? 1 : 2);
                                    this.b[n22][n19] = n10;
                                }
                                nArray3[0] = n30;
                                nArray3[1] = n20;
                                nArray6[1] = n21;
                                nArray6[2] = n31;
                                int[] nArray7 = this.e[n24];
                                int[] nArray8 = this.e[n25];
                                int[] nArray9 = this.e[n26];
                                int[] nArray10 = this.e[n27];
                                int n32 = nArray7.length;
                                int n33 = nArray8.length;
                                int n34 = nArray9.length;
                                int n35 = nArray10.length;
                                int[] nArray11 = new int[n32 + 1];
                                int[] nArray12 = new int[n33 - 1];
                                int[] nArray13 = new int[n34 - 1];
                                int[] nArray14 = new int[n35 + 1];
                                System.arraycopy(nArray7, 0, nArray11, 0, n32);
                                nArray11[n32] = n13;
                                int n36 = 0;
                                int n37 = 0;
                                while (n37 < n33) {
                                    if (nArray8[n37] != n13) {
                                        nArray12[n36++] = nArray8[n37];
                                    }
                                    ++n37;
                                }
                                n36 = 0;
                                int n38 = 0;
                                while (n38 < n34) {
                                    if (nArray9[n38] != n10) {
                                        nArray13[n36++] = nArray9[n38];
                                    }
                                    ++n38;
                                }
                                System.arraycopy(nArray10, 0, nArray14, 0, n35);
                                nArray14[n35] = n10;
                                this.e[n24] = nArray11;
                                this.e[n25] = nArray12;
                                this.e[n26] = nArray13;
                                this.e[n27] = nArray14;
                            }
                        }
                        blArray[n12] = false;
                    }
                    ++n11;
                }
                ++n10;
            }
            if (!bl2) break;
            ++n8;
        }
    }

    public void b(float[][] fArray) throws VisADException {
        block40: {
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            int n10 = this.c[0].length - 1;
            int n11 = n10 + 1;
            int n12 = fArray.length;
            int n13 = n12 + 1;
            int n14 = this.c.length;
            int n15 = fArray[0].length;
            int n16 = 1;
            while (n16 < n12) {
                n15 = Math.min(n15, fArray[n16].length);
                ++n16;
            }
            if (this.e == null) {
                this.e = new int[n15][];
                int[] nArray = new int[n15];
                n9 = 0;
                while (n9 < n14) {
                    n8 = 0;
                    while (n8 < n11) {
                        int n17 = this.c[n9][n8];
                        nArray[n17] = nArray[n17] + 1;
                        ++n8;
                    }
                    ++n9;
                }
                n8 = 0;
                while (n8 < n15) {
                    this.e[n8] = new int[nArray[n8]];
                    nArray[n8] = 0;
                    ++n8;
                }
                n7 = 0;
                while (n7 < n14) {
                    n6 = 0;
                    while (n6 < n11) {
                        int n18 = this.c[n7][n6];
                        int n19 = nArray[n18];
                        nArray[n18] = n19 + 1;
                        this.e[this.c[n7][n6]][n19] = n7;
                        ++n6;
                    }
                    ++n7;
                }
            }
            if (this.b == null && n10 <= 3) {
                this.b = new int[n14][n11];
                int n20 = 0;
                while (n20 < n14) {
                    n9 = 0;
                    while (n9 < n11) {
                        n8 = n9;
                        n7 = (n8 + 1) % n11;
                        this.b[n20][n9] = -1;
                        n6 = 0;
                        block8: while (n6 < this.e[this.c[n20][n8]].length) {
                            n5 = this.e[this.c[n20][n8]][n6];
                            if (n5 != n20) {
                                n4 = 0;
                                while (n4 < this.e[this.c[n20][n7]].length) {
                                    if (n10 == 2) {
                                        if (n5 == this.e[this.c[n20][n7]][n4]) {
                                            this.b[n20][n9] = n5;
                                            break block8;
                                        }
                                    } else {
                                        n3 = this.e[this.c[n20][n7]][n4];
                                        int n21 = (n7 + 1) % n11;
                                        if (n5 == n3) {
                                            n2 = 0;
                                            while (n2 < this.e[this.c[n20][n21]].length) {
                                                if (n5 == this.e[this.c[n20][n21]][n2]) {
                                                    this.b[n20][n9] = n5;
                                                    break block8;
                                                }
                                                ++n2;
                                            }
                                        }
                                    }
                                    ++n4;
                                }
                            }
                            ++n6;
                        }
                        ++n9;
                    }
                    ++n20;
                }
            }
            if (this.a != null || n10 > 3) break block40;
            int n22 = 3 * (n10 - 1);
            this.a = new int[n14][n22];
            n9 = 0;
            while (n9 < n14) {
                n8 = 0;
                while (n8 < n22) {
                    this.a[n9][n8] = -1;
                    ++n8;
                }
                ++n9;
            }
            this.d = 0;
            if (n10 == 2) {
                n8 = 0;
                while (n8 < n14) {
                    n7 = 0;
                    while (n7 < 3) {
                        if (this.a[n8][n7] < 0) {
                            n6 = this.b[n8][n7];
                            if (n6 >= 0) {
                                n5 = -1;
                                n4 = 0;
                                while (n4 < 3) {
                                    if (this.b[n6][n4] == n8) {
                                        n5 = n4;
                                    }
                                    ++n4;
                                }
                                if (n5 != -1) {
                                    this.a[n6][n5] = this.d;
                                } else {
                                    throw new SetException("Delaunay.finish_triang: error in triangulation!");
                                }
                            }
                            this.a[n8][n7] = this.d++;
                        }
                        ++n7;
                    }
                    ++n8;
                }
            } else {
                int[] nArray = new int[]{0, 0, 0, 1, 1, 2};
                int[] nArray2 = new int[]{1, 2, 3, 2, 3, 3};
                n6 = 0;
                while (n6 < n14) {
                    n5 = 0;
                    while (n5 < 6) {
                        if (this.a[n6][n5] < 0) {
                            int n23;
                            int n24;
                            n4 = this.c[n6][nArray[n5]];
                            n3 = this.c[n6][nArray2[n5]];
                            int[] nArray3 = new int[this.e[n4].length];
                            n2 = 0;
                            int n25 = 0;
                            while (n25 < this.e[n4].length) {
                                n24 = this.e[n4][n25];
                                n23 = 0;
                                while (n23 < this.e[n3].length) {
                                    if (n24 == this.e[n3][n23]) {
                                        nArray3[n2++] = n24;
                                        break;
                                    }
                                    ++n23;
                                }
                                ++n25;
                            }
                            n24 = 0;
                            while (n24 < n2) {
                                n23 = nArray3[n24];
                                int n26 = 0;
                                while (n26 < n22) {
                                    if (this.c[n23][nArray[n26]] == n4 && this.c[n23][nArray2[n26]] == n3 || this.c[n23][nArray[n26]] == n3 && this.c[n23][nArray2[n26]] == n4) {
                                        this.a[n23][n26] = this.d;
                                    }
                                    ++n26;
                                }
                                ++n24;
                            }
                            this.a[n6][n5] = this.d++;
                        }
                        ++n5;
                    }
                    ++n6;
                }
            }
        }
    }

    public String toString() {
        return this.a(null);
    }

    public String a(float[][] fArray) {
        int n2;
        int n3;
        int n4;
        int n5;
        StringBuffer stringBuffer = new StringBuffer("");
        if (fArray != null) {
            stringBuffer.append("\nsamples " + fArray[0].length + "\n");
            n5 = 0;
            while (n5 < fArray[0].length) {
                stringBuffer.append("  " + n5 + " -> " + fArray[0][n5] + " " + fArray[1][n5] + " " + fArray[2][n5] + "\n");
                ++n5;
            }
            stringBuffer.append("\n");
        }
        stringBuffer.append("\nTri (triangles -> vertices) " + this.c.length + "\n");
        n5 = 0;
        while (n5 < this.c.length) {
            stringBuffer.append("  " + n5 + " -> ");
            n4 = 0;
            while (n4 < this.c[n5].length) {
                stringBuffer.append(" " + this.c[n5][n4]);
                ++n4;
            }
            stringBuffer.append("\n");
            ++n5;
        }
        stringBuffer.append("\nVertices (vertices -> triangles) " + this.e.length + "\n");
        n4 = 0;
        while (n4 < this.e.length) {
            stringBuffer.append("  " + n4 + " -> ");
            n3 = 0;
            while (n3 < this.e[n4].length) {
                stringBuffer.append(" " + this.e[n4][n3]);
                ++n3;
            }
            stringBuffer.append("\n");
            ++n4;
        }
        stringBuffer.append("\nWalk (triangles -> triangles) " + this.b.length + "\n");
        n3 = 0;
        while (n3 < this.b.length) {
            stringBuffer.append("  " + n3 + " -> ");
            n2 = 0;
            while (n2 < this.b[n3].length) {
                stringBuffer.append(" " + this.b[n3][n2]);
                ++n2;
            }
            stringBuffer.append("\n");
            ++n3;
        }
        stringBuffer.append("\nEdges (triangles -> global edges) " + this.a.length + "\n");
        n2 = 0;
        while (n2 < this.a.length) {
            stringBuffer.append("  " + n2 + " -> ");
            int n6 = 0;
            while (n6 < this.a[n2].length) {
                stringBuffer.append(" " + this.a[n2][n6]);
                ++n6;
            }
            stringBuffer.append("\n");
            ++n2;
        }
        return stringBuffer.toString();
    }
}

