/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CommonUnit;
import visad.CoordinateSystem;
import visad.CoordinateSystemException;
import visad.RealTupleType;
import visad.Unit;

public class CylindricalCoordinateSystem
extends CoordinateSystem {
    private static Unit[] b = new Unit[]{null, CommonUnit.g, null};

    public CylindricalCoordinateSystem(RealTupleType realTupleType, boolean bl2) {
        super(realTupleType, b, bl2);
    }

    public double[][] a(double[][] dArray) throws CoordinateSystemException {
        if (dArray == null || dArray.length != 3) {
            throw new CoordinateSystemException("CylindricalCoordinateSystem.toReference: tuples wrong dimension");
        }
        int n2 = dArray[0].length;
        double[][] dArray2 = new double[3][n2];
        int n3 = 0;
        while (n3 < n2) {
            if (dArray[0][n3] < 0.0) {
                dArray2[0][n3] = Double.NaN;
                dArray2[1][n3] = Double.NaN;
                dArray2[2][n3] = Double.NaN;
            } else {
                double d2 = Math.cos(Math.PI / 180 * dArray[1][n3]);
                double d3 = Math.sin(Math.PI / 180 * dArray[1][n3]);
                dArray2[0][n3] = dArray[0][n3] * d2;
                dArray2[1][n3] = dArray[0][n3] * d3;
                dArray2[2][n3] = dArray[2][n3];
            }
            ++n3;
        }
        return dArray2;
    }

    public double[][] b(double[][] dArray) throws CoordinateSystemException {
        if (dArray == null || dArray.length != 3) {
            throw new CoordinateSystemException("CylindricalCoordinateSystem.fromReference: tuples wrong dimension");
        }
        int n2 = dArray[0].length;
        double[][] dArray2 = new double[3][n2];
        int n3 = 0;
        while (n3 < n2) {
            dArray2[0][n3] = Math.sqrt(dArray[0][n3] * dArray[0][n3] + dArray[1][n3] * dArray[1][n3]);
            dArray2[1][n3] = 57.29577951308232 * Math.atan2(dArray[1][n3], dArray[0][n3]);
            if (dArray2[1][n3] < 0.0) {
                double[] dArray3 = dArray2[1];
                int n4 = n3;
                dArray3[n4] = dArray3[n4] + 360.0;
            }
            dArray2[2][n3] = dArray[2][n3];
            ++n3;
        }
        return dArray2;
    }

    public float[][] a(float[][] fArray) throws CoordinateSystemException {
        if (fArray == null || fArray.length != 3) {
            throw new CoordinateSystemException("CylindricalCoordinateSystem.toReference: tuples wrong dimension");
        }
        int n2 = fArray[0].length;
        float[][] fArray2 = new float[3][n2];
        int n3 = 0;
        while (n3 < n2) {
            if ((double)fArray[0][n3] < 0.0) {
                fArray2[0][n3] = Float.NaN;
                fArray2[1][n3] = Float.NaN;
                fArray2[2][n3] = Float.NaN;
            } else {
                float f2 = (float)Math.cos(Math.PI / 180 * (double)fArray[1][n3]);
                float f3 = (float)Math.sin(Math.PI / 180 * (double)fArray[1][n3]);
                fArray2[0][n3] = fArray[0][n3] * f2;
                fArray2[1][n3] = fArray[0][n3] * f3;
                fArray2[2][n3] = fArray[2][n3];
            }
            ++n3;
        }
        return fArray2;
    }

    public float[][] b(float[][] fArray) throws CoordinateSystemException {
        if (fArray == null || fArray.length != 3) {
            throw new CoordinateSystemException("CylindricalCoordinateSystem.fromReference: tuples wrong dimension");
        }
        int n2 = fArray[0].length;
        float[][] fArray2 = new float[3][n2];
        int n3 = 0;
        while (n3 < n2) {
            fArray2[0][n3] = (float)Math.sqrt(fArray[0][n3] * fArray[0][n3] + fArray[1][n3] * fArray[1][n3]);
            fArray2[1][n3] = (float)(57.29577951308232 * Math.atan2(fArray[1][n3], fArray[0][n3]));
            if (fArray2[1][n3] < 0.0f) {
                float[] fArray3 = fArray2[1];
                int n4 = n3;
                fArray3[n4] = fArray3[n4] + 360.0f;
            }
            fArray2[2][n3] = fArray[2][n3];
            ++n3;
        }
        return fArray2;
    }

    public boolean equals(Object object) {
        return object instanceof CylindricalCoordinateSystem;
    }
}

