/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.CoordinateSystemException;
import visad.RealTupleType;
import visad.Unit;
import visad.VisADException;

public class CMYCoordinateSystem
extends CoordinateSystem {
    private static Unit[] b = new Unit[]{null, null, null};

    public CMYCoordinateSystem(RealTupleType realTupleType, boolean bl2) {
        super(realTupleType, b, bl2);
    }

    public double[][] a(double[][] dArray) throws VisADException {
        if (dArray == null || dArray.length != 3) {
            throw new CoordinateSystemException("CMYCoordinateSystem.toReference: tuples wrong dimension");
        }
        int n2 = dArray[0].length;
        double[][] dArray2 = new double[3][n2];
        int n3 = 0;
        while (n3 < n2) {
            dArray2[0][n3] = 1.0 - dArray[0][n3];
            dArray2[1][n3] = 1.0 - dArray[1][n3];
            dArray2[2][n3] = 1.0 - dArray[2][n3];
            ++n3;
        }
        return dArray2;
    }

    public double[][] b(double[][] dArray) throws VisADException {
        if (dArray == null || dArray.length != 3) {
            throw new CoordinateSystemException("CMYCoordinateSystem.fromReference: tuples wrong dimension");
        }
        int n2 = dArray[0].length;
        double[][] dArray2 = new double[3][n2];
        int n3 = 0;
        while (n3 < n2) {
            dArray2[0][n3] = 1.0 - dArray[0][n3];
            dArray2[1][n3] = 1.0 - dArray[1][n3];
            dArray2[2][n3] = 1.0 - dArray[2][n3];
            ++n3;
        }
        return dArray2;
    }

    public float[][] a(float[][] fArray) throws VisADException {
        if (fArray == null || fArray.length != 3) {
            throw new CoordinateSystemException("CMYCoordinateSystem.toReference: tuples wrong dimension");
        }
        int n2 = fArray[0].length;
        float[][] fArray2 = new float[3][n2];
        int n3 = 0;
        while (n3 < n2) {
            fArray2[0][n3] = 1.0f - fArray[0][n3];
            fArray2[1][n3] = 1.0f - fArray[1][n3];
            fArray2[2][n3] = 1.0f - fArray[2][n3];
            ++n3;
        }
        return fArray2;
    }

    public float[][] b(float[][] fArray) throws VisADException {
        if (fArray == null || fArray.length != 3) {
            throw new CoordinateSystemException("CMYCoordinateSystem.fromReference: tuples wrong dimension");
        }
        int n2 = fArray[0].length;
        float[][] fArray2 = new float[3][n2];
        int n3 = 0;
        while (n3 < n2) {
            fArray2[0][n3] = 1.0f - fArray[0][n3];
            fArray2[1][n3] = 1.0f - fArray[1][n3];
            fArray2[2][n3] = 1.0f - fArray[2][n3];
            ++n3;
        }
        return fArray2;
    }

    public boolean equals(Object object) {
        return object instanceof CMYCoordinateSystem;
    }
}

