/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import visad.Control;
import visad.CoordinateSystem;
import visad.DisplayException;
import visad.DisplayImpl;
import visad.Field;
import visad.Function;
import visad.FunctionType;
import visad.Linear1DSet;
import visad.List1DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.Set;
import visad.Unit;
import visad.VisADException;
import visad.util.Util;

public class BaseColorControl
extends Control {
    private float[][] b;
    private int d;
    private Function j;
    private transient RealTupleType q;
    private transient CoordinateSystem e;
    private transient Unit[] o;
    private transient Object l = new Object();
    private final int k;

    public BaseColorControl(DisplayImpl displayImpl, int n2) {
        super(displayImpl);
        if (n2 < 3) {
            n2 = 3;
        } else if (n2 > 4) {
            n2 = 4;
        }
        this.k = n2;
        this.d = 256;
        this.b = BaseColorControl.a(new float[n2][this.d]);
    }

    public static float[][] a(float[][] fArray) {
        if (fArray == null || fArray[0] == null) {
            return null;
        }
        boolean bl2 = fArray.length > 3;
        float f2 = 1.4f;
        float f3 = 1.0f;
        float f4 = 0.5f * f3;
        int n2 = fArray[0].length;
        int n3 = 0;
        while (n3 < n2) {
            float f5 = (float)n3 / (float)(n2 - 1);
            float f6 = f2 * (f5 - f4);
            fArray[0][n3] = (float)(0.5 + 0.5 * Math.atan(7.0 * (double)f6) / 1.57);
            fArray[1][n3] = (float)(0.5 + 0.5 * (2.0 * Math.exp(-7.0f * f6 * f6) - 1.0));
            fArray[2][n3] = (float)(0.5 + 0.5 * Math.atan(-7.0 * (double)f6) / 1.57);
            if (bl2) {
                fArray[3][n3] = 1.0f;
            }
            ++n3;
        }
        return fArray;
    }

    public int b() {
        return this.k;
    }

    public int a() {
        return this.d;
    }

    public void a(Function function) throws RemoteException, VisADException {
        FunctionType functionType = this.k == 4 ? FunctionType.o : FunctionType.h;
        if (function == null || !function.e().a(functionType)) {
            throw new DisplayException("BaseColorControl.setFunction: function must be 1D-to-" + this.k + "D");
        }
        Object object = this.l;
        synchronized (object) {
            this.j = function;
            this.q = ((FunctionType)this.j.e()).e();
            this.e = this.j.t();
            this.o = this.j.c();
            this.b = null;
        }
        this.a(true);
    }

    public void c(float[][] fArray) throws RemoteException, VisADException {
        if (fArray == null || fArray[0] == null) {
            throw new DisplayException(this.getClass().getName() + ".setTable: " + "Null table");
        }
        if (fArray.length != this.k) {
            if (fArray[0].length == this.k) {
                throw new DisplayException(this.getClass().getName() + ".setTable: " + " Table may be inverted");
            }
            throw new DisplayException(this.getClass().getName() + ".setTable: " + "Unusable table [" + fArray.length + "][" + fArray[0].length + "], expected [" + this.k + "][]");
        }
        if (fArray[0] == null || fArray[1] == null || fArray[2] == null || fArray.length > 3 && fArray[3] == null) {
            throw new DisplayException(this.getClass().getName() + ".setTable: " + "One or more component lists is null");
        }
        if (fArray[0].length != fArray[1].length || fArray[0].length != fArray[2].length || this.k > 3 && fArray[0].length != fArray[3].length) {
            throw new DisplayException("BaseColorControl.setTable: Inconsistent table lengths");
        }
        Object object = this.l;
        synchronized (object) {
            this.d = fArray[0].length;
            this.b = new float[this.k][this.d];
            int n2 = 0;
            while (n2 < this.k) {
                System.arraycopy(fArray[n2], 0, this.b[n2], 0, this.d);
                ++n2;
            }
            this.j = null;
        }
        this.a(true);
    }

    public float[][] e() {
        if (this.b == null) {
            return null;
        }
        float[][] fArray = new float[this.k][this.d];
        int n2 = 0;
        while (n2 < this.k) {
            System.arraycopy(this.b[n2], 0, fArray[n2], 0, this.d);
            ++n2;
        }
        return fArray;
    }

    public String d() {
        if (this.b == null) {
            return null;
        }
        int n2 = this.b.length;
        int n3 = this.b[0].length;
        StringBuffer stringBuffer = new StringBuffer(15 * n2 * n3);
        stringBuffer.append(n2);
        stringBuffer.append(" x ");
        stringBuffer.append(n3);
        stringBuffer.append('\n');
        int n4 = 0;
        while (n4 < n3) {
            stringBuffer.append(this.b[0][n4]);
            int n5 = 1;
            while (n5 < n2) {
                stringBuffer.append(' ');
                stringBuffer.append(this.b[n5][n4]);
                ++n5;
            }
            stringBuffer.append('\n');
            ++n4;
        }
        return stringBuffer.toString();
    }

    public float[][] a(float[] fArray) throws RemoteException, VisADException {
        if (fArray == null) {
            return null;
        }
        int n2 = this.d - 1;
        int n3 = fArray.length;
        float[][] fArray2 = null;
        Object object = this.l;
        synchronized (object) {
            if (this.b != null) {
                fArray2 = new float[this.k][n3];
                float f2 = this.d;
                try {
                    int n4 = 0;
                    while (n4 < n3) {
                        if (fArray[n4] != fArray[n4]) {
                            fArray2[0][n4] = Float.NaN;
                            fArray2[1][n4] = Float.NaN;
                            fArray2[2][n4] = Float.NaN;
                            if (this.k > 3) {
                                fArray2[3][n4] = Float.NaN;
                            }
                        } else {
                            int n5 = (int)(f2 * fArray[n4]);
                            if (n5 < 0) {
                                fArray2[0][n4] = this.b[0][0];
                                fArray2[1][n4] = this.b[1][0];
                                fArray2[2][n4] = this.b[2][0];
                                if (this.k > 3) {
                                    fArray2[3][n4] = this.b[3][0];
                                }
                            } else if (this.d <= n5) {
                                fArray2[0][n4] = this.b[0][n2];
                                fArray2[1][n4] = this.b[1][n2];
                                fArray2[2][n4] = this.b[2][n2];
                                if (this.k > 3) {
                                    fArray2[3][n4] = this.b[3][n2];
                                }
                            } else {
                                fArray2[0][n4] = this.b[0][n5];
                                fArray2[1][n4] = this.b[1][n5];
                                fArray2[2][n4] = this.b[2][n5];
                                if (this.k > 3) {
                                    fArray2[3][n4] = this.b[3][n5];
                                }
                            }
                        }
                        ++n4;
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
            } else if (this.j != null) {
                List1DSet list1DSet = new List1DSet(fArray, this.q, this.e, this.o);
                Field field = this.j.a(list1DSet, 100, 202);
                fArray2 = Set.c(field.l());
            }
        }
        return fArray2;
    }

    public float[][] a(int n2, int n3) throws VisADException, RemoteException {
        if (n2 < 0 || n3 >= this.d || n2 > n3) {
            throw new VisADException("Bad left/right value");
        }
        int n4 = this.d - 1;
        int n5 = n3 - n2 + 1;
        float[][] fArray = null;
        Object object = this.l;
        synchronized (object) {
            if (this.b != null) {
                fArray = new float[this.k][n5];
                int n6 = 0;
                while (n6 < n5) {
                    fArray[0][n6] = this.b[0][n6 + n2];
                    fArray[1][n6] = this.b[1][n6 + n2];
                    fArray[2][n6] = this.b[2][n6 + n2];
                    if (this.k > 3) {
                        fArray[3][n6] = this.b[3][n6 + n2];
                    }
                    ++n6;
                }
            } else if (this.j != null) {
                double d2 = this.d;
                Linear1DSet linear1DSet = new Linear1DSet((MathType)this.q, (double)n2 / d2, (double)n3 / d2, n5, this.e, this.o, null);
                Field field = this.j.a(linear1DSet, 100, 202);
                fArray = Set.c(field.l());
            }
        }
        return fArray;
    }

    public void a(int n2, int n3, float[][] fArray) throws VisADException, RemoteException {
        if (n2 < 0 || n3 >= this.d || n2 > n3) {
            throw new VisADException("Bad left/right value");
        }
        if (fArray == null || fArray.length != this.k || fArray[0] == null || fArray[1] == null || fArray[2] == null || fArray.length > 3 && fArray[3] == null) {
            throw new VisADException("Bad range table!");
        }
        if (this.b == null) {
            throw new VisADException("Cannot set values for function!");
        }
        int n4 = n3 - n2 + 1;
        if (fArray[0].length != n4 || fArray[1].length != n4 || fArray[2].length != n4 || fArray.length > 3 && fArray[3].length != n4) {
            throw new VisADException("Array does not contain " + n4 + " colors!");
        }
        Object object = this.l;
        synchronized (object) {
            int n5 = 0;
            while (n5 < n4) {
                this.b[0][n5 + n2] = fArray[0][n5];
                this.b[1][n5 + n2] = fArray[1][n5];
                this.b[2][n5 + n2] = fArray[2][n5];
                if (this.k > 3) {
                    this.b[3][n5 + n2] = fArray[3][n5];
                }
                ++n5;
            }
        }
        this.a(true);
    }

    private boolean b(float[][] fArray) {
        if (this.b == null) {
            if (fArray != null) {
                return false;
            }
        } else {
            if (fArray == null) {
                return false;
            }
            if (this.b != fArray) {
                if (this.b.length != fArray.length) {
                    return false;
                }
                int n2 = 0;
                while (n2 < this.b.length) {
                    if (this.b[n2].length != fArray[n2].length) {
                        return false;
                    }
                    ++n2;
                }
                n2 = 0;
                while (n2 < this.b.length) {
                    int n3 = 0;
                    while (n3 < this.b[n2].length) {
                        if (!Util.a(this.b[n2][n3], fArray[n2][n3])) {
                            return false;
                        }
                        ++n3;
                    }
                    ++n2;
                }
            }
        }
        return true;
    }

    private boolean b(Function function) {
        if (this.j == null) {
            if (function != null) {
                return false;
            }
        } else {
            if (function == null) {
                return false;
            }
            if (!this.j.equals(function)) {
                return false;
            }
        }
        return true;
    }

    public void a(Control control) throws VisADException {
        boolean bl2;
        if (control == null) {
            throw new VisADException("Cannot synchronize " + this.getClass().getName() + " with null Control object");
        }
        if (!(control instanceof BaseColorControl)) {
            throw new VisADException("Cannot synchronize " + this.getClass().getName() + " with " + control.getClass().getName());
        }
        BaseColorControl baseColorControl = (BaseColorControl)control;
        boolean bl3 = false;
        boolean bl4 = !this.b(baseColorControl.b);
        boolean bl5 = bl2 = !this.b(baseColorControl.j);
        if (bl4) {
            if (baseColorControl.b == null) {
                boolean bl6 = bl2 ? baseColorControl.j == null : this.j == null;
                if (bl6) {
                    throw new VisADException("BaseColorControl has null Table, but no Function");
                }
                this.b = null;
            } else {
                if (baseColorControl.b.length != this.k) {
                    throw new VisADException("Table must be float[" + this.k + "][], not float[" + baseColorControl.b.length + "][]");
                }
                Object object = this.l;
                synchronized (object) {
                    this.d = baseColorControl.b[0].length;
                    int n2 = 0;
                    while (n2 < this.k) {
                        if (this.b[n2].length != baseColorControl.b[n2].length) {
                            this.b[n2] = new float[baseColorControl.b[n2].length];
                        }
                        System.arraycopy(baseColorControl.b[n2], 0, this.b[n2], 0, baseColorControl.b[n2].length);
                        ++n2;
                    }
                    this.d = this.b[0].length;
                    this.j = null;
                }
                try {
                    this.a(true);
                }
                catch (RemoteException remoteException) {
                    throw new VisADException("Could not indicate that control changed: " + remoteException.getMessage());
                }
            }
        }
        if (bl2) {
            if (baseColorControl.j == null) {
                if (this.b == null) {
                    throw new VisADException("ColorControl has null Function, but no Table");
                }
                this.j = null;
            } else {
                try {
                    this.a(baseColorControl.j);
                }
                catch (RemoteException remoteException) {
                    throw new VisADException("Could not set function: " + remoteException.getMessage());
                }
            }
        }
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        BaseColorControl baseColorControl = (BaseColorControl)object;
        if (this.d != baseColorControl.d) {
            return false;
        }
        if (!this.b(baseColorControl.b)) {
            return false;
        }
        return this.b(baseColorControl.j);
    }

    public Object clone() {
        BaseColorControl baseColorControl = (BaseColorControl)super.clone();
        if (this.b != null) {
            baseColorControl.b = new float[this.b.length][];
            int n2 = this.b.length - 1;
            while (n2 >= 0) {
                baseColorControl.b[n2] = (float[])this.b[n2].clone();
                --n2;
            }
        }
        return baseColorControl;
    }

    private static char a(int n2, int n3, int n4) {
        if (n2 == 0 || n3 == 0 || n4 == 0) {
            if (n2 > 0) {
                if (n4 > 0) {
                    if (n2 > n4) {
                        return 'v';
                    }
                    return '^';
                }
                if (n3 > 0) {
                    return '~';
                }
                return '\\';
            }
            if (n4 > 0) {
                if (n3 > 0) {
                    return '~';
                }
                return '/';
            }
            return '_';
        }
        if (n2 > n3) {
            if (n2 > n3 + n4) {
                return '\\';
            }
            if (n4 > n2 + n3) {
                return '/';
            }
            if (n4 > n3) {
                return '^';
            }
        }
        if (n4 > n3) {
            if (n4 > n2 + n3) {
                return '/';
            }
            if (n2 > n3 + n4) {
                return '\\';
            }
        }
        if (n3 > n2 + n4) {
            return '-';
        }
        return '~';
    }

    public String toString() {
        int n2 = this.d;
        int n3 = 1;
        while (n2 > 32) {
            n2 >>= 1;
            n3 <<= 1;
        }
        String string = this.getClass().getName();
        int n4 = string.lastIndexOf(46);
        if (n4 >= 0) {
            string = string.substring(n4 + 1);
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append('[');
        String string2 = "RGBA";
        int n5 = 0;
        while (n5 < this.k) {
            if (n5 > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(string2.charAt(n5));
            stringBuffer.append('=');
            float f2 = this.b[n5][0];
            int n6 = 0;
            while (n6 < this.d) {
                int n7 = 0;
                int n8 = 0;
                int n9 = 0;
                int n10 = 0;
                while (n10 < n3) {
                    float f3 = this.b[n5][n6 + n10];
                    if ((double)Math.abs(f3 - f2) <= 1.0E-4) {
                        ++n8;
                    } else if (f3 < f2) {
                        ++n9;
                    } else {
                        ++n7;
                    }
                    f2 = f3;
                    ++n10;
                }
                stringBuffer.append(BaseColorControl.a(n9, n8, n7));
                n6 += n3;
            }
            ++n5;
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }
}

