/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;

public class Year
extends RegularTimePeriod
implements Serializable {
    private int b;

    public Year() {
        this(new Date());
    }

    public Year(int n2) {
        if (n2 < 1900 || n2 > 9999) {
            throw new IllegalArgumentException("Year constructor: year (" + n2 + ") outside valid range.");
        }
        this.b = n2;
    }

    public Year(Date date) {
        this(date, RegularTimePeriod.a);
    }

    public Year(Date date, TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.setTime(date);
        this.b = calendar.get(1);
    }

    public int b() {
        return this.b;
    }

    public RegularTimePeriod h() {
        if (this.b > 1900) {
            return new Year(this.b - 1);
        }
        return null;
    }

    public long c() {
        return this.b;
    }

    public long c(Calendar calendar) {
        Day day = new Day(1, 1, this.b);
        return day.c(calendar);
    }

    public long b(Calendar calendar) {
        Day day = new Day(31, 12, this.b);
        return day.b(calendar);
    }

    public boolean equals(Object object) {
        if (object != null) {
            if (object instanceof Year) {
                Year year = (Year)object;
                return this.b == year.b();
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        int n2 = 17;
        int n3 = this.b ^ this.b >>> 32;
        n2 = 37 * n2 + n3;
        return n2;
    }

    public int compareTo(Object object) {
        int n2;
        if (object instanceof Year) {
            Year year = (Year)object;
            n2 = this.b - year.b();
        } else {
            n2 = object instanceof RegularTimePeriod ? 0 : 1;
        }
        return n2;
    }

    public String toString() {
        return Integer.toString(this.b);
    }
}

