/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Year;
import org.jfree.date.SerialDate;

public class Month
extends RegularTimePeriod
implements Serializable {
    private int b;
    private Year d;

    public Month() {
        this(new Date());
    }

    public Month(int n2, Year year) {
        if (n2 < 1 && n2 > 12) {
            throw new IllegalArgumentException("Month(...): month outside valid range.");
        }
        this.b = n2;
        this.d = year;
    }

    public Month(Date date) {
        this(date, RegularTimePeriod.a);
    }

    public Month(Date date, TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.setTime(date);
        this.b = calendar.get(2) + 1;
        this.d = new Year(calendar.get(1));
    }

    public Year h() {
        return this.d;
    }

    public int b() {
        return this.b;
    }

    public RegularTimePeriod i() {
        Year year;
        Month month = this.b != 1 ? new Month(this.b - 1, this.d) : ((year = (Year)this.d.h()) != null ? new Month(12, year) : null);
        return month;
    }

    public long c() {
        return (long)this.d.b() * 12L + (long)this.b;
    }

    public String toString() {
        return SerialDate.a(this.b) + " " + this.d;
    }

    public boolean equals(Object object) {
        if (object != null) {
            if (object instanceof Month) {
                Month month = (Month)object;
                return this.b == month.b() && this.d.equals(month.h());
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        int n2 = 17;
        n2 = 37 * n2 + this.b;
        n2 = 37 * n2 + this.d.hashCode();
        return n2;
    }

    public int compareTo(Object object) {
        int n2;
        if (object instanceof Month) {
            Month month = (Month)object;
            n2 = this.d.b() - month.h().b();
            if (n2 == 0) {
                n2 = this.b - month.b();
            }
        } else {
            n2 = object instanceof RegularTimePeriod ? 0 : 1;
        }
        return n2;
    }

    public long c(Calendar calendar) {
        Day day = new Day(1, this.b, this.d.b());
        return day.c(calendar);
    }

    public long b(Calendar calendar) {
        int n2 = SerialDate.a(this.b, this.d.b());
        Day day = new Day(n2, this.b, this.d.b());
        return day.b(calendar);
    }
}

