/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data;

import java.io.Serializable;

public class Range
implements Serializable {
    private double b;
    private double a;

    public Range(double d2, double d3) {
        if (d2 > d3) {
            throw new IllegalArgumentException("Range(double, double): require lower<=upper.");
        }
        this.b = d2;
        this.a = d3;
    }

    public double d() {
        return this.b;
    }

    public double a() {
        return this.a;
    }

    public double e() {
        return this.a - this.b;
    }

    public double b() {
        return this.b / 2.0 + this.a / 2.0;
    }

    public boolean a(double d2) {
        return d2 >= this.b && d2 <= this.a;
    }

    public static Range a(Range range, Range range2) {
        if (range == null) {
            return range2;
        }
        if (range2 == null) {
            return range;
        }
        double d2 = Math.min(range.d(), range2.d());
        double d3 = Math.max(range.a(), range2.a());
        return new Range(d2, d3);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof Range) {
            Range range = (Range)object;
            boolean bl2 = this.b == range.b;
            boolean bl3 = this.a == range.a;
            return bl2 && bl3;
        }
        return false;
    }

    public String toString() {
        return "Range[" + this.b + "," + this.a + "]";
    }
}

