/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.ui.AxisPropertyEditPanel;
import org.jfree.layout.LCBLayout;
import org.jfree.ui.PaintSample;
import org.jfree.ui.StrokeChooserPanel;
import org.jfree.ui.StrokeSample;

public class NumberAxisPropertyEditPanel
extends AxisPropertyEditPanel
implements FocusListener {
    private boolean z;
    private double D;
    private double a;
    private JCheckBox t;
    private JTextField g;
    private JTextField x;
    private PaintSample s;
    private StrokeSample j;
    private StrokeSample[] v;
    public static ResourceBundle u = ResourceBundle.getBundle("org.jfree.chart.ui.LocalizationBundle");

    public NumberAxisPropertyEditPanel(NumberAxis numberAxis) {
        super(numberAxis);
        this.z = numberAxis.q();
        this.D = numberAxis.h();
        this.a = numberAxis.a();
        this.s = new PaintSample(Color.blue);
        this.j = new StrokeSample(new BasicStroke(1.0f));
        this.v = new StrokeSample[3];
        this.v[0] = new StrokeSample(new BasicStroke(1.0f));
        this.v[1] = new StrokeSample(new BasicStroke(2.0f));
        this.v[2] = new StrokeSample(new BasicStroke(3.0f));
        JTabbedPane jTabbedPane = this.u();
        JPanel jPanel = new JPanel(new LCBLayout(3));
        jPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        jPanel.add(new JPanel());
        this.t = new JCheckBox(u.getString("Auto-adjust_range"), this.z);
        this.t.setActionCommand("AutoRangeOnOff");
        this.t.addActionListener(this);
        jPanel.add(this.t);
        jPanel.add(new JPanel());
        jPanel.add(new JLabel(u.getString("Minimum_range_value")));
        this.g = new JTextField(Double.toString(this.D));
        this.g.setEnabled(!this.z);
        this.g.setActionCommand("MinimumRange");
        this.g.addActionListener(this);
        this.g.addFocusListener(this);
        jPanel.add(this.g);
        jPanel.add(new JPanel());
        jPanel.add(new JLabel(u.getString("Maximum_range_value")));
        this.x = new JTextField(Double.toString(this.a));
        this.x.setEnabled(!this.z);
        this.x.setActionCommand("MaximumRange");
        this.x.addActionListener(this);
        this.x.addFocusListener(this);
        jPanel.add(this.x);
        jPanel.add(new JPanel());
        jTabbedPane.add(u.getString("Range"), jPanel);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("GridStroke")) {
            this.t();
        } else if (string.equals("GridPaint")) {
            this.s();
        } else if (string.equals("AutoRangeOnOff")) {
            this.q();
        } else if (string.equals("MinimumRange")) {
            this.b();
        } else if (string.equals("MaximumRange")) {
            this.d();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    private void t() {
        StrokeChooserPanel strokeChooserPanel = new StrokeChooserPanel(null, this.v);
        int n2 = JOptionPane.showConfirmDialog(this, strokeChooserPanel, u.getString("Stroke_Selection"), 2, -1);
        if (n2 == 0) {
            this.j.a(strokeChooserPanel.a());
        }
    }

    private void s() {
        Color color = JColorChooser.showDialog(this, u.getString("Grid_Color"), Color.blue);
        if (color != null) {
            this.s.a(color);
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.g) {
            this.b();
        } else if (focusEvent.getSource() == this.x) {
            this.d();
        }
    }

    public void q() {
        this.z = this.t.isSelected();
        if (this.z) {
            this.g.setText(Double.toString(this.D));
            this.g.setEnabled(false);
            this.x.setText(Double.toString(this.a));
            this.x.setEnabled(false);
        } else {
            this.g.setEnabled(true);
            this.x.setEnabled(true);
        }
    }

    public void b() {
        double d2;
        try {
            d2 = Double.parseDouble(this.g.getText());
            if (d2 >= this.a) {
                d2 = this.D;
            }
        }
        catch (NumberFormatException numberFormatException) {
            d2 = this.D;
        }
        this.D = d2;
        this.g.setText(Double.toString(this.D));
    }

    public void d() {
        double d2;
        try {
            d2 = Double.parseDouble(this.x.getText());
            if (d2 <= this.D) {
                d2 = this.a;
            }
        }
        catch (NumberFormatException numberFormatException) {
            d2 = this.a;
        }
        this.a = d2;
        this.x.setText(Double.toString(this.a));
    }

    public void a(Axis axis) {
        super.a(axis);
        NumberAxis numberAxis = (NumberAxis)axis;
        numberAxis.c(this.z);
        if (!this.z) {
            numberAxis.c(this.D, this.a);
        }
    }
}

