/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.CrosshairInfo;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.XYBarRenderer;
import org.jfree.chart.renderer.XYItemRendererState;
import org.jfree.data.IntervalXYDataset;
import org.jfree.data.XYDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.PublicCloneable;

public class ClusteredXYBarRenderer
extends XYBarRenderer
implements Cloneable,
PublicCloneable,
Serializable {
    private double v;
    private double l;
    private boolean t;

    public ClusteredXYBarRenderer() {
        this(0.0, false);
    }

    public ClusteredXYBarRenderer(double d2, boolean bl2) {
        super(d2);
        this.v = d2;
        this.t = bl2;
    }

    public XYItemRendererState a(Graphics2D graphics2D, Rectangle2D rectangle2D, XYPlot xYPlot, XYDataset xYDataset, PlotRenderingInfo plotRenderingInfo) {
        XYItemRendererState xYItemRendererState = super.a(graphics2D, rectangle2D, xYPlot, xYDataset, plotRenderingInfo);
        ValueAxis valueAxis = xYPlot.f();
        this.l = valueAxis.a(0.0, rectangle2D, xYPlot.C());
        return xYItemRendererState;
    }

    public void a(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n2, int n3, CrosshairInfo crosshairInfo, int n4) {
        EntityCollection entityCollection;
        IntervalXYDataset intervalXYDataset = (IntervalXYDataset)xYDataset;
        Paint paint = this.j(n2, n3);
        Paint paint2 = this.e(n2, n3);
        Number number = intervalXYDataset.b(n2, n3);
        if (number == null) {
            return;
        }
        RectangleEdge rectangleEdge = xYPlot.C();
        double d2 = valueAxis2.a(number.doubleValue(), rectangle2D, rectangleEdge);
        RectangleEdge rectangleEdge2 = xYPlot.B();
        double d3 = intervalXYDataset.d(n2, n3).doubleValue();
        double d4 = valueAxis.a(d3, rectangle2D, rectangleEdge2);
        double d5 = intervalXYDataset.f(n2, n3).doubleValue();
        double d6 = valueAxis.a(d5, rectangle2D, rectangleEdge2);
        double d7 = Math.max(1.0, Math.abs(d6 - d4));
        double d8 = Math.abs(d2 - this.l);
        if (this.t) {
            d4 -= d7 / 2.0;
        }
        if (this.v > 0.0) {
            double d9 = d7 * this.v;
            d7 -= d9;
            d4 += d9 / 2.0;
        }
        int n5 = xYDataset.e_();
        double d10 = d7 / (double)n5;
        Rectangle2D.Double double_ = null;
        PlotOrientation plotOrientation = xYPlot.q();
        if (plotOrientation == PlotOrientation.b) {
            double_ = new Rectangle2D.Double(Math.min(this.l, d2), d4 - d10 * (double)(n5 - n2), d8, d10);
        } else if (plotOrientation == PlotOrientation.a) {
            double_ = new Rectangle2D.Double(d4 + d10 * (double)n2, Math.min(this.l, d2), d10, d8);
        }
        graphics2D.setPaint(paint);
        graphics2D.fill(double_);
        if (Math.abs(d6 - d4) > 3.0) {
            graphics2D.setStroke(this.f(n2, n3));
            graphics2D.setPaint(paint2);
            graphics2D.draw(double_);
        }
        if (plotRenderingInfo != null && (entityCollection = plotRenderingInfo.b().c()) != null) {
            String string = null;
            if (this.f() != null) {
                string = this.f().generateToolTip(xYDataset, n2, n3);
            }
            String string2 = null;
            if (this.c() != null) {
                string2 = this.c().a(xYDataset, n2, n3);
            }
            XYItemEntity xYItemEntity = new XYItemEntity(double_, xYDataset, n2, n3, string, string2);
            entityCollection.a(xYItemEntity);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

