/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.CrosshairInfo;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.labels.HighLowToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.AbstractXYItemRenderer;
import org.jfree.chart.renderer.XYItemRenderer;
import org.jfree.chart.renderer.XYItemRendererState;
import org.jfree.data.HighLowDataset;
import org.jfree.data.IntervalXYDataset;
import org.jfree.data.XYDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.PublicCloneable;

public class CandlestickRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
Cloneable,
PublicCloneable,
Serializable {
    private int l = 0;
    private double E = 0.6428571428571429;
    private double v = 0.0;
    private double O;
    private double D = 7.2E7;
    private double B;
    private transient Paint H;
    private transient Paint t;
    private boolean x;
    private transient double G;

    public CandlestickRenderer() {
        this(-1.0);
    }

    public CandlestickRenderer(double d2) {
        this(d2, true, new HighLowToolTipGenerator());
    }

    public CandlestickRenderer(double d2, boolean bl2, XYToolTipGenerator xYToolTipGenerator) {
        this.a(xYToolTipGenerator);
        this.O = d2;
        this.x = bl2;
        this.H = Color.green;
        this.t = Color.red;
    }

    public double g() {
        return this.O;
    }

    public Paint h() {
        return this.H;
    }

    public Paint i() {
        return this.t;
    }

    public XYItemRendererState a(Graphics2D graphics2D, Rectangle2D rectangle2D, XYPlot xYPlot, XYDataset xYDataset, PlotRenderingInfo plotRenderingInfo) {
        ValueAxis valueAxis = xYPlot.E();
        double d2 = valueAxis.h();
        double d3 = d2 + this.D;
        RectangleEdge rectangleEdge = xYPlot.B();
        double d4 = valueAxis.a(d2, rectangle2D, rectangleEdge);
        double d5 = valueAxis.a(d3, rectangle2D, rectangleEdge);
        this.B = Math.abs(d5 - d4);
        if (this.x) {
            HighLowDataset highLowDataset = (HighLowDataset)xYDataset;
            this.G = 0.0;
            for (int i2 = 0; i2 < highLowDataset.e_(); ++i2) {
                for (int i3 = 0; i3 < highLowDataset.b(i2); ++i3) {
                    double d6 = highLowDataset.j(i2, i3).doubleValue();
                    if (!(d6 > this.G)) continue;
                    this.G = d6;
                }
            }
        }
        return new XYItemRendererState(plotRenderingInfo);
    }

    public void a(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n2, int n3, CrosshairInfo crosshairInfo, int n4) {
        Object object;
        double d2;
        double d3;
        double d4;
        int n5;
        double d5;
        double d6;
        boolean bl2;
        PlotOrientation plotOrientation = xYPlot.q();
        if (plotOrientation == PlotOrientation.b) {
            bl2 = true;
        } else if (plotOrientation == PlotOrientation.a) {
            bl2 = false;
        } else {
            return;
        }
        EntityCollection entityCollection = null;
        if (plotRenderingInfo != null) {
            entityCollection = plotRenderingInfo.b().c();
        }
        HighLowDataset highLowDataset = (HighLowDataset)xYDataset;
        Number number = highLowDataset.c(n2, n3);
        Number number2 = highLowDataset.l(n2, n3);
        Number number3 = highLowDataset.g(n2, n3);
        Number number4 = highLowDataset.i(n2, n3);
        Number number5 = highLowDataset.k(n2, n3);
        RectangleEdge rectangleEdge = xYPlot.B();
        double d7 = valueAxis.a(number.doubleValue(), rectangle2D, rectangleEdge);
        RectangleEdge rectangleEdge2 = xYPlot.C();
        double d8 = valueAxis2.a(number2.doubleValue(), rectangle2D, rectangleEdge2);
        double d9 = valueAxis2.a(number3.doubleValue(), rectangle2D, rectangleEdge2);
        double d10 = valueAxis2.a(number4.doubleValue(), rectangle2D, rectangleEdge2);
        double d11 = valueAxis2.a(number5.doubleValue(), rectangle2D, rectangleEdge2);
        if (this.O > 0.0) {
            d6 = this.O;
            d5 = this.O;
        } else {
            double d12 = 0.0;
            switch (this.l) {
                case 0: {
                    n5 = highLowDataset.b(n2);
                    if (bl2) {
                        d12 = rectangle2D.getHeight() / (double)n5;
                        break;
                    }
                    d12 = rectangle2D.getWidth() / (double)n5;
                    break;
                }
                case 1: {
                    n5 = highLowDataset.b(n2);
                    d4 = -1.0;
                    d12 = rectangle2D.getWidth();
                    for (int i2 = 0; i2 < n5; ++i2) {
                        d3 = valueAxis.a(highLowDataset.c(n2, i2).doubleValue(), rectangle2D, rectangleEdge);
                        if (d4 != -1.0) {
                            d12 = Math.min(d12, Math.abs(d3 - d4));
                        }
                        d4 = d3;
                    }
                    break;
                }
                case 2: {
                    IntervalXYDataset intervalXYDataset = (IntervalXYDataset)xYDataset;
                    d3 = valueAxis.a(intervalXYDataset.d(n2, n3).doubleValue(), rectangle2D, xYPlot.B());
                    d2 = valueAxis.a(intervalXYDataset.f(n2, n3).doubleValue(), rectangle2D, xYPlot.B());
                    d12 = Math.abs(d2 - d3);
                }
            }
            d12 -= 2.0 * this.v;
            d12 *= this.E;
            d12 = Math.min(d12, this.B);
            d6 = Math.max(Math.min(1.0, this.B), d12);
            d5 = Math.max(Math.min(3.0, this.B), d12);
        }
        Paint paint = this.j(n2, n3);
        Stroke stroke = this.f(n2, n3);
        graphics2D.setStroke(stroke);
        if (this.x) {
            double d13;
            double d14;
            n5 = highLowDataset.j(n2, n3).intValue();
            d4 = (double)n5 / this.G;
            if (bl2) {
                d14 = rectangle2D.getMinX();
                d13 = rectangle2D.getMaxX();
            } else {
                d14 = rectangle2D.getMinY();
                d13 = rectangle2D.getMaxY();
            }
            double d15 = d4 * (d13 - d14);
            graphics2D.setPaint(Color.gray);
            object = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.3f));
            if (bl2) {
                graphics2D.fill(new Rectangle2D.Double(d14, d7 - d6 / 2.0, d15, d6));
            } else {
                graphics2D.fill(new Rectangle2D.Double(d7 - d6 / 2.0, d13 - d15, d6, d15));
            }
            graphics2D.setComposite((Composite)object);
        }
        graphics2D.setPaint(paint);
        double d16 = Math.max(d10, d11);
        double d17 = Math.min(d10, d11);
        d3 = Math.max(number4.doubleValue(), number5.doubleValue());
        d2 = Math.min(number4.doubleValue(), number5.doubleValue());
        if (number2.doubleValue() > d3) {
            if (bl2) {
                graphics2D.draw(new Line2D.Double(d8, d7, d16, d7));
            } else {
                graphics2D.draw(new Line2D.Double(d7, d8, d7, d16));
            }
        }
        if (number3.doubleValue() < d2) {
            if (bl2) {
                graphics2D.draw(new Line2D.Double(d9, d7, d17, d7));
            } else {
                graphics2D.draw(new Line2D.Double(d7, d9, d7, d17));
            }
        }
        Rectangle2D.Double double_ = null;
        double_ = bl2 ? new Rectangle2D.Double(d17, d7 - d5 / 2.0, d16 - d17, d5) : new Rectangle2D.Double(d7 - d5 / 2.0, d17, d5, d16 - d17);
        if (number4.doubleValue() > number5.doubleValue()) {
            if (this.H != null) {
                graphics2D.setPaint(this.H);
                graphics2D.fill(double_);
            }
        } else {
            if (this.t != null) {
                graphics2D.setPaint(this.t);
            }
            graphics2D.fill(double_);
        }
        graphics2D.setPaint(paint);
        graphics2D.draw(double_);
        if (entityCollection != null) {
            object = null;
            if (this.f() != null) {
                object = this.f().generateToolTip(xYDataset, n2, n3);
            }
            String string = null;
            if (this.c() != null) {
                string = this.c().a(xYDataset, n2, n3);
            }
            XYItemEntity xYItemEntity = new XYItemEntity(double_, xYDataset, n2, n3, (String)object, string);
            entityCollection.a(xYItemEntity);
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof CandlestickRenderer) {
            CandlestickRenderer candlestickRenderer = (CandlestickRenderer)object;
            boolean bl2 = super.equals(object);
            bl2 = bl2 && this.O == candlestickRenderer.g();
            bl2 = bl2 && this.H.equals(candlestickRenderer.h());
            bl2 = bl2 && this.t.equals(candlestickRenderer.i());
            bl2 = bl2 && this.x == candlestickRenderer.x;
            return bl2;
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

