/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.PieSectionEntity;
import org.jfree.chart.labels.PieItemLabelGenerator;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PlotState;
import org.jfree.chart.urls.PieURLGenerator;
import org.jfree.data.CategoryDataset;
import org.jfree.data.CategoryToPieDataset;
import org.jfree.data.Dataset;
import org.jfree.data.DatasetUtilities;
import org.jfree.data.PieDataset;
import org.jfree.util.ObjectList;
import org.jfree.util.ObjectUtils;
import org.jfree.util.PaintList;
import org.jfree.util.Rotation;
import org.jfree.util.StrokeList;

public class PiePlot
extends Plot
implements Cloneable,
Serializable {
    public static final Font ag = new Font("SansSerif", 0, 10);
    public static final Paint N = Color.black;
    public static final NumberFormat n = NumberFormat.getNumberInstance();
    public static final NumberFormat j = NumberFormat.getPercentInstance();
    public static final Font R = new Font("SansSerif", 0, 12);
    public static final Paint ac = Color.black;
    private PieDataset g;
    private CategoryDataset aa;
    private double y;
    private boolean V;
    private double af;
    private double A;
    private Rotation C;
    private int p;
    private Font h;
    private transient Paint G;
    private double M;
    private ObjectList O;
    private NumberFormat v;
    private NumberFormat ae;
    private PieItemLabelGenerator Y;
    private PieURLGenerator d;
    private boolean w = true;
    private Font a = R;
    private transient Paint u = ac;
    private transient Paint k;
    private PaintList m;
    private boolean X;
    private Paint D;
    private PaintList f;
    private boolean J;
    private transient Stroke I;
    private StrokeList E;
    private boolean H;
    private int B;
    private double P;
    public static ResourceBundle Q = ResourceBundle.getBundle("org.jfree.chart.plot.LocalizationBundle");

    public PiePlot() {
        this(null);
    }

    public PiePlot(PieDataset pieDataset) {
        this.g = pieDataset;
        if (pieDataset != null) {
            pieDataset.b(this);
        }
        this.aa = null;
        this.l();
    }

    private void l() {
        this.y = 0.25;
        this.V = true;
        this.af = 1.0;
        this.A = 90.0;
        this.C = Rotation.c;
        this.p = 1;
        this.h = ag;
        this.G = N;
        this.M = 0.1;
        this.v = n;
        this.ae = j;
        this.Y = null;
        this.d = null;
        this.k = null;
        this.m = new PaintList();
        this.X = true;
        this.D = Color.lightGray;
        this.f = new PaintList();
        this.J = true;
        this.I = new BasicStroke(1.0f);
        this.E = new StrokeList();
        this.H = true;
        this.P = 1.0E-5;
    }

    public PieDataset g() {
        return this.g;
    }

    public CategoryDataset a() {
        return this.aa;
    }

    public double r() {
        return this.A;
    }

    public Rotation i() {
        return this.C;
    }

    public double b() {
        return this.y;
    }

    public boolean h() {
        return this.V;
    }

    public void a(boolean bl2) {
        this.V = bl2;
    }

    public double k() {
        return this.af;
    }

    public double d(int n2) {
        Number number;
        if (n2 < 0) {
            throw new IllegalArgumentException("PiePlot.getExplodePercent(int): section outside valid range.");
        }
        double d2 = 0.0;
        if (this.O != null && (number = (Number)this.O.a(n2)) != null) {
            d2 = number.doubleValue();
        }
        return d2;
    }

    public int q() {
        return this.p;
    }

    public PieDataset m() {
        return this.g();
    }

    public Paint g(int n2) {
        Paint paint = null;
        if (this.k != null) {
            paint = this.k;
        } else {
            DrawingSupplier drawingSupplier;
            paint = this.m.b(n2);
            if (paint == null && this.d() && (drawingSupplier = this.A()) != null) {
                paint = drawingSupplier.b();
                this.m.a(n2, paint);
            }
        }
        return paint;
    }

    public Paint a(int n2) {
        return this.g(n2);
    }

    public boolean d() {
        return this.X;
    }

    public Paint c(int n2) {
        Paint paint = null;
        if (this.D != null) {
            paint = this.D;
        } else {
            DrawingSupplier drawingSupplier;
            paint = this.f.b(n2);
            if (paint == null && this.j() && (drawingSupplier = this.A()) != null) {
                paint = drawingSupplier.c();
                this.f.a(n2, paint);
            }
        }
        return paint;
    }

    public boolean j() {
        return this.J;
    }

    public Paint e(int n2) {
        return this.c(n2);
    }

    public Stroke f(int n2) {
        Stroke stroke = null;
        if (this.D != null) {
            stroke = this.I;
        } else {
            DrawingSupplier drawingSupplier;
            stroke = this.E.b(n2);
            if (stroke == null && this.n() && (drawingSupplier = this.A()) != null) {
                stroke = drawingSupplier.a();
                this.E.a(n2, stroke);
            }
        }
        return stroke;
    }

    public Stroke b(int n2) {
        return this.f(n2);
    }

    public boolean n() {
        return this.H;
    }

    public double p() {
        return this.P;
    }

    public LegendItemCollection o() {
        Dataset dataset;
        LegendItemCollection legendItemCollection = new LegendItemCollection();
        List list = null;
        Dataset dataset2 = this.g();
        if (dataset2 == null) {
            dataset2 = this.a();
        }
        if (dataset2 instanceof PieDataset) {
            dataset = dataset2;
            list = dataset.a();
        } else if (dataset2 instanceof CategoryDataset) {
            dataset = (CategoryDataset)dataset2;
            if (this.B == 0) {
                list = dataset.e();
            } else if (this.B == 1) {
                list = dataset.f();
            }
        }
        if (list != null) {
            int n2 = 0;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string;
                String string2 = string = iterator.next().toString();
                Shape shape = null;
                Paint paint = this.a(n2);
                Paint paint2 = this.e(n2);
                Stroke stroke = this.b(n2);
                LegendItem legendItem = new LegendItem(string, string2, shape, paint, paint2, stroke);
                legendItemCollection.a(legendItem);
                ++n2;
            }
        }
        return legendItemCollection;
    }

    public PieItemLabelGenerator f() {
        return this.Y;
    }

    public void a(PieItemLabelGenerator pieItemLabelGenerator) {
        this.Y = pieItemLabelGenerator;
    }

    public PieURLGenerator c() {
        return this.d;
    }

    public void a(Graphics2D graphics2D, Rectangle2D rectangle2D, PlotState plotState, PlotRenderingInfo plotRenderingInfo) {
        Insets insets = this.J();
        if (insets != null) {
            rectangle2D.setRect(rectangle2D.getX() + (double)insets.left, rectangle2D.getY() + (double)insets.top, rectangle2D.getWidth() - (double)insets.left - (double)insets.right, rectangle2D.getHeight() - (double)insets.top - (double)insets.bottom);
        }
        if (plotRenderingInfo != null) {
            plotRenderingInfo.a(rectangle2D);
            plotRenderingInfo.b(rectangle2D);
        }
        this.b(graphics2D, rectangle2D);
        this.a(graphics2D, rectangle2D);
        Shape shape = graphics2D.getClip();
        graphics2D.clip(rectangle2D);
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.y()));
        if (this.g != null) {
            if (!DatasetUtilities.b(this.g)) {
                this.a(graphics2D, rectangle2D, plotRenderingInfo, 0, this.g, null);
            } else {
                this.d(graphics2D, rectangle2D);
            }
        } else {
            this.a(graphics2D, rectangle2D, plotRenderingInfo);
        }
        graphics2D.clip(shape);
        graphics2D.setComposite(composite);
        this.a(graphics2D, rectangle2D);
    }

    public void a(Graphics2D graphics2D, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, int n2, PieDataset pieDataset, String string) {
        double d2 = rectangle2D.getWidth() * this.y;
        double d3 = rectangle2D.getHeight() * this.y;
        double d4 = rectangle2D.getX() + d2 / 2.0;
        double d5 = rectangle2D.getY() + d3 / 2.0;
        double d6 = rectangle2D.getWidth() - d2;
        double d7 = rectangle2D.getHeight() - d3;
        if (this.V) {
            double d8 = Math.min(d6, d7) / 2.0;
            d4 = (d4 + d4 + d6) / 2.0 - d8;
            d5 = (d5 + d5 + d7) / 2.0 - d8;
            d6 = 2.0 * d8;
            d7 = 2.0 * d8;
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(d4, d5, d6, d7);
        double d9 = (1.0 - this.af) * d6;
        double d10 = (1.0 - this.af) * d7;
        Rectangle2D.Double double_2 = new Rectangle2D.Double(d4 + d9 / 2.0, d5 + d10 / 2.0, d6 - d9, d7 - d10);
        if (pieDataset != null && pieDataset.a().size() > 0) {
            Object object;
            List list = pieDataset.a();
            double d11 = DatasetUtilities.a(pieDataset);
            double d12 = 0.0;
            int n3 = 0;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                double d13;
                object = (Comparable)iterator.next();
                Number number = pieDataset.a((Comparable)object);
                if (number != null && (d13 = number.doubleValue()) > 0.0) {
                    double d14 = this.A + this.C.a() * (d12 * 360.0) / d11;
                    double d15 = this.A + this.C.a() * (d12 + d13) * 360.0 / d11;
                    d12 += d13;
                    double d16 = d15 - d14;
                    if (Math.abs(d16) > this.P) {
                        EntityCollection entityCollection;
                        Rectangle2D rectangle2D2 = this.a(double_2, double_, d14, d15 - d14, this.d(n3));
                        Arc2D.Double double_3 = new Arc2D.Double(rectangle2D2, d14, d15 - d14, 2);
                        Paint paint = this.a(n3);
                        Paint paint2 = this.e(n3);
                        Stroke stroke = this.b(n3);
                        graphics2D.setPaint(paint);
                        graphics2D.fill(double_3);
                        graphics2D.setStroke(stroke);
                        graphics2D.setPaint(paint2);
                        graphics2D.draw(double_3);
                        if (plotRenderingInfo != null && (entityCollection = plotRenderingInfo.b().c()) != null) {
                            String string2 = null;
                            if (this.Y != null) {
                                string2 = this.Y.a(pieDataset, (Comparable)object, n2);
                            }
                            String string3 = null;
                            if (this.d != null) {
                                string3 = this.d.a(pieDataset, (Comparable)object, n2);
                            }
                            PieSectionEntity pieSectionEntity = new PieSectionEntity(double_3, this.g, n2, n3, (Comparable)object, string2, string3);
                            entityCollection.a(pieSectionEntity);
                        }
                    }
                    if (this.p != 0) {
                        this.a(graphics2D, double_2, double_, pieDataset, d13, n3, d14, d15 - d14);
                    }
                }
                ++n3;
            }
            if (string != null) {
                graphics2D.setPaint(this.u);
                graphics2D.setFont(this.a);
                object = graphics2D.getFontMetrics().getStringBounds(string, graphics2D);
                double d17 = d4 + d6 / 2.0 - ((RectangularShape)object).getWidth() / 2.0;
                double d18 = d5 + d7 + 2.0 * ((RectangularShape)object).getHeight();
                graphics2D.drawString(string, (int)d17, (int)d18);
            }
        } else {
            this.d(graphics2D, rectangle2D);
        }
    }

    public void a(Graphics2D graphics2D, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo) {
        int n2;
        int n3;
        if (DatasetUtilities.b(this.aa)) {
            this.d(graphics2D, rectangle2D);
            return;
        }
        int n4 = 0;
        n4 = this.B == 0 ? this.aa.d() : this.aa.a();
        int n5 = (int)Math.ceil(Math.sqrt(n4));
        if (n5 > (n3 = (int)Math.ceil((double)n4 / (double)n5)) && rectangle2D.getWidth() < rectangle2D.getHeight()) {
            n2 = n5;
            n5 = n3;
            n3 = n2;
        }
        n2 = graphics2D.getFontMetrics(this.a).getHeight() * 2;
        int n6 = (int)rectangle2D.getX();
        int n7 = (int)rectangle2D.getY();
        int n8 = (int)rectangle2D.getWidth() / n5;
        int n9 = (int)rectangle2D.getHeight() / n3;
        int n10 = 0;
        int n11 = 0;
        int n12 = n3 * n5 - n4;
        int n13 = 0;
        Rectangle rectangle = new Rectangle();
        for (int i2 = 0; i2 < n4; ++i2) {
            rectangle.setBounds(n6 + n13 + n8 * n11, n7 + n9 * n10, n8, n9 - n2);
            CategoryToPieDataset categoryToPieDataset = new CategoryToPieDataset(this.aa, this.B, i2);
            String string = null;
            string = this.B == 0 ? this.aa.a(i2).toString() : this.aa.b(i2).toString();
            this.a(graphics2D, rectangle, plotRenderingInfo, i2, categoryToPieDataset, string);
            if (++n11 != n5) continue;
            n11 = 0;
            if (++n10 != n3 - 1 || n12 == 0) continue;
            n13 = n12 * n8 / 2;
        }
    }

    public void a(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, PieDataset pieDataset, double d2, int n2, double d3, double d4) {
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        String string = "";
        if (this.p == 1) {
            string = pieDataset.a(n2).toString();
        } else if (this.p == 2) {
            string = this.v.format(d2);
        } else if (this.p == 3) {
            string = this.ae.format(d4 / 360.0 * this.C.a());
        } else if (this.p == 4) {
            string = pieDataset.a(n2).toString() + " (" + this.v.format(d2) + ")";
        } else if (this.p == 5) {
            string = pieDataset.a(n2).toString() + " (" + this.ae.format(d4 / 360.0 * this.C.a()) + ")";
        } else if (this.p == 6) {
            string = this.v.format(d2) + " (" + this.ae.format(d4 / 360.0 * this.C.a()) + ")";
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics(this.h);
        Rectangle2D rectangle2D3 = fontMetrics.getStringBounds(string, graphics2D);
        LineMetrics lineMetrics = this.h.getLineMetrics(string, fontRenderContext);
        double d5 = lineMetrics.getAscent();
        Point2D point2D = this.a(rectangle2D3, d5, rectangle2D, rectangle2D2, d3, d4, this.d(n2));
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
        graphics2D.setPaint(this.G);
        graphics2D.setFont(this.h);
        graphics2D.drawString(string, (float)point2D.getX(), (float)point2D.getY());
        graphics2D.setComposite(composite);
    }

    public String Q() {
        return Q.getString("Pie_Plot");
    }

    public Rectangle2D a(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, double d2, double d3, double d4) {
        if (d4 == 0.0) {
            return rectangle2D;
        }
        Arc2D.Double double_ = new Arc2D.Double(rectangle2D, d2, d3 / 2.0, 0);
        Point2D point2D = double_.getEndPoint();
        Arc2D.Double double_2 = new Arc2D.Double(rectangle2D2, d2, d3 / 2.0, 0);
        Point2D point2D2 = double_2.getEndPoint();
        double d5 = (point2D.getX() - point2D2.getX()) * d4;
        double d6 = (point2D.getY() - point2D2.getY()) * d4;
        return new Rectangle2D.Double(rectangle2D.getX() - d5, rectangle2D.getY() - d6, rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public Point2D a(Rectangle2D rectangle2D, double d2, Rectangle2D rectangle2D2, Rectangle2D rectangle2D3, double d3, double d4, double d5) {
        Arc2D.Double double_ = new Arc2D.Double(rectangle2D2, d3, d4 / 2.0, 0);
        Point2D point2D = double_.getEndPoint();
        Arc2D.Double double_2 = new Arc2D.Double(rectangle2D3, d3, d4 / 2.0, 0);
        Point2D point2D2 = double_2.getEndPoint();
        double d6 = (point2D.getX() - point2D2.getX()) * d5;
        double d7 = (point2D.getY() - point2D2.getY()) * d5;
        double d8 = point2D.getX() - (d6 -= (point2D.getX() - rectangle2D2.getCenterX()) * this.M);
        double d9 = point2D.getY() - (d7 -= (point2D.getY() - rectangle2D2.getCenterY()) * this.M);
        if (d8 <= rectangle2D2.getCenterX()) {
            d8 -= rectangle2D.getWidth();
        }
        if (d9 > rectangle2D2.getCenterY()) {
            d9 += d2;
        }
        return new Point2D.Double(d8, d9);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (super.equals(object) && object instanceof PiePlot) {
            PiePlot piePlot = (PiePlot)object;
            boolean bl2 = this.y == piePlot.y;
            boolean bl3 = this.V == piePlot.V;
            boolean bl4 = this.af == piePlot.af;
            boolean bl5 = this.A == piePlot.A;
            boolean bl6 = this.C == piePlot.C;
            boolean bl7 = this.p == piePlot.p;
            boolean bl8 = ObjectUtils.a(this.h, piePlot.h);
            boolean bl9 = ObjectUtils.a(this.G, piePlot.G);
            boolean bl10 = this.M == piePlot.M;
            boolean bl11 = ObjectUtils.a(this.O, piePlot.O);
            boolean bl12 = ObjectUtils.a(this.v, piePlot.v);
            boolean bl13 = ObjectUtils.a(this.ae, piePlot.ae);
            boolean bl14 = ObjectUtils.a(this.Y, piePlot.Y);
            boolean bl15 = ObjectUtils.a(this.d, piePlot.d);
            boolean bl16 = this.w == piePlot.w;
            boolean bl17 = ObjectUtils.a(this.a, piePlot.a);
            boolean bl18 = ObjectUtils.a(this.u, piePlot.u);
            boolean bl19 = true;
            boolean bl20 = ObjectUtils.a(this.k, piePlot.k);
            boolean bl21 = ObjectUtils.a(this.m, piePlot.m);
            boolean bl22 = true;
            boolean bl23 = ObjectUtils.a(this.D, piePlot.D);
            boolean bl24 = ObjectUtils.a(this.f, piePlot.f);
            boolean bl25 = true;
            boolean bl26 = ObjectUtils.a(this.I, piePlot.I);
            boolean bl27 = ObjectUtils.a(this.E, piePlot.E);
            boolean bl28 = this.B == piePlot.B;
            boolean bl29 = this.P == piePlot.P;
            return bl2 && bl3 && bl4 && bl5 && bl6 && bl7 && bl8 && bl9 && bl10 && bl11 && bl12 && bl13 && bl14 && bl15 && bl16 && bl17 && bl18 && bl19 && bl20 && bl21 && bl22 && bl24 && bl23 && bl25 && bl26 && bl27 && bl28 && bl29;
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        PiePlot piePlot = (PiePlot)super.clone();
        piePlot.v = (NumberFormat)this.v.clone();
        piePlot.ae = (NumberFormat)this.ae.clone();
        if (piePlot.g != null) {
            piePlot.g.b(piePlot);
        }
        return piePlot;
    }
}

