/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.Arrays;
import java.util.ResourceBundle;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.needle.ArrowNeedle;
import org.jfree.chart.needle.LineNeedle;
import org.jfree.chart.needle.LongNeedle;
import org.jfree.chart.needle.MeterNeedle;
import org.jfree.chart.needle.PinNeedle;
import org.jfree.chart.needle.PlumNeedle;
import org.jfree.chart.needle.PointerNeedle;
import org.jfree.chart.needle.ShipNeedle;
import org.jfree.chart.needle.WindNeedle;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PlotState;
import org.jfree.data.DefaultValueDataset;
import org.jfree.data.ValueDataset;
import org.jfree.util.ObjectUtils;

public class CompassPlot
extends Plot
implements Cloneable,
Serializable {
    public static final Font k = new Font("SansSerif", 1, 10);
    private int p;
    private Font a;
    private boolean y = false;
    private Paint u = Color.black;
    private Paint w = Color.yellow;
    private Paint A = Color.white;
    private Font g = new Font("Arial", 0, 10);
    private transient Ellipse2D m;
    private transient Ellipse2D f;
    private transient Area d;
    private transient Area n;
    private transient Rectangle2D v;
    private ValueDataset[] h = new ValueDataset[1];
    private MeterNeedle[] i = new MeterNeedle[1];
    public static ResourceBundle j = ResourceBundle.getBundle("org.jfree.chart.plot.LocalizationBundle");

    public CompassPlot() {
        this(new DefaultValueDataset());
    }

    public CompassPlot(ValueDataset valueDataset) {
        if (valueDataset != null) {
            this.h[0] = valueDataset;
            valueDataset.b(this);
        }
        this.m = new Ellipse2D.Double();
        this.f = new Ellipse2D.Double();
        this.v = new Rectangle2D.Double();
        this.a(0);
    }

    public void a(int n2, Paint paint) {
        if (n2 >= 0 && n2 < this.i.length) {
            this.i[n2].a(paint);
        }
    }

    public void a(int n2, Stroke stroke) {
        if (n2 >= 0 && n2 < this.i.length) {
            this.i[n2].a(stroke);
        }
    }

    public void a(int n2) {
        this.a(0, n2);
    }

    public void a(int n2, int n3) {
        switch (n3) {
            case 0: {
                this.a(n2, new ArrowNeedle(true));
                this.a(n2, Color.red);
                this.i[n2].b(Color.white);
                break;
            }
            case 1: {
                this.a(n2, new LineNeedle());
                break;
            }
            case 2: {
                this.a(n2, new LongNeedle());
                break;
            }
            case 3: {
                this.a(n2, new PinNeedle());
                break;
            }
            case 4: {
                this.a(n2, new PlumNeedle());
                break;
            }
            case 5: {
                this.a(n2, new PointerNeedle());
                break;
            }
            case 6: {
                this.a(n2, (Paint)null);
                this.a(n2, new BasicStroke(3.0f));
                this.a(n2, new ShipNeedle());
                break;
            }
            case 7: {
                this.a(n2, Color.blue);
                this.a(n2, new WindNeedle());
                break;
            }
            case 8: {
                this.a(n2, new ArrowNeedle(true));
                break;
            }
            default: {
                String string = "CompassPlot.setSeriesNeedle(...): unrecognised type.";
                throw new IllegalArgumentException(string);
            }
        }
    }

    public void a(int n2, MeterNeedle meterNeedle) {
        if (meterNeedle != null && n2 < this.i.length) {
            this.i[n2] = meterNeedle;
        }
        this.b(new PlotChangeEvent(this));
    }

    public void a(Graphics2D graphics2D, Rectangle2D rectangle2D, PlotState plotState, PlotRenderingInfo plotRenderingInfo) {
        Shape shape;
        int n2;
        double d2;
        int n3;
        Insets insets;
        int n4 = 0;
        int n5 = 0;
        if (plotRenderingInfo != null) {
            plotRenderingInfo.a(rectangle2D);
        }
        if ((insets = this.J()) != null) {
            rectangle2D.setRect(rectangle2D.getX() + (double)insets.left, rectangle2D.getY() + (double)insets.top, rectangle2D.getWidth() - (double)insets.left - (double)insets.right, rectangle2D.getHeight() - (double)insets.top - (double)insets.bottom);
        }
        if (this.y) {
            this.b(graphics2D, rectangle2D);
        }
        int n6 = (int)(rectangle2D.getWidth() / 2.0);
        int n7 = (int)(rectangle2D.getHeight() / 2.0);
        int n8 = n6;
        if (n7 < n6) {
            n8 = n7;
        }
        int n9 = 2 * --n8;
        this.m.setFrame((n6 += (int)rectangle2D.getMinX()) - n8, (n7 += (int)rectangle2D.getMinY()) - n8, n9, n9);
        this.f.setFrame(n6 - n8 + 15, n7 - n8 + 15, n9 - 30, n9 - 30);
        graphics2D.setPaint(this.w);
        this.d = new Area(this.m);
        this.n = new Area(this.f);
        this.d.subtract(this.n);
        graphics2D.fill(this.d);
        graphics2D.setPaint(this.A);
        int n10 = n9 - 30;
        graphics2D.fillOval(n6 - n8 + 15, n7 - n8 + 15, n10, n10);
        graphics2D.setPaint(this.u);
        graphics2D.drawOval(n6 - n8, n7 - n8, n9, n9);
        n10 = n9 - 20;
        graphics2D.drawOval(n6 - n8 + 10, n7 - n8 + 10, n10, n10);
        n10 = n9 - 30;
        graphics2D.drawOval(n6 - n8 + 15, n7 - n8 + 15, n10, n10);
        n10 = n9 - 80;
        graphics2D.drawOval(n6 - n8 + 40, n7 - n8 + 40, n10, n10);
        n4 = n8 - 20;
        n5 = n8 - 32;
        for (n3 = 0; n3 < 360; n3 += 15) {
            d2 = Math.toRadians(n3);
            n10 = n6 - (int)(Math.sin(d2) * (double)n5);
            int n11 = n6 - (int)(Math.sin(d2) * (double)n4);
            n2 = n7 - (int)(Math.cos(d2) * (double)n5);
            int n12 = n7 - (int)(Math.cos(d2) * (double)n4);
            graphics2D.drawLine(n10, n2, n11, n12);
        }
        graphics2D.setPaint(this.u);
        n5 = n8 - 26;
        n4 = 7;
        for (n3 = 45; n3 < 360; n3 += 90) {
            d2 = Math.toRadians(n3);
            n10 = n6 - (int)(Math.sin(d2) * (double)n5);
            n2 = n7 - (int)(Math.cos(d2) * (double)n5);
            graphics2D.fillOval(n10 - n4, n2 - n4, 2 * n4, 2 * n4);
        }
        for (n3 = 0; n3 < 360; n3 += 90) {
            d2 = Math.toRadians(n3);
            n10 = n6 - (int)(Math.sin(d2) * (double)n5);
            n2 = n7 - (int)(Math.cos(d2) * (double)n5);
            shape = new Polygon();
            shape.addPoint(n10 - n4, n2);
            shape.addPoint(n10, n2 + n4);
            shape.addPoint(n10 + n4, n2);
            shape.addPoint(n10, n2 - n4);
            graphics2D.fillPolygon((Polygon)shape);
        }
        n5 = n8 - 42;
        Font font = this.b(n8);
        graphics2D.setFont(font);
        graphics2D.drawString("N", n6 - 5, n7 - n5 + font.getSize());
        graphics2D.drawString("S", n6 - 5, n7 + n5 - 5);
        graphics2D.drawString("W", n6 - n5 + 5, n7 + 5);
        graphics2D.drawString("E", n6 + n5 - font.getSize(), n7 + 5);
        n2 = n8 / 2;
        n10 = n8 / 6;
        shape = new Rectangle2D.Double(n6 - n10, n7 - n2, 2 * n10, 2 * n2);
        int n13 = this.i.length;
        int n14 = 0;
        double d3 = 0.0;
        for (int i2 = this.h.length - 1; i2 >= 0; --i2) {
            ValueDataset valueDataset = this.h[i2];
            if (valueDataset == null || valueDataset.a() == null) continue;
            d3 = valueDataset.a().doubleValue() % 360.0;
            n14 = i2 % n13;
            this.i[n14].a(graphics2D, (Rectangle2D)shape, d3);
        }
        if (this.y) {
            this.a(graphics2D, rectangle2D);
        }
    }

    public String Q() {
        return j.getString("Compass_Plot");
    }

    public LegendItemCollection o() {
        return null;
    }

    public Font b(int n2) {
        float f2 = n2 / 10;
        if (f2 < 8.0f) {
            f2 = 8.0f;
        }
        Font font = this.g.deriveFont(f2);
        return font;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof CompassPlot && super.equals(object)) {
            CompassPlot compassPlot = (CompassPlot)object;
            boolean bl2 = this.p == compassPlot.p;
            boolean bl3 = ObjectUtils.a(this.a, compassPlot.a);
            boolean bl4 = this.y == compassPlot.y;
            boolean bl5 = ObjectUtils.a(this.u, compassPlot.u);
            boolean bl6 = ObjectUtils.a(this.w, compassPlot.w);
            boolean bl7 = ObjectUtils.a(this.A, compassPlot.A);
            boolean bl8 = ObjectUtils.a(this.g, compassPlot.g);
            boolean bl9 = Arrays.equals(this.i, compassPlot.i);
            return bl2 && bl3 && bl4 && bl5 && bl6 && bl7 && bl8 && bl9;
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        CompassPlot compassPlot = (CompassPlot)super.clone();
        compassPlot.m = (Ellipse2D)this.m.clone();
        compassPlot.f = (Ellipse2D)this.f.clone();
        compassPlot.d = (Area)this.d.clone();
        compassPlot.n = (Area)this.n.clone();
        compassPlot.v = (Rectangle2D)this.v.clone();
        compassPlot.h = (ValueDataset[])this.h.clone();
        compassPlot.i = (MeterNeedle[])this.i.clone();
        for (int i2 = 0; i2 < this.h.length; ++i2) {
            if (compassPlot.h[i2] == null) continue;
            compassPlot.h[i2].b(compassPlot);
        }
        return this.clone();
    }
}

