/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.DateTick;
import org.jfree.chart.axis.DateTickMarkPosition;
import org.jfree.chart.axis.DateTickUnit;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.TickUnits;
import org.jfree.chart.axis.Timeline;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.AxisChangeEvent;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.ValueAxisPlot;
import org.jfree.data.DateRange;
import org.jfree.data.Range;
import org.jfree.data.time.Month;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Year;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.TextAnchor;
import org.jfree.util.ObjectUtils;

public class DateAxis
extends ValueAxis
implements Cloneable,
Serializable {
    public static final DateRange A = new DateRange();
    public static final DateTickUnit y = new DateTickUnit(2, 1, new SimpleDateFormat());
    public static final Date ad = new Date();
    private DateTickUnit B;
    private DateFormat ae;
    private DateTickMarkPosition w = DateTickMarkPosition.c;
    private static final Timeline Y = new DefaultTimeline(null);
    private Timeline p;

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof DateAxis) {
            DateAxis dateAxis = (DateAxis)object;
            boolean bl2 = ObjectUtils.a(this.B, dateAxis.B);
            boolean bl3 = ObjectUtils.a(this.ae, dateAxis.ae);
            boolean bl4 = ObjectUtils.a(this.w, dateAxis.w);
            boolean bl5 = ObjectUtils.a(this.p, dateAxis.p);
            return bl2 && bl3 && bl4 && bl5;
        }
        return false;
    }

    public DateAxis() {
        this(null);
    }

    public DateAxis(String string) {
        this(string, Y);
    }

    public DateAxis(String string, Timeline timeline) {
        super(string, DateAxis.c());
        this.a(y, false, false);
        this.a(2.0);
        this.a(A, false, false);
        this.ae = null;
        this.p = timeline;
    }

    public DateTickUnit j() {
        return this.B;
    }

    public void a(DateTickUnit dateTickUnit, boolean bl2, boolean bl3) {
        this.B = dateTickUnit;
        if (bl3) {
            this.a(false, false);
        }
        if (bl2) {
            this.a(new AxisChangeEvent(this));
        }
    }

    public DateFormat d() {
        return this.ae;
    }

    public void a(Range range) {
        if (range == null) {
            throw new IllegalArgumentException("DateAxis.setRange(...): null not permitted.");
        }
        if (!(range instanceof DateRange)) {
            range = new DateRange(range);
        }
        this.a(range, true, true);
        this.a(new AxisChangeEvent(this));
    }

    public void c(double d2, double d3) {
        if (d2 >= d3) {
            throw new IllegalArgumentException("DateAxis.setRange(...): lower >= upper.");
        }
        this.a(new DateRange(d2, d3));
    }

    public Date k() {
        Date date = null;
        Range range = this.n();
        if (range instanceof DateRange) {
            DateRange dateRange = (DateRange)range;
            date = dateRange.f();
        } else {
            date = new Date((long)range.d());
        }
        return date;
    }

    public Date m() {
        Date date = null;
        Range range = this.n();
        if (range instanceof DateRange) {
            DateRange dateRange = (DateRange)range;
            date = dateRange.c();
        } else {
            date = new Date((long)range.a());
        }
        return date;
    }

    public void G() {
        if (this.q()) {
            this.x();
        }
    }

    public boolean a(long l2) {
        return !this.p.c(l2);
    }

    public double a(double d2, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        d2 = this.p.a((long)d2);
        DateRange dateRange = (DateRange)this.n();
        double d3 = this.p.a(dateRange.f().getTime());
        double d4 = this.p.a(dateRange.c());
        double d5 = 0.0;
        if (RectangleEdge.c(rectangleEdge)) {
            double d6 = rectangle2D.getX();
            double d7 = rectangle2D.getMaxX();
            d5 = this.B() ? d7 + (d2 - d3) / (d4 - d3) * (d6 - d7) : d6 + (d2 - d3) / (d4 - d3) * (d7 - d6);
        } else if (RectangleEdge.b(rectangleEdge)) {
            double d8 = rectangle2D.getMinY();
            double d9 = rectangle2D.getMaxY();
            d5 = this.B() ? d8 + (d2 - d3) / (d4 - d3) * (d9 - d8) : d9 - (d2 - d3) / (d4 - d3) * (d9 - d8);
        }
        return d5;
    }

    public double a(Date date, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        double d2 = date.getTime();
        return this.a(d2, rectangle2D, rectangleEdge);
    }

    public double b(double d2, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        DateRange dateRange = (DateRange)this.n();
        double d3 = this.p.a(dateRange.f());
        double d4 = this.p.a(dateRange.c());
        double d5 = 0.0;
        double d6 = 0.0;
        if (RectangleEdge.c(rectangleEdge)) {
            d5 = rectangle2D.getX();
            d6 = rectangle2D.getMaxX();
        } else if (RectangleEdge.b(rectangleEdge)) {
            d5 = rectangle2D.getMaxY();
            d6 = rectangle2D.getY();
        }
        double d7 = this.B() ? d4 - (d2 - d5) / (d6 - d5) * (d4 - d3) : d3 + (d2 - d5) / (d6 - d5) * (d4 - d3);
        d7 = this.p.a((long)d7);
        return d7;
    }

    public Date a(DateTickUnit dateTickUnit) {
        return this.a(this.k(), dateTickUnit);
    }

    public Date b(Date date, DateTickUnit dateTickUnit) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int n2 = dateTickUnit.c();
        int n3 = calendar.get(dateTickUnit.b());
        int n4 = n2 * (n3 / n2);
        switch (dateTickUnit.d()) {
            case 6: {
                int n5 = calendar.get(1);
                int n6 = calendar.get(2);
                int n7 = calendar.get(5);
                int n8 = calendar.get(11);
                int n9 = calendar.get(12);
                int n10 = calendar.get(13);
                calendar.set(n5, n6, n7, n8, n9, n10);
                calendar.set(14, n4);
                return calendar.getTime();
            }
            case 5: {
                int n11 = calendar.get(1);
                int n12 = calendar.get(2);
                int n13 = calendar.get(5);
                int n14 = calendar.get(11);
                int n15 = calendar.get(12);
                int n16 = this.w == DateTickMarkPosition.c ? 0 : (this.w == DateTickMarkPosition.b ? 500 : 999);
                calendar.set(14, n16);
                calendar.set(n11, n12, n13, n14, n15, n4);
                return calendar.getTime();
            }
            case 4: {
                int n17 = calendar.get(1);
                int n18 = calendar.get(2);
                int n19 = calendar.get(5);
                int n20 = calendar.get(11);
                int n21 = this.w == DateTickMarkPosition.c ? 0 : (this.w == DateTickMarkPosition.b ? 30 : 59);
                calendar.clear(14);
                calendar.set(n17, n18, n19, n20, n4, n21);
                return calendar.getTime();
            }
            case 3: {
                int n22;
                int n23;
                int n24 = calendar.get(1);
                int n25 = calendar.get(2);
                int n26 = calendar.get(5);
                if (this.w == DateTickMarkPosition.c) {
                    n23 = 0;
                    n22 = 0;
                } else if (this.w == DateTickMarkPosition.b) {
                    n23 = 30;
                    n22 = 0;
                } else {
                    n23 = 59;
                    n22 = 59;
                }
                calendar.clear(14);
                calendar.set(n24, n25, n26, n4, n23, n22);
                return calendar.getTime();
            }
            case 2: {
                int n27;
                int n28 = calendar.get(1);
                int n29 = calendar.get(2);
                if (this.w == DateTickMarkPosition.c) {
                    n27 = 0;
                    boolean bl2 = false;
                    boolean bl3 = false;
                } else if (this.w == DateTickMarkPosition.b) {
                    n27 = 12;
                    boolean bl4 = false;
                    boolean bl5 = false;
                } else {
                    n27 = 23;
                    int n30 = 59;
                    int n31 = 59;
                }
                calendar.clear(14);
                calendar.set(n28, n29, n4, n27, 0, 0);
                long l2 = calendar.getTime().getTime();
                if (l2 > date.getTime()) {
                    calendar.set(n28, n29, n4 - 1, n27, 0, 0);
                }
                return calendar.getTime();
            }
            case 1: {
                int n32 = calendar.get(1);
                calendar.clear(14);
                calendar.set(n32, n4, 1, 0, 0, 0);
                Month month = new Month(calendar.getTime());
                Date date2 = this.a(month, this.w);
                long l3 = date2.getTime();
                if (l3 > date.getTime()) {
                    month = (Month)month.i();
                    date2 = this.a(month, this.w);
                }
                return date2;
            }
            case 0: {
                int n33 = this.w == DateTickMarkPosition.c ? 0 : (this.w == DateTickMarkPosition.b ? 6 : 12);
                calendar.clear(14);
                calendar.set(n4, n33, 0, 0, 0, 0);
                return calendar.getTime();
            }
        }
        return null;
    }

    private Date a(RegularTimePeriod regularTimePeriod, DateTickMarkPosition dateTickMarkPosition) {
        Date date = null;
        if (dateTickMarkPosition == DateTickMarkPosition.c) {
            date = new Date(regularTimePeriod.a());
        } else if (dateTickMarkPosition == DateTickMarkPosition.b) {
            date = new Date(regularTimePeriod.f());
        } else if (dateTickMarkPosition == DateTickMarkPosition.a) {
            date = new Date(regularTimePeriod.e());
        }
        return date;
    }

    public Date a(Date date, DateTickUnit dateTickUnit) {
        Date date2 = this.b(date, dateTickUnit);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date2);
        calendar.add(dateTickUnit.b(), dateTickUnit.c());
        return calendar.getTime();
    }

    public static TickUnitSource c() {
        TickUnits tickUnits = new TickUnits();
        tickUnits.b(new DateTickUnit(6, 1, new SimpleDateFormat("HH:mm:ss.SSS")));
        tickUnits.b(new DateTickUnit(6, 5, 6, 1, new SimpleDateFormat("HH:mm:ss.SSS")));
        tickUnits.b(new DateTickUnit(6, 10, 6, 1, new SimpleDateFormat("HH:mm:ss.SSS")));
        tickUnits.b(new DateTickUnit(6, 25, 6, 5, new SimpleDateFormat("HH:mm:ss.SSS")));
        tickUnits.b(new DateTickUnit(6, 50, 6, 10, new SimpleDateFormat("HH:mm:ss.SSS")));
        tickUnits.b(new DateTickUnit(6, 100, 6, 10, new SimpleDateFormat("HH:mm:ss.SSS")));
        tickUnits.b(new DateTickUnit(6, 250, 6, 10, new SimpleDateFormat("HH:mm:ss.SSS")));
        tickUnits.b(new DateTickUnit(6, 500, 6, 50, new SimpleDateFormat("HH:mm:ss.SSS")));
        tickUnits.b(new DateTickUnit(5, 1, 6, 50, new SimpleDateFormat("HH:mm:ss")));
        tickUnits.b(new DateTickUnit(5, 5, 5, 1, new SimpleDateFormat("HH:mm:ss")));
        tickUnits.b(new DateTickUnit(5, 10, 5, 1, new SimpleDateFormat("HH:mm:ss")));
        tickUnits.b(new DateTickUnit(5, 30, 5, 5, new SimpleDateFormat("HH:mm:ss")));
        tickUnits.b(new DateTickUnit(4, 1, 5, 5, new SimpleDateFormat("HH:mm")));
        tickUnits.b(new DateTickUnit(4, 2, 5, 10, new SimpleDateFormat("HH:mm")));
        tickUnits.b(new DateTickUnit(4, 5, 4, 1, new SimpleDateFormat("HH:mm")));
        tickUnits.b(new DateTickUnit(4, 10, 4, 1, new SimpleDateFormat("HH:mm")));
        tickUnits.b(new DateTickUnit(4, 15, 4, 5, new SimpleDateFormat("HH:mm")));
        tickUnits.b(new DateTickUnit(4, 20, 4, 5, new SimpleDateFormat("HH:mm")));
        tickUnits.b(new DateTickUnit(4, 30, 4, 5, new SimpleDateFormat("HH:mm")));
        tickUnits.b(new DateTickUnit(3, 1, 4, 5, new SimpleDateFormat("HH:mm")));
        tickUnits.b(new DateTickUnit(3, 2, 4, 10, new SimpleDateFormat("HH:mm")));
        tickUnits.b(new DateTickUnit(3, 4, 4, 30, new SimpleDateFormat("HH:mm")));
        tickUnits.b(new DateTickUnit(3, 6, 3, 1, new SimpleDateFormat("HH:mm")));
        tickUnits.b(new DateTickUnit(3, 12, 3, 1, new SimpleDateFormat("d-MMM, HH:mm")));
        tickUnits.b(new DateTickUnit(2, 1, 3, 1, new SimpleDateFormat("d-MMM")));
        tickUnits.b(new DateTickUnit(2, 2, 3, 1, new SimpleDateFormat("d-MMM")));
        tickUnits.b(new DateTickUnit(2, 7, 2, 1, new SimpleDateFormat("d-MMM")));
        tickUnits.b(new DateTickUnit(2, 15, 2, 1, new SimpleDateFormat("d-MMM")));
        tickUnits.b(new DateTickUnit(1, 1, 2, 1, new SimpleDateFormat("MMM-yyyy")));
        tickUnits.b(new DateTickUnit(1, 2, 2, 1, new SimpleDateFormat("MMM-yyyy")));
        tickUnits.b(new DateTickUnit(1, 3, 1, 1, new SimpleDateFormat("MMM-yyyy")));
        tickUnits.b(new DateTickUnit(1, 4, 1, 1, new SimpleDateFormat("MMM-yyyy")));
        tickUnits.b(new DateTickUnit(1, 6, 1, 1, new SimpleDateFormat("MMM-yyyy")));
        tickUnits.b(new DateTickUnit(0, 1, 1, 1, new SimpleDateFormat("yyyy")));
        tickUnits.b(new DateTickUnit(0, 2, 1, 3, new SimpleDateFormat("yyyy")));
        tickUnits.b(new DateTickUnit(0, 5, 0, 1, new SimpleDateFormat("yyyy")));
        tickUnits.b(new DateTickUnit(0, 10, 0, 1, new SimpleDateFormat("yyyy")));
        tickUnits.b(new DateTickUnit(0, 25, 0, 5, new SimpleDateFormat("yyyy")));
        tickUnits.b(new DateTickUnit(0, 50, 0, 10, new SimpleDateFormat("yyyy")));
        tickUnits.b(new DateTickUnit(0, 100, 0, 20, new SimpleDateFormat("yyyy")));
        return tickUnits;
    }

    public void x() {
        Plot plot = this.o();
        if (plot == null) {
            return;
        }
        if (plot instanceof ValueAxisPlot) {
            long l2;
            ValueAxisPlot valueAxisPlot = (ValueAxisPlot)((Object)plot);
            Range range = valueAxisPlot.a(this);
            if (range == null) {
                range = new DateRange();
            }
            long l3 = this.p.a((long)range.a());
            long l4 = (long)this.K();
            if ((double)l4 > 0.0) {
                l2 = l3 - l4;
            } else {
                long l5;
                l2 = this.p.a((long)range.d());
                double d2 = l3 - l2;
                if (d2 < (double)(l5 = (long)this.I())) {
                    long l6 = (long)((double)l5 - d2) / 2L;
                    l3 += l6;
                    l2 -= l6;
                }
                l3 += (long)(d2 * this.r());
                l2 -= (long)(d2 * this.H());
            }
            l3 = this.p.b(l3);
            l2 = this.p.b(l2);
            DateRange dateRange = new DateRange(new Date(l2), new Date(l3));
            this.a(dateRange, false, false);
        }
    }

    public void c(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge) {
        if (RectangleEdge.c(rectangleEdge)) {
            this.b(graphics2D, rectangle2D, rectangle2D2, rectangleEdge);
        } else if (RectangleEdge.b(rectangleEdge)) {
            this.a(graphics2D, rectangle2D, rectangle2D2, rectangleEdge);
        }
    }

    public void b(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge) {
        double d2;
        double d3;
        double d4;
        double d5;
        TickUnitSource tickUnitSource = this.D();
        double d6 = this.a(0.0, rectangle2D2, rectangleEdge);
        double d7 = this.n().e() / 10.0;
        DateTickUnit dateTickUnit = (DateTickUnit)tickUnitSource.a(d7);
        double d8 = this.a(graphics2D, dateTickUnit);
        double d9 = d8 / (d5 = Math.abs((d4 = this.a(dateTickUnit.a(), rectangle2D2, rectangleEdge)) - d6)) * dateTickUnit.a();
        DateTickUnit dateTickUnit2 = (DateTickUnit)tickUnitSource.a(d9);
        double d10 = this.a(graphics2D, dateTickUnit2);
        DateTickUnit dateTickUnit3 = d10 < (d3 = Math.abs((d2 = this.a(dateTickUnit2.a(), rectangle2D2, rectangleEdge)) - d6)) ? dateTickUnit2 : (DateTickUnit)tickUnitSource.c(dateTickUnit2);
        this.a(dateTickUnit3, false, false);
    }

    public void a(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge) {
        double d2;
        double d3;
        double d4;
        double d5;
        TickUnitSource tickUnitSource = this.D();
        double d6 = this.a(0.0, rectangle2D2, rectangleEdge);
        double d7 = this.n().e() / 10.0;
        DateTickUnit dateTickUnit = (DateTickUnit)tickUnitSource.a(d7);
        double d8 = this.b(graphics2D, dateTickUnit);
        double d9 = d8 / (d5 = Math.abs((d4 = this.a(dateTickUnit.a(), rectangle2D2, rectangleEdge)) - d6)) * dateTickUnit.a();
        DateTickUnit dateTickUnit2 = (DateTickUnit)tickUnitSource.a(d9);
        double d10 = this.b(graphics2D, dateTickUnit2);
        DateTickUnit dateTickUnit3 = d10 < (d3 = Math.abs((d2 = this.a(dateTickUnit2.a(), rectangle2D2, rectangleEdge)) - d6)) ? dateTickUnit2 : (DateTickUnit)tickUnitSource.c(dateTickUnit2);
        this.a(dateTickUnit3, false, false);
    }

    private double a(Graphics2D graphics2D, DateTickUnit dateTickUnit) {
        Insets insets = this.w();
        double d2 = insets.left + insets.right;
        Font font = this.s();
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        LineMetrics lineMetrics = font.getLineMetrics("ABCxyz", fontRenderContext);
        if (this.t()) {
            d2 += (double)lineMetrics.getHeight();
        } else {
            DateRange dateRange = (DateRange)this.n();
            Date date = dateRange.f();
            Date date2 = dateRange.c();
            String string = null;
            String string2 = null;
            DateFormat dateFormat = this.d();
            if (dateFormat != null) {
                string = dateFormat.format(date);
                string2 = dateFormat.format(date2);
            } else {
                string = dateTickUnit.a(date);
                string2 = dateTickUnit.a(date2);
            }
            FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
            double d3 = fontMetrics.getStringBounds(string, graphics2D).getWidth();
            double d4 = fontMetrics.getStringBounds(string2, graphics2D).getWidth();
            d2 += Math.max(d3, d4);
        }
        return d2;
    }

    private double b(Graphics2D graphics2D, DateTickUnit dateTickUnit) {
        Insets insets = this.w();
        double d2 = insets.top + insets.bottom;
        Font font = this.s();
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        LineMetrics lineMetrics = font.getLineMetrics("ABCxyz", fontRenderContext);
        if (!this.t()) {
            d2 += (double)lineMetrics.getHeight();
        } else {
            DateRange dateRange = (DateRange)this.n();
            Date date = dateRange.f();
            Date date2 = dateRange.c();
            String string = null;
            String string2 = null;
            DateFormat dateFormat = this.d();
            if (dateFormat != null) {
                string = dateFormat.format(date);
                string2 = dateFormat.format(date2);
            } else {
                string = dateTickUnit.a(date);
                string2 = dateTickUnit.a(date2);
            }
            FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
            double d3 = fontMetrics.getStringBounds(string, graphics2D).getWidth();
            double d4 = fontMetrics.getStringBounds(string2, graphics2D).getWidth();
            d2 += Math.max(d3, d4);
        }
        return d2;
    }

    public List a(Graphics2D graphics2D, AxisState axisState, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge) {
        List list = null;
        if (RectangleEdge.c(rectangleEdge)) {
            list = this.b(graphics2D, axisState.c(), rectangle2D, rectangle2D2, rectangleEdge);
        } else if (RectangleEdge.b(rectangleEdge)) {
            list = this.c(graphics2D, axisState.c(), rectangle2D, rectangle2D2, rectangleEdge);
        }
        return list;
    }

    public List b(Graphics2D graphics2D, double d2, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge) {
        ArrayList<DateTick> arrayList = new ArrayList<DateTick>();
        Font font = this.s();
        graphics2D.setFont(font);
        if (this.i()) {
            this.c(graphics2D, rectangle2D, rectangle2D2, rectangleEdge);
        }
        DateTickUnit dateTickUnit = this.j();
        Date date = this.a(dateTickUnit);
        Date date2 = this.m();
        block5: while (date.before(date2)) {
            if (!this.a(date.getTime())) {
                double d3 = this.a(date, rectangle2D2, rectangleEdge);
                DateFormat dateFormat = this.d();
                String string = dateFormat != null ? dateFormat.format(date) : this.B.a(date);
                float f2 = (float)d3;
                float f3 = 0.0f;
                TextAnchor textAnchor = null;
                TextAnchor textAnchor2 = null;
                double d4 = 0.0;
                Insets insets = this.w();
                if (this.t()) {
                    textAnchor = TextAnchor.f;
                    textAnchor2 = TextAnchor.f;
                    if (rectangleEdge == RectangleEdge.c) {
                        f3 = (float)(d2 - (double)insets.right);
                        d4 = 1.5707963267948966;
                    } else {
                        f3 = (float)(d2 + (double)insets.right);
                        d4 = -1.5707963267948966;
                    }
                } else if (rectangleEdge == RectangleEdge.c) {
                    f3 = (float)(d2 - (double)insets.bottom);
                    textAnchor = TextAnchor.l;
                    textAnchor2 = TextAnchor.l;
                } else {
                    f3 = (float)(d2 + (double)insets.top);
                    textAnchor = TextAnchor.n;
                    textAnchor2 = TextAnchor.n;
                }
                DateTick dateTick = new DateTick(date, string, f2, f3, textAnchor, textAnchor2, d4);
                arrayList.add(dateTick);
                date = dateTickUnit.c(date);
            } else {
                date = dateTickUnit.b(date);
            }
            switch (dateTickUnit.d()) {
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    continue block5;
                }
                case 1: {
                    date = this.a(new Month(date), this.w);
                    continue block5;
                }
                case 0: {
                    date = this.a(new Year(date), this.w);
                    continue block5;
                }
            }
        }
        return arrayList;
    }

    public List c(Graphics2D graphics2D, double d2, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge) {
        ArrayList<DateTick> arrayList = new ArrayList<DateTick>();
        Font font = this.s();
        graphics2D.setFont(font);
        if (this.i()) {
            this.c(graphics2D, rectangle2D, rectangle2D2, rectangleEdge);
        }
        DateTickUnit dateTickUnit = this.j();
        Date date = this.a(dateTickUnit);
        Date date2 = this.m();
        while (date.before(date2)) {
            if (!this.a(date.getTime())) {
                double d3 = this.a(date, rectangle2D2, rectangleEdge);
                String string = this.B.a(date);
                float f2 = 0.0f;
                float f3 = (float)d3;
                TextAnchor textAnchor = null;
                TextAnchor textAnchor2 = null;
                double d4 = 0.0;
                if (this.t()) {
                    textAnchor = TextAnchor.l;
                    textAnchor2 = TextAnchor.l;
                    if (rectangleEdge == RectangleEdge.a) {
                        f2 = (float)(d2 - (double)this.w().bottom);
                        d4 = -1.5707963267948966;
                    } else {
                        f2 = (float)(d2 + (double)this.w().bottom);
                        d4 = 1.5707963267948966;
                    }
                } else if (rectangleEdge == RectangleEdge.a) {
                    f2 = (float)(d2 - (double)this.w().right);
                    textAnchor = TextAnchor.f;
                    textAnchor2 = TextAnchor.f;
                } else {
                    f2 = (float)(d2 + (double)this.w().left);
                    textAnchor = TextAnchor.c;
                    textAnchor2 = TextAnchor.c;
                }
                DateTick dateTick = new DateTick(date, string, f2, f3, textAnchor, textAnchor2, d4);
                arrayList.add(dateTick);
                date = dateTickUnit.c(date);
                continue;
            }
            date = dateTickUnit.b(date);
        }
        return arrayList;
    }

    public AxisState d(Graphics2D graphics2D, double d2, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge) {
        if (!this.y()) {
            AxisState axisState = new AxisState(d2);
            List list = this.a(graphics2D, axisState, rectangle2D, rectangle2D2, rectangleEdge);
            axisState.a(list);
            return axisState;
        }
        AxisState axisState = this.a(graphics2D, d2, rectangle2D, rectangle2D2, rectangleEdge);
        axisState = this.a(this.f(), graphics2D, rectangle2D, rectangle2D2, rectangleEdge, axisState);
        return axisState;
    }

    public Object clone() throws CloneNotSupportedException {
        DateAxis dateAxis = (DateAxis)super.clone();
        if (this.ae != null) {
            dateAxis.ae = (DateFormat)this.ae.clone();
        }
        return dateAxis;
    }

    public static class 1 {
    }

    private static class DefaultTimeline
    implements Timeline,
    Serializable {
        private DefaultTimeline() {
        }

        public long a(long l2) {
            return l2;
        }

        public long a(Date date) {
            return date.getTime();
        }

        public long b(long l2) {
            return l2;
        }

        public boolean c(long l2) {
            return true;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object == this) {
                return true;
            }
            return object instanceof DefaultTimeline;
        }

        public DefaultTimeline(1 var1_1) {
            this();
        }
    }
}

