/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.List;
import javax.swing.event.EventListenerList;
import org.jfree.chart.axis.AxisConstants;
import org.jfree.chart.axis.AxisSpace;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.event.AxisChangeEvent;
import org.jfree.chart.event.AxisChangeListener;
import org.jfree.chart.plot.Plot;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RefineryUtilities;
import org.jfree.ui.TextAnchor;
import org.jfree.util.ObjectUtils;

public abstract class Axis
implements AxisConstants,
Cloneable,
Serializable {
    private boolean ab;
    private String Z;
    private Font a;
    private transient Paint r;
    private Insets u;
    private double G;
    private boolean x;
    private Font I;
    private transient Paint k;
    private Insets v;
    private boolean g;
    private float F;
    private float X;
    private transient Stroke M;
    private transient Paint h;
    private double P;
    private transient Plot s;
    private transient EventListenerList S;
    public static Class t;

    public Axis(String string) {
        this.Z = string;
        this.ab = true;
        this.a = AxisConstants.z;
        this.r = AxisConstants.b;
        this.u = AxisConstants.o;
        this.G = 0.0;
        this.x = true;
        this.I = AxisConstants.W;
        this.k = AxisConstants.U;
        this.v = AxisConstants.l;
        this.g = true;
        this.M = AxisConstants.c;
        this.h = AxisConstants.T;
        this.F = 0.0f;
        this.X = 2.0f;
        this.s = null;
        this.S = new EventListenerList();
    }

    public boolean y() {
        return this.ab;
    }

    public String f() {
        return this.Z;
    }

    public void b(String string) {
        String string2 = this.Z;
        if (string2 != null) {
            if (!string2.equals(string)) {
                this.Z = string;
                this.a(new AxisChangeEvent(this));
            }
        } else if (string != null) {
            this.Z = string;
            this.a(new AxisChangeEvent(this));
        }
    }

    public Font A() {
        return this.a;
    }

    public void b(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Axis.setLabelFont(...): null not permitted.");
        }
        if (!this.a.equals(font)) {
            this.a = font;
            this.a(new AxisChangeEvent(this));
        }
    }

    public Paint L() {
        return this.r;
    }

    public void b(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Axis.setLabelPaint(...): null not permitted.");
        }
        if (!this.r.equals(paint)) {
            this.r = paint;
            this.a(new AxisChangeEvent(this));
        }
    }

    public Insets N() {
        return this.u;
    }

    public void b(Insets insets) {
        if (!insets.equals(this.u)) {
            this.u = insets;
            this.a(new AxisChangeEvent(this));
        }
    }

    public double C() {
        return this.G;
    }

    public boolean v() {
        return this.x;
    }

    public void d(boolean bl2) {
        if (bl2 != this.x) {
            this.x = bl2;
            this.a(new AxisChangeEvent(this));
        }
    }

    public Font s() {
        return this.I;
    }

    public void a(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Axis.setTickLabelFont(...): null not permitted.");
        }
        if (!this.I.equals(font)) {
            this.I = font;
            this.a(new AxisChangeEvent(this));
        }
    }

    public Paint e() {
        return this.k;
    }

    public void a(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Axis.setTickLabelPaint(...): null not permitted.");
        }
        if (!this.k.equals(paint)) {
            this.k = paint;
            this.a(new AxisChangeEvent(this));
        }
    }

    public Insets w() {
        return this.v;
    }

    public void a(Insets insets) {
        if (insets == null) {
            throw new IllegalArgumentException("Axis.setTickLabelInsets(...): null not permitted.");
        }
        if (!this.v.equals(insets)) {
            this.v = insets;
            this.a(new AxisChangeEvent(this));
        }
    }

    public boolean E() {
        return this.g;
    }

    public void a(boolean bl2) {
        if (bl2 != this.g) {
            this.g = bl2;
            this.a(new AxisChangeEvent(this));
        }
    }

    public float b() {
        return this.F;
    }

    public float z() {
        return this.X;
    }

    public Stroke l() {
        return this.M;
    }

    public Paint p() {
        return this.h;
    }

    public Plot o() {
        return this.s;
    }

    public void a(Plot plot) {
        this.s = plot;
        this.G();
    }

    public double g() {
        return this.P;
    }

    public abstract void G();

    public abstract AxisSpace a(Graphics2D var1, Plot var2, Rectangle2D var3, RectangleEdge var4, AxisSpace var5);

    public abstract AxisState d(Graphics2D var1, double var2, Rectangle2D var4, Rectangle2D var5, RectangleEdge var6);

    public abstract List a(Graphics2D var1, AxisState var2, Rectangle2D var3, Rectangle2D var4, RectangleEdge var5);

    public void b(AxisChangeListener axisChangeListener) {
        this.S.add(t == null ? (t = Axis.a("org.jfree.chart.event.AxisChangeListener")) : t, axisChangeListener);
    }

    public void a(AxisChangeListener axisChangeListener) {
        this.S.remove(t == null ? (t = Axis.a("org.jfree.chart.event.AxisChangeListener")) : t, axisChangeListener);
    }

    public void a(AxisChangeEvent axisChangeEvent) {
        Object[] objectArray = this.S.getListenerList();
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != (t == null ? Axis.a("org.jfree.chart.event.AxisChangeListener") : t)) continue;
            ((AxisChangeListener)objectArray[i2 + 1]).a(axisChangeEvent);
        }
    }

    public Rectangle2D a(Graphics2D graphics2D, RectangleEdge rectangleEdge) {
        Rectangle2D rectangle2D = new Rectangle2D.Double();
        String string = this.f();
        if (string != null) {
            FontMetrics fontMetrics = graphics2D.getFontMetrics(this.A());
            Rectangle2D rectangle2D2 = fontMetrics.getStringBounds(string, graphics2D);
            Insets insets = this.N();
            rectangle2D2.setRect(rectangle2D2.getX(), rectangle2D2.getY(), rectangle2D2.getWidth() + (double)insets.left + (double)insets.right, rectangle2D2.getHeight() + (double)insets.top + (double)insets.bottom);
            double d2 = this.C();
            if (rectangleEdge == RectangleEdge.a || rectangleEdge == RectangleEdge.b) {
                d2 -= 1.5707963267948966;
            }
            double d3 = rectangle2D2.getCenterX();
            double d4 = rectangle2D2.getCenterY();
            AffineTransform affineTransform = AffineTransform.getRotateInstance(d2, d3, d4);
            Shape shape = affineTransform.createTransformedShape(rectangle2D2);
            rectangle2D = shape.getBounds2D();
        }
        return rectangle2D;
    }

    public AxisState a(String string, Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge, AxisState axisState) {
        if (axisState == null) {
            throw new IllegalArgumentException("Axis.drawLabel: null state not permitted.");
        }
        if (string == null || string.equals("")) {
            return axisState;
        }
        Font font = this.A();
        Insets insets = this.N();
        graphics2D.setFont(font);
        graphics2D.setPaint(this.L());
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        Rectangle2D rectangle2D3 = fontMetrics.getStringBounds(string, graphics2D);
        if (rectangleEdge == RectangleEdge.c) {
            AffineTransform affineTransform = AffineTransform.getRotateInstance(this.C(), rectangle2D3.getCenterX(), rectangle2D3.getCenterY());
            Shape shape = affineTransform.createTransformedShape(rectangle2D3);
            rectangle2D3 = shape.getBounds2D();
            double d2 = rectangle2D2.getCenterX();
            double d3 = axisState.c() - (double)insets.bottom - rectangle2D3.getHeight() / 2.0;
            RefineryUtilities.b(string, graphics2D, (float)d2, (float)d3, TextAnchor.m, TextAnchor.m, this.C());
            axisState.d((double)insets.top + rectangle2D3.getHeight() + (double)insets.bottom);
        } else if (rectangleEdge == RectangleEdge.e) {
            AffineTransform affineTransform = AffineTransform.getRotateInstance(this.C(), rectangle2D3.getCenterX(), rectangle2D3.getCenterY());
            Shape shape = affineTransform.createTransformedShape(rectangle2D3);
            rectangle2D3 = shape.getBounds2D();
            double d4 = rectangle2D2.getCenterX();
            double d5 = axisState.c() + (double)insets.top + rectangle2D3.getHeight() / 2.0;
            RefineryUtilities.b(string, graphics2D, (float)d4, (float)d5, TextAnchor.m, TextAnchor.m, this.C());
            axisState.c((double)insets.top + rectangle2D3.getHeight() + (double)insets.bottom);
        } else if (rectangleEdge == RectangleEdge.a) {
            AffineTransform affineTransform = AffineTransform.getRotateInstance(this.C() - 1.5707963267948966, rectangle2D3.getCenterX(), rectangle2D3.getCenterY());
            Shape shape = affineTransform.createTransformedShape(rectangle2D3);
            rectangle2D3 = shape.getBounds2D();
            double d6 = axisState.c() - (double)insets.right - rectangle2D3.getWidth() / 2.0;
            double d7 = rectangle2D2.getY() + rectangle2D2.getHeight() / 2.0;
            RefineryUtilities.b(string, graphics2D, (float)d6, (float)d7, TextAnchor.m, TextAnchor.m, this.C() - 1.5707963267948966);
            axisState.e((double)insets.left + rectangle2D3.getWidth() + (double)insets.right);
        } else if (rectangleEdge == RectangleEdge.b) {
            AffineTransform affineTransform = AffineTransform.getRotateInstance(this.C() + 1.5707963267948966, rectangle2D3.getCenterX(), rectangle2D3.getCenterY());
            Shape shape = affineTransform.createTransformedShape(rectangle2D3);
            rectangle2D3 = shape.getBounds2D();
            double d8 = axisState.c() + (double)insets.left + rectangle2D3.getWidth() / 2.0;
            double d9 = rectangle2D2.getY() + rectangle2D2.getHeight() / 2.0;
            RefineryUtilities.b(string, graphics2D, (float)d8, (float)d9, TextAnchor.m, TextAnchor.m, this.C() + 1.5707963267948966);
            axisState.b((double)insets.left + rectangle2D3.getWidth() + (double)insets.right);
        }
        return axisState;
    }

    public Object clone() throws CloneNotSupportedException {
        Axis axis = (Axis)super.clone();
        if (this.u != null) {
            axis.u = (Insets)this.u.clone();
        }
        if (this.v != null) {
            axis.v = (Insets)this.v.clone();
        }
        axis.s = null;
        axis.S = new EventListenerList();
        return axis;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof Axis) {
            Axis axis = (Axis)object;
            boolean bl2 = this.ab == axis.ab;
            boolean bl3 = ObjectUtils.a(this.Z, axis.Z);
            boolean bl4 = ObjectUtils.a(this.a, axis.a);
            boolean bl5 = ObjectUtils.a(this.r, axis.r);
            boolean bl6 = ObjectUtils.a(this.u, axis.u);
            boolean bl7 = Math.abs(this.G - axis.G) < 1.0E-7;
            boolean bl8 = this.x == axis.x;
            boolean bl9 = ObjectUtils.a(this.I, axis.I);
            boolean bl10 = ObjectUtils.a(this.k, axis.k);
            boolean bl11 = ObjectUtils.a(this.v, axis.v);
            boolean bl12 = this.g == axis.g;
            boolean bl13 = (double)Math.abs(this.F - axis.F) < 1.0E-6;
            boolean bl14 = (double)Math.abs(this.X - axis.X) < 1.0E-6;
            boolean bl15 = ObjectUtils.a(this.h, axis.h);
            boolean bl16 = ObjectUtils.a(this.M, axis.M);
            boolean bl17 = Math.abs(this.P - axis.P) < 1.0E-6;
            return bl2 && bl3 && bl4 && bl5 && bl6 && bl8 && bl9 && bl10 && bl11 && bl12 && bl13 && bl14 && bl15 && bl16 && bl17 && bl7;
        }
        return false;
    }

    public static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

