/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.AbstractTitle;
import org.jfree.chart.Spacer;
import org.jfree.util.ObjectUtils;

public class TextTitle
extends AbstractTitle
implements Serializable,
Cloneable {
    public static final Font h = new Font("SansSerif", 1, 12);
    public static final Paint c = Color.black;
    private String g;
    private Font f;
    private transient Paint m;
    private transient Paint k;

    public TextTitle(String string, Font font) {
        this(string, font, c, 0, 4, 4, AbstractTitle.i);
    }

    public TextTitle(String string, Font font, Paint paint, int n2, int n3, int n4, Spacer spacer) {
        super(n2, n3, n4, spacer);
        if (string == null) {
            throw new NullPointerException("TextTitle(..): Text is null");
        }
        if (font == null) {
            throw new NullPointerException("TextTitle(..): Font is null");
        }
        if (paint == null) {
            throw new NullPointerException("TextTitle(..): Paint is null");
        }
        this.g = string;
        this.f = font;
        this.m = paint;
        this.k = null;
    }

    public boolean c(int n2) {
        return n2 == 0 || n2 == 1;
    }

    public double b(Graphics2D graphics2D) {
        graphics2D.setFont(this.f);
        FontMetrics fontMetrics = graphics2D.getFontMetrics(this.f);
        Rectangle2D rectangle2D = fontMetrics.getStringBounds(this.g, graphics2D);
        double d2 = rectangle2D.getWidth();
        Spacer spacer = this.a();
        if (spacer != null) {
            d2 = spacer.c(d2);
        }
        return d2;
    }

    public double a(Graphics2D graphics2D) {
        double d2 = 0.0;
        graphics2D.setFont(this.f);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        LineMetrics lineMetrics = this.f.getLineMetrics(this.g, fontRenderContext);
        d2 = lineMetrics.getHeight();
        Spacer spacer = this.a();
        if (spacer != null) {
            d2 = spacer.d(d2);
        }
        return d2;
    }

    public void b(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        this.a(graphics2D, rectangle2D);
    }

    public void a(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        if (this.g.equals("")) {
            return;
        }
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        FontMetrics fontMetrics = graphics2D.getFontMetrics(this.f);
        Rectangle2D rectangle2D2 = fontMetrics.getStringBounds(this.g, graphics2D);
        LineMetrics lineMetrics = this.f.getLineMetrics(this.g, fontRenderContext);
        double d2 = rectangle2D2.getWidth();
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = lineMetrics.getHeight();
        double d6 = 0.0;
        double d7 = 0.0;
        Spacer spacer = this.a();
        d3 = spacer.b(rectangle2D.getWidth());
        d4 = spacer.e(rectangle2D.getWidth());
        d6 = spacer.f(d5);
        d7 = spacer.a(d5);
        double d8 = rectangle2D.getY() + d6;
        int n2 = this.b();
        if (n2 == 0) {
            d8 = d8 + d5 - (double)lineMetrics.getLeading() - (double)lineMetrics.getDescent();
        } else if (n2 == 4) {
            double d9 = rectangle2D.getHeight() - d6 - d7 - d5;
            d8 = d8 + d9 / 2.0 + d5 - (double)lineMetrics.getLeading() - (double)lineMetrics.getDescent();
        } else if (n2 == 1) {
            d8 = rectangle2D.getMaxY() - d7 - (double)lineMetrics.getLeading() - (double)lineMetrics.getDescent();
        }
        int n3 = this.c();
        double d10 = rectangle2D.getX() + d3;
        if (n3 == 4) {
            d10 = d10 + (rectangle2D.getWidth() - d3 - d4) / 2.0 - d2 / 2.0;
        } else if (n3 == 3) {
            d10 = rectangle2D.getX() + d3;
        } else if (n3 == 2) {
            d10 = rectangle2D.getMaxX() - d4 - d2;
        }
        if (this.k != null) {
            graphics2D.setPaint(this.k);
            graphics2D.fill(rectangle2D);
        }
        graphics2D.setFont(this.f);
        graphics2D.setPaint(this.m);
        graphics2D.drawString(this.g, (float)d10, (float)d8);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof TextTitle) {
            TextTitle textTitle = (TextTitle)object;
            if (super.equals(object)) {
                if (!ObjectUtils.a(this.g, textTitle.g)) {
                    return false;
                }
                if (!ObjectUtils.a(this.f, textTitle.f)) {
                    return false;
                }
                return ObjectUtils.a(this.m, textTitle.m);
            }
        }
        return false;
    }
}

