/*
 * Decompiled with CFR 0.152.
 */
package djr.motif.sh3;

import djr.motif.model.AlignmentMotifModel;
import djr.motif.model.MixtureMotifModel;
import djr.motif.model.PSSMMotifModel;
import djr.motif.sampler.SiteSampler;
import djr.motif.sampler.sites.Sites;
import djr.util.ArgProcessor;
import djr.util.MyUtils;
import djr.util.array.IntVector;
import djr.util.array.ObjVector;
import djr.util.bio.Sequence;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class NetSiteSampler
extends SiteSampler {
    public Map G;
    public Map aa;
    public transient Map l;
    public transient Map ar;
    public ObjVector aG;
    public int j;
    public int at;
    public int[][] b;
    public int[][] e;
    public int[][] m;
    public int[][] g;
    public double p = 0.0;
    public double F = 0.0;
    public double k = 0.5;
    public double r = 0.1;
    public transient double[][][] ab;
    public transient double[][][] am;
    public transient kR A = null;

    public NetSiteSampler() {
    }

    public NetSiteSampler(String[] stringArray) {
        this.a(stringArray);
    }

    public NetSiteSampler(String string) {
        this(MyUtils.c(string, " "));
    }

    public boolean a(String[] stringArray) {
        Sequence[] sequenceArray;
        this.aq = new ArgProcessor();
        if (!this.aq.a(this, stringArray)) {
            MyUtils.a(0);
        }
        this.aG = this.a(this.aq.g("sh3"));
        String string = "sequences/yeast_culled_nosh3.fst.gz";
        try {
            sequenceArray = Sequence.a(this.aq.b("bgf", string));
        }
        catch (Exception exception) {
            sequenceArray = null;
            System.err.println(string + ":");
            exception.printStackTrace();
        }
        String string2 = this.aq.b("non", null);
        if (!MyUtils.c(string2) && !string.equals(string2)) {
            int n2;
            ObjVector objVector = new ObjVector();
            int n3 = sequenceArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                sequenceArray[n2].d(Sequence.e(sequenceArray[n2].d()).toUpperCase());
                boolean bl2 = false;
                int n4 = this.ai.length;
                for (int i2 = 0; i2 < n4; ++i2) {
                    if (!this.a(this.ai[i2], sequenceArray[n2])) continue;
                    bl2 = true;
                    break;
                }
                if (bl2) continue;
                objVector.a(sequenceArray[n2]);
            }
            sequenceArray = new Sequence[objVector.b()];
            n3 = objVector.b();
            for (n2 = 0; n2 < n3; ++n2) {
                sequenceArray[n2] = (Sequence)objVector.c(n2);
            }
            objVector = null;
            Sequence.a(string, sequenceArray);
            this.aq.a("bgf", (Object)string);
        }
        this.aR = super.a(stringArray);
        if (!this.aR) {
            return false;
        }
        this.aR = false;
        int n5 = 0;
        if (!this.ah) {
            this.l = Sequence.a(this.ai);
            Map map = this.a(this.aq.g("sif"), true);
            this.G = this.a(map);
            this.aa = this.f(this.G);
            this.j = this.G.size();
            this.at = this.aa.size();
            this.L = new String[this.j];
            Iterator iterator = this.G.keySet().iterator();
            while (iterator.hasNext()) {
                this.L[n5++] = (String)iterator.next();
            }
            this.t();
            this.a();
            if (this.aS) {
                this.a((Object)("A total of " + this.j + " SH3 proteins; " + this.at + " interactors; " + lg.e(this.b) + " interactions."));
                double d2 = 0.0;
                for (n5 = 0; n5 < this.at; ++n5) {
                    if (this.m[n5] == null) continue;
                    d2 += (double)this.m[n5].length;
                }
                this.a("An average of %.2f SH3 partners per interactor; ", d2 / (double)this.at);
                d2 = 0.0;
                for (n5 = 0; n5 < this.j; ++n5) {
                    if (this.b[n5] == null) continue;
                    d2 += (double)this.b[n5].length;
                }
                this.a("%.2f interactors per SH3 protein.\n", d2 / (double)this.j);
            }
        }
        Iterator iterator = this.G.keySet().iterator();
        n5 = 0;
        while (iterator.hasNext()) {
            this.L[n5++] = (String)iterator.next();
        }
        this.aw = this.j;
        double d3 = this.aq.k("P2");
        Sites sites = new Sites(this.ai, this.v, this.aw, this.N, this.aj);
        this.C = new MixtureMotifModel(this.aw, sites, this.v, this.b, this.m, d3);
        this.C.a(this.aQ, this.O, this.T, this.as, this.R, this.aO);
        this.k = this.aq.k("PD");
        this.aR = true;
        return this.aR;
    }

    public boolean a(Sequence sequence, Sequence sequence2) {
        return sequence.d().equals(sequence2.d()) || sequence.a(sequence2);
    }

    public boolean f() {
        return this.k > 0.0 && (this.au > this.aL * 3 / 4 || this.Y > 0);
    }

    public void a(int n2) {
        int n3 = n2 == -1 ? this.aJ : n2;
        MixtureMotifModel mixtureMotifModel = (MixtureMotifModel)this.C;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4;
            int n5 = n2 == -1 ? i2 : lg.d(0, this.aJ - 1);
            mixtureMotifModel.a(false, n5);
            int n6 = this.a(n5, this.aF, true);
            if (!this.u && (n4 = cr.b(this.aF, this.az[n5] - this.v + 1)) != -1) {
                n6 = n4;
            }
            if (n6 != -1) {
                this.w().g(n5);
                this.w().a(n5, n6, 0, true);
            }
            mixtureMotifModel.a(true, n5);
        }
    }

    public int a(int n2, double[] dArray, boolean bl2) {
        MixtureMotifModel mixtureMotifModel = (MixtureMotifModel)this.C;
        int n3 = mixtureMotifModel.a(n2, dArray, bl2);
        if (this.aA != 1.0) {
            cr.f(dArray, this.aA);
        }
        if (this.f()) {
            n3 = this.a(dArray, n2, bl2, n3);
        }
        return n3;
    }

    public void j() {
        if (this.f() && this.ab == null) {
            this.ab = new double[this.aJ][2][];
            for (int i2 = 0; i2 < this.aJ; ++i2) {
                this.ab[i2][0] = cr.a(this.m[i2].length);
                this.ab[i2][1] = cr.a(this.g[i2].length);
            }
            this.am = cr.a(this.aw, this.v, (int)this.Q);
            this.A = new kR();
        }
    }

    public int a(double[] dArray, int n2, boolean bl2, int n3) {
        int n4;
        this.j();
        for (int i2 = 0; i2 < this.j; ++i2) {
            this.C.b(this.C.e(i2), this.am[i2]);
        }
        double[][] dArray2 = this.ab[n2];
        int[] nArray = this.m[n2];
        int[] nArray2 = this.g[n2];
        int n5 = this.az[n2] - this.v + 1;
        double d2 = dArray[n3];
        double d3 = d2 * this.r;
        double d4 = -1.7976931348623157E308;
        int n6 = -1;
        short[] sArray = this.w().c(n2);
        for (n4 = 0; n4 < n5; ++n4) {
            if (dArray[n4] >= d3) {
                double d5 = this.a(sArray, n4, nArray, nArray2, dArray2);
                int n7 = n4;
                dArray[n7] = dArray[n7] * d5;
            }
            if (!bl2 || !(dArray[n4] > d4)) continue;
            d4 = dArray[n4];
            n6 = n4;
        }
        if (bl2) {
            n4 = 0;
            while (n4 < n5) {
                int n8 = n4++;
                dArray[n8] = dArray[n8] / d4;
            }
        }
        return n6;
    }

    public double a(short[] sArray, int n2, int[] nArray, int[] nArray2, double[][] dArray) {
        int n3;
        double d2 = 1.0;
        int n4 = dArray[0].length;
        for (n3 = 0; n3 < n4; ++n3) {
            dArray[0][n3] = cr.c(this.C.a(sArray, n2, this.am[nArray[n3]]));
        }
        n4 = dArray[1].length;
        for (n3 = 0; n3 < n4; ++n3) {
            dArray[1][n3] = cr.c(this.C.a(sArray, n2, this.am[nArray2[n3]]));
        }
        try {
            this.A.a(dArray[1], dArray[0]);
            d2 = (this.A.a() > 0.0 ? 1.0 - this.A.b() : 0.0) + this.k;
        }
        catch (Exception exception) {
            d2 = 1.0;
            exception.printStackTrace();
        }
        return d2;
    }

    public double e(Map map) {
        double d2;
        if (map == null) {
            map = this.ao;
        }
        this.p = d2 = super.e(map);
        if (this.f()) {
            int n2;
            this.j();
            this.F = 0.0;
            AlignmentMotifModel alignmentMotifModel = (AlignmentMotifModel)map.get("mm");
            Sites sites = alignmentMotifModel.d();
            for (n2 = 0; n2 < this.j; ++n2) {
                alignmentMotifModel.b(alignmentMotifModel.e(n2), this.am[n2]);
            }
            for (n2 = 0; n2 < this.j; ++n2) {
                int[] nArray = this.b[n2];
                int n3 = nArray.length;
                if (n3 <= 0) continue;
                for (int i2 = 0; i2 < n3; ++i2) {
                    int n4 = nArray[i2];
                    double[][] dArray = this.ab[n4];
                    int[] nArray2 = this.m[n4];
                    int[] nArray3 = this.g[n4];
                    short[] sArray = sites.c(n4);
                    ObjVector objVector = new ObjVector();
                    sites.a(n4, n2, objVector);
                    if (objVector.b() <= 0) continue;
                    int n5 = ((int[])objVector.c(0))[1];
                    double d3 = this.a(sArray, n5, nArray2, nArray3, dArray);
                    d2 += cr.d(d3);
                    this.F += cr.d(d3);
                }
            }
        }
        return d2;
    }

    public int[][][] k() {
        int[][][] nArrayArray = new int[this.aw][][];
        for (int i2 = 0; i2 < this.aw; ++i2) {
            int n2;
            ObjVector objVector = new ObjVector(10, 10);
            for (n2 = 0; n2 < this.aJ; ++n2) {
                int[] nArray = this.m[n2];
                if (nArray == null || !lg.b(nArray, i2)) continue;
                this.w().a(n2, objVector);
            }
            nArrayArray[i2] = new int[objVector.b()][];
            for (n2 = 0; n2 < objVector.b(); ++n2) {
                nArrayArray[i2][n2] = (int[])objVector.c(n2);
            }
        }
        return nArrayArray;
    }

    public void a() {
        this.m = new int[this.aJ][];
        this.g = new int[this.aJ][];
        for (int i2 = 0; i2 < this.aJ; ++i2) {
            IntVector intVector = new IntVector();
            IntVector intVector2 = new IntVector();
            for (int i3 = 0; i3 < this.j; ++i3) {
                int[] nArray = this.b[i3];
                boolean bl2 = false;
                int n2 = nArray.length;
                for (int i4 = 0; i4 < n2; ++i4) {
                    if (nArray[i4] != i2) continue;
                    intVector.a(i3);
                    bl2 = true;
                }
                if (bl2) continue;
                intVector2.a(i3);
            }
            this.m[i2] = intVector.c();
            this.g[i2] = intVector2.c();
        }
    }

    public void t() {
        this.b = new int[this.j][];
        this.e = new int[this.j][];
        for (int i2 = 0; i2 < this.j; ++i2) {
            int n2;
            ObjVector objVector = (ObjVector)this.G.get(this.L[i2]);
            IntVector intVector = new IntVector();
            IntVector intVector2 = new IntVector();
            int n3 = objVector.b();
            block1: for (n2 = 0; n2 < n3; ++n2) {
                String string = (String)objVector.c(n2);
                for (int i3 = 0; i3 < this.aJ; ++i3) {
                    if (!string.equals(this.ai[i3].d().toUpperCase())) continue;
                    intVector.a(i3);
                    continue block1;
                }
            }
            this.b[i2] = intVector.c();
            for (n2 = 0; n2 < this.aJ; ++n2) {
                if (lg.b(this.b[i2], n2)) continue;
                intVector2.a(n2);
            }
            this.e[i2] = intVector2.c();
        }
    }

    public Map f(Map map) {
        HashMap<String, ObjVector> hashMap = new HashMap<String, ObjVector>();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            ObjVector objVector = (ObjVector)map.get(string);
            int n2 = objVector.b();
            for (int i2 = 0; i2 < n2; ++i2) {
                String string2 = (String)objVector.c(i2);
                ObjVector objVector2 = (ObjVector)hashMap.get(string2);
                if (objVector2 == null) {
                    objVector2 = new ObjVector();
                }
                if (!objVector2.d(string)) {
                    objVector2.a(string);
                }
                hashMap.put(string2, objVector2);
            }
        }
        return hashMap;
    }

    public ObjVector a(String string) {
        ObjVector objVector = new ObjVector();
        try {
            Enumeration enumeration = MyUtils.a(string).c();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                String[] stringArray = MyUtils.c(string2, " ");
                stringArray[0] = NetSiteSampler.f(stringArray[0]);
                if (!"true".equals(stringArray[1])) continue;
                objVector.a(stringArray[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return objVector;
    }

    public Map a(Map map) {
        HashMap<String, ObjVector> hashMap = new HashMap<String, ObjVector>();
        try {
            int n2 = this.aG.b();
            for (int i2 = 0; i2 < n2; ++i2) {
                String string = NetSiteSampler.f((String)this.aG.c(i2));
                ObjVector objVector = (ObjVector)map.get(string);
                if (objVector != null) {
                    hashMap.put(string, objVector);
                    continue;
                }
                System.err.println("SH3 protein " + string + " doesn't have any interactors.");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hashMap;
    }

    public Map a(String string, boolean bl2) {
        HashMap<String, ObjVector> hashMap = new HashMap<String, ObjVector>();
        try {
            Object object;
            int n2;
            ObjVector objVector = MyUtils.a(string);
            Enumeration enumeration = objVector.c();
            int[] nArray = null;
            if (this.aq.h("cull-ints") > 0) {
                if (this.ar == null) {
                    this.ar = new HashMap();
                }
                n2 = objVector.b();
                object = lo.a(n2);
                int n3 = this.aq.h("cull-ints");
                nArray = lg.a(n3);
                for (int i2 = 0; i2 < n3; ++i2) {
                    int n4 = -1;
                    while (n4 == -1 || object[n4]) {
                        n4 = lg.b(n2);
                    }
                    nArray[i2] = n4;
                }
            }
            n2 = -1;
            while (enumeration.hasMoreElements()) {
                ++n2;
                object = (String)enumeration.nextElement();
                String[] stringArray = MyUtils.c((String)object, " ");
                String string2 = stringArray[0].toUpperCase();
                String string3 = stringArray[2].toUpperCase();
                string2 = NetSiteSampler.f(string2);
                string2 = string2.toUpperCase();
                string3 = NetSiteSampler.f(string3);
                string3 = string3.toUpperCase();
                if (nArray != null && lg.b(nArray, n2)) {
                    if (this.D) {
                        this.a((Object)("Culling interaction " + string2 + " -> " + string3 + " from the dataset."));
                    }
                    this.ar.put(string2, string3);
                    continue;
                }
                if (this.ac != null && (this.ac.containsKey(string2) || this.ac.containsKey(string3))) {
                    if (this.ar == null) {
                        this.ar = new HashMap();
                    }
                    this.ar.put(string2, string3);
                    continue;
                }
                if (!this.l.containsKey(string2)) {
                    System.err.println("WARNING: no sequence for protein " + string2 + ". Skipping.");
                    if (this.l.containsKey(string3)) continue;
                    System.err.println("WARNING: no sequence for protein " + string3 + ". Skipping.");
                    continue;
                }
                if (!this.l.containsKey(string3)) {
                    System.err.println("WARNING: no sequence for protein " + string3 + ". Skipping.");
                    continue;
                }
                ObjVector objVector2 = (ObjVector)hashMap.get(string2);
                if (objVector2 == null) {
                    objVector2 = new ObjVector();
                }
                if (!objVector2.d(string3)) {
                    objVector2.a(string3);
                }
                hashMap.put(string2, objVector2);
                if (!bl2) continue;
                ObjVector objVector3 = (ObjVector)hashMap.get(string3);
                if (objVector3 == null) {
                    objVector3 = new ObjVector();
                }
                if (!objVector3.d(string2)) {
                    objVector3.a(string2);
                }
                hashMap.put(string3, objVector3);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return hashMap;
    }

    public void a(Sequence[] sequenceArray, String string) {
        int n2;
        int n3;
        int n4;
        Object[] objectArray = MyUtils.c(string, ", ");
        if (objectArray.length <= 1) {
            return;
        }
        boolean bl2 = true;
        int n5 = 1;
        try {
            n5 = Integer.parseInt(objectArray[0]);
        }
        catch (Exception exception) {
            n5 = 1;
            bl2 = false;
        }
        if (bl2) {
            string = MyUtils.a(objectArray, ",", 1, objectArray.length - 1);
            objectArray = MyUtils.c(string, ", ");
        }
        int n6 = this.aq.a("spec", 10);
        PSSMMotifModel pSSMMotifModel = PSSMMotifModel.a(string, n6);
        double[][] dArray = cr.a(objectArray.length, objectArray.length);
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            for (int i3 = i2 + 1; i3 < objectArray.length; ++i3) {
                double d2 = pSSMMotifModel.b(i2, i3);
                double d3 = d2 * d2 * d2;
                dArray[i3][i2] = d3;
                dArray[i2][i3] = d3;
            }
            cr.g(dArray);
        }
        String string2 = this.aq.g("saveseqs");
        if (MyUtils.c(string2)) {
            return;
        }
        String string3 = string2;
        int n7 = string3.lastIndexOf(".");
        if (n7 > 0) {
            string3 = string3.substring(0, n7);
        }
        String[] stringArray = new String[objectArray.length];
        ObjVector[] objVectorArray = new ObjVector[objectArray.length];
        boolean[] blArray = lo.a(sequenceArray.length);
        for (int i4 = 0; i4 < objectArray.length; ++i4) {
            n4 = -1;
            while (n4 < 0 || blArray[n4]) {
                n4 = lg.d(0, this.ai.length - 1);
            }
            blArray[n4] = true;
            stringArray[i4] = this.ai[n4].d();
            objVectorArray[i4] = new ObjVector();
        }
        PrintStream printStream = null;
        try {
            printStream = new PrintStream(new FileOutputStream(string3 + ".info"));
            printStream.println("SIMILARITY SCORES:\n");
            for (n4 = 0; n4 < objectArray.length; ++n4) {
                for (n3 = n4 + 1; n3 < objectArray.length; ++n3) {
                    printStream.println(MyUtils.a("%16s ", (String)objectArray[n4]) + MyUtils.a("%16s  ", (String)objectArray[n3]) + MyUtils.a("%4s ", stringArray[n4]) + MyUtils.a("%4s ", stringArray[n3]) + cr.a("%.3f ", dArray[n4][n3]) + cr.a("%.3f", 0.1 / dArray[n4][n3]));
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        double[] dArray2 = cr.a(objectArray.length + 1);
        for (n3 = 1; n3 <= objectArray.length; ++n3) {
            dArray2[n3] = Math.pow(n3, -2.0);
        }
        n3 = 1;
        double[] dArray3 = cr.a(objectArray.length);
        double[] dArray4 = cr.a(objectArray.length);
        cr.a(dArray3);
        cr.g(dArray3);
        ObjVector objVector = new ObjVector();
        boolean[] blArray2 = lo.a(objectArray.length);
        int n8 = sequenceArray.length;
        for (n2 = 0; n2 < n8; ++n2) {
            int n9;
            Sequence sequence = sequenceArray[n2];
            String string4 = sequence.a();
            int n10 = sequence.l();
            String string5 = sequence.d();
            boolean[] blArray3 = lo.a(n10);
            int n11 = 0;
            int n12 = -1;
            while (n11 == 0) {
                n11 = cr.c(dArray2);
            }
            lo.a((Object)blArray2);
            IntVector intVector = null;
            if (n3 != 0) {
                intVector = new IntVector();
            }
            for (int i5 = 0; i5 < n11; ++i5) {
                int n13 = -1;
                n9 = -1;
                int n14 = 0;
                cr.c((Object)dArray4, dArray3);
                if (n12 >= 0) {
                    cr.a((Object)dArray4, dArray[n12]);
                    cr.g(dArray4);
                }
                while (n14++ < 1000 && n13 < 0 || blArray2[n13] || blArray[n2] && string5.equals(stringArray[n13])) {
                    n13 = cr.c(dArray3);
                }
                if (n14 >= 1000) continue;
                blArray2[n13] = true;
                n12 = n13;
                if (n3 != 0) {
                    intVector.c(n13);
                    continue;
                }
                short[] sArray = pSSMMotifModel.b(n13);
                while (n9 < 0 || blArray3[n9]) {
                    n9 = lg.d(0, n10 - sArray.length);
                }
                for (int i6 = n9 - ((String)objectArray[n13]).length(); i6 < n9 + ((String)objectArray[n13]).length(); ++i6) {
                    if (i6 < 0 || i6 >= blArray3.length) continue;
                    blArray3[i6] = true;
                }
                Sequence sequence2 = new Sequence(sArray);
                sequence.a(sequence2, n9);
                objVectorArray[n13].a(string5);
                objVector.c(string5 + " " + n9 + " " + sequence2.a() + "\t" + stringArray[n13] + " " + (String)objectArray[n13]);
            }
            if (n3 == 0) continue;
            int[] nArray = intVector.c();
            short[] sArray = pSSMMotifModel.a(nArray);
            n9 = -1;
            while (n9 < 0 || blArray3[n9]) {
                n9 = lg.d(0, n10 - sArray.length);
            }
            blArray3[n9] = true;
            Sequence sequence3 = new Sequence(sArray);
            sequence.a(sequence3, n9);
            for (int i7 = 0; i7 < nArray.length; ++i7) {
                int n15 = nArray[i7];
                objVectorArray[n15].a(string5);
                objVector.c(string5 + " " + n9 + " " + sequence3.a() + "\t" + stringArray[n15] + " " + (String)objectArray[n15]);
            }
        }
        try {
            printStream.println("\nSH3s and their motifs:");
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                printStream.println(stringArray[n2] + " " + (String)objectArray[n2] + cr.a(" %.3f ", dArray3[n2]));
            }
            printStream.println("\nSequences and the inserted peptides:");
            for (n2 = 0; n2 < objVector.b(); ++n2) {
                printStream.println(objVector.a(n2));
            }
            PrintStream printStream2 = new PrintStream(new FileOutputStream(string3 + ".isSH3Protein"));
            for (n8 = 0; n8 < objectArray.length; ++n8) {
                printStream2.println(stringArray[n8] + " true");
            }
            printStream2 = new PrintStream(new FileOutputStream(string3 + ".sif"));
            for (n8 = 0; n8 < objectArray.length; ++n8) {
                int n16 = objVectorArray[n8].b();
                for (int i8 = 0; i8 < n16; ++i8) {
                    printStream2.println(stringArray[n8] + " pp " + objVectorArray[n8].c(i8));
                }
            }
            printStream2 = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String f(String string) {
        if ("YHR114W".equals(string)) {
            return "BZZ1";
        }
        if ("YSC84".equals(string)) {
            return "YHR016C";
        }
        if ("YBR098W".equals(string)) {
            return "MMS4";
        }
        return string;
    }

    public void a(ArgProcessor argProcessor) {
        super.a(argProcessor);
        argProcessor.a("NetSiteSampler Parameters");
        argProcessor.a("sif", "<fname>", "", "SIF containing interactions");
        argProcessor.a("sh3", "<fname>", "", "file with list of interaction domain nodes");
        argProcessor.a("non", "<fname>", "", "FASTA with non-interacting sequences");
        argProcessor.a("spec", "<int>", "10", "specificity for simulated motifs");
        argProcessor.a("P2", "<frange:0:100>", "0.5", "supermodel pseudocount fraction");
        argProcessor.a("PD", "<frange:0:100>", "0.5", "discrimination pseudofrequency");
    }
}

