/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.vizmap;

import cytoscape.util.Misc;
import cytoscape.vizmap.AttributeMapper;
import cytoscape.vizmap.AttributeMapperCategories;
import cytoscape.vizmap.FlatInterpolator;
import cytoscape.vizmap.Interpolator;
import cytoscape.vizmap.LinearNumberToColorInterpolator;
import cytoscape.vizmap.LinearNumberToNumberInterpolator;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;

public class VizMapperCategories
implements AttributeMapperCategories {
    public static final Integer l = new Integer(0);
    public static final Integer k = new Integer(1);
    public static final Integer e = new Integer(2);
    public static final Integer b = new Integer(3);
    public static final Integer j = new Integer(4);
    public static final Integer c = new Integer(5);
    public static final Integer g = new Integer(6);
    public static final Integer i = new Integer(10);
    public static final Integer d = new Integer(11);
    public static final Integer a = new Integer(12);
    public static final Integer h = new Integer(13);
    public static final Integer f = new Integer(14);

    public Color getNodeFillColor(Map map, AttributeMapper attributeMapper) {
        return (Color)this.getRangeValue(map, attributeMapper, l);
    }

    public Color getNodeBorderColor(Map map, AttributeMapper attributeMapper) {
        return (Color)this.getRangeValue(map, attributeMapper, k);
    }

    public Color getNodeSelectedColor(AttributeMapper attributeMapper) {
        return (Color)attributeMapper.getDefaultValue(g);
    }

    public eS getNodeBorderLineType(Map map, AttributeMapper attributeMapper) {
        return (eS)this.getRangeValue(map, attributeMapper, e);
    }

    public double getNodeHeight(Map map, AttributeMapper attributeMapper) {
        Double d2 = (Double)this.getRangeValue(map, attributeMapper, b);
        if (d2 == null) {
            return 0.0;
        }
        return d2;
    }

    public double getNodeWidth(Map map, AttributeMapper attributeMapper) {
        Double d2 = (Double)this.getRangeValue(map, attributeMapper, j);
        if (d2 == null) {
            return 0.0;
        }
        return d2;
    }

    public byte getNodeShape(Map map, AttributeMapper attributeMapper) {
        Byte by2 = (Byte)this.getRangeValue(map, attributeMapper, c);
        if (by2 == null) {
            return 0;
        }
        return by2;
    }

    public Color getEdgeColor(Map map, AttributeMapper attributeMapper) {
        return (Color)this.getRangeValue(map, attributeMapper, i);
    }

    public Color getBGColor(AttributeMapper attributeMapper) {
        return (Color)attributeMapper.getDefaultValue(f);
    }

    public eS getEdgeLineType(Map map, AttributeMapper attributeMapper) {
        return (eS)this.getRangeValue(map, attributeMapper, d);
    }

    public nh getEdgeSourceDecoration(Map map, AttributeMapper attributeMapper) {
        return (nh)this.getRangeValue(map, attributeMapper, a);
    }

    public nh getEdgeTargetDecoration(Map map, AttributeMapper attributeMapper) {
        return (nh)this.getRangeValue(map, attributeMapper, h);
    }

    public Object getRangeValue(Map map, AttributeMapper attributeMapper, Integer n2) {
        String string = (String)this.getPropertyNamesMap().get(n2);
        if (string == null || map == null) {
            return attributeMapper.getRangeValue(map, n2);
        }
        Object v2 = map.get(string);
        if (v2 == null) {
            return attributeMapper.getRangeValue(map, n2);
        }
        if (!(v2 instanceof String)) {
            System.err.println("Unexpected data attribute value:");
            System.err.println("    " + string + " = " + v2);
            System.err.println("    Expected a String, class = " + v2.getClass());
            return attributeMapper.getRangeValue(map, n2);
        }
        Object object = this.parseRangeAttributeValue(n2, (String)v2);
        if (object == null) {
            return attributeMapper.getRangeValue(map, n2);
        }
        return object;
    }

    public Map getInitialDefaults() {
        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
        hashMap.put(l, new Color(255, 255, 255));
        hashMap.put(k, new Color(0, 0, 0));
        hashMap.put(e, eS.j);
        hashMap.put(b, new Double(30.0));
        hashMap.put(j, new Double(70.0));
        hashMap.put(c, new Byte(0));
        hashMap.put(i, new Color(0, 0, 0));
        hashMap.put(f, new Color(255, 255, 255));
        hashMap.put(d, eS.j);
        hashMap.put(a, nh.g);
        hashMap.put(h, nh.g);
        return hashMap;
    }

    public Map getPropertyNamesMap() {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        hashMap.put(l, "node.fillColor");
        hashMap.put(k, "node.borderColor");
        hashMap.put(g, "node.selectedColor");
        hashMap.put(e, "node.borderLinetype");
        hashMap.put(b, "node.height");
        hashMap.put(j, "node.width");
        hashMap.put(c, "node.shape");
        hashMap.put(i, "edge.color");
        hashMap.put(f, "background.color");
        hashMap.put(d, "edge.linetype");
        hashMap.put(a, "edge.sourceDecoration");
        hashMap.put(h, "edge.targetDecoration");
        return hashMap;
    }

    public Object parseRangeAttributeValue(Integer n2, String string) {
        Object object = null;
        if (n2.equals(l) || n2.equals(k) || n2.equals(i) || n2.equals(f) || n2.equals(g)) {
            object = Misc.parseRGBText(string);
        } else if (n2.equals(b) || n2.equals(j)) {
            object = new Double(string);
        } else if (n2.equals(c)) {
            object = Misc.parseNodeShapeTextIntoByte(string);
        } else if (n2.equals(e) || n2.equals(d)) {
            object = Misc.parseLineTypeText(string);
        } else if (n2.equals(a) || n2.equals(h)) {
            object = Misc.parseArrowText(string);
        } else {
            System.err.println("Error parsing range attribute value:");
            System.err.println("    unknown vizAttribute: " + n2.toString());
        }
        return object;
    }

    public String rangeAttributeValueToString(Integer n2, Object object) {
        boolean bl2 = false;
        boolean bl3 = false;
        if (n2.equals(l) || n2.equals(k) || n2.equals(i) || n2.equals(f) || n2.equals(g)) {
            if (object instanceof Color) {
                return Misc.getRGBText((Color)object);
            }
            bl2 = true;
        } else if (n2.equals(b) || n2.equals(j)) {
            if (object instanceof Double) {
                return object.toString();
            }
            bl2 = true;
        } else if (n2.equals(c)) {
            if (object instanceof Byte) {
                return Misc.getNodeShapeText((Byte)object);
            }
            bl2 = true;
        } else if (n2.equals(e) || n2.equals(d)) {
            if (object instanceof eS) {
                return Misc.getLineTypeText((eS)object);
            }
            bl2 = true;
        } else if (n2.equals(a) || n2.equals(h)) {
            if (object instanceof nh) {
                return Misc.getArrowText((nh)object);
            }
            bl2 = true;
        } else {
            bl3 = true;
        }
        if (bl2) {
            System.err.println("Error converting attribute value to string:");
            System.err.println("Incorrect attribute value object type: " + object.getClass());
        }
        if (bl3) {
            System.err.println("Error converting attribute value to string:");
            System.err.println("    unknown vizAttribute: " + n2.toString());
        }
        return "";
    }

    public Interpolator getInterpolator(Integer n2) {
        Interpolator interpolator = null;
        if (n2.equals(l) || n2.equals(k) || n2.equals(i) || n2.equals(f) || n2.equals(g)) {
            interpolator = new LinearNumberToColorInterpolator();
        } else if (n2.equals(b) || n2.equals(j)) {
            interpolator = new LinearNumberToNumberInterpolator();
        } else if (n2.equals(c)) {
            interpolator = new FlatInterpolator();
        } else if (n2.equals(e) || n2.equals(d)) {
            interpolator = new FlatInterpolator();
        } else if (n2.equals(a) || n2.equals(h)) {
            interpolator = new FlatInterpolator();
        } else {
            System.err.println("Error parsing range attribute value:");
            System.err.println("    unknown vizAttribute: " + n2.toString());
        }
        return interpolator;
    }
}

