/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.vizmap;

import cytoscape.vizmap.AttributeMapper;
import cytoscape.vizmap.AttributeMapperCategories;
import cytoscape.vizmap.BoundaryRangeValues;
import cytoscape.vizmap.ContinuousMapper;
import cytoscape.vizmap.DiscreteMapper;
import cytoscape.vizmap.Interpolator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;

public class AttributeMapperPropertiesAdapter {
    private AttributeMapper b;
    private AttributeMapperCategories a;

    public AttributeMapperPropertiesAdapter() {
        this.setAttributeMapper(null);
        this.setAttributeMapperCategories(null);
    }

    public AttributeMapperPropertiesAdapter(AttributeMapper attributeMapper, AttributeMapperCategories attributeMapperCategories) {
        this.setAttributeMapper(attributeMapper);
        this.setAttributeMapperCategories(attributeMapperCategories);
    }

    public AttributeMapper getAttributeMapper() {
        return this.b;
    }

    public void setAttributeMapper(AttributeMapper attributeMapper) {
        this.b = attributeMapper;
    }

    public AttributeMapperCategories getAttributeMapperCategories() {
        return this.a;
    }

    public void setAttributeMapperCategories(AttributeMapperCategories attributeMapperCategories) {
        this.a = attributeMapperCategories;
    }

    public void applyAllRangeProperties(Properties properties) {
        if (properties == null || this.b == null || this.a == null) {
            return;
        }
        Iterator iterator = this.a.getPropertyNamesMap().keySet().iterator();
        while (iterator.hasNext()) {
            Integer n2 = (Integer)iterator.next();
            this.applyRangeProperties(n2, properties);
        }
    }

    public void applyRangeProperties(Integer n2, Properties properties) {
        Object object;
        String string;
        if (n2 == null || properties == null || this.b == null || this.a == null) {
            return;
        }
        String string2 = (String)this.a.getPropertyNamesMap().get(n2);
        if (string2 == null) {
            System.err.println("Error parsing attributeMap properties:");
            System.err.println("    don't know how to parse range attribute " + n2.toString());
            return;
        }
        String string3 = string2 + ".default";
        if (properties.containsKey(string3)) {
            string = properties.getProperty(string3);
            object = this.a.parseRangeAttributeValue(n2, string);
            this.b.setDefaultValue(n2, object);
        }
        if (properties.containsKey(string = string2 + ".controller")) {
            object = properties.getProperty(string);
            String string4 = string2 + "." + (String)object;
            String string5 = string4 + ".type";
            String string6 = properties.getProperty(string5);
            if (string6 == null) {
                System.err.println("Error parsing attributeMap properties:");
                System.err.println("    no property matching: " + string5);
                return;
            }
            if (string6.equals("discrete")) {
                Map map = this.a(properties, string4);
                this.a(n2, map);
                DiscreteMapper discreteMapper = new DiscreteMapper(map);
                this.b.setAttributeMapEntry(n2, (String)object, discreteMapper);
                return;
            }
            if (string6.equals("continuous")) {
                SortedMap sortedMap = this.b(properties, string4);
                SortedMap sortedMap2 = this.a(n2, sortedMap);
                Interpolator interpolator = this.a.getInterpolator(n2);
                ContinuousMapper continuousMapper = new ContinuousMapper(sortedMap2, interpolator);
                this.b.setAttributeMapEntry(n2, (String)object, continuousMapper);
                return;
            }
            System.err.println("Error parsing attributeMap properties:");
            System.err.println("    Unrecognized property value: " + string6);
            System.err.println("    for key: " + string5);
            System.err.println("    (Expected 'discrete' or 'continuous')");
            return;
        }
    }

    public Map a(Properties properties, String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string2 = string + ".map";
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            if (!string3.startsWith(string2)) continue;
            String string4 = properties.getProperty(string3);
            String string5 = string3.substring(string2.length() + 1);
            hashMap.put(string5, string4);
        }
        return hashMap;
    }

    public SortedMap b(Properties properties, String string) {
        int n2;
        TreeMap<String, BoundaryRangeValues> treeMap = new TreeMap<String, BoundaryRangeValues>();
        String string2 = string + ".boundaryvalues";
        String string3 = properties.getProperty(string2);
        if (string3 == null) {
            System.err.println("Warning: while parsing attributeMap properties:");
            System.err.println("    no boundary values specified for");
            System.err.println("continuous key: " + string);
            return treeMap;
        }
        try {
            n2 = Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("Error parsing attributeMap properties:");
            System.err.println("    Expected number value for key: " + string3);
            return treeMap;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            String string4 = string + ".bv" + Integer.toString(i2);
            String string5 = string4 + ".domainvalue";
            String string6 = properties.getProperty(string5);
            if (string6 == null) {
                System.err.println("Error parsing attributeMap properties:");
                System.err.println("    expected numerical value for key: " + string5);
                continue;
            }
            BoundaryRangeValues boundaryRangeValues = new BoundaryRangeValues();
            String string7 = string4 + ".lesser";
            String string8 = properties.getProperty(string7);
            boundaryRangeValues.a = string8;
            String string9 = string4 + ".equal";
            String string10 = properties.getProperty(string9);
            boundaryRangeValues.b = string10;
            String string11 = string4 + ".greater";
            String string12 = properties.getProperty(string11);
            boundaryRangeValues.c = string12;
            treeMap.put(string6, boundaryRangeValues);
        }
        return treeMap;
    }

    public void a(Integer n2, Map map) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getValue();
            Object object = this.a.parseRangeAttributeValue(n2, string);
            if (object == null) {
                iterator.remove();
                continue;
            }
            entry.setValue(object);
        }
    }

    public SortedMap a(Integer n2, SortedMap sortedMap) {
        TreeMap<Double, BoundaryRangeValues> treeMap = new TreeMap<Double, BoundaryRangeValues>();
        Iterator iterator = sortedMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            BoundaryRangeValues boundaryRangeValues = (BoundaryRangeValues)sortedMap.get(string);
            Double d2 = null;
            try {
                d2 = Double.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("Error parsing attributeMap properties:");
                System.err.println("    expected number value for key: " + string);
                continue;
            }
            String string2 = (String)boundaryRangeValues.a;
            Object object = this.a.parseRangeAttributeValue(n2, string2);
            if (object == null) continue;
            boundaryRangeValues.a = object;
            String string3 = (String)boundaryRangeValues.b;
            Object object2 = this.a.parseRangeAttributeValue(n2, string3);
            if (object2 == null) continue;
            boundaryRangeValues.b = object2;
            String string4 = (String)boundaryRangeValues.c;
            Object object3 = this.a.parseRangeAttributeValue(n2, string4);
            if (object3 == null) continue;
            boundaryRangeValues.c = object3;
            treeMap.put(d2, boundaryRangeValues);
        }
        return treeMap;
    }
}

