/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.mappings;

import cytoscape.visual.mappings.ContinuousMapping;
import cytoscape.visual.mappings.DiscreteMapping;
import cytoscape.visual.mappings.ObjectMapping;
import cytoscape.visual.mappings.PassThroughMapping;
import cytoscape.visual.parsers.ValueParser;
import java.util.Properties;

public class MappingFactory {
    public static ObjectMapping newMapping(Properties properties, String string, ValueParser valueParser, Object object, byte by2) {
        String string2 = properties.getProperty(string + ".type");
        if (string2 == null) {
            System.err.println("MappingFactory: no Mapping class specified in properties");
            return null;
        }
        if (string2.equals("DiscreteMapping")) {
            DiscreteMapping discreteMapping = new DiscreteMapping(object, by2);
            discreteMapping.applyProperties(properties, string, valueParser);
            return discreteMapping;
        }
        if (string2.equals("ContinuousMapping")) {
            ContinuousMapping continuousMapping = new ContinuousMapping(object, by2);
            continuousMapping.applyProperties(properties, string, valueParser);
            return continuousMapping;
        }
        if (string2.equals("PassThroughMapping")) {
            PassThroughMapping passThroughMapping = new PassThroughMapping(object, by2);
            passThroughMapping.applyProperties(properties, string, valueParser);
            return passThroughMapping;
        }
        System.err.println("MappingFactory: unknown Mapping type: " + string2);
        return null;
    }

    public static Properties getProperties(ObjectMapping objectMapping, String string) {
        if (objectMapping == null) {
            return null;
        }
        Properties properties = objectMapping.getProperties(string);
        if (objectMapping instanceof DiscreteMapping) {
            properties.setProperty(string + ".type", "DiscreteMapping");
        } else if (objectMapping instanceof ContinuousMapping) {
            properties.setProperty(string + ".type", "ContinuousMapping");
        } else if (objectMapping instanceof PassThroughMapping) {
            properties.setProperty(string + ".type", "PassThroughMapping");
        } else {
            String string2 = objectMapping.getClass().getName();
            System.err.println("MappingFactory: unknown Mapping type: " + string2);
            return null;
        }
        return properties;
    }
}

