/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.mappings;

import cytoscape.GraphObjAttributes;
import cytoscape.dialogs.GridBagGroup;
import cytoscape.dialogs.MiscGB;
import cytoscape.visual.Network;
import cytoscape.visual.mappings.ObjectMapping;
import cytoscape.visual.parsers.ObjectToString;
import cytoscape.visual.parsers.ValueParser;
import cytoscape.visual.ui.ValueDisplayer;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DiscreteMapping
extends TreeMap
implements ObjectMapping {
    public Object h;
    public Class g;
    public String k;
    public byte i;
    public HashSet j;
    public JScrollPane c;
    public JDialog b;
    public Vector f = new Vector(1, 1);
    public transient ChangeEvent e;
    public static Class a;
    public static Class d;

    public DiscreteMapping(Object object, byte by2) throws IllegalArgumentException {
        this(object, null, by2);
    }

    public DiscreteMapping(Object object, String string, byte by2) {
        this.h = object;
        this.g = object.getClass();
        if (by2 != 0 && by2 != 1) {
            throw new IllegalArgumentException("Unknown mapping type " + by2);
        }
        this.i = by2;
        if (string != null) {
            this.setControllingAttributeName(string, null, false);
        }
    }

    public Class getRangeClass() {
        return this.g;
    }

    public Class[] getAcceptedDataClasses() {
        Class[] classArray = new Class[]{a == null ? (a = DiscreteMapping.a("java.lang.String")) : a, d == null ? (d = DiscreteMapping.a("java.lang.Number")) : d};
        return classArray;
    }

    public String getControllingAttributeName() {
        return this.k;
    }

    public void setControllingAttributeName(String string, Network network, boolean bl2) {
        this.k = string;
        if (!bl2) {
            this.clear();
            this.j = new HashSet();
        }
    }

    public void loadKeys(Network network) {
        if (network == null) {
            return;
        }
        GraphObjAttributes graphObjAttributes = this.i == 0 ? network.getEdgeAttributes() : network.getNodeAttributes();
        HashMap hashMap = graphObjAttributes.getAttribute(this.k);
        if (hashMap == null) {
            return;
        }
        Collection collection = hashMap.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object v2 = iterator.next();
            if (v2 instanceof List) {
                List list = (List)v2;
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    Object e2 = list.get(i2);
                    if (this.j.contains(e2)) continue;
                    this.j.add(e2);
                }
                continue;
            }
            if (this.j.contains(v2)) continue;
            this.j.add(v2);
        }
    }

    public Object calculateRangeValue(Map map) {
        if (map == null || this.k == null) {
            return null;
        }
        Object v2 = map.get(this.k);
        if (v2 == null) {
            return null;
        }
        try {
            if (v2 instanceof List) {
                Iterator iterator = ((List)v2).iterator();
                while (iterator.hasNext()) {
                    Object e2 = iterator.next();
                    if (this.get(e2) == null) continue;
                    return this.get(e2);
                }
                return null;
            }
            return this.get(v2);
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public Object put(Object object, Object object2) {
        if (this.g.isInstance(object2)) {
            return super.put(object, object2);
        }
        String string = "Invalid map entry: Expected class " + this.g.toString() + ", got class " + object2.getClass().toString();
        throw new ClassCastException(string);
    }

    public void putAll(Map map) {
        if (map == null) {
            return;
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k2 = iterator.next();
            this.put(k2, map.get(k2));
        }
    }

    public void applyProperties(Properties properties, String string, ValueParser valueParser) {
        String string2 = string + ".controller";
        String string3 = properties.getProperty(string2);
        if (string3 != null) {
            this.setControllingAttributeName(string3, null, false);
        }
        String string4 = string + ".map.";
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string5 = (String)enumeration.nextElement();
            if (!string5.startsWith(string4)) continue;
            String string6 = properties.getProperty(string5);
            String string7 = string5.substring(string4.length());
            Object object = valueParser.parseStringValue(string6);
            this.put(string7, object);
        }
    }

    public Properties getProperties(String string) {
        Properties properties = new Properties();
        String string2 = string + ".controller";
        String string3 = this.getControllingAttributeName();
        properties.setProperty(string2, string3);
        String string4 = string + ".map.";
        Iterator iterator = this.keySet().iterator();
        while (iterator.hasNext()) {
            String string5 = (String)iterator.next();
            Object v2 = this.get(string5);
            String string6 = ObjectToString.getStringValue(v2);
            properties.setProperty(string4 + string5, string6);
        }
        return properties;
    }

    public Object clone() {
        DiscreteMapping discreteMapping = (DiscreteMapping)super.clone();
        if (this.k != null) {
            discreteMapping.k = new String(this.k);
            discreteMapping.j = (HashSet)this.j.clone();
        }
        return discreteMapping;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.f.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.f.remove(changeListener);
    }

    public void a() {
        for (int i2 = this.f.size() - 1; i2 >= 0; --i2) {
            ChangeListener changeListener = (ChangeListener)this.f.get(i2);
            if (this.e == null) {
                this.e = new ChangeEvent(this);
            }
            changeListener.stateChanged(this.e);
        }
    }

    public JPanel getUI(JDialog jDialog, Network network) {
        this.b = jDialog;
        this.loadKeys(network);
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        if (this.k == null || this.j == null || this.j.size() == 0) {
            jPanel.add(new JLabel("Unknown attribute set!"));
            return jPanel;
        }
        Object[] objectArray = this.j.toArray();
        int n2 = this.j.size();
        int n3 = (int)Math.ceil((double)n2 * 2.0 / 512.0);
        for (int i2 = 0; i2 < n3; ++i2) {
            GridBagGroup gridBagGroup = new GridBagGroup();
            int n4 = i2 * 256;
            for (int i3 = 0; i3 < 256 && n4 < objectArray.length; ++i3, ++n4) {
                Object object = objectArray[n4];
                String string = object.toString();
                JButton jButton = new JButton(string);
                Object v2 = this.get(object);
                ValueDisplayer valueDisplayer = v2 == null ? ValueDisplayer.getDisplayFor(jDialog, "Define Discrete Mapping", this.h) : ValueDisplayer.getDisplayFor(jDialog, "Define Discrete Mapping", this.get(object));
                valueDisplayer.addItemListener(new ValueChangeListener(this, object));
                jButton.addActionListener(valueDisplayer.getInputListener());
                if (i3 == n2 - 1) {
                    MiscGB.insert(gridBagGroup, jButton, 0, i3, -1, 0, 1);
                    MiscGB.insert(gridBagGroup, valueDisplayer, 1, i3, 0, 0, 1);
                    continue;
                }
                MiscGB.insert(gridBagGroup, jButton, 0, i3, -1, 1, 1);
                MiscGB.insert(gridBagGroup, valueDisplayer, 1, i3, 0, 1, 1);
            }
            jPanel2.add(gridBagGroup.c);
        }
        this.a(jPanel, jPanel2);
        return jPanel;
    }

    private void a(JPanel jPanel, JPanel jPanel2) {
        this.c = new JScrollPane(jPanel2, 20, 31);
        jPanel.add(this.c);
        Dimension dimension = this.c.getPreferredSize();
        int n2 = (int)dimension.getHeight();
        if (n2 > 200) {
            n2 = 200;
        }
        this.c.setPreferredSize(new Dimension((int)dimension.getWidth() + 10, n2));
        if (this.b != null) {
            this.b.pack();
            this.b.validate();
            this.b.repaint();
        }
    }

    public static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    protected class ValueChangeListener
    implements ItemListener {
        private Object a;
        private final DiscreteMapping b;

        public ValueChangeListener(DiscreteMapping discreteMapping, Object object) {
            this.b = discreteMapping;
            this.a = object;
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            ValueDisplayer valueDisplayer = (ValueDisplayer)itemEvent.getItemSelectable();
            this.b.put(this.a, valueDisplayer.getValue());
            this.b.a();
        }
    }
}

