/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual;

import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.EdgeAppearanceCalculator;
import cytoscape.visual.GlobalAppearanceCalculator;
import cytoscape.visual.NodeAppearanceCalculator;
import cytoscape.visual.VisualStyle;
import cytoscape.visual.calculators.Calculator;
import cytoscape.visual.calculators.CalculatorFactory;
import cytoscape.visual.calculators.EdgeArrowCalculator;
import cytoscape.visual.calculators.EdgeColorCalculator;
import cytoscape.visual.calculators.EdgeFontFaceCalculator;
import cytoscape.visual.calculators.EdgeFontSizeCalculator;
import cytoscape.visual.calculators.EdgeLabelCalculator;
import cytoscape.visual.calculators.EdgeLineTypeCalculator;
import cytoscape.visual.calculators.EdgeToolTipCalculator;
import cytoscape.visual.calculators.NodeColorCalculator;
import cytoscape.visual.calculators.NodeFontFaceCalculator;
import cytoscape.visual.calculators.NodeFontSizeCalculator;
import cytoscape.visual.calculators.NodeLabelCalculator;
import cytoscape.visual.calculators.NodeLineTypeCalculator;
import cytoscape.visual.calculators.NodeShapeCalculator;
import cytoscape.visual.calculators.NodeSizeCalculator;
import cytoscape.visual.calculators.NodeToolTipCalculator;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class CalculatorIO {
    public static void storeCatalog(CalculatorCatalog calculatorCatalog, File file) {
        try {
            String string;
            String string2 = System.getProperty("line.separator");
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("This file specifies visual mappings for Cytoscape");
            stringBuffer.append(" and has been automatically generated.").append(string2);
            stringBuffer.append("# WARNING: any changes you make to this file while");
            stringBuffer.append(" Cytoscape is running may be overwritten.").append(string2);
            stringBuffer.append("# Any changes may make these visual mappings unreadable.");
            stringBuffer.append(string2);
            stringBuffer.append("# Please make sure you know what you are doing before");
            stringBuffer.append(" modifying this file by hand.").append(string2);
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            Properties properties = CalculatorIO.getProperties(calculatorCatalog);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            properties.store(byteArrayOutputStream, stringBuffer.toString());
            String string3 = byteArrayOutputStream.toString();
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string3));
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            String string4 = bufferedReader.readLine();
            while (string4 != null) {
                if (string4.startsWith("#")) {
                    arrayList.add(string4);
                } else {
                    arrayList2.add(string4);
                }
                string4 = bufferedReader.readLine();
            }
            Collections.sort(arrayList2);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                bufferedWriter.write(string, 0, string.length());
                bufferedWriter.newLine();
            }
            iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                bufferedWriter.write(string, 0, string.length());
                bufferedWriter.newLine();
            }
            bufferedWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static Properties getProperties(CalculatorCatalog calculatorCatalog) {
        Properties properties = new Properties();
        CalculatorIO.a(properties, calculatorCatalog.getNodeColorCalculators(), "nodeColorCalculator");
        CalculatorIO.a(properties, calculatorCatalog.getNodeLineTypeCalculators(), "nodeLineTypeCalculator");
        CalculatorIO.a(properties, calculatorCatalog.getNodeShapeCalculators(), "nodeShapeCalculator");
        CalculatorIO.a(properties, calculatorCatalog.getNodeSizeCalculators(), "nodeSizeCalculator");
        CalculatorIO.a(properties, calculatorCatalog.getNodeLabelCalculators(), "nodeLabelCalculator");
        CalculatorIO.a(properties, calculatorCatalog.getNodeToolTipCalculators(), "nodeToolTipCalculator");
        CalculatorIO.a(properties, calculatorCatalog.getNodeFontFaceCalculators(), "nodeFontFaceCalculator");
        CalculatorIO.a(properties, calculatorCatalog.getNodeFontSizeCalculators(), "nodeFontSizeCalculator");
        CalculatorIO.a(properties, calculatorCatalog.getEdgeColorCalculators(), "edgeColorCalculator");
        CalculatorIO.a(properties, calculatorCatalog.getEdgeLineTypeCalculators(), "edgeLineTypeCalculator");
        CalculatorIO.a(properties, calculatorCatalog.getEdgeArrowCalculators(), "edgeArrowCalculator");
        CalculatorIO.a(properties, calculatorCatalog.getEdgeLabelCalculators(), "edgeLabelCalculator");
        CalculatorIO.a(properties, calculatorCatalog.getEdgeToolTipCalculators(), "edgeToolTipCalculator");
        CalculatorIO.a(properties, calculatorCatalog.getEdgeFontFaceCalculators(), "edgeFontFaceCalculator");
        CalculatorIO.a(properties, calculatorCatalog.getEdgeFontSizeCalculators(), "edgeFontSizeCalculator");
        Set set = calculatorCatalog.getVisualStyleNames();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object object;
            String string = (String)iterator.next();
            VisualStyle visualStyle = calculatorCatalog.getVisualStyle(string);
            try {
                Properties properties2 = new Properties();
                object = visualStyle.getNodeAppearanceCalculator();
                String string2 = "nodeAppearanceCalculator." + string;
                Properties properties3 = ((NodeAppearanceCalculator)object).getProperties(string2);
                properties2.putAll((Map<?, ?>)properties3);
                EdgeAppearanceCalculator edgeAppearanceCalculator = visualStyle.getEdgeAppearanceCalculator();
                String string3 = "edgeAppearanceCalculator." + string;
                Properties properties4 = edgeAppearanceCalculator.getProperties(string3);
                properties2.putAll((Map<?, ?>)properties4);
                GlobalAppearanceCalculator globalAppearanceCalculator = visualStyle.getGlobalAppearanceCalculator();
                String string4 = "globalAppearanceCalculator." + string;
                Properties properties5 = globalAppearanceCalculator.getProperties(string4);
                properties2.putAll((Map<?, ?>)properties5);
                properties.putAll((Map<?, ?>)properties2);
            }
            catch (Exception exception) {
                object = "Exception while saving visual style " + string;
                System.err.println((String)object);
                System.err.println(exception.getMessage());
            }
        }
        return properties;
    }

    private static void a(Properties properties, Collection collection, String string) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Calculator calculator = (Calculator)iterator.next();
            if (calculator == null) continue;
            String string2 = string + "." + ((Object)calculator).toString();
            try {
                Properties properties2 = CalculatorFactory.getProperties(calculator, string2);
                properties.putAll((Map<?, ?>)properties2);
            }
            catch (Exception exception) {
                System.err.println("Exception while saving " + string2);
                System.err.println(exception.getMessage());
                exception.printStackTrace();
            }
        }
    }

    public static void loadCalculators(Properties properties, CalculatorCatalog calculatorCatalog) {
        CalculatorIO.loadCalculators(properties, calculatorCatalog, true);
    }

    public static void loadCalculators(Properties properties, CalculatorCatalog calculatorCatalog, boolean bl2) {
        VisualStyle visualStyle;
        Cloneable cloneable;
        String string;
        Properties properties2;
        Object object;
        Object object2;
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        HashMap hashMap3 = new HashMap();
        HashMap hashMap4 = new HashMap();
        HashMap hashMap5 = new HashMap();
        HashMap hashMap6 = new HashMap();
        HashMap hashMap7 = new HashMap();
        HashMap hashMap8 = new HashMap();
        HashMap hashMap9 = new HashMap();
        HashMap hashMap10 = new HashMap();
        HashMap hashMap11 = new HashMap();
        HashMap hashMap12 = new HashMap();
        HashMap hashMap13 = new HashMap();
        HashMap hashMap14 = new HashMap();
        HashMap hashMap15 = new HashMap();
        HashMap hashMap16 = new HashMap();
        HashMap hashMap17 = new HashMap();
        HashMap hashMap18 = new HashMap();
        Object object3 = properties.propertyNames();
        while (object3.hasMoreElements()) {
            object2 = (String)object3.nextElement();
            if (((String)object2).startsWith("nodeColorCalculator.")) {
                CalculatorIO.a((String)object2, properties, hashMap);
                continue;
            }
            if (((String)object2).startsWith("nodeLineTypeCalculator.")) {
                CalculatorIO.a((String)object2, properties, hashMap2);
                continue;
            }
            if (((String)object2).startsWith("nodeShapeCalculator.")) {
                CalculatorIO.a((String)object2, properties, hashMap3);
                continue;
            }
            if (((String)object2).startsWith("nodeSizeCalculator.")) {
                CalculatorIO.a((String)object2, properties, hashMap4);
                continue;
            }
            if (((String)object2).startsWith("nodeLabelCalculator.")) {
                CalculatorIO.a((String)object2, properties, hashMap5);
                continue;
            }
            if (((String)object2).startsWith("nodeToolTipCalculator.")) {
                CalculatorIO.a((String)object2, properties, hashMap6);
                continue;
            }
            if (((String)object2).startsWith("nodeFontFaceCalculator.")) {
                CalculatorIO.a((String)object2, properties, hashMap7);
                continue;
            }
            if (((String)object2).startsWith("nodeFontSizeCalculator.")) {
                CalculatorIO.a((String)object2, properties, hashMap8);
                continue;
            }
            if (((String)object2).startsWith("edgeColorCalculator.")) {
                CalculatorIO.a((String)object2, properties, hashMap9);
                continue;
            }
            if (((String)object2).startsWith("edgeLineTypeCalculator.")) {
                CalculatorIO.a((String)object2, properties, hashMap10);
                continue;
            }
            if (((String)object2).startsWith("edgeArrowCalculator.")) {
                CalculatorIO.a((String)object2, properties, hashMap11);
                continue;
            }
            if (((String)object2).startsWith("edgeLabelCalculator.")) {
                CalculatorIO.a((String)object2, properties, hashMap12);
                continue;
            }
            if (((String)object2).startsWith("edgeToolTipCalculator.")) {
                CalculatorIO.a((String)object2, properties, hashMap13);
                continue;
            }
            if (((String)object2).startsWith("edgeFontFaceCalculator.")) {
                CalculatorIO.a((String)object2, properties, hashMap14);
                continue;
            }
            if (((String)object2).startsWith("edgeFontSizeCalculator.")) {
                CalculatorIO.a((String)object2, properties, hashMap15);
                continue;
            }
            if (((String)object2).startsWith("nodeAppearanceCalculator.")) {
                CalculatorIO.a((String)object2, properties, hashMap16);
                continue;
            }
            if (((String)object2).startsWith("edgeAppearanceCalculator.")) {
                CalculatorIO.a((String)object2, properties, hashMap17);
                continue;
            }
            if (!((String)object2).startsWith("globalAppearanceCalculator.")) continue;
            CalculatorIO.a((String)object2, properties, hashMap18);
        }
        CalculatorIO.a(hashMap, calculatorCatalog, bl2, "nodeColorCalculator", "NodeColorCalculator");
        CalculatorIO.a(hashMap2, calculatorCatalog, bl2, "nodeLineTypeCalculator", "NodeLineTypeCalculator");
        CalculatorIO.a(hashMap3, calculatorCatalog, bl2, "nodeShapeCalculator", "NodeShapeCalculator");
        CalculatorIO.a(hashMap4, calculatorCatalog, bl2, "nodeSizeCalculator", "NodeSizeCalculator");
        CalculatorIO.a(hashMap5, calculatorCatalog, bl2, "nodeLabelCalculator", "NodeLabelCalculator");
        CalculatorIO.a(hashMap6, calculatorCatalog, bl2, "nodeToolTipCalculator", "NodeToolTipCalculator");
        CalculatorIO.a(hashMap7, calculatorCatalog, bl2, "nodeFontFaceCalculator", "NodeFontFaceCalculator");
        CalculatorIO.a(hashMap8, calculatorCatalog, bl2, "nodeFontSizeCalculator", "NodeFontSizeCalculator");
        CalculatorIO.a(hashMap9, calculatorCatalog, bl2, "edgeColorCalculator", "EdgeColorCalculator");
        CalculatorIO.a(hashMap10, calculatorCatalog, bl2, "edgeLineTypeCalculator", "EdgeLineTypeCalculator");
        CalculatorIO.a(hashMap11, calculatorCatalog, bl2, "edgeArrowCalculator", "EdgeArrowCalculator");
        CalculatorIO.a(hashMap12, calculatorCatalog, bl2, "edgeLabelCalculator", "EdgeLabelCalculator");
        CalculatorIO.a(hashMap13, calculatorCatalog, bl2, "edgeToolTipCalculator", "EdgeToolTipCalculator");
        CalculatorIO.a(hashMap14, calculatorCatalog, bl2, "edgeFontFaceCalculator", "EdgeFontFaceCalculator");
        CalculatorIO.a(hashMap15, calculatorCatalog, bl2, "edgeFontSizeCalculator", "EdgeFontSizeCalculator");
        object3 = new HashMap();
        object2 = hashMap16.keySet().iterator();
        while (object2.hasNext()) {
            object = (String)object2.next();
            properties2 = (Properties)hashMap16.get(object);
            string = "nodeAppearanceCalculator." + (String)object;
            cloneable = new NodeAppearanceCalculator((String)object, properties2, string, calculatorCatalog);
            visualStyle = (VisualStyle)object3.get(object);
            if (visualStyle == null) {
                visualStyle = new VisualStyle((String)object);
                object3.put(object, visualStyle);
            }
            visualStyle.setNodeAppearanceCalculator((NodeAppearanceCalculator)cloneable);
        }
        object2 = hashMap17.keySet().iterator();
        while (object2.hasNext()) {
            object = (String)object2.next();
            properties2 = (Properties)hashMap17.get(object);
            string = "edgeAppearanceCalculator." + (String)object;
            cloneable = new EdgeAppearanceCalculator((String)object, properties2, string, calculatorCatalog);
            visualStyle = (VisualStyle)object3.get(object);
            if (visualStyle == null) {
                visualStyle = new VisualStyle((String)object);
                object3.put(object, visualStyle);
            }
            visualStyle.setEdgeAppearanceCalculator((EdgeAppearanceCalculator)cloneable);
        }
        object2 = hashMap18.keySet().iterator();
        while (object2.hasNext()) {
            object = (String)object2.next();
            properties2 = (Properties)hashMap18.get(object);
            string = "globalAppearanceCalculator." + (String)object;
            cloneable = new GlobalAppearanceCalculator((String)object, properties2, string, calculatorCatalog);
            visualStyle = (VisualStyle)object3.get(object);
            if (visualStyle == null) {
                visualStyle = new VisualStyle((String)object);
                object3.put(object, visualStyle);
            }
            visualStyle.setGlobalAppearanceCalculator((GlobalAppearanceCalculator)cloneable);
        }
        object2 = object3.values().iterator();
        while (object2.hasNext()) {
            object = (VisualStyle)object2.next();
            calculatorCatalog.addVisualStyle((VisualStyle)object);
        }
    }

    private static void a(String string, Properties properties, Map map) {
        String string2 = CalculatorIO.a(string);
        if (string2 != null) {
            Properties properties2 = (Properties)map.get(string2);
            if (properties2 == null) {
                properties2 = new Properties();
                map.put(string2, properties2);
            }
            properties2.setProperty(string, properties.getProperty(string));
        }
    }

    private static String a(String string) {
        if (string == null) {
            return null;
        }
        int n2 = string.indexOf(".");
        if (n2 == -1 || n2 >= string.length() - 1) {
            return null;
        }
        int n3 = string.indexOf(".", n2 + 1);
        if (n3 == -1) {
            return null;
        }
        return string.substring(n2 + 1, n3);
    }

    private static void a(Map map, CalculatorCatalog calculatorCatalog, boolean bl2, String string, String string2) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string3;
            String string4;
            Properties properties;
            String string5 = (String)iterator.next();
            Calculator calculator = CalculatorFactory.newCalculator(string5, properties = (Properties)map.get(string5), string4 = string + "." + string5, string3 = "cytoscape.visual.calculators." + string2);
            if (calculator == null) continue;
            if (bl2) {
                CalculatorIO.removeDuplicate(calculator, calculatorCatalog);
            } else {
                CalculatorIO.renameAsNeeded(calculator, calculatorCatalog);
            }
            calculatorCatalog.addCalculator(calculator);
        }
    }

    public static void removeDuplicate(Calculator calculator, CalculatorCatalog calculatorCatalog) {
        String string = ((Object)calculator).toString();
        if (calculator instanceof NodeColorCalculator) {
            calculatorCatalog.removeNodeColorCalculator(string);
        } else if (calculator instanceof NodeLineTypeCalculator) {
            calculatorCatalog.removeNodeLineTypeCalculator(string);
        } else if (calculator instanceof NodeShapeCalculator) {
            calculatorCatalog.removeNodeShapeCalculator(string);
        } else if (calculator instanceof NodeSizeCalculator) {
            calculatorCatalog.removeNodeSizeCalculator(string);
        } else if (calculator instanceof NodeLabelCalculator) {
            calculatorCatalog.removeNodeLabelCalculator(string);
        } else if (calculator instanceof NodeToolTipCalculator) {
            calculatorCatalog.removeNodeToolTipCalculator(string);
        } else if (calculator instanceof NodeFontFaceCalculator) {
            calculatorCatalog.removeNodeFontFaceCalculator(string);
        } else if (calculator instanceof NodeFontSizeCalculator) {
            calculatorCatalog.removeNodeFontSizeCalculator(string);
        } else if (calculator instanceof EdgeColorCalculator) {
            calculatorCatalog.removeEdgeColorCalculator(string);
        } else if (calculator instanceof EdgeLineTypeCalculator) {
            calculatorCatalog.removeEdgeLineTypeCalculator(string);
        } else if (calculator instanceof EdgeArrowCalculator) {
            calculatorCatalog.removeEdgeArrowCalculator(string);
        } else if (calculator instanceof EdgeLabelCalculator) {
            calculatorCatalog.removeEdgeLabelCalculator(string);
        } else if (calculator instanceof EdgeToolTipCalculator) {
            calculatorCatalog.removeEdgeToolTipCalculator(string);
        } else if (calculator instanceof EdgeFontFaceCalculator) {
            calculatorCatalog.removeEdgeFontFaceCalculator(string);
        } else if (calculator instanceof EdgeFontSizeCalculator) {
            calculatorCatalog.removeEdgeFontSizeCalculator(string);
        }
    }

    public static void renameAsNeeded(Calculator calculator, CalculatorCatalog calculatorCatalog) {
        String string;
        String string2 = ((Object)calculator).toString();
        if (calculator instanceof NodeColorCalculator) {
            String string3 = calculatorCatalog.checkNodeColorCalculatorName(string2);
            if (!string3.equals(string2)) {
                calculator.setName(string3);
            }
        } else if (calculator instanceof NodeLineTypeCalculator) {
            String string4 = calculatorCatalog.checkNodeLineTypeCalculatorName(string2);
            if (!string4.equals(string2)) {
                calculator.setName(string4);
            }
        } else if (calculator instanceof NodeShapeCalculator) {
            String string5 = calculatorCatalog.checkNodeShapeCalculatorName(string2);
            if (!string5.equals(string2)) {
                calculator.setName(string5);
            }
        } else if (calculator instanceof NodeSizeCalculator) {
            String string6 = calculatorCatalog.checkNodeSizeCalculatorName(string2);
            if (!string6.equals(string2)) {
                calculator.setName(string6);
            }
        } else if (calculator instanceof NodeLabelCalculator) {
            String string7 = calculatorCatalog.checkNodeLabelCalculatorName(string2);
            if (!string7.equals(string2)) {
                calculator.setName(string7);
            }
        } else if (calculator instanceof NodeToolTipCalculator) {
            String string8 = calculatorCatalog.checkNodeToolTipCalculatorName(string2);
            if (!string8.equals(string2)) {
                calculator.setName(string8);
            }
        } else if (calculator instanceof NodeFontFaceCalculator) {
            String string9 = calculatorCatalog.checkNodeFontFaceCalculatorName(string2);
            if (!string9.equals(string2)) {
                calculator.setName(string9);
            }
        } else if (calculator instanceof NodeFontSizeCalculator) {
            String string10 = calculatorCatalog.checkNodeFontSizeCalculatorName(string2);
            if (!string10.equals(string2)) {
                calculator.setName(string10);
            }
        } else if (calculator instanceof EdgeColorCalculator) {
            String string11 = calculatorCatalog.checkEdgeColorCalculatorName(string2);
            if (!string11.equals(string2)) {
                calculator.setName(string11);
            }
        } else if (calculator instanceof EdgeLineTypeCalculator) {
            String string12 = calculatorCatalog.checkEdgeLineTypeCalculatorName(string2);
            if (!string12.equals(string2)) {
                calculator.setName(string12);
            }
        } else if (calculator instanceof EdgeArrowCalculator) {
            String string13 = calculatorCatalog.checkEdgeArrowCalculatorName(string2);
            if (!string13.equals(string2)) {
                calculator.setName(string13);
            }
        } else if (calculator instanceof EdgeLabelCalculator) {
            String string14 = calculatorCatalog.checkEdgeLabelCalculatorName(string2);
            if (!string14.equals(string2)) {
                calculator.setName(string14);
            }
        } else if (calculator instanceof EdgeToolTipCalculator) {
            String string15 = calculatorCatalog.checkEdgeToolTipCalculatorName(string2);
            if (!string15.equals(string2)) {
                calculator.setName(string15);
            }
        } else if (calculator instanceof EdgeFontFaceCalculator) {
            String string16 = calculatorCatalog.checkEdgeFontFaceCalculatorName(string2);
            if (!string16.equals(string2)) {
                calculator.setName(string16);
            }
        } else if (calculator instanceof EdgeFontSizeCalculator && !(string = calculatorCatalog.checkEdgeFontSizeCalculatorName(string2)).equals(string2)) {
            calculator.setName(string);
        }
    }
}

