/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.unitTests;

import cytoscape.GraphObjAttributes;
import cytoscape.unitTests.AllTests;
import java.io.File;
import java.util.HashMap;

public class GraphObjAttributesTest
extends ii {
    public static Class b;

    public GraphObjAttributesTest(String string) {
        super(string);
    }

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    public void testCtor() throws Exception {
        AllTests.standardOut("testCtor");
        GraphObjAttributes graphObjAttributes = new GraphObjAttributes();
        GraphObjAttributesTest.a(graphObjAttributes.numberOfAttributes() == 0);
    }

    public void testSet() throws Exception {
        AllTests.standardOut("testSet");
        GraphObjAttributes graphObjAttributes = new GraphObjAttributes();
        GraphObjAttributesTest.a(graphObjAttributes.numberOfAttributes() == 0);
        graphObjAttributes.set("expressionLevel", "GAL4", 1.8);
        GraphObjAttributesTest.a(graphObjAttributes.numberOfAttributes() == 1);
        graphObjAttributes.set("expressionLevel", "GAL80", 0.01);
        GraphObjAttributesTest.a(graphObjAttributes.numberOfAttributes() == 1);
        graphObjAttributes.set("foo", "GAL4", 321.23);
        GraphObjAttributesTest.a(graphObjAttributes.numberOfAttributes() == 2);
    }

    public void testGetSingleStringValueFromVector() throws Exception {
        AllTests.standardOut("testGetSingleStringValueFromVector");
        GraphObjAttributes graphObjAttributes = new GraphObjAttributes();
        GraphObjAttributesTest.a(graphObjAttributes.numberOfAttributes() == 0);
        String string = "synonym 1";
        String string2 = "synonym 2";
        graphObjAttributes.append("synonym", "GAL4", string);
        graphObjAttributes.append("synonym", "GAL4", string2);
        GraphObjAttributesTest.a(graphObjAttributes.numberOfAttributes() == 1);
        String string3 = graphObjAttributes.getStringValue("synonym", "GAL4");
        GraphObjAttributesTest.a(string3.equals(string));
    }

    public void testGetSingleDoubleValueFromVector() throws Exception {
        AllTests.standardOut("testGetSingleDoubleValueFromVector");
        GraphObjAttributes graphObjAttributes = new GraphObjAttributes();
        GraphObjAttributesTest.a(graphObjAttributes.numberOfAttributes() == 0);
        Double d2 = new Double(1.0);
        Double d3 = new Double(2.0);
        graphObjAttributes.append("score", "GAL4", d2);
        graphObjAttributes.append("score", "GAL4", d3);
        GraphObjAttributesTest.a(graphObjAttributes.numberOfAttributes() == 1);
        Double d4 = graphObjAttributes.getDoubleValue("score", "GAL4");
        GraphObjAttributesTest.a(d4.equals(d2));
        Object[] objectArray = graphObjAttributes.getArrayValues("score", "GAL4");
        GraphObjAttributesTest.a(objectArray.length == 2);
        Double d5 = (Double)objectArray[0];
        Double d6 = (Double)objectArray[1];
        GraphObjAttributesTest.a(d5.equals(d2));
        GraphObjAttributesTest.a(d6.equals(d3));
    }

    public void testAdd() throws Exception {
        AllTests.standardOut("testAdd");
        GraphObjAttributes graphObjAttributes = new GraphObjAttributes();
        GraphObjAttributesTest.a(graphObjAttributes.numberOfAttributes() == 0);
        graphObjAttributes.add("expressionLevel", "GAL4", 1.8);
        GraphObjAttributesTest.a(graphObjAttributes.numberOfAttributes() == 1);
        graphObjAttributes.add("expressionLevel", "GAL80", 0.01);
        GraphObjAttributesTest.a(graphObjAttributes.numberOfAttributes() == 1);
        graphObjAttributes.add("foo", "GAL4", 321.23);
        GraphObjAttributesTest.a(graphObjAttributes.numberOfAttributes() == 2);
        GraphObjAttributes graphObjAttributes2 = (GraphObjAttributes)graphObjAttributes.clone();
        GraphObjAttributesTest.a(graphObjAttributes2.numberOfAttributes() == 2);
        graphObjAttributes.deleteAttribute("expressionLevel");
        graphObjAttributes.deleteAttribute("foo");
        GraphObjAttributesTest.a(graphObjAttributes2.numberOfAttributes() == 2);
        GraphObjAttributes graphObjAttributes3 = new GraphObjAttributes();
        GraphObjAttributesTest.a(graphObjAttributes3.numberOfAttributes() == 0);
        graphObjAttributes3.add(graphObjAttributes2);
        GraphObjAttributesTest.a(graphObjAttributes3.numberOfAttributes() == 2);
        HashMap hashMap = graphObjAttributes3.getAttributes("GAL4");
        GraphObjAttributesTest.a(hashMap.size() == 2);
        graphObjAttributes3.deleteAttribute("expressionLevel");
        graphObjAttributes3.deleteAttribute("foo");
        GraphObjAttributesTest.a(graphObjAttributes3.numberOfAttributes() == 0);
        graphObjAttributes3.add("GAL4", hashMap);
        GraphObjAttributesTest.a(graphObjAttributes3.numberOfAttributes() == 2);
        graphObjAttributes3.add("whimsical", "GAL4", 101.101);
        HashMap hashMap2 = graphObjAttributes3.getAttributes("GAL4");
        GraphObjAttributesTest.a(hashMap2.size() == 3);
        Double d2 = (Double)hashMap2.get("whimsical");
        GraphObjAttributesTest.a(d2.equals(new Double(101.101)));
    }

    public void testAddGraphObjAttributes() throws Exception {
        AllTests.standardOut("testAddGraphObjAttributes");
        GraphObjAttributes graphObjAttributes = new GraphObjAttributes();
        graphObjAttributes.set("expressionLevel", "GAL4", 1.8);
        graphObjAttributes.set("expressionLevel", "GAL80", 0.01);
        graphObjAttributes.set("foo", "GAL4", 321.23);
        graphObjAttributes.set("bar", "GAL4", "The Columbia City Ale House");
        GraphObjAttributesTest.a(graphObjAttributes.hasAttribute("expressionLevel"));
        GraphObjAttributesTest.a(graphObjAttributes.hasAttribute("foo"));
        GraphObjAttributesTest.a(graphObjAttributes.hasAttribute("bar"));
        GraphObjAttributesTest.a(!graphObjAttributes.hasAttribute("BAR"));
        GraphObjAttributesTest.a(graphObjAttributes.getClass("expressionLevel") == new Double(0.0).getClass());
        GraphObjAttributesTest.a(graphObjAttributes.getClass("foo") == new Double(0.0).getClass());
        GraphObjAttributesTest.a(graphObjAttributes.getClass("bar") == "string".getClass());
        GraphObjAttributesTest.a(graphObjAttributes.getDoubleValue("expressionLevel", "GAL4").equals(new Double(1.8)));
        GraphObjAttributesTest.a(graphObjAttributes.getDoubleValue("expressionLevel", "GAL80").equals(new Double(0.01)));
        GraphObjAttributesTest.a(graphObjAttributes.getDoubleValue("foo", "GAL4").equals(new Double(321.23)));
        GraphObjAttributesTest.a(graphObjAttributes.getStringValue("bar", "GAL4").equals("The Columbia City Ale House"));
        GraphObjAttributes graphObjAttributes2 = new GraphObjAttributes();
        Double d2 = new Double(99.32);
        Integer n2 = new Integer(33);
        String string = "abracadabra";
        String string2 = "GAL4";
        graphObjAttributes2.set("homology", string2, d2);
        graphObjAttributes2.set("count", string2, n2);
        graphObjAttributes2.set("magic", string2, string);
        GraphObjAttributesTest.a(graphObjAttributes2.getClass("homology") == new Double(0.0).getClass());
        GraphObjAttributesTest.a(graphObjAttributes2.getClass("count") == new Integer(0).getClass());
        GraphObjAttributesTest.a(graphObjAttributes2.getClass("magic") == "string".getClass());
        GraphObjAttributesTest.a(graphObjAttributes2.getDoubleValue("homology", string2).equals(d2));
        GraphObjAttributesTest.a(graphObjAttributes2.getIntegerValue("count", string2).equals(n2));
        GraphObjAttributesTest.a(graphObjAttributes2.getStringValue("magic", string2).equals(string));
        graphObjAttributes.add(graphObjAttributes2);
        GraphObjAttributesTest.a(graphObjAttributes.hasAttribute("expressionLevel"));
        GraphObjAttributesTest.a(graphObjAttributes.hasAttribute("foo"));
        GraphObjAttributesTest.a(graphObjAttributes.hasAttribute("bar"));
        GraphObjAttributesTest.a(!graphObjAttributes.hasAttribute("BAR"));
        GraphObjAttributesTest.a(graphObjAttributes.getClass("expressionLevel") == new Double(0.0).getClass());
        GraphObjAttributesTest.a(graphObjAttributes.getClass("foo") == new Double(0.0).getClass());
        GraphObjAttributesTest.a(graphObjAttributes.getClass("bar") == "string".getClass());
        GraphObjAttributesTest.a(graphObjAttributes.getDoubleValue("expressionLevel", "GAL4").equals(new Double(1.8)));
        GraphObjAttributesTest.a(graphObjAttributes.getDoubleValue("expressionLevel", "GAL80").equals(new Double(0.01)));
        GraphObjAttributesTest.a(graphObjAttributes.getDoubleValue("foo", "GAL4").equals(new Double(321.23)));
        GraphObjAttributesTest.a(graphObjAttributes.getStringValue("bar", "GAL4").equals("The Columbia City Ale House"));
        GraphObjAttributesTest.a(graphObjAttributes2.getClass("homology") == new Double(0.0).getClass());
        GraphObjAttributesTest.a(graphObjAttributes2.getClass("count") == new Integer(0).getClass());
        GraphObjAttributesTest.a(graphObjAttributes2.getClass("magic") == "string".getClass());
        GraphObjAttributesTest.a(graphObjAttributes2.getDoubleValue("homology", string2).equals(d2));
        GraphObjAttributesTest.a(graphObjAttributes2.getIntegerValue("count", string2).equals(n2));
        GraphObjAttributesTest.a(graphObjAttributes2.getStringValue("magic", string2).equals(string));
    }

    public void testHasAttribute() throws Exception {
        AllTests.standardOut("testHasAttribute");
        GraphObjAttributes graphObjAttributes = new GraphObjAttributes();
        graphObjAttributes.set("expressionLevel", "GAL4", 1.8);
        graphObjAttributes.set("expressionLevel", "GAL80", 0.01);
        graphObjAttributes.set("foo", "GAL4", 321.23);
        GraphObjAttributesTest.a(graphObjAttributes.hasAttribute("expressionLevel"));
        GraphObjAttributesTest.a(graphObjAttributes.hasAttribute("foo"));
        GraphObjAttributesTest.a(!graphObjAttributes.hasAttribute("bar"));
        GraphObjAttributesTest.a(graphObjAttributes.getObjectCount("expressionLevel") == 2);
        GraphObjAttributesTest.a(graphObjAttributes.getObjectCount("foo") == 1);
        GraphObjAttributesTest.a(graphObjAttributes.getObjectCount("bar") == 0);
        String[] stringArray = graphObjAttributes.getAttributeNames();
        GraphObjAttributesTest.a(stringArray.length == 2);
        GraphObjAttributesTest.a(graphObjAttributes.hasAttribute("expressionLevel", "GAL4"));
        GraphObjAttributesTest.a(graphObjAttributes.hasAttribute("expressionLevel", "GAL80"));
        GraphObjAttributesTest.a(graphObjAttributes.hasAttribute("foo", "GAL4"));
        GraphObjAttributesTest.a(!graphObjAttributes.hasAttribute("foo", "GAL4bogus"));
    }

    public void testGetAttributeNames() throws Exception {
        AllTests.standardOut("testGetAttributeNames");
        GraphObjAttributes graphObjAttributes = new GraphObjAttributes();
        graphObjAttributes.set("expressionLevel", "GAL4", 1.8);
        graphObjAttributes.set("expressionLevel", "GAL80", 0.01);
        graphObjAttributes.set("foo", "GAL4", 321.23);
        GraphObjAttributesTest.a(graphObjAttributes.numberOfAttributes() == 2);
        String[] stringArray = graphObjAttributes.getAttributeNames();
        GraphObjAttributesTest.a(stringArray.length == 2);
    }

    public void testGetAttributeByName() throws Exception {
        AllTests.standardOut("testGetAttributeByName");
        GraphObjAttributes graphObjAttributes = new GraphObjAttributes();
        graphObjAttributes.set("expressionLevel", "GAL4", 1.8);
        graphObjAttributes.set("expressionLevel", "GAL80", 0.01);
        graphObjAttributes.set("foo", "GAL4", 321.23);
        GraphObjAttributesTest.a(graphObjAttributes.numberOfAttributes() == 2);
        String[] stringArray = graphObjAttributes.getAttributeNames();
        GraphObjAttributesTest.a(stringArray.length == 2);
        HashMap hashMap = graphObjAttributes.getAttribute("expressionLevel");
        GraphObjAttributesTest.a(hashMap != null);
        GraphObjAttributesTest.a(hashMap.size() == 2);
        GraphObjAttributesTest.a(graphObjAttributes.getClass("expressionLevel") == Class.forName("java.lang.Double"));
        Object v2 = hashMap.get("GAL4");
        GraphObjAttributesTest.a(v2.getClass() == Class.forName("java.lang.Double"));
        HashMap hashMap2 = graphObjAttributes.getAttribute("foo");
        GraphObjAttributesTest.a(hashMap2 != null);
        GraphObjAttributesTest.a(hashMap2.size() == 1);
        HashMap hashMap3 = graphObjAttributes.getAttribute("bar");
        GraphObjAttributesTest.a(hashMap3 == null);
    }

    public void testGetOneGeneAttribute() throws Exception {
        AllTests.standardOut("testGetOneGeneAttribute");
        GraphObjAttributes graphObjAttributes = new GraphObjAttributes();
        double d2 = 1.8;
        double d3 = 0.01;
        graphObjAttributes.set("expressionLevel", "GAL4", d2);
        graphObjAttributes.set("expressionLevel", "GAL80", d3);
        Double d4 = new Double(321.23);
        graphObjAttributes.set("foo", "GAL4", d4);
        GraphObjAttributesTest.a(graphObjAttributes.numberOfAttributes() == 2);
        Double d5 = graphObjAttributes.getDoubleValue("expressionLevel", "GAL4");
        GraphObjAttributesTest.a(d5.compareTo(new Double(d2)) == 0);
        d5 = graphObjAttributes.getDoubleValue("expressionLevel", "GAL80");
        GraphObjAttributesTest.a(d5.compareTo(new Double(d3)) == 0);
        d5 = graphObjAttributes.getDoubleValue("foo", "GAL4");
        GraphObjAttributesTest.a(d5.compareTo(d4) == 0);
        d5 = graphObjAttributes.getDoubleValue("phoo", "GAL4");
        GraphObjAttributesTest.a(d5 == null);
        d5 = graphObjAttributes.getDoubleValue("foo", "GUY4");
        GraphObjAttributesTest.a(d5 == null);
    }

    public void testTextFileReaderOnNodeAttributeData() throws Exception {
        AllTests.standardOut("testTextFileReaderOnNodeAttributeData");
        GraphObjAttributes graphObjAttributes = new GraphObjAttributes();
        GraphObjAttributesTest.a(graphObjAttributes.numberOfAttributes() == 0);
        String string = "fooB";
        graphObjAttributes.readAttributesFromFile(new File("testData/noLabels.fooB"));
        GraphObjAttributesTest.a(graphObjAttributes.numberOfAttributes() == 1);
        HashMap hashMap = graphObjAttributes.getAttribute("fooB");
        GraphObjAttributesTest.a(hashMap.size() == 333);
    }

    public void testTextFileReaderOnEdgeAttributeData() throws Exception {
        AllTests.standardOut("testTextFileReaderOnEdgeAttributeData");
        GraphObjAttributes graphObjAttributes = new GraphObjAttributes();
        GraphObjAttributesTest.a(graphObjAttributes.numberOfAttributes() == 0);
        File file = new File("testData/yeastSmall.edgeAttr.0");
        graphObjAttributes.readAttributesFromFile(file);
        GraphObjAttributesTest.a(graphObjAttributes.numberOfAttributes() == 1);
        String[] stringArray = graphObjAttributes.getAttributeNames();
        GraphObjAttributesTest.a(stringArray.length == 1);
        HashMap hashMap = graphObjAttributes.getAttribute(stringArray[0]);
        GraphObjAttributesTest.a(hashMap.size() == 27);
    }

    public void testAddAttributeHash() throws Exception {
        AllTests.standardOut("testAddAttributeHash");
        GraphObjAttributes graphObjAttributes = new GraphObjAttributes();
        GraphObjAttributesTest.a(graphObjAttributes.numberOfAttributes() == 0);
        String string = "fooB";
        graphObjAttributes.readAttributesFromFile(new File("testData/noLabels.fooB"));
        GraphObjAttributesTest.a(graphObjAttributes.numberOfAttributes() == 1);
        HashMap hashMap = graphObjAttributes.getAttribute("fooB");
        GraphObjAttributesTest.a(hashMap.size() == 333);
        File file = new File("testData/yeastSmall.edgeAttr.0");
        GraphObjAttributes graphObjAttributes2 = new GraphObjAttributes();
        graphObjAttributes2.readAttributesFromFile(file);
        GraphObjAttributesTest.a(graphObjAttributes2.numberOfAttributes() == 1);
        String[] stringArray = graphObjAttributes2.getAttributeNames();
        HashMap hashMap2 = graphObjAttributes2.getAttribute(stringArray[0]);
        graphObjAttributes.set(graphObjAttributes2);
        GraphObjAttributesTest.a(graphObjAttributes.numberOfAttributes() == 2);
        stringArray = graphObjAttributes.getAttributeNames();
        GraphObjAttributesTest.a(stringArray.length == 2);
        hashMap = graphObjAttributes.getAttribute("fooB");
        GraphObjAttributesTest.a(hashMap.size() == 333);
        HashMap hashMap3 = graphObjAttributes.getAttribute("edge_attribute_0");
        GraphObjAttributesTest.a(hashMap3.size() == 27);
    }

    public void testNodeToNameMapping() throws Exception {
        AllTests.standardOut("testNodeToNameMapping");
        GraphObjAttributes graphObjAttributes = new GraphObjAttributes();
        GraphObjAttributesTest.a(graphObjAttributes.numberOfAttributes() == 0);
        String string = "fooB";
        graphObjAttributes.readAttributesFromFile(new File("testData/noLabels.fooB"));
        GraphObjAttributesTest.a(graphObjAttributes.numberOfAttributes() == 1);
        HashMap hashMap = graphObjAttributes.getAttribute(string);
        GraphObjAttributesTest.a(hashMap.size() == 333);
        Integer n2 = new Integer(1);
        Integer n3 = new Integer(2);
        String[] stringArray = graphObjAttributes.getObjectNames(string);
        int n4 = stringArray.length / 2;
        int n5 = stringArray.length / 3;
        String string2 = stringArray[stringArray.length / 2];
        String string3 = stringArray[stringArray.length / 3];
        GraphObjAttributesTest.a(string2 != null);
        GraphObjAttributesTest.a(string3 != null);
        GraphObjAttributesTest.a(string2.length() > 0);
        GraphObjAttributesTest.a(string3.length() > 0);
        graphObjAttributes.addNameMapping(string2, n2);
        graphObjAttributes.addNameMapping(string3, n3);
        String string4 = graphObjAttributes.getCanonicalName(n2);
        GraphObjAttributesTest.a(string4.equals(string2));
        String string5 = graphObjAttributes.getCanonicalName(n3);
        GraphObjAttributesTest.a(string5.equals(string3));
        String string6 = graphObjAttributes.getCanonicalName(new Double(99999.9999));
        GraphObjAttributesTest.a(string6 == null);
    }

    public void testGetAttributesBundle() throws Exception {
        AllTests.standardOut("testGetAttributesBundle");
        GraphObjAttributes graphObjAttributes = new GraphObjAttributes();
        Double d2 = new Double(99.32);
        Integer n2 = new Integer(33);
        String string = "abracadabra";
        String string2 = "GAL4";
        graphObjAttributes.set("homology", string2, d2);
        graphObjAttributes.set("count", string2, n2);
        graphObjAttributes.set("magic", string2, string);
        HashMap hashMap = graphObjAttributes.getAttributes(string2);
        GraphObjAttributesTest.a(hashMap.size() == 3);
        Double d3 = (Double)hashMap.get("homology");
        GraphObjAttributesTest.a(d3.equals(d2));
        Integer n3 = (Integer)hashMap.get("count");
        GraphObjAttributesTest.a(n3.equals(n2));
        String string3 = (String)hashMap.get("magic");
        GraphObjAttributesTest.a(string3.equals(string));
    }

    public void testAddAttributesBundle() throws Exception {
        AllTests.standardOut("testAddAttributesBundle");
        GraphObjAttributes graphObjAttributes = new GraphObjAttributes();
        Double d2 = new Double(99.32);
        Integer n2 = new Integer(33);
        String string = "abracadabra";
        String string2 = "GAL4";
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("homology", d2);
        hashMap.put("count", n2);
        hashMap.put("magic", string);
        graphObjAttributes.set(string2, hashMap);
        HashMap hashMap2 = graphObjAttributes.getAttributes(string2);
        GraphObjAttributesTest.a(hashMap2.size() == 3);
        Double d3 = (Double)hashMap2.get("homology");
        GraphObjAttributesTest.a(d3.equals(d2));
        Integer n3 = (Integer)hashMap2.get("count");
        GraphObjAttributesTest.a(n3.equals(n2));
        String string3 = (String)hashMap2.get("magic");
        GraphObjAttributesTest.a(string3.equals(string));
    }

    public void testCountDuplicateNamesForAttribute() throws Exception {
        AllTests.standardOut("testCountDuplicateNamesForAttribute");
        GraphObjAttributes graphObjAttributes = new GraphObjAttributes();
        GraphObjAttributesTest.a(graphObjAttributes.countIdentical("A") == 0);
        GraphObjAttributesTest.a(graphObjAttributes.countIdentical("B") == 0);
        GraphObjAttributesTest.a(graphObjAttributes.countIdentical("A") == 1);
        GraphObjAttributesTest.a(graphObjAttributes.countIdentical("A") == 2);
        GraphObjAttributesTest.a(graphObjAttributes.countIdentical("B") == 1);
    }

    public void testGetAndAddNameMapping() throws Exception {
        AllTests.standardOut("testGetAndAddNameMapping");
        GraphObjAttributes graphObjAttributes = new GraphObjAttributes();
        GraphObjAttributesTest.a(graphObjAttributes.numberOfAttributes() == 0);
        String string = "fooB";
        graphObjAttributes.readAttributesFromFile(new File("testData/noLabels.fooB"));
        GraphObjAttributesTest.a(graphObjAttributes.numberOfAttributes() == 1);
        HashMap hashMap = graphObjAttributes.getAttribute(string);
        GraphObjAttributesTest.a(hashMap.size() == 333);
        Integer n2 = new Integer(1);
        Integer n3 = new Integer(2);
        String[] stringArray = graphObjAttributes.getObjectNames(string);
        int n4 = stringArray.length / 2;
        int n5 = stringArray.length / 3;
        String string2 = stringArray[n4];
        String string3 = stringArray[n5];
        GraphObjAttributesTest.a(string2 != null);
        GraphObjAttributesTest.a(string3 != null);
        GraphObjAttributesTest.a(string2.length() > 0);
        GraphObjAttributesTest.a(string3.length() > 0);
        graphObjAttributes.addNameMapping(string2, n2);
        graphObjAttributes.addNameMapping(string3, n3);
        String string4 = graphObjAttributes.getCanonicalName(n2);
        GraphObjAttributesTest.a(string4.equals(string2));
        String string5 = graphObjAttributes.getCanonicalName(n3);
        GraphObjAttributesTest.a(string5.equals(string3));
        String string6 = graphObjAttributes.getCanonicalName(new Double(99999.9999));
        GraphObjAttributesTest.a(string6 == null);
        HashMap hashMap2 = graphObjAttributes.getNameMap();
        GraphObjAttributesTest.a(hashMap2.size() == 2);
        graphObjAttributes.addNameMap(hashMap2);
        GraphObjAttributesTest.a(hashMap2.size() == 2);
        HashMap<Integer, String> hashMap3 = new HashMap<Integer, String>();
        Integer n6 = new Integer(3);
        Integer n7 = new Integer(4);
        int n8 = stringArray.length / 4;
        int n9 = stringArray.length / 5;
        String string7 = stringArray[n8];
        String string8 = stringArray[n9];
        hashMap3.put(n6, string7);
        hashMap3.put(n7, string8);
        graphObjAttributes.addNameMap(hashMap3);
        GraphObjAttributesTest.a(hashMap2.size() == 4);
        String string9 = graphObjAttributes.getCanonicalName(n6);
        GraphObjAttributesTest.a(string9.equals(string7));
        String string10 = graphObjAttributes.getCanonicalName(n7);
        GraphObjAttributesTest.a(string10.equals(string8));
        string6 = graphObjAttributes.getCanonicalName(new Double(99999.9999));
        GraphObjAttributesTest.a(string6 == null);
    }

    public void testGetAttributeClass() throws Exception {
        AllTests.standardOut("testGetAttributeClass");
        GraphObjAttributes graphObjAttributes = new GraphObjAttributes();
        Double d2 = new Double(99.32);
        Integer n2 = new Integer(33);
        String string = "abracadabra";
        String string2 = "GAL4";
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("homology", d2);
        hashMap.put("count", n2);
        hashMap.put("magic", string);
        graphObjAttributes.set(string2, hashMap);
        graphObjAttributes.setClass("homology", d2.getClass());
        graphObjAttributes.setClass("count", n2.getClass());
        graphObjAttributes.setClass("magic", string.getClass());
        GraphObjAttributesTest.a(graphObjAttributes.getClass("homology") == new Double(0.0).getClass());
        GraphObjAttributesTest.a(graphObjAttributes.getClass("count") == new Integer(0).getClass());
        GraphObjAttributesTest.a(graphObjAttributes.getClass("magic") == "string".getClass());
    }

    public void testCloning() throws Exception {
        AllTests.standardOut("testCloning");
        GraphObjAttributes graphObjAttributes = new GraphObjAttributes();
        Double d2 = new Double(99.32);
        Integer n2 = new Integer(33);
        String string = "abracadabra";
        String string2 = "GAL4";
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("homology", d2);
        hashMap.put("count", n2);
        hashMap.put("magic", string);
        graphObjAttributes.set(string2, hashMap);
        GraphObjAttributes graphObjAttributes2 = (GraphObjAttributes)graphObjAttributes.clone();
        GraphObjAttributesTest.a(graphObjAttributes != graphObjAttributes2);
        String string3 = (String)graphObjAttributes.getValue("magic", "GAL4");
        String string4 = (String)graphObjAttributes2.getValue("magic", "GAL4");
        GraphObjAttributesTest.a(string3.equals(string));
        GraphObjAttributesTest.a(string4.equals(string));
        String string5 = "shazam!";
        graphObjAttributes2.set("magic", "GAL4", string5);
        String string6 = (String)graphObjAttributes2.get("magic", "GAL4");
        GraphObjAttributesTest.a(string6.equals(string5));
        String string7 = (String)graphObjAttributes.get("magic", "GAL4");
        GraphObjAttributesTest.a(string7.equals(string));
    }

    public void testDeleteAttribute() throws Exception {
        AllTests.standardOut("testDeleteAttribute");
        GraphObjAttributes graphObjAttributes = new GraphObjAttributes();
        Double d2 = new Double(99.32);
        Integer n2 = new Integer(33);
        String string = "abracadabra";
        String string2 = "GAL4";
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("homology", d2);
        hashMap.put("count", n2);
        hashMap.put("magic", string);
        graphObjAttributes.set(string2, hashMap);
        GraphObjAttributesTest.a(graphObjAttributes.numberOfAttributes() == 3);
        graphObjAttributes.deleteAttribute("homology");
        GraphObjAttributesTest.a(graphObjAttributes.numberOfAttributes() == 2);
        GraphObjAttributesTest.a(!graphObjAttributes.hasAttribute("homology"));
        graphObjAttributes.deleteAttribute("count");
        GraphObjAttributesTest.a(graphObjAttributes.numberOfAttributes() == 1);
        GraphObjAttributesTest.a(!graphObjAttributes.hasAttribute("count"));
        graphObjAttributes.deleteAttribute("magic");
        GraphObjAttributesTest.a(graphObjAttributes.numberOfAttributes() == 0);
        GraphObjAttributesTest.a(!graphObjAttributes.hasAttribute("magic"));
    }

    public void testDeleteAttributeForOneGraphObject() throws Exception {
        AllTests.standardOut("testDeleteAttributeForOneGraphObject");
        GraphObjAttributes graphObjAttributes = new GraphObjAttributes();
        Double d2 = new Double(99.32);
        Integer n2 = new Integer(33);
        String string = "abracadabra";
        String string2 = "GAL4";
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("homology", d2);
        hashMap.put("count", n2);
        hashMap.put("magic", string);
        graphObjAttributes.set(string2, hashMap);
        GraphObjAttributesTest.a(graphObjAttributes.numberOfAttributes() == 3);
        graphObjAttributes.append("homology", "GAL80", new Double(888.88));
        GraphObjAttributesTest.a(graphObjAttributes.hasAttribute("homology", "GAL80"));
        GraphObjAttributesTest.a(graphObjAttributes.hasAttribute("homology", "GAL4"));
        GraphObjAttributesTest.a(graphObjAttributes.hasAttribute("count", "GAL4"));
        graphObjAttributes.deleteAttribute("homology", "GAL4");
        GraphObjAttributesTest.a(!graphObjAttributes.hasAttribute("homology", "GAL4"));
        GraphObjAttributesTest.a(graphObjAttributes.hasAttribute("homology", "GAL80"));
        GraphObjAttributesTest.a(graphObjAttributes.hasAttribute("count", "GAL4"));
    }

    public void testDeleteAttributeValueForOneGraphObject() throws Exception {
        AllTests.standardOut("testDeleteAttributeValueForOneGraphObject");
        GraphObjAttributes graphObjAttributes = new GraphObjAttributes();
        graphObjAttributes.append("homolog", "GAL4", "h0");
        graphObjAttributes.append("homolog", "GAL4", "h1");
        graphObjAttributes.append("homolog", "GAL4", "h2");
        GraphObjAttributesTest.a(graphObjAttributes.numberOfAttributes() == 1);
        String[] stringArray = graphObjAttributes.getStringArrayValues("homolog", "GAL4");
        GraphObjAttributesTest.a(stringArray.length == 3);
        graphObjAttributes.deleteAttributeValue("homolog", "GAL4", "h0");
        GraphObjAttributesTest.a(graphObjAttributes.getStringArrayValues("homolog", "GAL4").length == 2);
        graphObjAttributes.deleteAttributeValue("homolog", "GAL4", "h0");
        GraphObjAttributesTest.a(graphObjAttributes.getStringArrayValues("homolog", "GAL4").length == 2);
        graphObjAttributes.deleteAttributeValue("homolog", "GAL4", "hohoho");
        GraphObjAttributesTest.a(graphObjAttributes.getStringArrayValues("homolog", "GAL4").length == 2);
        graphObjAttributes.deleteAttributeValue("homolog", "GAL4", "hobo");
        GraphObjAttributesTest.a(graphObjAttributes.getStringArrayValues("homolog", "GAL4").length == 2);
        graphObjAttributes.deleteAttributeValue("homolog", "GAL5", "hobo");
        graphObjAttributes.deleteAttributeValue("homologue", "GAL4", "hobo");
        GraphObjAttributesTest.a(graphObjAttributes.getStringArrayValues("homolog", "GAL4").length == 2);
        graphObjAttributes.deleteAttributeValue("homolog", "GAL4", "h1");
        GraphObjAttributesTest.a(graphObjAttributes.getStringArrayValues("homolog", "GAL4").length == 1);
        GraphObjAttributesTest.a(graphObjAttributes.getStringArrayValues("homolog", "GAL4")[0].equals("h2"));
        graphObjAttributes.deleteAttributeValue("homolog", "GAL4", "h2");
        GraphObjAttributesTest.a(graphObjAttributes.getStringArrayValues("homolog", "GAL4").length == 0);
    }

    public void testAttributeCategories() throws Exception {
        AllTests.standardOut("testAttributeCategories");
        GraphObjAttributes graphObjAttributes = new GraphObjAttributes();
        Double d2 = new Double(99.32);
        String string = "amino acid synthesis";
        String string2 = "abracadabra";
        String string3 = "GAL4";
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("homology", d2);
        hashMap.put("biological process", string);
        hashMap.put("magic", string2);
        graphObjAttributes.set(string3, hashMap);
        GraphObjAttributesTest.a(graphObjAttributes.numberOfAttributes() == 3);
        graphObjAttributes.setCategory("homology", "numerical");
        graphObjAttributes.setCategory("biological process", "annotation");
        GraphObjAttributesTest.a(graphObjAttributes.getCategory("homology").equals("numerical"));
        GraphObjAttributesTest.a(graphObjAttributes.getCategory("magic") == null);
        GraphObjAttributesTest.a(graphObjAttributes.getCategory("biological process").equals("annotation"));
        GraphObjAttributesTest.a(graphObjAttributes.getCategory("nonexistent") == null);
    }

    public void testProcessFileHeader() throws Exception {
        AllTests.standardOut("testProcessFileHeader");
        String string = "SNP Count";
        String string2 = "SNP Count (category=data)";
        String string3 = "SNP Count (class=java.lang.Integer)";
        String string4 = "SNP Count (category=data) (class=java.lang.Integer)";
        GraphObjAttributes graphObjAttributes = new GraphObjAttributes();
        graphObjAttributes.processFileHeader(string);
        graphObjAttributes.processFileHeader(string2);
        graphObjAttributes.processFileHeader(string3);
        graphObjAttributes.processFileHeader(string4);
    }

    public void testClassDeduction() throws Exception {
        AllTests.standardOut("testClassDeduction");
        String string = "32";
        String string2 = "32.23";
        String string3 = "http://www.ncbi.nlm.nih.gov/LocusLink/LocRpt.cgi?l=3294";
        String string4 = "a very fine day in Havanna";
        Class clazz = GraphObjAttributes.deduceClass(string2);
        GraphObjAttributesTest.a(clazz == Class.forName("java.lang.Double"));
        clazz = GraphObjAttributes.deduceClass(string3);
        GraphObjAttributesTest.a(clazz == Class.forName("java.net.URL"));
        clazz = GraphObjAttributes.deduceClass(string4);
        GraphObjAttributesTest.a(clazz == Class.forName("java.lang.String"));
    }

    public void testObjectCreation() throws Exception {
        AllTests.standardOut("testObjectCreation");
        Class<?> clazz = Class.forName("java.lang.Integer");
        Class<?> clazz2 = Class.forName("java.lang.String");
        Class<?> clazz3 = Class.forName("java.lang.Double");
        Class<?> clazz4 = Class.forName("java.net.URL");
        String string = "32";
        String string2 = "http://www.ncbi.nlm.nih.gov/LocusLink/LocRpt.cgi?l=3294";
        Object object = GraphObjAttributes.createInstanceFromString(clazz, string);
        GraphObjAttributesTest.a(object.getClass() == clazz);
        object = GraphObjAttributes.createInstanceFromString(clazz2, string);
        GraphObjAttributesTest.a(object.getClass() == clazz2);
        object = GraphObjAttributes.createInstanceFromString(clazz3, string);
        GraphObjAttributesTest.a(object.getClass() == clazz3);
        object = GraphObjAttributes.createInstanceFromString(clazz4, string2);
        GraphObjAttributesTest.a(object.getClass() == clazz4);
        try {
            object = GraphObjAttributes.createInstanceFromString(clazz4, string);
            GraphObjAttributesTest.a(object.getClass() == clazz4);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            object = GraphObjAttributes.createInstanceFromString(clazz3, string2);
            GraphObjAttributesTest.a(object.getClass() == clazz2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testAttributeCategoryAndClassDetection() throws Exception {
        AllTests.standardOut("testAttributeCategoryAndClassDetection");
        GraphObjAttributes graphObjAttributes = new GraphObjAttributes();
        graphObjAttributes.readAttributesFromFile(new File("testData/implicitStringNoCategory.attribute"));
        GraphObjAttributesTest.a(graphObjAttributes.getClass("sample zero") == "string".getClass());
        GraphObjAttributesTest.a(graphObjAttributes.getCategory("sample zero").equals("unknown"));
        graphObjAttributes = new GraphObjAttributes();
        graphObjAttributes.readAttributesFromFile(new File("testData/explicitStringNoCategory.attribute"));
        GraphObjAttributesTest.a(graphObjAttributes.getClass("sample zero") == "string".getClass());
        GraphObjAttributesTest.a(graphObjAttributes.getCategory("sample zero").equals("unknown"));
        graphObjAttributes = new GraphObjAttributes();
        graphObjAttributes.readAttributesFromFile(new File("testData/implicitStringWithCategory.attribute"));
        GraphObjAttributesTest.a(graphObjAttributes.getClass("sample zero") == "string".getClass());
        GraphObjAttributesTest.a(graphObjAttributes.getCategory("sample zero").equals("annotation"));
        graphObjAttributes = new GraphObjAttributes();
        graphObjAttributes.readAttributesFromFile(new File("testData/explicitStringWithCategory.attribute"));
        GraphObjAttributesTest.a(graphObjAttributes.getClass("sample zero") == "string".getClass());
        GraphObjAttributesTest.a(graphObjAttributes.getCategory("sample zero").equals("annotation"));
        graphObjAttributes = new GraphObjAttributes();
        graphObjAttributes.readAttributesFromFile(new File("testData/explicitUrlWithCategory.attribute"));
        GraphObjAttributesTest.a(graphObjAttributes.getClass("locusLink") == Class.forName("java.net.URL"));
        GraphObjAttributesTest.a(graphObjAttributes.getCategory("locusLink").equals("annotation"));
        graphObjAttributes = new GraphObjAttributes();
        graphObjAttributes.readAttributesFromFile(new File("testData/implicitDouble.attribute"));
        GraphObjAttributesTest.a(graphObjAttributes.getClass("Score") == Class.forName("java.lang.Double"));
        GraphObjAttributesTest.a(graphObjAttributes.getCategory("Score").equals("unknown"));
        graphObjAttributes = new GraphObjAttributes();
        graphObjAttributes.readAttributesFromFile(new File("testData/implicitUrl.attribute"));
        GraphObjAttributesTest.a(graphObjAttributes.getClass("Locus Link") == Class.forName("java.net.URL"));
        GraphObjAttributesTest.a(graphObjAttributes.getCategory("Locus Link").equals("unknown"));
    }

    public void testReadArrayAttributes() throws Exception {
        AllTests.standardOut("testReadArrayAttributes");
        String string = "GO molecular function, level 4";
        GraphObjAttributes graphObjAttributes = new GraphObjAttributes();
        graphObjAttributes.readAttributesFromFile(new File("testData/implicitStringArray.attribute"));
        String string2 = "HSD17B2";
        String[] stringArray = graphObjAttributes.getStringArrayValues(string, string2);
        GraphObjAttributesTest.a(stringArray.length == 2);
        GraphObjAttributesTest.a(stringArray[0].equals("membrane"));
        GraphObjAttributesTest.a(stringArray[1].equals("intracellular"));
        string2 = "CDH3";
        stringArray = graphObjAttributes.getStringArrayValues(string, string2);
        GraphObjAttributesTest.a(stringArray.length == 1);
        GraphObjAttributesTest.a(stringArray[0].equals("cell adhesion molecule"));
        string2 = "AP1G1";
        stringArray = graphObjAttributes.getStringArrayValues(string, string2);
        GraphObjAttributesTest.a(stringArray.length == 3);
        GraphObjAttributesTest.a(stringArray[0].equals("intracellular"));
        GraphObjAttributesTest.a(stringArray[1].equals("clathrin adaptor"));
        GraphObjAttributesTest.a(stringArray[2].equals("intracellular transporter"));
        string2 = "E2F4";
        stringArray = graphObjAttributes.getStringArrayValues(string, string2);
        GraphObjAttributesTest.a(stringArray.length == 1);
        GraphObjAttributesTest.a(stringArray[0].equals("DNA binding"));
    }

    public void testGetUniqueValues() throws Exception {
        AllTests.standardOut("testGetUniqueValues");
        String string = "KEGG-2";
        GraphObjAttributes graphObjAttributes = new GraphObjAttributes();
        graphObjAttributes.append("KEGG", "GAL4", "xxx");
        graphObjAttributes.append("KEGG", "GAL4", "yyy");
        graphObjAttributes.append("KEGG", "GAL4", "zzz");
        graphObjAttributes.append("KEGG", "GAL3", "xxx");
        graphObjAttributes.append("KEGG", "GAL3", "yyy");
        graphObjAttributes.append("KEGG", "GAL3", "QQQ");
        Object[] objectArray = graphObjAttributes.getUniqueValues("KEGG");
        GraphObjAttributesTest.a(objectArray.length == 4);
        String[] stringArray = graphObjAttributes.getUniqueStringValues("KEGG");
        GraphObjAttributesTest.a(stringArray.length == 4);
    }

    public static void main(String[] stringArray) {
        dQ.a(new lD(b == null ? (b = GraphObjAttributesTest.a("cytoscape.unitTests.GraphObjAttributesTest")) : b));
    }

    public static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

