/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.unitTests;

import cytoscape.data.ExpressionData;
import cytoscape.data.mRNAMeasurement;
import cytoscape.unitTests.AllTests;
import java.io.File;
import java.util.Vector;

public class ExpressionDataTest
extends ii {
    private static String c = "testData";
    private static String b = "/gal1.22x5.mRNA";
    public static Class d;

    public ExpressionDataTest(String string) {
        super(string);
    }

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    public void testCtor() throws Exception {
        AllTests.standardOut("testCtor");
        ExpressionData expressionData = new ExpressionData(c + b);
        Vector vector = expressionData.getAllMeasurements();
        ExpressionDataTest.a(expressionData.getNumberOfGenes() == vector.size());
        if (expressionData.getNumberOfGenes() > 0) {
            String string = expressionData.getGeneNames()[0];
            Vector vector2 = (Vector)vector.get(0);
            if (expressionData.getNumberOfConditions() > 0) {
                String string2 = expressionData.getConditionNames()[0];
                mRNAMeasurement mRNAMeasurement2 = (mRNAMeasurement)vector2.get(0);
                ExpressionDataTest.a(mRNAMeasurement2.getRatio() >= -200.0);
                ExpressionDataTest.a(mRNAMeasurement2.getSignificance() >= 0.0);
            }
        }
    }

    public void testGetConditionNames() throws Exception {
        AllTests.standardOut("testGetConditionNames");
        ExpressionData expressionData = new ExpressionData(c + b);
        String[] stringArray = expressionData.getConditionNames();
        ExpressionDataTest.a(stringArray.length == expressionData.getNumberOfConditions());
    }

    public void testGetGeneNames() throws Exception {
        AllTests.standardOut("testGetGeneNames");
        ExpressionData expressionData = new ExpressionData(c + b);
        String[] stringArray = expressionData.getGeneNames();
        ExpressionDataTest.a(stringArray.length == expressionData.getNumberOfGenes());
    }

    public void testGetGeneDescriptors() throws Exception {
        AllTests.standardOut("testGetGeneDescriptors");
        ExpressionData expressionData = new ExpressionData(c + b);
        String[] stringArray = expressionData.getGeneDescriptors();
        ExpressionDataTest.a(stringArray.length == expressionData.getNumberOfGenes());
    }

    public void testGetMeasurement() throws Exception {
        AllTests.standardOut("testGetMeasurement");
        ExpressionData expressionData = new ExpressionData(c + b);
        if (expressionData.getNumberOfGenes() > 0 && expressionData.getNumberOfConditions() > 0) {
            String string = expressionData.getGeneNames()[0];
            String string2 = expressionData.getConditionNames()[0];
            mRNAMeasurement mRNAMeasurement2 = expressionData.getMeasurement(string, string2);
            double d2 = mRNAMeasurement2.getRatio();
            double d3 = mRNAMeasurement2.getSignificance();
            ExpressionDataTest.a(d2 > -100.0);
            ExpressionDataTest.a(d2 < 1000.0);
            ExpressionDataTest.a(d3 >= 0.0);
            ExpressionDataTest.a(d3 < 10000.0);
        }
    }

    public static void main(String[] stringArray) {
        File file;
        if (stringArray.length == 1) {
            c = stringArray[0];
        }
        if (!(file = new File(c)).canRead() || !file.isDirectory()) {
            System.err.println("error! ExpressionDataTest cannot read relative directory '" + c + "'");
            System.exit(1);
        }
        dQ.a(new lD(d == null ? (d = ExpressionDataTest.a("cytoscape.data.unitTests.ExpressionDataTest")) : d));
    }

    public static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

