/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.servers;

import cytoscape.data.annotation.Annotation;
import cytoscape.data.annotation.AnnotationDescription;
import cytoscape.data.servers.BioDataServerInterface;
import cytoscape.data.synonyms.Thesaurus;
import java.io.Serializable;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Date;
import java.util.HashMap;

public class BioDataServerRmi
extends UnicastRemoteObject
implements BioDataServerInterface,
Serializable {
    public HashMap d = new HashMap();
    public HashMap b = new HashMap();
    public Date c = new Date();
    public Date a = new Date();

    public void addAnnotation(Annotation annotation) {
        this.a = new Date();
        AnnotationDescription annotationDescription = new AnnotationDescription(annotation.getSpecies(), annotation.getCurator(), annotation.getType());
        if (this.d.containsKey(annotationDescription)) {
            Annotation annotation2 = (Annotation)this.d.get(annotationDescription);
            String[] stringArray = annotation.getNames();
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                int[] nArray = annotation.getClassifications(stringArray[i2]);
                for (int i3 = 0; i3 < nArray.length; ++i3) {
                    annotation2.add(stringArray[i2], nArray[i3]);
                }
            }
        } else {
            this.d.put(annotationDescription, annotation);
        }
    }

    public void clear() {
        this.d = new HashMap();
        this.a = new Date();
    }

    public int getAnnotationCount() {
        this.a = new Date();
        return this.d.size();
    }

    public AnnotationDescription[] getAnnotationDescriptions() {
        this.a = new Date();
        AnnotationDescription[] annotationDescriptionArray = this.d.keySet().toArray(new AnnotationDescription[0]);
        return annotationDescriptionArray;
    }

    public Annotation getAnnotation(String string, String string2, String string3) {
        this.a = new Date();
        AnnotationDescription annotationDescription = new AnnotationDescription(string, string2, string3);
        return this.getAnnotation(annotationDescription);
    }

    public Annotation getAnnotation(AnnotationDescription annotationDescription) {
        this.a = new Date();
        return (Annotation)this.d.get(annotationDescription);
    }

    public int[] getClassifications(String string, String string2, String string3, String string4) {
        this.a = new Date();
        AnnotationDescription annotationDescription = new AnnotationDescription(string, string2, string3);
        return this.getClassifications(annotationDescription, string4);
    }

    public int[] getClassifications(AnnotationDescription annotationDescription, String string) {
        this.a = new Date();
        Annotation annotation = (Annotation)this.d.get(annotationDescription);
        return annotation.getClassifications(string);
    }

    public String[][] getAllAnnotations(AnnotationDescription annotationDescription, String string) {
        this.a = new Date();
        Annotation annotation = (Annotation)this.d.get(annotationDescription);
        return annotation.getAllHierarchyPathsAsNames(string);
    }

    public String describe() {
        StringBuffer stringBuffer = new StringBuffer();
        Annotation[] annotationArray = this.d.values().toArray(new Annotation[0]);
        for (int i2 = 0; i2 < annotationArray.length; ++i2) {
            stringBuffer.append(annotationArray[i2]);
            stringBuffer.append("\n");
        }
        Thesaurus[] thesaurusArray = this.b.values().toArray(new Thesaurus[0]);
        for (int i3 = 0; i3 < thesaurusArray.length; ++i3) {
            stringBuffer.append(thesaurusArray[i3]);
            stringBuffer.append("\n");
        }
        stringBuffer.append("\n");
        stringBuffer.append("    started: " + this.c);
        stringBuffer.append("\n");
        stringBuffer.append("last access: " + this.a);
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public void addThesaurus(String string, Thesaurus thesaurus) {
        this.b.put(string, thesaurus);
    }

    public String getCanonicalName(String string, String string2) {
        String string3;
        Thesaurus thesaurus;
        if (this.b.containsKey(string) && (thesaurus = (Thesaurus)this.b.get(string)) != null && (string3 = thesaurus.getCanonicalName(string2)) != null) {
            return string3;
        }
        return string2;
    }

    public String[] getAllCommonNames(String string, String string2) {
        String[] stringArray;
        String[] stringArray2;
        if (this.b.containsKey(string) && (stringArray2 = (Thesaurus)this.b.get(string)) != null && (stringArray = stringArray2.getAllCommonNames(string2)) != null) {
            return stringArray;
        }
        stringArray2 = new String[]{string2};
        return stringArray2;
    }

    public String getCommonName(String string, String string2) {
        String string3;
        Thesaurus thesaurus;
        if (this.b.containsKey(string) && (thesaurus = (Thesaurus)this.b.get(string)) != null && (string3 = thesaurus.getCommonName(string2)) != null) {
            return string3;
        }
        return string2;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.err.println("usage:  BioDataServerRmi <server name>");
            System.exit(1);
        }
        String string = stringArray[0];
        try {
            BioDataServerRmi bioDataServerRmi = new BioDataServerRmi();
            Naming.rebind(string, bioDataServerRmi);
            System.out.println("BioDataServer bound as '" + string + "'");
        }
        catch (Exception exception) {
            System.err.println("BioDataServer exception: " + exception.getMessage());
            exception.printStackTrace();
        }
    }
}

