/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.servers;

import cytoscape.data.annotation.Annotation;
import cytoscape.data.annotation.AnnotationDescription;
import cytoscape.data.annotation.Ontology;
import cytoscape.data.annotation.readers.AnnotationFlatFileReader;
import cytoscape.data.annotation.readers.AnnotationXmlReader;
import cytoscape.data.annotation.readers.OntologyFlatFileReader;
import cytoscape.data.readers.TextFileReader;
import cytoscape.data.readers.TextHttpReader;
import cytoscape.data.readers.TextJarReader;
import cytoscape.data.servers.BioDataServerInterface;
import cytoscape.data.servers.BioDataServerRmi;
import cytoscape.data.synonyms.Thesaurus;
import cytoscape.data.synonyms.readers.ThesaurusFlatFileReader;
import java.io.File;
import java.net.URL;
import java.rmi.Naming;
import java.util.Vector;

public class BioDataServer {
    public BioDataServerInterface a;

    public BioDataServer(String string) throws Exception {
        if (string.indexOf("rmi://") >= 0) {
            this.a = (BioDataServerInterface)Naming.lookup(string);
        } else {
            this.a = new BioDataServerRmi();
            File file = new File(string);
            if (string.startsWith("jar://") || string.startsWith("http://") || !file.isDirectory() && file.canRead()) {
                String[] stringArray = this.a(string, "ontology");
                String[] stringArray2 = this.a(string, "annotation");
                this.loadAnnotationFiles(stringArray2, stringArray);
                String[] stringArray3 = this.a(string, "synonyms");
                this.loadThesaurusFiles(stringArray3);
            } else {
                System.err.println("could not read BioDataServer load file '" + string + "'");
            }
        }
    }

    public String[] a(String string, String string2) {
        Object object;
        String string3;
        String[] stringArray;
        File file = null;
        String string4 = null;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            if (string.trim().startsWith("jar://")) {
                stringArray = new TextJarReader(string);
                stringArray.read();
                string3 = stringArray.getText();
            } else if (string.trim().startsWith("http://")) {
                stringArray = new TextHttpReader(string);
                stringArray.read();
                string3 = stringArray.getText();
                bl3 = true;
                try {
                    object = new URL(string);
                    String string5 = ((URL)object).toString();
                    string4 = string5.substring(0, string5.lastIndexOf("/"));
                }
                catch (Exception exception) {
                    string4 = "url parsing error!";
                }
            } else {
                stringArray = new File(string);
                bl2 = true;
                file = stringArray.getAbsoluteFile().getParentFile();
                object = new TextFileReader(string);
                ((TextFileReader)object).read();
                string3 = ((TextFileReader)object).getText();
            }
        }
        catch (Exception exception) {
            System.err.println("-- Exception while reading annotation server load file " + string);
            System.err.println(exception.getMessage());
            return new String[0];
        }
        stringArray = string3.split("\n");
        object = new Vector();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string6 = stringArray[i2].trim();
            if (string6.trim().startsWith("#") || !string6.startsWith(string2)) continue;
            String string7 = string6.substring(string6.indexOf("=") + 1);
            if (bl2) {
                string7 = new File(file, string7).getPath();
            } else if (bl3) {
                string7 = string4 + "/" + string7;
            }
            ((Vector)object).add(string7);
        }
        return ((Vector)object).toArray(new String[0]);
    }

    public BioDataServer() throws Exception {
        this.a = new BioDataServerRmi();
    }

    public Ontology[] readOntologyFlatFiles(String[] stringArray) throws Exception {
        Vector<Ontology> vector = new Vector<Ontology>();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string = stringArray[i2];
            if (string.endsWith(".xml")) continue;
            OntologyFlatFileReader ontologyFlatFileReader = new OntologyFlatFileReader(string);
            vector.add(ontologyFlatFileReader.getOntology());
        }
        return vector.toArray(new Ontology[0]);
    }

    public Ontology a(Ontology[] ontologyArray, Annotation annotation) {
        for (int i2 = 0; i2 < ontologyArray.length; ++i2) {
            if (!ontologyArray[i2].getCurator().equalsIgnoreCase(annotation.getCurator())) continue;
            return ontologyArray[i2];
        }
        return null;
    }

    public void loadAnnotationFiles(String[] stringArray, String[] stringArray2) throws Exception {
        Ontology[] ontologyArray = this.readOntologyFlatFiles(stringArray2);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            Annotation annotation;
            Object object;
            String string = stringArray[i2];
            if (!string.endsWith(".xml")) {
                object = new AnnotationFlatFileReader(string);
                annotation = ((AnnotationFlatFileReader)object).getAnnotation();
                annotation.setOntology(this.a(ontologyArray, annotation));
            } else {
                object = new File(stringArray[i2]);
                AnnotationXmlReader annotationXmlReader = new AnnotationXmlReader((File)object);
                annotation = annotationXmlReader.getAnnotation();
            }
            this.a.addAnnotation(annotation);
        }
    }

    public void loadThesaurusFiles(String[] stringArray) throws Exception {
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string = stringArray[i2];
            ThesaurusFlatFileReader thesaurusFlatFileReader = new ThesaurusFlatFileReader(string);
            Thesaurus thesaurus = thesaurusFlatFileReader.getThesaurus();
            this.a.addThesaurus(thesaurus.getSpecies(), thesaurus);
        }
    }

    public void clear() {
        try {
            this.a.clear();
        }
        catch (Exception exception) {
            System.err.println("Error!  failed to clear");
            exception.printStackTrace();
        }
    }

    public void addAnnotation(Annotation annotation) {
        try {
            this.a.addAnnotation(annotation);
        }
        catch (Exception exception) {
            System.err.println("Error!  failed to add annotation " + annotation);
            exception.printStackTrace();
        }
    }

    public int getAnnotationCount() {
        try {
            int n2 = this.a.getAnnotationCount();
            return n2;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public AnnotationDescription[] getAnnotationDescriptions() {
        try {
            return this.a.getAnnotationDescriptions();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Annotation getAnnotation(String string, String string2, String string3) {
        try {
            return this.a.getAnnotation(string, string2, string3);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Annotation getAnnotation(AnnotationDescription annotationDescription) {
        try {
            return this.a.getAnnotation(annotationDescription);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int[] getClassifications(String string, String string2, String string3, String string4) {
        try {
            return this.a.getClassifications(string, string2, string3, string4);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int[] getClassifications(AnnotationDescription annotationDescription, String string) {
        try {
            return this.a.getClassifications(annotationDescription, string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String[][] getAllAnnotations(AnnotationDescription annotationDescription, String string) {
        try {
            return this.a.getAllAnnotations(annotationDescription, string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String describe() {
        try {
            return this.a.describe();
        }
        catch (Exception exception) {
            return "error connecting to data server";
        }
    }

    public void addThesaurus(String string, Thesaurus thesaurus) {
        try {
            this.a.addThesaurus(string, thesaurus);
        }
        catch (Exception exception) {
            return;
        }
    }

    public String getCanonicalName(String string, String string2) {
        try {
            return this.a.getCanonicalName(string, string2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String[] getAllCommonNames(String string, String string2) {
        try {
            return this.a.getAllCommonNames(string, string2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getCommonName(String string, String string2) {
        try {
            return this.a.getCommonName(string, string2);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

