/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.readers.unitTests;

import cytoscape.GraphObjAttributes;
import cytoscape.data.Interaction;
import cytoscape.data.readers.InteractionsReader;
import cytoscape.data.servers.BioDataServer;
import cytoscape.unitTests.AllTests;
import java.util.HashMap;

public class InteractionsReaderTest
extends ii {
    private boolean d = AllTests.runAllTests();
    private BioDataServer b = null;
    private String e = "unknown";
    public static Class c;

    public InteractionsReaderTest(String string) {
        super(string);
    }

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    public void testReadFromTypicalFile() throws Exception {
        AllTests.standardOut("testFromTypicalFile");
        InteractionsReader interactionsReader = this.a("sample.sif");
        interactionsReader.read();
        InteractionsReaderTest.a(interactionsReader.getCount() == 25);
        Interaction[] interactionArray = interactionsReader.getAllInteractions();
        InteractionsReaderTest.a(interactionArray[0].getSource().equals("YNL312W"));
        InteractionsReaderTest.a(interactionArray[0].getType().equals("pd"));
        InteractionsReaderTest.a(interactionArray[0].numberOfTargets() == 1);
        InteractionsReaderTest.a(interactionArray[0].getTargets()[0].equals("YPL111W"));
        InteractionsReaderTest.a(interactionArray[11].numberOfTargets() == 3);
    }

    public void testReadFileWithNoInteractions() throws Exception {
        AllTests.standardOut("testReadFileWithNoInteractions");
        InteractionsReader interactionsReader = this.a("degenerate.sif");
        interactionsReader.read();
        InteractionsReaderTest.a(interactionsReader.getCount() == 9);
        Interaction[] interactionArray = interactionsReader.getAllInteractions();
        for (int i2 = 0; i2 < interactionArray.length; ++i2) {
            InteractionsReaderTest.a(interactionArray[i2].getSource().startsWith("Y"));
            InteractionsReaderTest.a(interactionArray[i2].getType() == null);
            InteractionsReaderTest.a(interactionArray[i2].numberOfTargets() == 0);
        }
    }

    public void testGetGraph() throws Exception {
        AllTests.standardOut("testGetGraph");
        InteractionsReader interactionsReader = this.a("sample.sif");
        interactionsReader.read();
        InteractionsReaderTest.a(interactionsReader.getCount() == 25);
        eI eI2 = interactionsReader.getGraph();
        ap ap2 = eI2.e();
        InteractionsReaderTest.a("node count", ap2.g() == 31);
        nC nC2 = eI2.c();
        InteractionsReaderTest.a("edge count", nC2.g() == 27);
    }

    public void testGetGraphAndEdgeAttributes() throws Exception {
        AllTests.standardOut("testGetGraphAndEdgeAttributes");
        InteractionsReader interactionsReader = this.a("sample.sif");
        interactionsReader.read();
        InteractionsReaderTest.a(interactionsReader.getCount() == 25);
        eI eI2 = interactionsReader.getGraph();
        ap ap2 = eI2.e();
        InteractionsReaderTest.a("node count", ap2.g() == 31);
        nC nC2 = eI2.c();
        InteractionsReaderTest.a("edge count", nC2.g() == 27);
        GraphObjAttributes graphObjAttributes = interactionsReader.getEdgeAttributes();
        InteractionsReaderTest.a("attribute count", graphObjAttributes.size() == 2);
        HashMap hashMap = graphObjAttributes.getAttribute("interaction");
        InteractionsReaderTest.a("non-null interactions", hashMap != null);
        String[] stringArray = graphObjAttributes.getObjectNames("interaction");
        InteractionsReaderTest.a("edgeNames count", stringArray.length == 27);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            InteractionsReaderTest.a("looking for ' (pd) '", stringArray[i2].indexOf(" (pd) ") > 0);
            String string = (String)graphObjAttributes.getValue("interaction", stringArray[i2]);
            InteractionsReaderTest.a(string.equals("pd"));
        }
    }

    public void testReadMultiWordProteinsFile() throws Exception {
        AllTests.standardOut("testReadMultiWordProteinsFile");
        String string = "multiWordProteins.sif";
        InteractionsReader interactionsReader = this.a(string);
        interactionsReader.read();
        InteractionsReaderTest.a(interactionsReader.getCount() == 29);
        Interaction[] interactionArray = interactionsReader.getAllInteractions();
        InteractionsReaderTest.a(interactionArray[16].getSource().equals("26S ubiquitin dependent proteasome"));
        InteractionsReaderTest.a(interactionArray[16].getType().equals("interactsWith"));
        InteractionsReaderTest.a(interactionArray[16].numberOfTargets() == 1);
        InteractionsReaderTest.a(interactionArray[16].getTargets()[0].equals("I-kappa-B-alpha"));
        InteractionsReaderTest.a(interactionArray[28].getSource().equals("TRAF6"));
        InteractionsReaderTest.a(interactionArray[28].getType().equals("interactsWith"));
        InteractionsReaderTest.a(interactionArray[28].numberOfTargets() == 3);
        InteractionsReaderTest.a(interactionArray[28].getTargets()[0].equals("RIP2"));
        InteractionsReaderTest.a(interactionArray[28].getTargets()[1].equals("ABCDE oopah"));
        InteractionsReaderTest.a(interactionArray[28].getTargets()[2].equals("HJKOL coltrane"));
    }

    public void testReadMultiWordProteinsFileWithErrantSpaces() throws Exception {
        AllTests.standardOut("testReadMultiWordProteinsFileWithErrantSpaces");
        String string = "multiWordProteinsFileTrailingSpaces.sif";
        InteractionsReader interactionsReader = this.a(string);
        interactionsReader.read();
        InteractionsReaderTest.a(interactionsReader.getCount() == 29);
        Interaction[] interactionArray = interactionsReader.getAllInteractions();
        InteractionsReaderTest.a(interactionArray[16].getSource().equals("26S ubiquitin dependent proteasome"));
        InteractionsReaderTest.a(interactionArray[16].getType().equals("interactsWith"));
        InteractionsReaderTest.a(interactionArray[16].numberOfTargets() == 1);
        InteractionsReaderTest.a(interactionArray[16].getTargets()[0].equals("I-kappa-B-alpha"));
        InteractionsReaderTest.a(interactionArray[28].getSource().equals("TRAF6"));
        InteractionsReaderTest.a(interactionArray[28].getType().equals("interactsWith"));
        InteractionsReaderTest.a(interactionArray[28].numberOfTargets() == 3);
        InteractionsReaderTest.a(interactionArray[28].getTargets()[0].equals("RIP2"));
        InteractionsReaderTest.a(interactionArray[28].getTargets()[1].equals("ABCDE oopah"));
        InteractionsReaderTest.a(interactionArray[28].getTargets()[2].equals("HJKOL coltrane"));
    }

    private InteractionsReader a(String string) {
        if (this.d) {
            string = new String("src/cytoscape/data/readers/unitTests/" + string);
        }
        InteractionsReader interactionsReader = new InteractionsReader(this.b, this.e, string);
        return interactionsReader;
    }

    public static void main(String[] stringArray) {
        dQ.a(new lD(c == null ? (c = InteractionsReaderTest.d("cytoscape.data.readers.unitTests.InteractionsReaderTest")) : c));
    }

    public static Class d(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

