/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.readers;

import cytoscape.CytoscapeConfig;
import cytoscape.GraphObjAttributes;
import cytoscape.data.readers.GMLReader;
import cytoscape.data.readers.GraphReader;
import cytoscape.data.readers.InteractionsReader;
import cytoscape.data.servers.BioDataServer;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.jar.JarFile;

public class FileReadingAbstractions {
    public static Class a;

    public static InputStream getInputStream(String string) {
        if (string == null) {
            return null;
        }
        try {
            if (string.trim().startsWith("jar://")) {
                String string2 = string.substring(6);
                ClassLoader classLoader = (a == null ? (a = FileReadingAbstractions.a("cytoscape.data.readers.FileReadingAbstractions")) : a).getClassLoader();
                URL uRL = classLoader.getResource(string2);
                JarURLConnection jarURLConnection = (JarURLConnection)uRL.openConnection();
                JarFile jarFile = jarURLConnection.getJarFile();
                InputStream inputStream = jarFile.getInputStream(jarFile.getJarEntry(string2));
                return inputStream;
            }
            FileInputStream fileInputStream = new FileInputStream(string);
            return fileInputStream;
        }
        catch (Exception exception) {
            System.err.println("In FileReadingAbstractions.getInputStream:");
            String string3 = "Exception while constructing InputStream from file " + string;
            System.err.println(string3);
            exception.printStackTrace();
            System.err.println("returning null and continuing execution");
            return null;
        }
    }

    public static eI loadGMLBasic(String string, GraphObjAttributes graphObjAttributes, boolean bl2) {
        GMLReader gMLReader = new GMLReader(string);
        return FileReadingAbstractions.loadBasic(gMLReader, graphObjAttributes, bl2);
    }

    public static eI loadIntrBasic(BioDataServer bioDataServer, String string, String string2, GraphObjAttributes graphObjAttributes, boolean bl2) {
        InteractionsReader interactionsReader = new InteractionsReader(bioDataServer, string, string2);
        return FileReadingAbstractions.loadBasic(interactionsReader, graphObjAttributes, bl2);
    }

    public static eI loadBasic(GraphReader graphReader, GraphObjAttributes graphObjAttributes, boolean bl2) {
        graphReader.read(bl2);
        eI eI2 = graphReader.getGraph();
        if (eI2 == null) {
            return null;
        }
        GraphObjAttributes graphObjAttributes2 = graphReader.getEdgeAttributes();
        graphObjAttributes.add(graphObjAttributes2);
        graphObjAttributes.addNameMap(graphObjAttributes2.getNameMap());
        graphObjAttributes.addClassMap(graphObjAttributes2.getClassMap());
        return eI2;
    }

    public static void initAttribs(BioDataServer bioDataServer, String string, CytoscapeConfig cytoscapeConfig, eI eI2, GraphObjAttributes graphObjAttributes, GraphObjAttributes graphObjAttributes2) {
        String[] stringArray = cytoscapeConfig.getEdgeAttributeFilenames();
        String[] stringArray2 = cytoscapeConfig.getNodeAttributeFilenames();
        boolean bl2 = cytoscapeConfig.getCanonicalize();
        FileReadingAbstractions.initAttribs(bioDataServer, string, eI2, graphObjAttributes, graphObjAttributes2, stringArray2, stringArray, bl2);
    }

    public static void initAttribs(BioDataServer bioDataServer, String string, eI eI2, GraphObjAttributes graphObjAttributes, GraphObjAttributes graphObjAttributes2, String[] stringArray, String[] stringArray2, boolean bl2) {
        FileReadingAbstractions.readAttribs(bioDataServer, string, eI2, graphObjAttributes, graphObjAttributes2, stringArray, stringArray2, bl2);
        if (graphObjAttributes != null) {
            FileReadingAbstractions.a(eI2.R(), graphObjAttributes);
        }
    }

    public static void readAttribs(BioDataServer bioDataServer, String string, eI eI2, GraphObjAttributes graphObjAttributes, GraphObjAttributes graphObjAttributes2, String[] stringArray, String[] stringArray2, boolean bl2) {
        int n2;
        if (stringArray != null) {
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                try {
                    graphObjAttributes.readAttributesFromFile(bioDataServer, string, stringArray[n2], bl2);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println(numberFormatException.getMessage());
                    numberFormatException.printStackTrace();
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    System.err.println(illegalArgumentException.getMessage());
                    illegalArgumentException.printStackTrace();
                    continue;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.err.println(fileNotFoundException.getMessage());
                    fileNotFoundException.printStackTrace();
                }
            }
        }
        if (stringArray2 != null) {
            for (n2 = 0; n2 < stringArray2.length; ++n2) {
                try {
                    graphObjAttributes2.readAttributesFromFile(stringArray2[n2]);
                    continue;
                }
                catch (Exception exception) {
                    System.err.println(exception.getMessage());
                    exception.printStackTrace();
                }
            }
        }
    }

    public static void a(Object[] objectArray, GraphObjAttributes graphObjAttributes) {
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            Object object = objectArray[i2];
            String string = object.toString();
            graphObjAttributes.addNameMapping(string, object);
        }
    }

    public static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

