/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.annotation.unitTests;

import cytoscape.data.annotation.Ontology;
import cytoscape.data.annotation.OntologyDescription;
import cytoscape.data.annotation.OntologyTerm;
import cytoscape.data.annotation.unitTests.Utils;
import cytoscape.unitTests.AllTests;

public class OntologyTest
extends ii {
    public static Class b;

    public OntologyTest(String string) {
        super(string);
    }

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    public void testCtor() throws Exception {
        AllTests.standardOut("testCtor");
        String string = "KEGG";
        String string2 = "Metabolic Pathways";
        Ontology ontology = Utils.a();
        OntologyTest.a(ontology.getCurator().equals(string));
        OntologyTest.a(ontology.getType().equals(string2));
        OntologyDescription ontologyDescription = ontology.getDescription();
        OntologyTest.a(ontologyDescription.getCurator().equals(string));
        OntologyTest.a(ontologyDescription.getType().equals(string2));
    }

    public void testAdd() throws Exception {
        AllTests.standardOut("testAdd");
        String string = "KEGG";
        String string2 = "Metabolic Pathways";
        Ontology ontology = new Ontology(string, string2);
        OntologyTerm ontologyTerm = new OntologyTerm("Metabolism", 90001);
        OntologyTerm ontologyTerm2 = new OntologyTerm("Carbohydrate Metabolism", 80001);
        ontologyTerm2.addParent(ontologyTerm.getId());
        ontology.add(ontologyTerm);
        ontology.add(ontologyTerm2);
        OntologyTest.a(ontology.size() == 2);
        OntologyTest.a(ontology.containsTerm(ontologyTerm.getId()));
        OntologyTest.a(ontology.containsTerm(ontologyTerm2.getId()));
        OntologyTerm ontologyTerm3 = ontology.getTerm(ontologyTerm.getId());
        OntologyTerm ontologyTerm4 = ontology.getTerm(ontologyTerm2.getId());
        OntologyTest.a(ontologyTerm3.getName().equals("Metabolism"));
        OntologyTest.a(ontologyTerm4.getName().equals("Carbohydrate Metabolism"));
        OntologyTest.a(ontology.getTerms().size() == 2);
    }

    public void testGetHierarchyInts() throws Exception {
        AllTests.standardOut("testGetHierarchyInts");
        Ontology ontology = Utils.a();
        int[][] nArray = ontology.getAllHierarchyPaths(80001);
        OntologyTest.a(nArray.length == 1);
        OntologyTest.a(nArray[0].length == 2);
        OntologyTest.a(nArray[0][0] == 90001);
        OntologyTest.a(nArray[0][1] == 80001);
        nArray = ontology.getAllHierarchyPaths(40);
        OntologyTest.a(nArray.length == 1);
        OntologyTest.a(nArray[0].length == 3);
        OntologyTest.a(nArray[0][0] == 90001);
        OntologyTest.a(nArray[0][1] == 80001);
        OntologyTest.a(nArray[0][2] == 40);
        nArray = ontology.getAllHierarchyPaths(666);
        OntologyTest.a(nArray.length == 2);
        OntologyTest.a(nArray[0].length == 4);
        OntologyTest.a(nArray[0][0] == 90001);
        OntologyTest.a(nArray[0][1] == 80007);
        OntologyTest.a(nArray[0][2] == 500);
        OntologyTest.a(nArray[0][3] == 666);
        OntologyTest.a(nArray[1].length == 4);
        OntologyTest.a(nArray[1][0] == 90001);
        OntologyTest.a(nArray[1][1] == 80007);
        OntologyTest.a(nArray[1][2] == 530);
        OntologyTest.a(nArray[1][3] == 666);
    }

    public void testGetHierarchyNames() throws Exception {
        AllTests.standardOut("testGetHierarchyNames");
        Ontology ontology = Utils.a();
        String[][] stringArray = ontology.getAllHierarchyPathsAsNames(80001);
        this.a(stringArray);
        OntologyTest.a(stringArray.length == 1);
        OntologyTest.a(stringArray[0].length == 2);
        OntologyTest.a(stringArray[0][0].equals("Metabolism"));
        OntologyTest.a(stringArray[0][1].equals("Carbohydrate Metabolism"));
        stringArray = ontology.getAllHierarchyPathsAsNames(40);
        OntologyTest.a(stringArray.length == 1);
        OntologyTest.a(stringArray[0].length == 3);
        OntologyTest.a(stringArray[0][0].equals("Metabolism"));
        OntologyTest.a(stringArray[0][1].equals("Carbohydrate Metabolism"));
        OntologyTest.a(stringArray[0][2].equals("Nucleotide Metabolism"));
        stringArray = ontology.getAllHierarchyPathsAsNames(666);
        this.a(stringArray);
        OntologyTest.a(stringArray.length == 2);
        OntologyTest.a(stringArray[0].length == 4);
        OntologyTest.a(stringArray[0][0].equals("Metabolism"));
        OntologyTest.a(stringArray[0][1].equals("Glutamate metabolism"));
        OntologyTest.a(stringArray[0][2].equals("Biosynthesis of Secondary Metabolites"));
        OntologyTest.a(stringArray[0][3].equals("Two Parents"));
        OntologyTest.a(stringArray[1].length == 4);
        OntologyTest.a(stringArray[1][0].equals("Metabolism"));
        OntologyTest.a(stringArray[1][1].equals("Glutamate metabolism"));
        OntologyTest.a(stringArray[1][2].equals("Starch and sucrose metabolism"));
        OntologyTest.a(stringArray[1][3].equals("Two Parents"));
    }

    private void a(String[][] stringArray) {
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String[] stringArray2 = stringArray[i2];
            for (int i3 = 0; i3 < stringArray2.length; ++i3) {
                AllTests.standardOut(stringArray2[i3]);
                if (i3 >= stringArray2.length - 1) continue;
                AllTests.standardOut(", ");
            }
            AllTests.standardOut("\n");
        }
    }

    public static void main(String[] stringArray) {
        dQ.a(new lD(b == null ? (b = OntologyTest.a("cytoscape.data.annotation.unitTests.OntologyTest")) : b));
    }

    public static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

