/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.annotation.readers;

import cytoscape.data.annotation.Annotation;
import cytoscape.data.readers.TextFileReader;
import cytoscape.data.readers.TextHttpReader;
import cytoscape.data.readers.TextJarReader;
import java.io.File;

public class AnnotationFlatFileReader {
    public Annotation d;
    public String a;
    public String g;
    public String c;
    public String f;
    public String e;
    public String[] b;

    public AnnotationFlatFileReader(File file) throws Exception {
        this(file.getPath());
    }

    public AnnotationFlatFileReader(String string) throws Exception {
        this.f = string;
        try {
            if (string.trim().startsWith("jar://")) {
                TextJarReader textJarReader = new TextJarReader(string);
                textJarReader.read();
                this.e = textJarReader.getText();
            } else if (string.trim().startsWith("http://")) {
                TextHttpReader textHttpReader = new TextHttpReader(string);
                textHttpReader.read();
                this.e = textHttpReader.getText();
            } else {
                TextFileReader textFileReader = new TextFileReader(string);
                textFileReader.read();
                this.e = textFileReader.getText();
            }
        }
        catch (Exception exception) {
            System.err.println("-- Exception while reading ontology flat file " + string);
            System.err.println(exception.getMessage());
            return;
        }
        this.b = this.e.split("\n");
        this.parseHeader(this.b[0]);
        this.a();
    }

    private int a(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public void parseHeader(String string) throws Exception {
        String[] stringArray = string.trim().split("\\)");
        String string2 = "error in AnnotationFlatFileReader.parseHeader ().\n";
        string2 = string2 + "First line of " + this.f + " must have form:\n";
        string2 = string2 + "   (species=Homo sapiens) (type=Biological Process) (curator=GO)\n";
        string2 = string2 + "instead found:\n";
        string2 = string2 + "   " + string + "\n";
        if (stringArray.length != 3) {
            throw new IllegalArgumentException(string2);
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String[] stringArray2 = stringArray[i2].split("=");
            if (stringArray2.length != 2) {
                throw new IllegalArgumentException(string2);
            }
            String string3 = stringArray2[0].trim();
            String string4 = stringArray2[1].trim();
            if (string3.equalsIgnoreCase("(species")) {
                this.g = string4;
                continue;
            }
            if (string3.equalsIgnoreCase("(type")) {
                this.a = string4;
                continue;
            }
            if (!string3.equalsIgnoreCase("(curator")) continue;
            this.c = string4;
        }
    }

    private void a() throws Exception {
        this.d = new Annotation(this.g, this.a, this.c);
        for (int i2 = 1; i2 < this.b.length; ++i2) {
            String string = this.b[i2];
            if (string.length() < 2) continue;
            String[] stringArray = string.split("=");
            String string2 = stringArray[0].trim();
            int n2 = this.a(stringArray[1].trim());
            this.d.add(string2, n2);
        }
    }

    public Annotation getAnnotation() {
        return this.d;
    }
}

