/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.annotation;

import cytoscape.CytoscapeWindow;
import cytoscape.GraphObjAttributes;
import cytoscape.data.annotation.Annotation;
import cytoscape.data.annotation.AnnotationDescription;
import cytoscape.data.servers.BioDataServer;
import cytoscape.layout.AttributeLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class AnnotationGui
extends AbstractAction {
    public CytoscapeWindow m;
    public GraphObjAttributes d;
    public GraphObjAttributes h;
    public BioDataServer p;
    public String f;
    public AnnotationDescription[] g;
    public JTree a;
    public JTree j;
    public DefaultListModel b;
    public TreePath e;
    public String i;
    public AttributeLayout o;
    public eI n;
    public JButton k;
    public JButton c;
    public JButton l;

    public AnnotationGui(CytoscapeWindow cytoscapeWindow) {
        this.p = cytoscapeWindow.getBioDataServer();
        if (this.p != null) {
            this.g = this.p.getAnnotationDescriptions();
        }
        this.m = cytoscapeWindow;
        this.f = cytoscapeWindow.getDefaultSpecies();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.p == null) {
            JOptionPane.showMessageDialog(null, "No annotations are available.", "Error!", 0);
            return;
        }
        this.m.setInteractivity(false);
        this.n = this.m.getGraph();
        this.d = this.m.getNodeAttributes();
        this.h = this.m.getEdgeAttributes();
        this.o = new AttributeLayout(this.m);
        Gui gui = new Gui(this, "Annotation");
        gui.pack();
        gui.setLocationRelativeTo(this.m.getMainFrame());
        gui.setVisible(true);
        this.m.setInteractivity(true);
    }

    public String addAnnotationToNodes(AnnotationDescription annotationDescription, int n2) {
        String string = annotationDescription.getCurator() + " " + annotationDescription.getType();
        String string2 = string + " (level " + n2 + ")";
        String string3 = string + " leaf IDs";
        this.d.deleteAttribute(string2);
        this.d.deleteAttribute(string3);
        this.m.setInteractivity(false);
        HashMap hashMap = this.d.getNameMap();
        String[] stringArray = hashMap.values().toArray(new String[0]);
        int n3 = 0;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String[][] stringArray2 = this.p.getAllAnnotations(annotationDescription, stringArray[i2]);
            if (stringArray2.length == 0) {
                ++n3;
                continue;
            }
            String[] stringArray3 = this.a(stringArray2, n2);
            for (int i3 = 0; i3 < stringArray3.length; ++i3) {
                this.d.append(string2, stringArray[i2], stringArray3[i3]);
            }
            int[] nArray = this.p.getClassifications(annotationDescription, stringArray[i2]);
            Integer[] integerArray = new Integer[nArray.length];
            for (int i4 = 0; i4 < nArray.length; ++i4) {
                integerArray[i4] = new Integer(nArray[i4]);
            }
        }
        this.d.setCategory(string2, "annotation");
        this.m.setInteractivity(true);
        return string2;
    }

    private String[] a(String[][] stringArray, int n2) {
        Vector<String> vector = new Vector<String>();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string;
            int n3 = n2 - 1;
            if (n3 > stringArray[i2].length - 1) {
                n3 = stringArray[i2].length - 1;
            }
            if (vector.contains(string = stringArray[i2][n3])) continue;
            vector.add(string);
        }
        return vector.toArray(new String[0]);
    }

    public class ActionListBoxSelectionListener
    implements ListSelectionListener {
        private final AnnotationGui a;

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            Vector vector = new Vector();
            if (!listSelectionModel.isSelectionEmpty()) {
                int n2 = listSelectionModel.getMinSelectionIndex();
                int n3 = listSelectionModel.getMaxSelectionIndex();
                for (int i2 = n2; i2 <= n3; ++i2) {
                    if (!listSelectionModel.isSelectedIndex(i2)) continue;
                    Object e2 = this.a.b.elementAt(i2);
                    this.a.i = (String)e2;
                }
            }
        }
    }

    public class ApplyAnnotationAction
    extends AbstractAction {
        private final AnnotationGui a;

        public ApplyAnnotationAction(AnnotationGui annotationGui) {
            this.a = annotationGui;
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            Serializable serializable;
            int n2 = this.a.e.getPathCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                serializable = (DefaultMutableTreeNode)this.a.e.getPathComponent(i2);
                object = serializable.getUserObject();
            }
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.a.e.getPathComponent(1);
            serializable = (AnnotationDescription)defaultMutableTreeNode.getUserObject();
            object = (DefaultMutableTreeNode)this.a.e.getPathComponent(2);
            int n3 = (Integer)((DefaultMutableTreeNode)object).getUserObject();
            if (serializable == null) {
                return;
            }
            this.a.m.setInteractivity(false);
            this.a.i = this.a.addAnnotationToNodes((AnnotationDescription)serializable, n3);
            Object[] objectArray = this.a.d.getUniqueValues(this.a.i);
            if (objectArray != null && objectArray.length > 0 && objectArray[0].getClass() == "string".getClass()) {
                Arrays.sort(objectArray, String.CASE_INSENSITIVE_ORDER);
                this.a(this.a.i, objectArray);
            }
            this.a.m.setInteractivity(true);
        }

        public void a(String string, Object[] objectArray) {
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string);
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(objectArray[i2]));
            }
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)this.a.j.getModel().getRoot();
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.a.j.getModel();
            defaultTreeModel.insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode2, defaultMutableTreeNode2.getChildCount());
            this.a.j.scrollPathToVisible(new TreePath(defaultMutableTreeNode.getPath()));
            defaultTreeModel.reload();
        }
    }

    protected class Gui
    extends JDialog {
        private final AnnotationGui a;

        public Gui(AnnotationGui annotationGui, String string) {
            this.a = annotationGui;
            super((Frame)annotationGui.m.getMainFrame(), false);
            this.setTitle(string);
            this.setContentPane(this.b());
        }

        private JPanel b() {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new GridLayout(0, 2));
            this.a.a = this.a();
            this.a.j = this.c();
            this.a.a.addTreeSelectionListener(new AddAnnotationTreeSelectionListener(this));
            this.a.j.addTreeSelectionListener(new SelectNodesTreeSelectionListener(this));
            JScrollPane jScrollPane = new JScrollPane(this.a.a);
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new BorderLayout());
            jPanel3.add((Component)jScrollPane, "Center");
            this.a.k = new JButton("Apply Annotation to All Nodes");
            this.a.k.setEnabled(false);
            jPanel3.add((Component)this.a.k, "South");
            jPanel3.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Avaliable"), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
            this.a.k.addActionListener(new ApplyAnnotationAction(this.a));
            jPanel2.add(jPanel3);
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new GridLayout(0, 2));
            this.a.c = new JButton("Layout");
            this.a.c.setEnabled(false);
            jPanel4.add(this.a.c);
            this.a.c.addActionListener(new LayoutByAnnotationAction(this));
            this.a.l = new JButton("Add Edges");
            jPanel4.add(this.a.l);
            this.a.l.setEnabled(false);
            this.a.l.addActionListener(new DrawSharedEdgesAnnotationAction(this));
            JScrollPane jScrollPane2 = new JScrollPane(this.a.j);
            jScrollPane2.setPreferredSize(jScrollPane.getPreferredSize());
            JPanel jPanel5 = new JPanel();
            jPanel5.setLayout(new BorderLayout());
            jPanel5.add((Component)jScrollPane2, "Center");
            jPanel5.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Current Annotations"), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
            jPanel5.add((Component)jPanel4, "South");
            jPanel2.add(jPanel5);
            jPanel.add((Component)jPanel2, "Center");
            JPanel jPanel6 = new JPanel();
            JButton jButton = new JButton("Dismiss");
            jButton.addActionListener(new DismissAction(this));
            jPanel6.add(jButton);
            jPanel.add((Component)jPanel6, "South");
            return jPanel;
        }

        private void a(JTree jTree, TreePath treePath, boolean bl2) {
            TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
            if (treeNode.getChildCount() >= 0) {
                Enumeration<? extends TreeNode> enumeration = treeNode.children();
                while (enumeration.hasMoreElements()) {
                    TreeNode treeNode2 = enumeration.nextElement();
                    TreePath treePath2 = treePath.pathByAddingChild(treeNode2);
                    this.a(jTree, treePath2, bl2);
                }
            }
            if (bl2) {
                jTree.expandPath(treePath);
            } else {
                jTree.collapsePath(treePath);
            }
        }

        public JTree a() {
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Available Annotations");
            this.a(defaultMutableTreeNode, this.a.g);
            JTree jTree = new JTree(defaultMutableTreeNode);
            jTree.getSelectionModel().setSelectionMode(1);
            jTree.setRootVisible(false);
            jTree.setShowsRootHandles(true);
            return jTree;
        }

        public JTree c() {
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Annotations Categories");
            JTree jTree = new JTree(defaultMutableTreeNode);
            jTree.setRootVisible(false);
            jTree.setShowsRootHandles(true);
            this.a(jTree, new TreePath(defaultMutableTreeNode), true);
            return jTree;
        }

        public void a(DefaultMutableTreeNode defaultMutableTreeNode, AnnotationDescription[] annotationDescriptionArray) {
            if (annotationDescriptionArray == null || annotationDescriptionArray.length == 0) {
                return;
            }
            ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(this.a.m.getAllSpecies()));
            DefaultMutableTreeNode defaultMutableTreeNode2 = null;
            Object var5_5 = null;
            Vector<String> vector = new Vector<String>();
            for (int i2 = 0; i2 < annotationDescriptionArray.length; ++i2) {
                String string = annotationDescriptionArray[i2].getSpecies();
                if (!arrayList.contains(string)) continue;
                vector.add(annotationDescriptionArray[i2].getCurator() + ", " + annotationDescriptionArray[i2].getType() + ", " + annotationDescriptionArray[i2].getSpecies());
                defaultMutableTreeNode2 = new DefaultMutableTreeNode(annotationDescriptionArray[i2]);
                Annotation annotation = this.a.p.getAnnotation(annotationDescriptionArray[i2]);
                if (annotation == null) continue;
                int n2 = annotation.maxDepth();
                for (int i3 = 0; i3 < n2; ++i3) {
                    defaultMutableTreeNode2.add(new DefaultMutableTreeNode(new Integer(i3 + 1)));
                }
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
            }
        }

        public static AnnotationGui a(Gui gui) {
            return gui.a;
        }

        public class DrawSharedEdgesAnnotationAction
        extends AbstractAction {
            private final Gui a;

            public DrawSharedEdgesAnnotationAction(Gui gui) {
                this.a = gui;
                super("");
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Gui.a((Gui)this.a).o.doCallback(Gui.a((Gui)this.a).i, 1);
            }
        }

        public class LayoutByAnnotationAction
        extends AbstractAction {
            private final Gui a;

            public LayoutByAnnotationAction(Gui gui) {
                this.a = gui;
                super("");
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Gui.a((Gui)this.a).o.doCallback(Gui.a((Gui)this.a).i, 0);
            }
        }

        public class DismissAction
        extends AbstractAction {
            private final Gui a;

            public DismissAction(Gui gui) {
                this.a = gui;
                super("");
            }

            public void actionPerformed(ActionEvent actionEvent) {
                this.a.dispose();
            }
        }

        public class SelectNodesTreeSelectionListener
        implements TreeSelectionListener {
            private final Gui a;

            public SelectNodesTreeSelectionListener(Gui gui) {
                this.a = gui;
            }

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)Gui.a((Gui)this.a).j.getLastSelectedPathComponent();
                if (defaultMutableTreeNode == null) {
                    return;
                }
                Gui.a((Gui)this.a).c.setEnabled(!defaultMutableTreeNode.isLeaf());
                Gui.a((Gui)this.a).l.setEnabled(!defaultMutableTreeNode.isLeaf());
                if (!defaultMutableTreeNode.isLeaf()) {
                    return;
                }
                TreePath[] treePathArray = Gui.a((Gui)this.a).j.getSelectionPaths();
                HashMap hashMap = this.a(treePathArray);
                String[] stringArray = hashMap.keySet().toArray(new String[0]);
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    String string = stringArray[i2];
                    Vector vector = (Vector)hashMap.get(string);
                    String[] stringArray2 = vector.toArray(new String[0]);
                    hm[] hmArray = this.a(string, stringArray2);
                    boolean bl2 = false;
                    if (i2 == 0) {
                        bl2 = true;
                    }
                    Gui.a((Gui)this.a).m.selectNodes(hmArray, bl2);
                    Gui.a((Gui)this.a).m.redrawGraph();
                }
            }

            public HashMap a(TreePath[] treePathArray) {
                HashMap<String, Vector> hashMap = new HashMap<String, Vector>();
                for (int i2 = 0; i2 < treePathArray.length; ++i2) {
                    Vector vector;
                    String string = treePathArray[i2].getPathComponent(1).toString();
                    String string2 = treePathArray[i2].getPathComponent(2).toString();
                    if (!hashMap.containsKey(string)) {
                        vector = new Vector();
                        hashMap.put(string, vector);
                    }
                    vector = (Vector)hashMap.get(string);
                    vector.add(string2);
                }
                String[] stringArray = hashMap.keySet().toArray(new String[0]);
                return hashMap;
            }

            public hm[] a(String string, String[] stringArray) {
                Vector<hm> vector = new Vector<hm>();
                hm[] hmArray = Gui.a((Gui)this.a).n.R();
                for (int i2 = 0; i2 < hmArray.length; ++i2) {
                    Object object;
                    String string2 = Gui.a((Gui)this.a).m.getCanonicalNodeName(hmArray[i2]);
                    if (string2 == null || (object = Gui.a((Gui)this.a).d.getValue(string, string2)) == null) continue;
                    String[] stringArray2 = GraphObjAttributes.unpackPossiblyCompoundStringAttributeValue(object);
                    for (int i3 = 0; i3 < stringArray2.length; ++i3) {
                        for (int i4 = 0; i4 < stringArray.length; ++i4) {
                            if (!stringArray[i4].equals(stringArray2[i3])) continue;
                            vector.add(hmArray[i2]);
                        }
                    }
                }
                return vector.toArray(new hm[0]);
            }
        }

        public class AddAnnotationTreeSelectionListener
        implements TreeSelectionListener {
            private final Gui a;

            public AddAnnotationTreeSelectionListener(Gui gui) {
                this.a = gui;
            }

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)Gui.a((Gui)this.a).a.getLastSelectedPathComponent();
                if (defaultMutableTreeNode == null) {
                    return;
                }
                if (!defaultMutableTreeNode.isLeaf()) {
                    return;
                }
                Gui.a((Gui)this.a).e = Gui.a((Gui)this.a).a.getSelectionPaths()[0];
                Object object = defaultMutableTreeNode.getUserObject();
                Gui.a((Gui)this.a).k.setEnabled(true);
            }
        }
    }
}

