/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data;

import cytoscape.GraphObjAttributes;
import cytoscape.data.mRNAMeasurement;
import cytoscape.data.readers.TextFileReader;
import cytoscape.data.readers.TextJarReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class ExpressionData
implements Serializable {
    public String h = null;
    public int f = 0;
    public int k = 0;
    public int l = 0;
    public boolean o = false;
    public Vector g;
    public Vector m;
    public Vector c;
    public Hashtable n;
    public Hashtable a;
    public double j;
    public double i;
    public double d;
    public double p;
    public Vector b;
    public static Class e;

    public ExpressionData() {
        this.a();
    }

    public ExpressionData(String string) {
        this.a();
        this.loadData(string);
    }

    public String getFileName() {
        return this.h;
    }

    public File getFullPath() {
        File file = new File(this.h);
        return file.getAbsoluteFile();
    }

    private void a() {
        int n2 = 1000;
        if (this.g != null) {
            this.g.clear();
        }
        this.g = new Vector(0, n2);
        if (this.m != null) {
            this.m.clear();
        }
        this.m = new Vector(0, n2);
        if (this.c != null) {
            this.c.clear();
        }
        this.c = new Vector();
        if (this.n != null) {
            this.n.clear();
        }
        this.n = new Hashtable();
        if (this.a != null) {
            this.a.clear();
        }
        this.a = new Hashtable();
        this.j = Double.MAX_VALUE;
        this.i = Double.MIN_VALUE;
        this.d = Double.MAX_VALUE;
        this.p = Double.MIN_VALUE;
        if (this.b != null) {
            this.b.clear();
        }
        this.b = new Vector(0, n2);
    }

    public boolean oldLoadData(String string) {
        int n2;
        int n3;
        BufferedReader bufferedReader;
        if (string == null) {
            return false;
        }
        try {
            bufferedReader = new BufferedReader(new FileReader(string), 8192);
        }
        catch (IOException iOException) {
            System.err.println("Error trying to open data file " + string);
            return false;
        }
        String string2 = this.a(bufferedReader);
        if (this.a(string2, bufferedReader, string)) {
            return false;
        }
        if (this.a(string2)) {
            string2 = this.a(bufferedReader);
        }
        boolean bl2 = this.c(string2);
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        int n4 = stringTokenizer.countTokens();
        if (n4 < 3 || n4 < 4 && bl2) {
            System.err.println("Bad header format in data file " + string);
            System.err.println("Number of tokens parsed: " + n4);
            for (int i2 = 0; i2 < n4; ++i2) {
                System.err.println("Token " + i2 + ": " + stringTokenizer.nextToken());
            }
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }
        double d2 = (double)n4 / 2.0;
        int n5 = (int)Math.rint(d2);
        int n6 = 0;
        if (bl2) {
            if ((double)n5 == d2) {
                n3 = (n4 - 2) / 2;
                n6 = 0;
            } else {
                n3 = (n4 - 3) / 2;
                n6 = 1;
            }
        } else {
            n3 = n4 - 2;
        }
        System.out.println("parsed " + n4 + " tokens from header line," + " representing " + n3 + " conditions.");
        stringTokenizer.nextToken();
        stringTokenizer.nextToken();
        Vector<String> vector = new Vector<String>(n3);
        for (n2 = 0; n2 < n3; ++n2) {
            vector.add(stringTokenizer.nextToken());
        }
        if (bl2) {
            for (n2 = 0; n2 < n3; ++n2) {
                String string3 = stringTokenizer.nextToken();
                if (string3.equals(vector.get(n2))) continue;
                System.err.println("Expecting both ratios and p-values.\n");
                System.err.println("Condition name mismatch in header line of data file " + string + ": " + vector.get(n2) + " vs. " + string3);
                return false;
            }
        }
        this.h = string;
        this.k = n3;
        this.l = n6;
        this.a();
        this.c = vector;
        for (n2 = 0; n2 < this.k; ++n2) {
            this.a.put(this.c.get(n2), new Integer(n2));
        }
        String string4 = this.a(bufferedReader);
        int n7 = 1;
        while (string4 != null) {
            this.a(string4, ++n7, bl2);
            string4 = this.a(bufferedReader);
        }
        this.f = this.g.size();
        for (int i3 = 0; i3 < this.g.size(); ++i3) {
            this.n.put(this.g.get(i3), new Integer(i3));
        }
        this.g.trimToSize();
        this.m.trimToSize();
        this.b.trimToSize();
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public boolean loadData(String string) {
        int n2;
        int n3;
        String string2;
        String[] stringArray;
        if (string == null) {
            return false;
        }
        try {
            if (string.trim().startsWith("jar://")) {
                stringArray = new TextJarReader(string);
                stringArray.read();
                string2 = stringArray.getText();
            } else {
                stringArray = new TextFileReader(string);
                stringArray.read();
                string2 = stringArray.getText();
            }
        }
        catch (Exception exception) {
            System.err.println("-- Exception while reading expression file " + string);
            System.err.println(exception.getMessage());
            return false;
        }
        stringArray = string2.split("\n");
        int n4 = 0;
        String string3 = stringArray[n4++];
        if (string3 == null || string3.length() == 0) {
            return false;
        }
        if (this.a(string3)) {
            string3 = stringArray[n4++];
        }
        boolean bl2 = this.c(string3);
        StringTokenizer stringTokenizer = new StringTokenizer(string3);
        int n5 = stringTokenizer.countTokens();
        if (n5 < 3 || n5 < 4 && bl2) {
            System.err.println("Bad header format in data file " + string);
            System.err.println("Number of tokens parsed: " + n5);
            for (int i2 = 0; i2 < n5; ++i2) {
                System.err.println("Token " + i2 + ": " + stringTokenizer.nextToken());
            }
            return false;
        }
        double d2 = (double)n5 / 2.0;
        int n6 = (int)Math.rint(d2);
        int n7 = 0;
        if (bl2) {
            if ((double)n6 == d2) {
                n3 = (n5 - 2) / 2;
                n7 = 0;
            } else {
                n3 = (n5 - 3) / 2;
                n7 = 1;
            }
        } else {
            n3 = n5 - 2;
        }
        System.out.println("parsed " + n5 + " tokens from header line," + " representing " + n3 + " conditions.");
        stringTokenizer.nextToken();
        stringTokenizer.nextToken();
        Vector<String> vector = new Vector<String>(n3);
        for (n2 = 0; n2 < n3; ++n2) {
            vector.add(stringTokenizer.nextToken());
        }
        if (bl2) {
            for (n2 = 0; n2 < n3; ++n2) {
                String string4 = stringTokenizer.nextToken();
                if (string4.equals(vector.get(n2))) continue;
                System.err.println("Expecting both ratios and p-values.\n");
                System.err.println("Condition name mismatch in header line of data file " + string + ": " + vector.get(n2) + " vs. " + string4);
                return false;
            }
        }
        this.h = string;
        this.k = n3;
        this.l = n7;
        this.o = bl2;
        this.a();
        this.c = vector;
        for (n2 = 0; n2 < this.k; ++n2) {
            this.a.put(this.c.get(n2), new Integer(n2));
        }
        for (n2 = n4; n2 < stringArray.length; ++n2) {
            this.a(stringArray[n2], n4, bl2);
        }
        this.f = this.g.size();
        for (n2 = 0; n2 < this.g.size(); ++n2) {
            this.n.put(this.g.get(n2), new Integer(n2));
        }
        this.g.trimToSize();
        this.m.trimToSize();
        this.b.trimToSize();
        return true;
    }

    private boolean c(String string) {
        boolean bl2 = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n2 = stringTokenizer.countTokens();
        if (n2 < 3) {
            bl2 = false;
        } else {
            stringTokenizer.nextToken();
            stringTokenizer.nextToken();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            while (!bl2 && stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                String string3 = string2;
                if (hashMap.get(string3) == null) {
                    hashMap.put(string3, string3);
                    continue;
                }
                bl2 = true;
            }
        }
        return bl2;
    }

    private boolean a(String string, BufferedReader bufferedReader, String string2) {
        if (string == null) {
            System.err.println("Could not read header line from data file " + string2);
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    private boolean a(String string) {
        boolean bl2 = false;
        String string2 = "\t+RATIOS\t+LAMBDAS";
        try {
            bl2 = string.matches(string2);
        }
        catch (Exception exception) {
            System.out.println("EXCEPTION in isHeaderLineMTXHeader: " + exception);
            System.out.flush();
        }
        return bl2;
    }

    private String a(BufferedReader bufferedReader) {
        String string = null;
        try {
            string = bufferedReader.readLine();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string;
    }

    private void a(String string, int n2, boolean bl2) {
        int n3;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n4 = stringTokenizer.countTokens();
        if (n4 == 0) {
            return;
        }
        String string2 = stringTokenizer.nextToken();
        if (string2.startsWith("NumSigGenes")) {
            return;
        }
        if (bl2 && n4 < 2 * this.k + 2 || !bl2 && n4 < this.k + 2) {
            System.out.println("Warning: parse error on line " + n2 + "  tokens read: " + n4);
            return;
        }
        this.g.add(string2);
        this.m.add(stringTokenizer.nextToken());
        String[] stringArray = new String[this.k];
        for (int i2 = 0; i2 < this.k; ++i2) {
            stringArray[i2] = stringTokenizer.nextToken();
        }
        String[] stringArray2 = new String[this.k];
        if (bl2) {
            for (n3 = 0; n3 < this.k; ++n3) {
                stringArray2[n3] = stringTokenizer.nextToken();
            }
        } else {
            for (n3 = 0; n3 < this.k; ++n3) {
                stringArray2[n3] = stringArray[n3];
            }
        }
        Vector<mRNAMeasurement> vector = new Vector<mRNAMeasurement>(this.k);
        for (int i3 = 0; i3 < this.k; ++i3) {
            mRNAMeasurement mRNAMeasurement2 = new mRNAMeasurement(stringArray[i3], stringArray2[i3]);
            vector.add(mRNAMeasurement2);
            double d2 = mRNAMeasurement2.getRatio();
            double d3 = mRNAMeasurement2.getSignificance();
            if (d2 < this.j) {
                this.j = d2;
            }
            if (d2 > this.i) {
                this.i = d2;
            }
            if (d3 < this.d) {
                this.d = d3;
            }
            if (!(d3 > this.p)) continue;
            this.p = d3;
        }
        this.b.add(vector);
    }

    public String getDescription() {
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Data read from: " + this.h + string);
        stringBuffer.append(string);
        stringBuffer.append("Number of genes = " + this.getNumberOfGenes() + string);
        stringBuffer.append("Number of conditions = " + this.getNumberOfConditions() + string);
        stringBuffer.append("Significance values: ");
        if (this.o) {
            stringBuffer.append("yes");
        } else {
            stringBuffer.append("no");
        }
        stringBuffer.append(string).append(string);
        stringBuffer.append("MinExp: " + this.j + "    MaxExp: " + this.i + string);
        if (this.o) {
            stringBuffer.append("MinSig: " + this.d + "    MaxSig: " + this.p + string);
        }
        return stringBuffer.toString();
    }

    public int getNumberOfGenes() {
        return this.f;
    }

    public int getNumberOfConditions() {
        return this.k;
    }

    public String[] getGeneNames() {
        return this.g.toArray(new String[0]);
    }

    public Vector getGeneNamesVector() {
        return this.g;
    }

    public void setGeneNames(Vector vector) {
        this.g = vector;
        this.n.clear();
        for (int i2 = 0; i2 < this.g.size(); ++i2) {
            this.n.put(this.g.get(i2), new Integer(i2));
        }
    }

    public String[] getGeneDescriptors() {
        return this.m.toArray(new String[0]);
    }

    public Vector getGeneDescriptorsVector() {
        return this.m;
    }

    public void setGeneDescriptors(Vector vector) {
        this.m = vector;
    }

    public String[] getConditionNames() {
        return this.c.toArray(new String[0]);
    }

    public int getConditionIndex(String string) {
        return (Integer)this.a.get(string);
    }

    public double[][] getExtremeValues() {
        double[][] dArray = new double[2][2];
        dArray[0][0] = this.j;
        dArray[0][1] = this.i;
        dArray[1][0] = this.d;
        dArray[0][1] = this.p;
        return dArray;
    }

    public String getGeneDescriptor(String string) {
        Integer n2 = (Integer)this.n.get(string);
        if (n2 == null) {
            return null;
        }
        return (String)this.m.get(n2);
    }

    public boolean hasSignificanceValues() {
        return this.o;
    }

    public Vector getAllMeasurements() {
        return this.b;
    }

    public Vector getMeasurements(String string) {
        Integer n2 = (Integer)this.n.get(string);
        if (n2 == null) {
            return null;
        }
        Vector vector = (Vector)this.getAllMeasurements().get(n2);
        return vector;
    }

    public mRNAMeasurement getMeasurement(String string, String string2) {
        Integer n2 = (Integer)this.a.get(string2);
        if (n2 == null) {
            return null;
        }
        Vector vector = this.getMeasurements(string);
        if (vector == null) {
            return null;
        }
        mRNAMeasurement mRNAMeasurement2 = (mRNAMeasurement)vector.get(n2);
        return mRNAMeasurement2;
    }

    public void copyToAttribs(GraphObjAttributes graphObjAttributes) {
        String[] stringArray = this.getConditionNames();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string = stringArray[i2];
            String string2 = string + "exp";
            String string3 = string + "sig";
            for (int i3 = 0; i3 < this.g.size(); ++i3) {
                String string4 = (String)this.g.get(i3);
                mRNAMeasurement mRNAMeasurement2 = this.getMeasurement(string4, string);
                if (mRNAMeasurement2 == null) continue;
                graphObjAttributes.add(string2, string4, mRNAMeasurement2.getRatio());
                graphObjAttributes.add(string3, string4, mRNAMeasurement2.getSignificance());
            }
            graphObjAttributes.setClass(string2, e == null ? ExpressionData.b("java.lang.Double") : e);
            graphObjAttributes.setClass(string3, e == null ? ExpressionData.b("java.lang.Double") : e);
        }
    }

    public static Class b(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

