/*
 * Decompiled with CFR 0.152.
 */
package csplugins.vectormath;

import csplugins.vectormath.MathVector;
import csplugins.vectormath.MathVectorFactory;
import csplugins.vectormath.ReadOnlyVectorDataProvider;

public class ReadOnlyMathVector
implements ReadOnlyVectorDataProvider {
    public ReadOnlyVectorDataProvider a;

    public ReadOnlyMathVector(ReadOnlyVectorDataProvider readOnlyVectorDataProvider) {
        this.a = readOnlyVectorDataProvider;
    }

    public MathVector copy() {
        return MathVectorFactory.makeVector(this.getNewDataArray());
    }

    public ReadOnlyMathVector readOnlyCopy() {
        return MathVectorFactory.makeReadOnlyVector(this.getNewDataArray());
    }

    public double[] getNewDataArray() {
        int n2 = this.a.size();
        double[] dArray = new double[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            dArray[i2] = this.a.getQuick(i2);
        }
        return dArray;
    }

    public int size() {
        return this.a.size();
    }

    public static int verifySizeMatch(ReadOnlyMathVector readOnlyMathVector, ReadOnlyMathVector readOnlyMathVector2) throws IndexOutOfBoundsException {
        int n2 = readOnlyMathVector.a.size();
        if (n2 == readOnlyMathVector2.a.size()) {
            return n2;
        }
        String string = "vector size mismatch: first = " + n2 + ", second = " + readOnlyMathVector2.a.size();
        throw new IndexOutOfBoundsException(string);
    }

    public double get(int n2) throws IndexOutOfBoundsException {
        if (n2 > -1 && n2 < this.a.size()) {
            return this.a.getQuick(n2);
        }
        String string = "Element requested: " + n2 + ",  vector size: " + this.a.size();
        throw new IndexOutOfBoundsException(string);
    }

    public double getQuick(int n2) {
        return this.a.getQuick(n2);
    }

    public boolean equals(ReadOnlyMathVector readOnlyMathVector, double d2) throws IndexOutOfBoundsException {
        if (this.a == readOnlyMathVector.a) {
            return true;
        }
        int n2 = ReadOnlyMathVector.verifySizeMatch(this, readOnlyMathVector);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!(Math.abs(this.a.getQuick(i2) - readOnlyMathVector.a.getQuick(i2)) > d2)) continue;
            return false;
        }
        return true;
    }

    public double mag() {
        return Math.sqrt(this.magSquared());
    }

    public double magSquared() {
        double d2 = 0.0;
        for (int i2 = 0; i2 < this.a.size(); ++i2) {
            double d3 = this.a.getQuick(i2);
            d2 += d3 * d3;
        }
        return d2;
    }

    public double mean() {
        double d2 = 0.0;
        int n2 = this.a.size();
        if (n2 == 0) {
            return d2;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            d2 += this.a.getQuick(i2);
        }
        return d2 / (double)n2;
    }

    public double dot(ReadOnlyMathVector readOnlyMathVector) throws IndexOutOfBoundsException {
        int n2 = ReadOnlyMathVector.verifySizeMatch(this, readOnlyMathVector);
        double d2 = 0.0;
        for (int i2 = 0; i2 < n2; ++i2) {
            d2 += this.a.getQuick(i2) * readOnlyMathVector.a.getQuick(i2);
        }
        return d2;
    }

    public double dotNorm(ReadOnlyMathVector readOnlyMathVector) throws IndexOutOfBoundsException {
        double d2 = this.mag() * readOnlyMathVector.mag();
        return d2 == 0.0 ? 0.0 : this.dot(readOnlyMathVector) / d2;
    }

    public double correlation(ReadOnlyMathVector readOnlyMathVector) throws IndexOutOfBoundsException {
        int n2 = ReadOnlyMathVector.verifySizeMatch(this, readOnlyMathVector);
        MathVector mathVector = this.copy().subtract(this.mean());
        MathVector mathVector2 = readOnlyMathVector.copy().subtract(readOnlyMathVector.mean());
        return mathVector.dot(mathVector2) / (mathVector.mag() * mathVector2.mag());
    }

    public String toString() {
        int n2 = this.a.size();
        if (n2 < 1) {
            return new String("()");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("( " + this.a.getQuick(0));
        for (int i2 = 1; i2 < n2; ++i2) {
            stringBuffer.append(", " + this.a.getQuick(i2));
        }
        stringBuffer.append(" )");
        return stringBuffer.toString();
    }
}

