/*
 * Decompiled with CFR 0.152.
 */
package csplugins.vectormath;

import csplugins.vectormath.MathVectorFactory;
import csplugins.vectormath.ReadOnlyMathVector;
import csplugins.vectormath.VectorDataProvider;

public class MathVector
extends ReadOnlyMathVector
implements VectorDataProvider {
    public VectorDataProvider p;

    public MathVector(VectorDataProvider vectorDataProvider) {
        super(vectorDataProvider);
        this.p = vectorDataProvider;
    }

    public void set(int n2, double d2) throws IndexOutOfBoundsException {
        if (n2 <= -1 || n2 >= this.p.size()) {
            String string = "Element requested: " + n2 + ",  vector size: " + this.p.size();
            throw new IndexOutOfBoundsException(string);
        }
        this.p.setQuick(n2, d2);
    }

    public void setQuick(int n2, double d2) {
        this.p.setQuick(n2, d2);
    }

    public MathVector normalize() {
        double d2 = this.mag();
        if (d2 == 0.0) {
            return this;
        }
        for (int i2 = 0; i2 < this.p.size(); ++i2) {
            this.p.setQuick(i2, this.p.getQuick(i2) / d2);
        }
        return this;
    }

    public MathVector add(ReadOnlyMathVector readOnlyMathVector) throws IndexOutOfBoundsException {
        int n2 = ReadOnlyMathVector.verifySizeMatch(this, readOnlyMathVector);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.p.setQuick(i2, this.p.getQuick(i2) + readOnlyMathVector.a.getQuick(i2));
        }
        return this;
    }

    public static MathVector sum(ReadOnlyMathVector readOnlyMathVector, ReadOnlyMathVector readOnlyMathVector2) throws IndexOutOfBoundsException {
        int n2 = ReadOnlyMathVector.verifySizeMatch(readOnlyMathVector, readOnlyMathVector2);
        double[] dArray = new double[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            dArray[i2] = readOnlyMathVector.getQuick(i2) + readOnlyMathVector2.getQuick(i2);
        }
        return MathVectorFactory.makeVector(dArray);
    }

    public MathVector subtract(ReadOnlyMathVector readOnlyMathVector) throws IndexOutOfBoundsException {
        int n2 = ReadOnlyMathVector.verifySizeMatch(this, readOnlyMathVector);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.p.setQuick(i2, this.p.getQuick(i2) - readOnlyMathVector.a.getQuick(i2));
        }
        return this;
    }

    public static MathVector difference(ReadOnlyMathVector readOnlyMathVector, ReadOnlyMathVector readOnlyMathVector2) throws IndexOutOfBoundsException {
        int n2 = ReadOnlyMathVector.verifySizeMatch(readOnlyMathVector, readOnlyMathVector2);
        double[] dArray = new double[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            dArray[i2] = readOnlyMathVector.getQuick(i2) - readOnlyMathVector2.getQuick(i2);
        }
        return MathVectorFactory.makeVector(dArray);
    }

    public MathVector add(double d2) {
        for (int i2 = 0; i2 < this.p.size(); ++i2) {
            this.p.setQuick(i2, this.p.getQuick(i2) + d2);
        }
        return this;
    }

    public MathVector subtract(double d2) {
        for (int i2 = 0; i2 < this.p.size(); ++i2) {
            this.p.setQuick(i2, this.p.getQuick(i2) - d2);
        }
        return this;
    }

    public MathVector times(double d2) {
        for (int i2 = 0; i2 < this.p.size(); ++i2) {
            this.p.setQuick(i2, d2 * this.p.getQuick(i2));
        }
        return this;
    }

    public MathVector pow(double d2) {
        for (int i2 = 0; i2 < this.p.size(); ++i2) {
            double d3 = this.p.getQuick(i2);
            this.p.setQuick(i2, Math.pow(d3, d2));
        }
        return this;
    }

    public static double magSum(ReadOnlyMathVector readOnlyMathVector, ReadOnlyMathVector readOnlyMathVector2) throws IndexOutOfBoundsException {
        return Math.sqrt(MathVector.magSumSquared(readOnlyMathVector, readOnlyMathVector2));
    }

    public static double magSumSquared(ReadOnlyMathVector readOnlyMathVector, ReadOnlyMathVector readOnlyMathVector2) {
        int n2 = ReadOnlyMathVector.verifySizeMatch(readOnlyMathVector, readOnlyMathVector2);
        double d2 = 0.0;
        for (int i2 = 0; i2 < n2; ++i2) {
            double d3 = readOnlyMathVector.getQuick(i2) + readOnlyMathVector2.getQuick(i2);
            d2 += d3 * d3;
        }
        return d2;
    }

    public static double magDiff(ReadOnlyMathVector readOnlyMathVector, ReadOnlyMathVector readOnlyMathVector2) throws IndexOutOfBoundsException {
        return Math.sqrt(MathVector.magDiffSquared(readOnlyMathVector, readOnlyMathVector2));
    }

    public static double magDiffSquared(ReadOnlyMathVector readOnlyMathVector, ReadOnlyMathVector readOnlyMathVector2) {
        int n2 = ReadOnlyMathVector.verifySizeMatch(readOnlyMathVector, readOnlyMathVector2);
        double d2 = 0.0;
        for (int i2 = 0; i2 < n2; ++i2) {
            double d3 = readOnlyMathVector.getQuick(i2) - readOnlyMathVector2.getQuick(i2);
            d2 += d3 * d3;
        }
        return d2;
    }
}

