/*
 * Decompiled with CFR 0.152.
 */
package csplugins.trial.pshannon.dataCube.ops;

import csplugins.trial.pshannon.dataCube.DataMatrixLens;
import csplugins.vectormath.MathVector;
import csplugins.vectormath.MathVectorFactory;
import csplugins.vectormath.ReadOnlyMathVector;
import cytoscape.GraphObjAttributes;
import java.util.HashMap;
import java.util.Map;

public class CorrelationFinder {
    private DataMatrixLens a;
    private Map b = new HashMap();
    private GraphObjAttributes c;

    public CorrelationFinder() {
    }

    public CorrelationFinder(DataMatrixLens dataMatrixLens) {
        this.setDataMatrixLens(dataMatrixLens);
    }

    public void setDataMatrixLens(DataMatrixLens dataMatrixLens) {
        this.a = dataMatrixLens;
    }

    public void setNodeAttributes(GraphObjAttributes graphObjAttributes) {
        this.c = graphObjAttributes;
    }

    public Map buildCorrelationTable(String string) {
        this.b.clear();
        if (this.a == null) {
            return this.b;
        }
        double[] dArray = this.a.get(string);
        if (dArray.length == 0) {
            return this.b;
        }
        ReadOnlyMathVector readOnlyMathVector = MathVectorFactory.makeReadOnlyVector(dArray);
        return this.buildCorrelationTable(readOnlyMathVector);
    }

    public Map buildCorrelationTable(String[] stringArray) {
        this.b.clear();
        if (this.a == null || stringArray == null || stringArray.length == 0) {
            return this.b;
        }
        int n2 = this.a.getColumnCount();
        double[] dArray = new double[n2];
        MathVector mathVector = MathVectorFactory.makeVector(dArray);
        int n3 = 0;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            double[] dArray2 = this.a.get(stringArray[i2]);
            ReadOnlyMathVector readOnlyMathVector = MathVectorFactory.makeReadOnlyVector(dArray2);
            mathVector.add(readOnlyMathVector.copy().normalize());
            ++n3;
        }
        if (n3 == 0) {
            return this.b;
        }
        mathVector.times(1.0 / (double)n3);
        return this.buildCorrelationTable(mathVector);
    }

    public Map buildCorrelationTable(ReadOnlyMathVector readOnlyMathVector) {
        this.b.clear();
        int n2 = this.a.getColumnCount();
        if (readOnlyMathVector.size() != n2) {
            return this.b;
        }
        String[] stringArray = this.a.getRowTitles();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            double[] dArray = this.a.get(stringArray[i2]);
            ReadOnlyMathVector readOnlyMathVector2 = MathVectorFactory.makeReadOnlyVector(dArray);
            Double d2 = new Double(readOnlyMathVector.dotNorm(readOnlyMathVector2));
            this.b.put(stringArray[i2], d2);
        }
        return this.b;
    }

    public Map getCorrelationTable() {
        return this.b;
    }
}

