/*
 * Decompiled with CFR 0.152.
 */
package csplugins.serializable;

import csplugins.serializable.CoreCytoscapeObjects;
import csplugins.serializable.CytoscapeSerializeAction;
import csplugins.util.IndeterminateProgressBar;
import csplugins.util.SwingWorker;
import cytoscape.CytoscapeWindow;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JOptionPane;

public class CytoscapeSerializePlugIn {
    public CytoscapeWindow b;
    public CytoscapeSerializeAction c;
    public File a;

    public CytoscapeSerializePlugIn(CytoscapeWindow cytoscapeWindow) {
        this(cytoscapeWindow, null, 0, null, null);
    }

    public CytoscapeSerializePlugIn(CytoscapeWindow cytoscapeWindow, String string, int n2, JMenu jMenu, CoreCytoscapeObjects coreCytoscapeObjects) {
        this.b = cytoscapeWindow;
        if (coreCytoscapeObjects == null) {
            coreCytoscapeObjects = new CoreCytoscapeObjects(this.b);
        }
        this.c = new CytoscapeSerializeAction(coreCytoscapeObjects);
        this.a = new File(System.getProperty("user.dir"));
        if (jMenu == null) {
            jMenu = this.b.getOperationsMenu();
        }
        if (string == null) {
            string = "Workspace";
        }
        JMenu jMenu2 = new JMenu(string);
        jMenu2.add(new SerializeAction(this));
        jMenu2.add(new DeserializeAction(this));
        jMenu.insert(jMenu2, n2);
    }

    public CytoscapeSerializePlugIn(CytoscapeWindow cytoscapeWindow, CoreCytoscapeObjects coreCytoscapeObjects) {
        this(cytoscapeWindow, null, 0, null, coreCytoscapeObjects);
    }

    public boolean deserialize(String string) {
        IndeterminateProgressBar indeterminateProgressBar = new IndeterminateProgressBar((Frame)this.b.getMainFrame(), "Opening", "Opening work space. Please wait...");
        indeterminateProgressBar.setResizable(false);
        indeterminateProgressBar.pack();
        indeterminateProgressBar.setLocationRelativeTo(this.b);
        indeterminateProgressBar.setVisible(true);
        CoreCytoscapeObjects coreCytoscapeObjects = null;
        try {
            coreCytoscapeObjects = this.c.deserialize(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            indeterminateProgressBar.dispose();
            JOptionPane.showMessageDialog(null, "Could not find file \"" + string + "\".\n", "Error", 0);
            return false;
        }
        catch (IOException iOException) {
            indeterminateProgressBar.dispose();
            String string2 = iOException.getLocalizedMessage();
            System.out.println("ERROR: " + iOException);
            System.out.println("MESSAGE: " + string2);
            iOException.printStackTrace();
            JOptionPane.showMessageDialog(null, "Could not open or read file \"" + string + "\".\n", "Error", 0);
            return false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            indeterminateProgressBar.dispose();
            JOptionPane.showMessageDialog(null, "Class not found exception \"" + string + "\".\n", "Error", 0);
            return false;
        }
        if (coreCytoscapeObjects == null) {
            this.b.setInteractivity(true);
            return false;
        }
        this.b.setGraph(coreCytoscapeObjects.getGraph());
        this.b.setNodeAttributes(coreCytoscapeObjects.getNodeAttributes(), true);
        this.b.setEdgeAttributes(coreCytoscapeObjects.getEdgeAttributes());
        this.b.setExpressionData(coreCytoscapeObjects.getExpressionData());
        this.b.redrawGraph(false);
        coreCytoscapeObjects.setCytoscapeWindow(this.b);
        coreCytoscapeObjects.serializeCallBack();
        indeterminateProgressBar.dispose();
        return true;
    }

    public boolean serialize(String string) {
        try {
            this.c.serialize(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(null, "Could not open or read file \"" + string + "\".\n", "Error", 0);
            return false;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            JOptionPane.showMessageDialog(null, "Could not open or read file \"" + string + "\".\n", "Error", 0);
            return false;
        }
        return true;
    }

    protected class SerializeAction
    extends AbstractAction {
        private final CytoscapeSerializePlugIn a;

        public SerializeAction(CytoscapeSerializePlugIn cytoscapeSerializePlugIn) {
            this.a = cytoscapeSerializePlugIn;
            super("Save");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SwingWorker swingWorker = new SwingWorker(this){
                private final SerializeAction a;
                {
                    this.a = serializeAction;
                }

                public Object construct() {
                    SerializeAction.a((SerializeAction)this.a).b.setInteractivity(false);
                    JFileChooser jFileChooser = new JFileChooser(SerializeAction.a((SerializeAction)this.a).a);
                    if (jFileChooser.showSaveDialog(SerializeAction.a((SerializeAction)this.a).b) == 0) {
                        SerializeAction.a((SerializeAction)this.a).a = jFileChooser.getCurrentDirectory();
                        String string = jFileChooser.getSelectedFile().toString();
                        SerializeAction.a(this.a).serialize(string);
                    }
                    SerializeAction.a((SerializeAction)this.a).b.setInteractivity(true);
                    return null;
                }
            };
            swingWorker.start();
        }

        public static CytoscapeSerializePlugIn a(SerializeAction serializeAction) {
            return serializeAction.a;
        }
    }

    protected class DeserializeAction
    extends AbstractAction {
        private final CytoscapeSerializePlugIn a;

        public DeserializeAction(CytoscapeSerializePlugIn cytoscapeSerializePlugIn) {
            this.a = cytoscapeSerializePlugIn;
            super("Open");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SwingWorker swingWorker = new SwingWorker(this){
                private final DeserializeAction a;
                {
                    this.a = deserializeAction;
                }

                public Object construct() {
                    DeserializeAction.a((DeserializeAction)this.a).b.setInteractivity(false);
                    JFileChooser jFileChooser = new JFileChooser(DeserializeAction.a((DeserializeAction)this.a).a);
                    if (jFileChooser.showOpenDialog(DeserializeAction.a((DeserializeAction)this.a).b) == 0) {
                        DeserializeAction.a((DeserializeAction)this.a).a = jFileChooser.getCurrentDirectory();
                        String string = jFileChooser.getSelectedFile().toString();
                        DeserializeAction.a(this.a).deserialize(string);
                    }
                    DeserializeAction.a((DeserializeAction)this.a).b.setInteractivity(true);
                    return null;
                }
            };
            swingWorker.start();
        }

        public static CytoscapeSerializePlugIn a(DeserializeAction deserializeAction) {
            return deserializeAction.a;
        }
    }
}

