/*
 * Decompiled with CFR 0.152.
 */
package csplugins.serializable;

import csplugins.serializable.CoreCytoscapeObjects;
import java.awt.event.ActionEvent;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.AbstractAction;

public class CytoscapeSerializeAction
extends AbstractAction {
    public CoreCytoscapeObjects a;

    public CytoscapeSerializeAction(CoreCytoscapeObjects coreCytoscapeObjects) {
        this.a = coreCytoscapeObjects;
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    public CoreCytoscapeObjects deserialize(String string) throws FileNotFoundException, IOException, ClassNotFoundException {
        System.out.println("In CytoscapeSerializeAction.deserialize()...");
        ObjectInputStream objectInputStream = null;
        if (string.trim().startsWith("jar://")) {
            string = string.substring(6);
            ClassLoader classLoader = this.getClass().getClassLoader();
            URL uRL = classLoader.getResource(string);
            if (uRL == null) {
                System.out.println("In CytoscapeSerializeAction.deserialize(): the resource could not be found or the permission privileges prevents obtaining the resource");
                return null;
            }
            JarURLConnection jarURLConnection = (JarURLConnection)uRL.openConnection();
            JarFile jarFile = jarURLConnection.getJarFile();
            if (jarFile == null) {
                System.out.println("In CytoscapeSerializeAction.deserialize(): the JarFile returned by juc.getJarFile() is null");
                return null;
            }
            JarEntry jarEntry = jarFile.getJarEntry(string);
            if (jarEntry == null) {
                System.out.println("In CytoscapeSerializeAction.deserialize(): the JarEntry " + string + " was not found in " + jarFile);
                return null;
            }
            InputStream inputStream = null;
            try {
                inputStream = jarFile.getInputStream(jarEntry);
            }
            catch (SecurityException securityException) {
                System.out.println("Could not deserialize. The JarEntry was not properly signed.");
                securityException.printStackTrace();
                return null;
            }
            objectInputStream = new ObjectInputStream(inputStream);
        } else {
            FileInputStream fileInputStream = new FileInputStream(string);
            objectInputStream = new ObjectInputStream(fileInputStream);
        }
        this.a = (CoreCytoscapeObjects)objectInputStream.readObject();
        System.out.println("Leaving CytoscapeSerializeAction.deserialize()");
        return this.a;
    }

    public CoreCytoscapeObjects getCoreCytoscapeObjects() {
        return this.a;
    }

    public void serialize(String string) throws FileNotFoundException, IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
        objectOutputStream.writeObject(this.a);
        objectOutputStream.flush();
        objectOutputStream.close();
    }
}

