/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.dreiss.visualClustering;

import csplugins.isb.dreiss.visualClustering.AttributeChooser;
import csplugins.isb.dreiss.visualClustering.VisualClusteringPlugin;
import cytoscape.CytoscapeWindow;
import cytoscape.GraphObjAttributes;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AttributeChooser
extends JDialog
implements ActionListener,
ListSelectionListener {
    public JList k;
    public JButton j;
    public JButton c;
    public JTabbedPane e;
    public String[] g;
    public VisualClusteringPlugin f;
    public String[] d;
    public GraphObjAttributes b;
    public Map h = new HashMap();
    public static Class i;
    public static Class a;

    public AttributeChooser(VisualClusteringPlugin visualClusteringPlugin, CytoscapeWindow cytoscapeWindow, String[] stringArray) {
        super((Frame)cytoscapeWindow.getMainFrame(), false);
        this.f = visualClusteringPlugin;
        this.b = cytoscapeWindow.getNodeAttributes();
        this.setTitle("Choose attribute(s) for graph layout");
        this.g = stringArray;
        Arrays.sort(this.g, String.CASE_INSENSITIVE_ORDER);
        this.e = new JTabbedPane();
        this.e.setTabLayoutPolicy(1);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(20, 20));
        jPanel.setBorder(new EmptyBorder(new Insets(20, 40, 20, 40)));
        jPanel.add((Component)new JLabel("Select multiple attributes by Shift-clicking."), "North");
        this.k = new JList<String>(this.g);
        this.k.setSelectionMode(2);
        ListSelectionModel listSelectionModel = this.k.getSelectionModel();
        listSelectionModel.addListSelectionListener(this);
        this.k.addMouseListener(new MouseAdapter(this){
            private final AttributeChooser a;
            {
                this.a = attributeChooser;
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    this.a.a();
                }
            }
        });
        JPanel jPanel2 = new JPanel(new BorderLayout(20, 20));
        JScrollPane jScrollPane = new JScrollPane(this.k);
        jPanel2.add((Component)jScrollPane, "Center");
        JPanel jPanel3 = new JPanel(new GridLayout(3, 2));
        JCheckBox jCheckBox = new JCheckBox("Re-layout", true);
        jPanel3.add(jCheckBox);
        this.h.put("re-layout", jCheckBox);
        jCheckBox = new JCheckBox("Hide old edges first", true);
        jPanel3.add(jCheckBox);
        this.h.put("hide others", jCheckBox);
        jCheckBox = new JCheckBox("Hide new edges", false);
        jPanel3.add(jCheckBox);
        this.h.put("hide", jCheckBox);
        jCheckBox = new JCheckBox("Restore old edges", false);
        jPanel3.add(jCheckBox);
        this.h.put("restore", jCheckBox);
        jCheckBox = new JCheckBox("Edges between closest only", true);
        jPanel3.add(jCheckBox);
        this.h.put("closest", jCheckBox);
        jPanel2.add((Component)jPanel3, "South");
        jPanel.add(jPanel2);
        JPanel jPanel4 = new JPanel();
        this.c = new JButton("Configure");
        this.c.addActionListener(this);
        this.c.setEnabled(false);
        jPanel4.add(this.c);
        jPanel.add((Component)jPanel4, "South");
        jPanel4 = new JPanel();
        this.j = new JButton("Apply");
        this.j.addActionListener(this);
        this.j.setEnabled(false);
        jPanel4.add(this.j);
        JButton jButton = new JButton("Cancel");
        jButton.addActionListener(this);
        jPanel4.add((Component)jButton, "East");
        this.getContentPane().add((Component)jPanel4, "South");
        this.e.addTab("Main", jPanel);
        this.getContentPane().add((Component)this.e, "Center");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Configure")) {
            this.a();
        } else if (string.equals("Cancel")) {
            this.h.clear();
            this.dispose();
        } else if (string.equals("Apply")) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (this.d != null && this.d.length > 0) {
                this.f.doCallback(this.d, this);
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.h.clear();
            this.dispose();
        }
    }

    public boolean doRelayout() {
        return ((JCheckBox)this.h.get("re-layout")).isSelected();
    }

    public boolean hideOthers() {
        return ((JCheckBox)this.h.get("hide others")).isSelected();
    }

    public boolean deleteEdges() {
        return ((JCheckBox)this.h.get("hide")).isSelected();
    }

    public boolean restoreOthers() {
        return ((JCheckBox)this.h.get("restore")).isSelected();
    }

    public Map getConfiguration(String string) {
        return (Map)this.h.get(string);
    }

    public boolean closestOnly() {
        return ((JCheckBox)this.h.get("closest")).isSelected();
    }

    public double getScaling(String string) {
        Map map = this.getConfiguration(string);
        if (map == null || map.get("scaling") == null) {
            return 50.0;
        }
        return Double.parseDouble(((JLabel)map.get("scaling")).getText().trim());
    }

    public double getRange(String string) {
        Map map = this.getConfiguration(string);
        if (map == null || map.get("range") == null) {
            return 0.0;
        }
        return Double.parseDouble(((JLabel)map.get("range")).getText().trim());
    }

    public boolean getRelative(String string) {
        Map map = this.getConfiguration(string);
        if (map == null || map.get("relative") == null) {
            return false;
        }
        return ((JCheckBox)map.get("relative")).isSelected();
    }

    public boolean getCombineViaAnd(String string) {
        Map map = this.getConfiguration(string);
        if (map == null || map.get("andor") == null) {
            return false;
        }
        return ((JCheckBox)map.get("andor")).isSelected();
    }

    public int getCorrelationType(String string) {
        Map map = this.getConfiguration(string);
        if (map == null || map.get("corrType") == null) {
            return 1;
        }
        ButtonGroup buttonGroup = (ButtonGroup)map.get("corrType");
        Enumeration<AbstractButton> enumeration = buttonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            JRadioButton jRadioButton = (JRadioButton)enumeration.nextElement();
            if (!jRadioButton.isSelected()) continue;
            if (jRadioButton.getText().toLowerCase().startsWith("Dot")) {
                return 1;
            }
            if (jRadioButton.getText().toLowerCase().startsWith("Pearson")) {
                return 2;
            }
            if (!jRadioButton.getText().toLowerCase().startsWith("Equivalence")) continue;
            return 3;
        }
        return 1;
    }

    public void a() {
        if (this.d == null || this.d.length <= 0) {
            return;
        }
        int n2 = this.e.getTabCount() - 1;
        while (n2 > 0) {
            String string = this.e.getTitleAt(n2);
            this.e.remove(n2);
            this.h.remove(string);
            --n2;
        }
        int n3 = 0;
        while (n3 < this.d.length) {
            JPanel jPanel;
            String string = this.d[n3];
            boolean bl2 = string.equals("mRNA co-regulation");
            boolean bl3 = !bl2 && string.equals("sequence homology");
            HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
            this.h.put(string, hashMap);
            Class clazz = this.b.getClass(string);
            Object[] objectArray = this.b.getUniqueValues(string);
            JPanel jPanel2 = new JPanel(new FlowLayout(1, 10, 10));
            jPanel2.setBorder(new TitledBorder(new EtchedBorder(), "Node attribute: " + string));
            JPanel jPanel3 = new JPanel(new BorderLayout(5, 5));
            JPanel jPanel4 = new JPanel(new BorderLayout());
            JCheckBox jCheckBox = new JCheckBox("Add via AND (not OR)");
            jPanel4.add((Component)jCheckBox, "North");
            hashMap.put("andor", jCheckBox);
            JTextArea jTextArea = new JTextArea();
            jTextArea.setBackground((Color)UIManager.getDefaults().get("Button.background"));
            jTextArea.setEditable(false);
            jTextArea.setFont(new Font("Dialog", 1, 12));
            jTextArea.setLineWrap(true);
            jTextArea.setText("Set the relative influence of attribute \"" + string + "\" on the clustering:");
            jTextArea.setWrapStyleWord(true);
            jPanel4.add((Component)jTextArea, "Center");
            jPanel3.add((Component)jPanel4, "North");
            JPanel jPanel5 = new JPanel(new FlowLayout(0, 10, 10));
            JSlider jSlider = new JSlider(0, 100, 50);
            ChangeListener changeListener = new ChangeListener(this){
                private final AttributeChooser a;
                {
                    this.a = attributeChooser;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    this.setText("" + (double)((JSlider)changeEvent.getSource()).getValue() / 100.0);
                }
            };
            ((JLabel)((Object)changeListener)).setText("0.5 ");
            hashMap.put("scaling", (Serializable)((Object)changeListener));
            jSlider.addChangeListener(changeListener);
            jPanel5.add(jSlider);
            jPanel5.add((Component)((Object)changeListener));
            jPanel4.add((Component)jPanel5, "South");
            jPanel2.add(jPanel3);
            if (clazz != null && clazz.equals(i == null ? AttributeChooser.a("java.lang.Integer") : i) || clazz != null && clazz.equals(a == null ? AttributeChooser.a("java.lang.Double") : a) || clazz == null && (bl2 || bl3)) {
                jPanel = new JPanel(new BorderLayout(5, 5));
                jTextArea = new JTextArea();
                jTextArea.setBackground((Color)UIManager.getDefaults().get("Button.background"));
                jTextArea.setEditable(false);
                jTextArea.setFont(new Font("Dialog", 1, 12));
                jTextArea.setLineWrap(true);
                jTextArea.setWrapStyleWord(true);
                if (!bl2 && !bl3) {
                    jTextArea.setText("Set the range within which nodes with attribute \"" + string + "\" are judged to be equivalent:");
                } else if (bl2) {
                    jTextArea.setText("Set the minimum correlation value to use for nodes with equivalent expression levels:");
                } else if (bl3) {
                    jTextArea.setText("Set the minimum Smith-Waterman match score to use for nodes with equivalent expression levels:");
                }
                jPanel.add((Component)jTextArea, "North");
                jPanel5 = new JPanel(new FlowLayout(0, 10, 10));
                if (clazz != null && clazz.equals(i == null ? AttributeChooser.a("java.lang.Integer") : i)) {
                    int n4 = Integer.MAX_VALUE;
                    int n5 = Integer.MIN_VALUE;
                    int n6 = 0;
                    while (n6 < objectArray.length) {
                        int n7 = (Integer)objectArray[n6];
                        if (n7 < n4) {
                            n4 = n7;
                        } else if (n7 > n5) {
                            n5 = n7;
                        }
                        ++n6;
                    }
                    jSlider = new JSlider(0, n5 - n4, 1);
                    changeListener = new /* invalid duplicate definition of identical inner class */;
                    ((JLabel)((Object)changeListener)).setText("0     ");
                } else {
                    double d2 = Double.MAX_VALUE;
                    double d3 = Double.MIN_VALUE;
                    double d4 = 1.0;
                    if (clazz != null && clazz.equals(a == null ? AttributeChooser.a("java.lang.Double") : a)) {
                        int n8 = 0;
                        while (n8 < objectArray.length) {
                            double d5 = (Double)objectArray[n8];
                            if (d5 < d2) {
                                d2 = d5;
                            } else if (d5 > d3) {
                                d3 = d5;
                            }
                            ++n8;
                        }
                        d4 = (d3 - d2) / 10.0;
                    } else if (bl2) {
                        d2 = 0.0;
                        d3 = 1.0;
                        d4 = 0.9;
                    } else if (bl3) {
                        d2 = 0.0;
                        d3 = 2000.0;
                        d4 = 100.0;
                    }
                    double d6 = 10000.0;
                    int n9 = (int)((d3 - d2) * 10000.0) + 1;
                    jSlider = new JSlider(0, n9, (int)(d4 * 10000.0));
                    changeListener = new MyLabel(this){
                        private final AttributeChooser a;
                        {
                            this.a = attributeChooser;
                            super(attributeChooser);
                        }

                        public void stateChanged(ChangeEvent changeEvent) {
                            this.setText("" + (double)((JSlider)changeEvent.getSource()).getValue() / 10000.0);
                        }
                    };
                    ((JLabel)((Object)changeListener)).setText((double)((int)(d4 * 100.0)) / 100.0 + "  ");
                }
                hashMap.put("range", (Serializable)((Object)changeListener));
                jSlider.addChangeListener(changeListener);
                jPanel5.add(jSlider);
                jPanel5.add((Component)((Object)changeListener));
                jPanel.add((Component)jPanel5, "Center");
                if (!bl2 && !bl3) {
                    JCheckBox jCheckBox2 = new JCheckBox("Relative");
                    jPanel5.add(jCheckBox2);
                    hashMap.put("relative", jCheckBox2);
                } else if (bl2) {
                    JPanel jPanel6 = new JPanel(new GridLayout(4, 1));
                    jPanel6.add(new JLabel("Select correlation type to use:"));
                    ButtonGroup buttonGroup = new ButtonGroup();
                    JRadioButton jRadioButton = new JRadioButton("Pearson correlation", true);
                    buttonGroup.add(jRadioButton);
                    jPanel6.add(jRadioButton);
                    JRadioButton jRadioButton2 = new JRadioButton("Dot product");
                    buttonGroup.add(jRadioButton2);
                    jPanel6.add(jRadioButton2);
                    JRadioButton jRadioButton3 = new JRadioButton("Equivalence (within tolerance)");
                    buttonGroup.add(jRadioButton3);
                    jPanel6.add(jRadioButton3);
                    hashMap.put("corrType", buttonGroup);
                    jPanel.add((Component)jPanel6, "South");
                }
                jPanel2.add((Component)jPanel, "Center");
            } else if (clazz != null) {
                jPanel = new JPanel(new BorderLayout(5, 5));
                String[] stringArray = new String[objectArray.length];
                int n10 = 0;
                while (n10 < objectArray.length) {
                    stringArray[n10] = objectArray[n10].toString();
                    ++n10;
                }
                Arrays.sort(stringArray, String.CASE_INSENSITIVE_ORDER);
                JPanel jPanel7 = new JPanel(new BorderLayout(10, 10));
                jPanel7.add((Component)new JLabel("Available discrete categories:"), "North");
                JList<String> jList = new JList<String>(stringArray);
                jList.setBackground((Color)UIManager.getDefaults().get("Button.background"));
                JScrollPane jScrollPane = new JScrollPane(jList);
                jPanel7.add((Component)jScrollPane, "Center");
                jPanel.add((Component)jPanel7, "South");
                jPanel2.add(jPanel);
            }
            this.e.add(string, jPanel2);
            ++n3;
        }
        this.e.setSelectedIndex(1);
        this.e.repaint();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        Object[] objectArray = this.k.getSelectedValues();
        this.d = new String[objectArray.length];
        this.j.setEnabled(this.d.length > 0);
        this.c.setEnabled(this.d.length > 0);
        int n2 = 0;
        while (n2 < objectArray.length) {
            this.d[n2] = objectArray[n2].toString();
            ++n2;
        }
    }

    public void doubleClickedOnListBox(int n2) {
        System.err.println("DOUBLE CLIKED ON INDEX " + n2);
    }

    public static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

