/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.dreiss.httpdata;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;

public class NCBIUtils {
    public static String getPage(String string) throws Exception {
        return NCBIUtils.getPage(new URL(string));
    }

    public static String getPage(URL uRL) throws Exception {
        String string;
        boolean bl2 = false;
        StringBuffer stringBuffer = new StringBuffer();
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        int n2 = httpURLConnection.getResponseCode();
        String string2 = httpURLConnection.getContentType();
        int n3 = httpURLConnection.getContentLength();
        String string3 = httpURLConnection.getContentEncoding();
        if (n2 != 200) {
            throw new IOException("\nHTTP response code: " + n2);
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
        while ((string = bufferedReader.readLine()) != null) {
            stringBuffer.append(string);
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public static String getGINumber(String string) throws Exception {
        return NCBIUtils.getGINumber(string, "Saccharomyces cerevisiae");
    }

    public static String getGINumber(String string, String string2) throws Exception {
        String string3 = null;
        if (!string.startsWith("NP_") && !string.startsWith("XP_")) {
            string3 = NCBIUtils.getRefSeqFromOrfName(string);
        }
        if (string3 != null && !"".equals(string3) && string3.length() > 0) {
            string = string3;
        }
        String string4 = "http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=Protein&cmd=search&doptcmdl=DocSum&term=";
        string2 = string2.replace(' ', '+');
        String string5 = NCBIUtils.getPage(string4 + string + "+" + string2);
        int n2 = string5.indexOf("gi|");
        if (n2 < 0) {
            return "";
        }
        int n3 = string5.indexOf("|", n2 + 3);
        if (n3 < 0 || n3 <= n2) {
            return "";
        }
        String string6 = string5.substring(n2 + 3, n3);
        return string6;
    }

    public static String getCommonNameFromGINumber(String string) throws Exception {
        if (string == null || "".equals(string) || string.indexOf(32) >= 0) {
            return "";
        }
        String string2 = "http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=Protein&cmd=search&doptcmdl=DocSum&term=";
        String string3 = NCBIUtils.getPage(string2 + string);
        int n2 = string3.indexOf("p [Saccharomyces cerevisiae]");
        int n3 = n2 - 1;
        while (string3.charAt(n3) != ';') {
            --n3;
        }
        return string3.substring(n3 += 2, n2);
    }

    public static String getOrfNameFromRefSeq(String string) throws Exception {
        String string2 = "http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=Protein&cmd=search&doptcmdl=DocSum&term=";
        String string3 = NCBIUtils.getPage(string2 + string + "+Saccharomyces+cerevisiae");
        int n2 = string3.indexOf("p [Saccharomyces cerevisiae]");
        int n3 = n2 - 1;
        while (string3.charAt(n3) != ';') {
            --n3;
        }
        return string3.substring(n3 += 2, n2);
    }

    public static String getRefSeqFromOrfName(String string) throws Exception {
        int n2;
        String string2;
        int n3;
        String string3 = "http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=Protein&cmd=search&doptcmdl=DocSum&term=";
        string3 = string3 + string;
        if (!string.endsWith("p")) {
            string3 = string3 + "p";
        }
        if ((n3 = (string2 = NCBIUtils.getPage(string3 = string3 + "+Saccharomyces+cerevisiae")).indexOf("|NP_")) < 0) {
            n3 = string2.indexOf("|XP_");
        }
        if ((n2 = string2.indexOf(46, n3)) - n3 > 10 || n2 - n3 <= 0) {
            n2 = string2.indexOf(124, n3);
        }
        return string2.substring(n3 + 1, n2);
    }

    public static String getSequenceFromGINumber(String string) throws Exception {
        return NCBIUtils.getSequenceFromGINumber(string, null);
    }

    public static String getOrfNameFromGINumber(String string) throws Exception {
        String string2;
        if (string == null || "".equals(string) || string.indexOf(32) >= 0) {
            return "";
        }
        String string3 = "http://www.ncbi.nlm.nih.gov/entrez/viewer.fcgi?db=Protein&dopt=GenPept&val=";
        String string4 = NCBIUtils.getPage(string3 + string);
        int n2 = string4.indexOf(string2 = "/locus_tag=\"");
        if (n2 < 0) {
            return "";
        }
        int n3 = string4.indexOf("\"", (n2 += string2.length()) + 1);
        String string5 = string4.substring(n2, n3);
        return string5;
    }

    public static String getSequenceFromGINumber(String string, String string2) throws Exception {
        String string3;
        int n2;
        if (string == null || "".equals(string) || string.indexOf(32) >= 0) {
            return "";
        }
        String string4 = "http://www.ncbi.nlm.nih.gov/entrez/viewer.fcgi?db=Protein&dopt=GenPept&val=";
        String string5 = NCBIUtils.getPage(string4 + string);
        if (string2 != null && !"".equals(string2) && string5.toLowerCase().indexOf(string2.toLowerCase()) < 0) {
            System.err.println("Uh oh -- sequence retrieved may not be of species " + string2);
        }
        if ((n2 = string5.indexOf(string3 = "ORIGIN")) < 0) {
            return "";
        }
        int n3 = string5.indexOf("//", (n2 += string3.length()) + 1);
        String string6 = string5.substring(n2, n3);
        String[] stringArray = string6.split("\n");
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = 0;
        while (n4 < stringArray.length) {
            String string7 = stringArray[n4].trim();
            if (string7.length() != 0) {
                String[] stringArray2 = string7.split("\\s+");
                int n5 = 0;
                while (n5 < stringArray2.length) {
                    String string8 = stringArray2[n5];
                    if (!string8.matches("\\d+")) {
                        stringBuffer.append(string8);
                    }
                    ++n5;
                }
            }
            ++n4;
        }
        return stringBuffer.toString().toUpperCase();
    }

    public static String getSequence(String string) throws Exception {
        return NCBIUtils.getSequence(string, "Saccharomyces cerevisiae");
    }

    public static String getSequence(String string, String string2) throws Exception {
        String string3;
        block10: {
            string3 = "";
            try {
                if (string.startsWith("EST")) {
                    System.err.println("Unknown sequence type: EST");
                    break block10;
                }
                if (string.startsWith("IPI")) {
                    System.err.println("Unknown sequence type: IPI");
                    break block10;
                }
                if (string.startsWith("Hs.")) {
                    System.err.println("Unknown sequence type: Hs.");
                    break block10;
                }
                try {
                    if (string.startsWith("GI")) {
                        string = string.substring(2);
                    }
                    Integer.parseInt(string);
                    string3 = NCBIUtils.getSequenceFromGINumber(string, string2);
                }
                catch (Exception exception) {
                    try {
                        string3 = NCBIUtils.getSequenceFromGINumber(NCBIUtils.getGINumber(string, string2));
                    }
                    catch (Exception exception2) {
                        string3 = "";
                    }
                }
            }
            catch (Exception exception) {
                string3 = "";
            }
        }
        return string3;
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(NCBIUtils.getGINumber("Ref2"));
            System.out.println(NCBIUtils.getSequence(NCBIUtils.getGINumber("Ref2")));
            System.out.println(NCBIUtils.getRefSeqFromOrfName("Ref2") + "\n");
            System.out.println(NCBIUtils.getGINumber("NP_010481"));
            System.out.println(NCBIUtils.getSequence(NCBIUtils.getGINumber("NP_010481")));
            System.out.println(NCBIUtils.getOrfNameFromRefSeq("NP_010481"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

