/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.dreiss.homology;

import csplugins.isb.dreiss.homology.BlastPlugin;
import csplugins.isb.dreiss.httpdata.Homolog;
import csplugins.isb.dreiss.httpdata.HomologSet;
import csplugins.isb.dreiss.httpdata.client.BlastClient;
import csplugins.isb.dreiss.httpdata.client.DataClientFactory;
import csplugins.isb.dreiss.httpdata.client.FavoriteHomologClient;
import csplugins.isb.dreiss.httpdata.client.SynonymClient;
import csplugins.isb.dreiss.util.MonitoredAction;
import cytoscape.CytoscapeWindow;
import cytoscape.GraphObjAttributes;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;
import javax.jnlp.BasicService;
import javax.jnlp.ServiceManager;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SpinnerListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;

public class BlastDialog
extends JDialog {
    public BlastClient m;
    public FavoriteHomologClient i;
    public SynonymClient u;
    public CytoscapeWindow p;
    public HomologSet[] l;
    public HashMap d = new HashMap();
    public JSpinner n;
    public JSpinner b;
    public JComboBox s;
    public JComboBox t;
    public GraphObjAttributes j;
    public String[] a;
    public String h;
    public String q;
    public String[] w = new String[]{"BLOSUM80", "BLOSUM62", "BLOSUM50", "BLOSUM45", "PAM250", "BLOSUM62_20", "BLOSUM90", "PAM30", "PAM70"};
    public HashMap v = new HashMap();
    public Vector c = new Vector();
    public String o = "unknown";
    public double g = 0.01;
    public int f = 10;
    public double k = 200.0;
    public int e = 5;
    public boolean r = true;

    public BlastDialog(CytoscapeWindow cytoscapeWindow, BlastPlugin blastPlugin, String string, HomologSet[] homologSetArray) {
        this.p = cytoscapeWindow;
        this.l = homologSetArray;
        this.setTitle("Blast");
        this.a();
        this.b();
        this.j = cytoscapeWindow.getNodeAttributes();
        this.setContentPane(this.d());
        this.v = this.c();
        this.pack();
        this.setLocationRelativeTo(cytoscapeWindow.getMainFrame());
        this.setVisible(true);
    }

    public void a() {
        Properties properties = this.p.getConfiguration().getProperties();
        this.o = properties.getProperty("userName", this.o);
    }

    public void b() {
        String string;
        try {
            this.m = (BlastClient)DataClientFactory.getClient("blast");
            this.a = this.m.getSequenceFileNames().toArray(new String[0]);
        }
        catch (Exception exception) {
            string = "<html> Failed to contact blast server<p>";
            string = string + "<p> exception message: " + exception.getMessage() + "</html>";
            JOptionPane.showMessageDialog(this.p.getMainFrame(), string);
            exception.printStackTrace();
        }
        try {
            this.i = (FavoriteHomologClient)DataClientFactory.getClient("favoriteHomolog");
        }
        catch (Exception exception) {
            string = "<html> Failed to contact favorite homologs fetcher<p>";
            string = string + "<p> exception message: " + exception.getMessage() + "</html>";
            JOptionPane.showMessageDialog(this.p.getMainFrame(), string);
            exception.printStackTrace();
        }
        try {
            this.u = (SynonymClient)DataClientFactory.getClient("synonym");
        }
        catch (Exception exception) {
            string = "<html> Failed to contact synonym fetcher<p>";
            string = string + "<p> exception message: " + exception.getMessage() + "</html>";
            JOptionPane.showMessageDialog(this.p.getMainFrame(), string);
            exception.printStackTrace();
        }
    }

    public HashMap c() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("yeast.aa", "Saccharomyces cerevisiae");
        return hashMap;
    }

    public JPanel d() {
        JComponent jComponent;
        Object object;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JTabbedPane jTabbedPane = new JTabbedPane();
        int n2 = 0;
        while (n2 < this.l.length) {
            object = this.l[n2].getSourceSequenceCommonName();
            jComponent = this.a(this.l[n2], jTabbedPane);
            if (jComponent != null) {
                jTabbedPane.addTab((String)object, jComponent);
            }
            ++n2;
        }
        jPanel.add((Component)jTabbedPane, "Center");
        object = new JPanel();
        jPanel.add((Component)object, "South");
        jComponent = new JButton("Blast em all");
        ((Container)object).add(jComponent);
        ((AbstractButton)jComponent).addActionListener(new BlastEmAllAction(this));
        JButton jButton = new JButton("Dismiss");
        ((Container)object).add(jButton);
        jButton.addActionListener(new DismissAction(this));
        return jPanel;
    }

    public JPanel a(HomologSet homologSet, JTabbedPane jTabbedPane) {
        String string = homologSet.getSourceSequenceName();
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel(false);
        jPanel2.setLayout(new BorderLayout());
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        JPanel jPanel5 = new JPanel();
        jPanel4.add(jPanel5);
        jPanel5.setLayout(new BoxLayout(jPanel5, 1));
        JPanel jPanel6 = new JPanel();
        JPanel jPanel7 = new JPanel();
        JPanel jPanel8 = new JPanel();
        JPanel jPanel9 = new JPanel();
        JPanel jPanel10 = new JPanel();
        JPanel jPanel11 = new JPanel();
        JLabel jLabel = new JLabel("Target");
        this.t = new JComboBox<String>(this.a);
        this.t.addActionListener(new TargetSequenceFileComboBoxListener(this));
        int n2 = -1;
        int n3 = 0;
        while (n3 < this.a.length) {
            if (this.a[n3].equalsIgnoreCase("yeast.aa")) {
                n2 = n3;
            }
            ++n3;
        }
        if (n2 >= 0) {
            this.t.setSelectedIndex(n2);
        }
        jPanel7.add(jLabel);
        jPanel7.add(this.t);
        jLabel = new JLabel("Matrix");
        this.s = new JComboBox<String>(this.w);
        this.s.addActionListener(new BlastMatrixComboBoxListener(this));
        this.s.setSelectedIndex(1);
        jPanel8.add(jLabel);
        jPanel8.add(this.s);
        jPanel6.add(jPanel7);
        jPanel6.add(jPanel8);
        jPanel5.add(jPanel6);
        jLabel = new JLabel("max hits");
        this.b = new JSpinner();
        this.b.setValue(new Integer(10));
        Dimension dimension = this.b.getPreferredSize();
        this.b.setPreferredSize(new Dimension(80, (int)dimension.getHeight()));
        this.b.addChangeListener(new MaxHitsSpinnerListener(this));
        jPanel9.add(jLabel);
        jPanel9.add(this.b);
        jPanel11.add(jPanel9);
        SpinnerListModel spinnerListModel = new SpinnerListModel(new String[]{"1e-10", "0.1", "1.0"});
        jLabel = new JLabel("e value");
        this.n = new JSpinner(spinnerListModel);
        dimension = this.n.getPreferredSize();
        this.n.setPreferredSize(new Dimension(80, (int)dimension.getHeight()));
        this.n.addChangeListener(new eValueSpinnerListener(this));
        this.n.setValue("0.1");
        jPanel10.add(jLabel);
        jPanel10.add(this.n);
        jPanel11.add(jPanel10);
        jPanel5.add(jPanel11);
        JPanel jPanel12 = new JPanel();
        JButton jButton = new JButton("Run Blast");
        jPanel12.add(jButton);
        jPanel3.add((Component)jPanel4, "Center");
        jPanel3.add((Component)jPanel12, "South");
        jPanel2.add((Component)jPanel3, "North");
        String[][] stringArray = new String[0][0];
        ResultsTableModel resultsTableModel = new ResultsTableModel(this, stringArray);
        BlastAction blastAction = new BlastAction(this, resultsTableModel, homologSet);
        if (blastAction.isValid()) {
            this.c.add(blastAction);
            jButton.addActionListener(blastAction);
            JScrollPane jScrollPane = this.createResultsTable(resultsTableModel, homologSet.getSourceSequenceName());
            jPanel2.add((Component)jScrollPane, "Center");
            return jPanel2;
        }
        return null;
    }

    public String getSequence(String string, String string2) {
        if (this.j.hasAttribute("sequence", string2)) {
            return this.j.getStringValue("sequence", string2);
        }
        if (this.j.hasAttribute("sequence", string2 = this.getCanonicalName(string2, string))) {
            return this.j.getStringValue("sequence", string2);
        }
        return "";
    }

    public String getCanonicalName(String string, String string2) {
        String string3;
        int n2;
        String string4 = null;
        if (this.v.containsKey(string2)) {
            string2 = (String)this.v.get(string2);
        }
        Vector vector = null;
        try {
            vector = this.u.getSynonyms(string, string2);
        }
        catch (Exception exception) {
            vector = null;
        }
        if (vector != null) {
            int n3 = 0;
            n2 = vector.size();
            while (n3 < n2) {
                string3 = ((String)vector.get(n3)).toUpperCase();
                if ("Saccharomyces cerevisiae".equals(string2) && string3.startsWith("Y") && (string3.endsWith("C") || string3.endsWith("W") || string3.endsWith("-A") || string3.endsWith("-B"))) {
                    string4 = string3;
                    break;
                }
                ++n3;
            }
            if (string4 == null || string4.length() <= 0) {
                int n4 = 0;
                int n5 = vector.size();
                while (n4 < n5) {
                    String string5 = ((String)vector.get(n4)).toUpperCase();
                    if (string5.startsWith("NP_") || string5.startsWith("XP_")) {
                        string4 = string5;
                        break;
                    }
                    ++n4;
                }
            }
        }
        if (string4 == null || string4.length() <= 0) {
            try {
                string4 = this.p.getBioDataServer().getCanonicalName(string2, string);
                if (string4 != null && !"".equals(string4)) {
                    this.u.put(string, string4, string2);
                }
            }
            catch (Exception exception) {
                string4 = null;
            }
            if (vector != null && (string4 == null || string4.length() <= 0)) {
                int n6 = 0;
                n2 = vector.size();
                while (n6 < n2) {
                    string3 = ((String)vector.get(n6)).toUpperCase();
                    if (string3.startsWith("GI") || string3.startsWith("IPI")) {
                        string4 = string3;
                        break;
                    }
                    ++n6;
                }
            }
        }
        return string4;
    }

    public JScrollPane createResultsTable(ResultsTableModel resultsTableModel, String string) {
        JTable jTable = new JTable(resultsTableModel);
        jTable.addMouseListener(new MyMouseListener(this, jTable, string));
        int n2 = 200;
        Dimension dimension = jTable.getPreferredSize();
        int n3 = (int)dimension.getWidth();
        jTable.setPreferredScrollableViewportSize(new Dimension(n3, n2));
        JScrollPane jScrollPane = new JScrollPane(jTable);
        return jScrollPane;
    }

    public void a(String string, int n2, boolean bl2) {
        block4: {
            HomologSet homologSet = (HomologSet)this.d.get(string);
            String string2 = homologSet.getSourceSpecies();
            String string3 = homologSet.getSourceSequenceName();
            String string4 = homologSet.getTargetSpecies();
            String string5 = homologSet.getAll()[n2].getRefSeqID();
            String string6 = this.getCanonicalName(string5, string4);
            if (string6 == null || "".equals(string6)) {
                string6 = string5;
            }
            try {
                if (bl2) {
                    this.j.append("homolog", string3, string6);
                    this.i.add(this.o, string2, string3, string4, string6);
                    break block4;
                }
                this.j.deleteAttributeValue("homolog", string3, string6);
                this.i.delete(this.o, string2, string3, string4, string6);
            }
            catch (Exception exception) {
                String string7 = "Favorite homolog server failure: " + exception.getMessage();
                exception.printStackTrace();
                JOptionPane.showMessageDialog(this, string7);
            }
        }
    }

    public void a(URL uRL) {
        try {
            BasicService basicService = (BasicService)ServiceManager.lookup("javax.jnlp.BasicService");
            basicService.showDocument(uRL);
        }
        catch (Exception exception) {
            String string = "<html>You need to invoke Cytsocape through Java Web Start <br>in order to make use of your web browser from within the program.<br><br>Error message: " + exception.getMessage() + "</html>";
            JOptionPane.showMessageDialog(this, string);
        }
    }

    public class MyMouseListener
    implements MouseListener {
        public JTable a;
        public String b;
        private final BlastDialog c;

        public MyMouseListener(BlastDialog blastDialog, JTable jTable, String string) {
            this.c = blastDialog;
            this.a = jTable;
            this.b = string;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            block4: {
                String string;
                TableColumnModel tableColumnModel = this.a.getColumnModel();
                int n2 = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
                int n3 = mouseEvent.getY() / this.a.getRowHeight();
                if (n3 >= this.a.getRowCount() || n3 < 0 || n2 >= this.a.getColumnCount() || n2 < 0) {
                    return;
                }
                Object object = this.a.getValueAt(n3, n2);
                if (n2 == 6) {
                    boolean bl2 = (Boolean)object;
                    this.c.a(this.b, n3, bl2);
                }
                if (object == null || n2 != 5 || !(string = (String)object).toLowerCase().startsWith("http://")) break block4;
                try {
                    URL uRL = new URL(string);
                    System.out.println("URL: " + uRL);
                    this.c.a(uRL);
                }
                catch (MalformedURLException malformedURLException) {}
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }

    public class DismissAction
    extends AbstractAction {
        private final BlastDialog a;

        public DismissAction(BlastDialog blastDialog) {
            this.a = blastDialog;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.a.dispose();
        }
    }

    public class BlastEmAllAction
    extends MonitoredAction {
        private final BlastDialog c;

        public BlastEmAllAction(BlastDialog blastDialog) {
            this.c = blastDialog;
            super(blastDialog.p, "", "Blasting all these durn blasted nodes...");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            new Thread(this, actionEvent){
                private final ActionEvent b;
                private final BlastEmAllAction a;
                {
                    this.a = blastEmAllAction;
                    this.b = actionEvent;
                }

                public void run() {
                    int n2 = BlastEmAllAction.a((BlastEmAllAction)this.a).c.size();
                    int n3 = 0;
                    while (n3 < n2) {
                        BlastAction blastAction = (BlastAction)BlastEmAllAction.a((BlastEmAllAction)this.a).c.get(n3);
                        this.a.setProgress(n3, n2, (int)((double)n3 * 100.0 / (double)n2) + "%: " + blastAction.getName());
                        if (BlastEmAllAction.b(this.a)) break;
                        if (blastAction.isValid()) {
                            blastAction.actionPerformed(this.b);
                        }
                        ++n3;
                    }
                    this.a.setProgress(n2 + 1, n2, "Done");
                }
            }.start();
        }

        public static BlastDialog a(BlastEmAllAction blastEmAllAction) {
            return blastEmAllAction.c;
        }

        public static boolean b(BlastEmAllAction blastEmAllAction) {
            return blastEmAllAction.b;
        }
    }

    public class BlastMatrixComboBoxListener
    implements ActionListener {
        private final BlastDialog a;

        public BlastMatrixComboBoxListener(BlastDialog blastDialog) {
            this.a = blastDialog;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            this.a.q = (String)jComboBox.getSelectedItem();
        }
    }

    public class TargetSequenceFileComboBoxListener
    implements ActionListener {
        private final BlastDialog a;

        public TargetSequenceFileComboBoxListener(BlastDialog blastDialog) {
            this.a = blastDialog;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            this.a.h = (String)jComboBox.getSelectedItem();
        }
    }

    public class MaxHitsSpinnerListener
    implements ChangeListener {
        private final BlastDialog a;

        public MaxHitsSpinnerListener(BlastDialog blastDialog) {
            this.a = blastDialog;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JSpinner jSpinner = (JSpinner)changeEvent.getSource();
            this.a.f = (Integer)jSpinner.getValue();
        }
    }

    public class eValueSpinnerListener
    implements ChangeListener {
        private final BlastDialog a;

        public eValueSpinnerListener(BlastDialog blastDialog) {
            this.a = blastDialog;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JSpinner jSpinner = (JSpinner)changeEvent.getSource();
            String string = (String)jSpinner.getValue();
            try {
                this.a.g = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("eValueSpinnerListener, trouble parsing double: " + string);
            }
        }
    }

    public class ResultsTableModel
    extends AbstractTableModel {
        public String[] a;
        public Vector b;
        private final BlastDialog c;

        public ResultsTableModel(BlastDialog blastDialog, String[][] stringArray) {
            this.c = blastDialog;
            this.a = new String[]{"", "name 1", "name 2", "Species", "Score", "Link", "Keep?"};
            this.b = new Vector();
        }

        public void setData(Vector vector) {
            this.b = vector;
        }

        public Vector getData() {
            return this.b;
        }

        public int getColumnCount() {
            return this.a.length;
        }

        public int getRowCount() {
            return this.b.size();
        }

        public String getColumnName(int n2) {
            return this.a[n2];
        }

        public Class getColumnClass(int n2) {
            return this.getValueAt(0, n2).getClass();
        }

        public Object getValueAt(int n2, int n3) {
            Vector vector = (Vector)this.b.get(n2);
            Object e2 = vector.get(n3);
            return e2;
        }

        public void setValueAt(Object object, int n2, int n3) {
            Vector vector = (Vector)this.b.get(n2);
            vector.set(n3, object);
            this.fireTableCellUpdated(n2, n3);
        }

        public boolean isCellEditable(int n2, int n3) {
            return true;
        }
    }

    public class BlastAction
    extends AbstractAction {
        public ResultsTableModel d;
        public HomologSet c;
        public boolean a;
        private final BlastDialog b;

        public BlastAction(BlastDialog blastDialog, ResultsTableModel resultsTableModel, HomologSet homologSet) {
            this.b = blastDialog;
            this.a = false;
            this.d = resultsTableModel;
            this.c = homologSet;
            String string = homologSet.getSourceSequenceName();
            this.a = blastDialog.j.hasAttribute("sequence", string);
        }

        public boolean isValid() {
            return this.a;
        }

        public String getName() {
            return this.c.getSourceSequenceName();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Vector vector;
            String string;
            String string2 = "blastp";
            String string3 = this.c.getSourceSequenceName();
            String string4 = this.c.getSourceSpecies();
            String string5 = string3;
            this.b.j.deleteAttribute("homolog", string5);
            if (!string3.equals(string5)) {
                this.b.j.deleteAttribute("homolog", string3);
            }
            if (!((string = this.b.getSequence(string4, string5)) != null && string.length() != 0 || (string = this.b.getSequence(string4, string3)) != null && string.length() != 0)) {
                String string6 = "No sequence available for " + string3 + " (" + string5 + ") in species " + string4 + ".";
                JOptionPane.showMessageDialog(this.b, string6);
                return;
            }
            Homolog[] homologArray = null;
            boolean bl2 = false;
            try {
                this.b.m.setup(string2, string, string3, string4, this.b.h, this.b.g);
                this.b.m.setMatrix(this.b.q);
                this.b.m.run();
                HomologSet homologSet = this.b.m.getResults();
                this.b.d.put(homologSet.getSourceSequenceName(), homologSet);
                homologArray = homologSet.getAll();
                bl2 = true;
            }
            catch (Exception exception) {
                bl2 = false;
                System.err.println("Exception running blast on " + string3 + ": " + exception.getMessage());
                try {
                    this.b.m.run();
                    vector = this.b.m.getResults();
                    this.b.d.put(((HomologSet)((Object)vector)).getSourceSequenceName(), vector);
                    homologArray = ((HomologSet)((Object)vector)).getAll();
                    bl2 = true;
                }
                catch (Exception exception2) {
                    System.out.println("Exception running blast on " + string3 + ": " + exception2.getMessage());
                }
            }
            if (bl2) {
                try {
                    this.b.i.delete(this.b.o, string4, string5);
                }
                catch (Exception exception) {
                    vector = "FavoritesFetcher error when deleting previous values: " + exception.getMessage();
                    JOptionPane.showMessageDialog(this.b, vector);
                    return;
                }
            }
            int n2 = 0;
            if (homologArray != null) {
                n2 = homologArray.length;
            }
            if (n2 > this.b.f) {
                n2 = this.b.f;
            }
            vector = new Vector();
            int n3 = 0;
            int n4 = 0;
            while (n4 < n2) {
                Homolog homolog = homologArray[n4];
                Vector<Object> vector2 = new Vector<Object>();
                vector.add(vector2);
                vector2.add(new Integer(n4 + 1));
                vector2.add(this.b.getCanonicalName(homolog.getRefSeqID(), homolog.getTargetSpecies()));
                vector2.add(homolog.getRefSeqID());
                vector2.add(homolog.getTargetSpecies());
                double d2 = homolog.getScore();
                vector2.add(new Double(d2));
                String string7 = "http://www.ncbi.nlm.nih.gov/blast/bl2seq/wblast2.cgi?program=";
                string7 = string7 + "blastp";
                string7 = string7 + "&one=";
                string7 = string7 + string5;
                string7 = string7 + "&two=";
                String string8 = homolog.getRefSeqID();
                string7 = string7 + (string8.startsWith("Y") ? "" + homolog.getGiNumber() : string8);
                vector2.add(string7);
                boolean bl3 = this.b.r && d2 > this.b.k && n3++ < this.b.e;
                vector2.add(new Boolean(bl3));
                if (bl3) {
                    this.b.a(this.c.getSourceSequenceName(), n4, true);
                }
                ++n4;
            }
            this.d.setData(vector);
            this.d.fireTableStructureChanged();
        }
    }
}

