/*
 * Decompiled with CFR 0.152.
 */
package csplugins.graphAlgo.hierarchicalClustering;

import csplugins.util.CytoscapeProgressMonitor;
import csplugins.util.MonitoredTask;
import csplugins.util.SwingWorker;
import java.awt.Component;
import java.util.Arrays;

public class SimilarityCalculator
implements MonitoredTask {
    public double[][] l;
    public double[] m;
    public double[][] d;
    public double n;
    public double o;
    public double q;
    public int h;
    public boolean p;
    public boolean k;
    public boolean b;
    public boolean[][] j;
    public int e;
    public int f;
    public boolean c;
    public boolean g;
    public String i;
    public String a;

    public SimilarityCalculator(double[][] dArray, int n2, boolean bl2) {
        this(dArray, null, n2, bl2, false, false);
    }

    public SimilarityCalculator(int[][] nArray, int n2, boolean bl2) {
        if (nArray == null) {
            throw new IllegalArgumentException("The input_matrix argument must not be null.");
        }
        int n3 = nArray.length;
        int n4 = nArray[0].length;
        this.l = new double[n3][n4];
        for (int i2 = 0; i2 < n3; ++i2) {
            for (int i3 = 0; i3 < n4; ++i3) {
                this.l[i2][i3] = nArray[i2][i3] == Integer.MAX_VALUE ? Double.MAX_VALUE : (double)nArray[i2][i3];
            }
        }
        this.m = bl2 ? new double[n4] : new double[n3];
        Arrays.fill(this.m, 1.0);
        this.h = n2;
        if (SimilarityCalculator.getCategory(this.h) == 1) {
            switch (this.h) {
                case 3: {
                    this.a = "Calculating Manhattan Distances...";
                    break;
                }
                default: {
                    this.a = "Calculating Unknown Distances...";
                    break;
                }
            }
        } else {
            this.a = "Calculating Similarities...";
        }
        this.p = bl2;
        this.k = false;
        this.b = false;
        this.a();
    }

    public SimilarityCalculator(double[][] dArray, double[] dArray2, int n2, boolean bl2, boolean bl3, boolean bl4) {
        if (dArray == null) {
            throw new IllegalArgumentException("The input_matrix argument must not be null.");
        }
        this.l = dArray;
        if (dArray2 == null) {
            dArray2 = bl2 ? new double[dArray[0].length] : new double[dArray.length];
            Arrays.fill(dArray2, 1.0);
        }
        this.m = dArray2;
        this.h = n2;
        this.a = SimilarityCalculator.getCategory(this.h) == 1 ? "Calculating Distances..." : "Calculating Similarities...";
        this.p = bl2;
        this.k = bl3;
        this.b = bl4;
        this.a();
    }

    public double[][] getSimilarities() {
        return this.d;
    }

    public double getMaxSimilarity() {
        return this.n;
    }

    public double getNonSelfMaxSimilarity() {
        return this.o;
    }

    public double getMinSimilarity() {
        return this.q;
    }

    public void a() {
        if (this.l != null) {
            int n2 = this.p ? this.l[0].length : this.l.length;
            this.e = n2 * n2 - (n2 - 1) * n2 / 2;
        } else {
            this.e = 0;
        }
        this.f = 0;
        this.c = false;
        this.g = false;
        this.i = "Completed 0%";
        this.q = Double.NaN;
        this.n = Double.NaN;
        this.o = Double.NaN;
    }

    public void incrementProgress() {
        ++this.f;
        double d2 = this.f * 100 / this.e;
        this.i = "Completed " + d2 + "%";
    }

    public int getCurrent() {
        return this.f;
    }

    public int getLengthOfTask() {
        return this.e;
    }

    public String getMessage() {
        return this.i;
    }

    public String getTaskName() {
        return this.a;
    }

    public String getName() {
        return "Similarity Calculator";
    }

    public boolean done() {
        return this.c;
    }

    public void cancel() {
        this.g = true;
    }

    public boolean wasCanceled() {
        return this.g;
    }

    public void calculateSimsAndMonitor(Component component) {
        this.c = false;
        this.g = false;
        this.i = "Completed 0%";
        this.q = Double.NaN;
        this.n = Double.NaN;
        this.o = Double.NaN;
        this.f = 0;
        CytoscapeProgressMonitor cytoscapeProgressMonitor = new CytoscapeProgressMonitor(this, component);
        cytoscapeProgressMonitor.startMonitor(true);
    }

    public Object construct() {
        System.out.println("Calculating sims/dists between vectors..");
        int n2 = this.p ? this.l[0].length : this.l.length;
        this.e = n2 * n2 - (n2 - 1) * n2 / 2;
        this.d = new double[n2][n2];
        this.n = Double.MIN_VALUE;
        this.o = Double.MIN_VALUE;
        this.q = Double.MAX_VALUE;
        block6: for (int i2 = 0; i2 < n2 && !this.g; ++i2) {
            for (int i3 = i2; i3 < n2; ++i3) {
                double d2;
                if (this.j != null && !this.j[i2][i3]) {
                    this.d[i2][i3] = Double.NaN;
                    this.d[i3][i2] = Double.NaN;
                    ++this.f;
                    d2 = this.f * 100 / this.e;
                    this.i = "Completed " + d2 + "%";
                    continue;
                }
                double d3 = 1.0;
                switch (this.h) {
                    case 1: {
                        if (i2 == i3) break;
                        d3 = SimilarityCalculator.a(this.l, this.l, this.m, i2, i3, this.p, this.k, this.b, null);
                        break;
                    }
                    case 0: {
                        d3 = SimilarityCalculator.c(this.l, this.l, this.m, i2, i3, this.p, this.k, this.b, null);
                        break;
                    }
                    case 2: {
                        d3 = SimilarityCalculator.d(this.l, this.l, this.m, i2, i3, this.p, this.k, this.b, null);
                        break;
                    }
                    case 3: {
                        d3 = SimilarityCalculator.b(this.l, this.l, this.m, i2, i3, this.p, this.k, this.b, null);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid similarity metric: " + this.h + ".  It should be COS, DOT_PRODUCT, or EUC.");
                    }
                }
                this.d[i2][i3] = d3;
                this.d[i3][i2] = d3;
                if (this.q > d3) {
                    this.q = d3;
                }
                if (d3 < Double.MAX_VALUE && this.n < d3) {
                    this.n = d3;
                }
                if (i2 != i3 && d3 < Double.MAX_VALUE && this.o < d3) {
                    this.o = d3;
                }
                if (this.g) {
                    this.d = null;
                    this.q = Double.NaN;
                    this.n = Double.NaN;
                    this.o = Double.NaN;
                    continue block6;
                }
                ++this.f;
                d2 = this.f * 100 / this.e;
                this.i = "Completed " + d2 + "%";
            }
        }
        this.c = true;
        System.out.println("...Done calculating sims/dists between vectors.");
        return this.d;
    }

    public void go(boolean bl2) {
        SwingWorker swingWorker = new SwingWorker(this){
            private final SimilarityCalculator a;
            {
                this.a = similarityCalculator;
            }

            public Object construct() {
                return this.a.construct();
            }
        };
        swingWorker.start();
        if (bl2) {
            swingWorker.get();
        }
    }

    public void stop() {
        this.c = true;
    }

    public static double a(double[][] dArray, double[][] dArray2, double[] dArray3, int n2, int n3, boolean bl2, boolean bl3, boolean bl4, boolean[] blArray) {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        int n4 = bl2 ? dArray.length : dArray[n2].length;
        for (int i2 = 0; i2 < n4; ++i2) {
            if (blArray != null && !blArray[i2] || dArray3[i2] == 0.0) continue;
            if (bl2) {
                if (Double.isNaN(dArray[i2][n2]) || Double.isNaN(dArray2[i2][n3])) continue;
                d2 += dArray3[i2] * dArray[i2][n2];
                d3 += dArray3[i2] * dArray2[i2][n3];
                d4 += dArray3[i2] * dArray[i2][n2] * dArray2[i2][n3];
                d5 += dArray3[i2] * Math.pow(dArray[i2][n2], 2.0);
                d6 += dArray3[i2] * Math.pow(dArray2[i2][n3], 2.0);
                d7 += dArray3[i2];
                continue;
            }
            if (Double.isNaN(dArray[n2][i2]) || Double.isNaN(dArray2[n3][i2])) continue;
            d2 += dArray3[i2] * dArray[n2][i2];
            d3 += dArray3[i2] * dArray2[n3][i2];
            d4 += dArray3[i2] * dArray[n2][i2] * dArray2[n3][i2];
            d5 += dArray3[i2] * Math.pow(dArray[n2][i2], 2.0);
            d6 += dArray3[i2] * Math.pow(dArray2[n3][i2], 2.0);
            d7 += dArray3[i2];
        }
        if (d7 == 0.0) {
            return 0.0;
        }
        double d8 = 0.0;
        if (bl3) {
            double d9 = d2 / d7;
            double d10 = d3 / d7;
            double d11 = Math.sqrt((d5 - 2.0 * d9 * d2 + d7 * Math.pow(d9, 2.0)) * (d6 - 2.0 * d10 * d3 + d7 * Math.pow(d10, 2.0)));
            if (d11 > 0.0) {
                d8 = (d4 - d2 * d10 - d3 * d9 + d7 * d9 * d10) / d11;
            }
        } else {
            double d12 = Math.sqrt(d5 * d6);
            if (d12 > 0.0) {
                d8 = d4 / d12;
            }
        }
        if (bl4 && d8 < 0.0) {
            return 0.0 - d8;
        }
        return d8;
    }

    public static double c(double[][] dArray, double[][] dArray2, double[] dArray3, int n2, int n3, boolean bl2, boolean bl3, boolean bl4, boolean[] blArray) {
        double d2 = 0.0;
        int n4 = bl2 ? dArray.length : dArray[n2].length;
        for (int i2 = 0; i2 < n4; ++i2) {
            if (blArray != null && !blArray[i2]) continue;
            if (bl2) {
                d2 += dArray[i2][n2] * dArray2[i2][n3];
                continue;
            }
            d2 += dArray[n2][i2] * dArray2[n3][i2];
        }
        return d2;
    }

    public static double d(double[][] dArray, double[][] dArray2, double[] dArray3, int n2, int n3, boolean bl2, boolean bl3, boolean bl4, boolean[] blArray) {
        int n4;
        double d2 = 0.0;
        int n5 = n4 = bl2 ? dArray.length : dArray[n2].length;
        for (int i2 = 0; i2 < n4; ++i2) {
            if (blArray != null && !blArray[i2]) {
                --n5;
                continue;
            }
            if (bl2) {
                d2 += Math.pow(dArray[i2][n2] - dArray2[i2][n3], 2.0);
                continue;
            }
            d2 += Math.pow(dArray[n2][i2] - dArray2[n3][i2], 2.0);
        }
        if (d2 == 0.0) {
            return 1.0;
        }
        return 1.0 / Math.sqrt(d2 / (double)n5);
    }

    public static double b(double[][] dArray, double[][] dArray2, double[] dArray3, int n2, int n3, boolean bl2, boolean bl3, boolean bl4, boolean[] blArray) {
        int n4 = bl2 ? dArray.length : dArray[n2].length;
        double d2 = 0.0;
        if (bl2) {
            for (int i2 = 0; i2 < n4; ++i2) {
                if (blArray != null && !blArray[i2]) continue;
                if (dArray[i2][n2] == Double.MAX_VALUE && dArray2[i2][n3] != Double.MAX_VALUE) {
                    d2 = Double.MAX_VALUE;
                    break;
                }
                if (dArray[i2][n2] != Double.MAX_VALUE && dArray2[i2][n3] == Double.MAX_VALUE) {
                    d2 = Double.MAX_VALUE;
                    break;
                }
                d2 += Math.abs(dArray[i2][n2] - dArray2[i2][n3]);
            }
        } else {
            for (int i3 = 0; i3 < n4; ++i3) {
                if (blArray != null && !blArray[i3]) continue;
                if (dArray[n2][i3] == Double.MAX_VALUE && dArray2[n3][i3] != Double.MAX_VALUE) {
                    d2 = Double.MAX_VALUE;
                    break;
                }
                if (dArray[n2][i3] != Double.MAX_VALUE && dArray2[n3][i3] == Double.MAX_VALUE) {
                    d2 = Double.MAX_VALUE;
                    break;
                }
                d2 += Math.abs(dArray[n2][i3] - dArray2[n3][i3]);
            }
        }
        return d2;
    }

    public static double[][] calculateSimilarities(double[][] dArray, double[] dArray2, int n2, boolean bl2, boolean[][] blArray) {
        return SimilarityCalculator.calculateSimilarities(dArray, dArray2, n2, bl2, false, false, blArray);
    }

    public static double[][] calculateSimilarities(double[][] dArray, double[] dArray2, int n2, boolean bl2, boolean bl3, boolean bl4, boolean[][] blArray) {
        SimilarityCalculator similarityCalculator = new SimilarityCalculator(dArray, dArray2, n2, bl2, bl3, bl4);
        similarityCalculator.useFilter(blArray);
        SwingWorker swingWorker = new SwingWorker(similarityCalculator){
            private final SimilarityCalculator a;
            {
                this.a = similarityCalculator;
            }

            public Object construct() {
                return this.a.construct();
            }
        };
        swingWorker.start();
        return (double[][])swingWorker.get();
    }

    public static double a(double[] dArray, double[] dArray2, double[] dArray3, int n2, boolean bl2, boolean bl3, boolean[] blArray) {
        double d2;
        double[][] dArrayArray = new double[][]{dArray};
        double[][] dArrayArray2 = new double[][]{dArray2};
        switch (n2) {
            case 1: {
                d2 = SimilarityCalculator.a(dArrayArray, dArrayArray2, dArray3, 0, 0, false, bl2, bl3, blArray);
                break;
            }
            case 0: {
                d2 = SimilarityCalculator.c(dArrayArray, dArrayArray2, dArray3, 0, 0, false, bl2, bl3, blArray);
                break;
            }
            case 2: {
                d2 = SimilarityCalculator.d(dArrayArray, dArrayArray2, dArray3, 0, 0, false, bl2, bl3, blArray);
                break;
            }
            case 3: {
                d2 = SimilarityCalculator.b(dArrayArray, dArrayArray2, dArray3, 0, 0, false, bl2, bl3, blArray);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid similarity metric: " + n2 + ".  It should be COS, DOT_PRODUCT, or EUC.");
            }
        }
        return d2;
    }

    public static int getCategory(int n2) {
        switch (n2) {
            case 0: 
            case 1: 
            case 2: {
                return 0;
            }
            case 3: {
                return 1;
            }
        }
        System.out.println("Unknown similarity metric " + n2);
        System.out.flush();
        return -1;
    }

    public void useFilter(boolean[][] blArray) {
        this.j = blArray;
    }
}

