/*
 * Decompiled with CFR 0.152.
 */
package csplugins.graphAlgo.hierarchicalClustering;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;

public class ClusterNode
extends DefaultMutableTreeNode {
    public static final Comparator p = new AscendingDistanceBetweenChildrenComparator();
    public double o = 0.0;
    public int f;
    public NodeFaces n;
    public NodeFaces j;
    public boolean q;

    public ClusterNode(Object object) {
        this.setUserObject(object);
        this.b();
    }

    public ClusterNode(Object object, boolean bl2) {
        this.setUserObject(object);
        this.setAllowsChildren(!bl2);
        this.b();
    }

    public void b() {
        this.f = -1;
        this.n = null;
        this.j = null;
        this.q = true;
    }

    public void setDistanceBetweenChildren(double d2) {
        this.o = d2;
    }

    public double getDistanceBetweenChildren() {
        return this.o;
    }

    public void setOrientation(int n2) {
        this.f = n2;
    }

    public int getOrientation() {
        return this.f;
    }

    public void setOutFirst(boolean bl2) {
        this.q = bl2;
    }

    public boolean isOutFirst() {
        return this.q;
    }

    public ClusterNode getBranch(int n2) {
        switch (n2) {
            case 0: {
                return this.getLeftBranch();
            }
            case 1: {
                return this.getRightBranch();
            }
            case 2: {
                return this.getOutsideBranch();
            }
            case 3: {
                return this.getInsideBranch();
            }
            case 4: {
                return this.getFirstBranch();
            }
            case 5: {
                return this.getLastBranch();
            }
        }
        throw new IllegalArgumentException("Unknown branch type: " + n2);
    }

    public ClusterNode getLeftBranch() {
        if (this.isLeaf()) {
            return null;
        }
        return (ClusterNode)this.getChildAt(0);
    }

    public ClusterNode getRightBranch() {
        if (this.isLeaf()) {
            return null;
        }
        int n2 = this.getChildCount();
        return (ClusterNode)this.getChildAt(n2 - 1);
    }

    public ClusterNode getOutsideBranch() {
        if (this.f == 0) {
            return this.getLeftBranch();
        }
        if (this.f == 1) {
            return this.getRightBranch();
        }
        return this.getLeftBranch();
    }

    public ClusterNode getInsideBranch() {
        if (this.f == 0) {
            return this.getRightBranch();
        }
        if (this.f == 1) {
            return this.getLeftBranch();
        }
        return this.getRightBranch();
    }

    public ClusterNode getFirstBranch() {
        if (this.isOutFirst()) {
            return this.getOutsideBranch();
        }
        return this.getInsideBranch();
    }

    public ClusterNode getLastBranch() {
        if (this.isOutFirst()) {
            return this.getInsideBranch();
        }
        return this.getOutsideBranch();
    }

    public NodeFaces getFaces(int n2) {
        switch (n2) {
            case 0: {
                return this.getLeftFaces();
            }
            case 1: {
                return this.getRightFaces();
            }
            case 2: {
                return this.getOutsideFaces();
            }
            case 3: {
                return this.getInsideFaces();
            }
            case 4: {
                return this.getFirstFaces();
            }
            case 5: {
                return this.getLastFaces();
            }
        }
        throw new IllegalArgumentException("Unknown branch type: " + n2);
    }

    public NodeFaces getLeftFaces() {
        if (this.n == null) {
            this.n = new NodeFaces(this, 0);
        }
        return this.n;
    }

    public NodeFaces getRightFaces() {
        if (this.j == null) {
            this.j = new NodeFaces(this, 1);
        }
        return this.j;
    }

    public NodeFaces getOutsideFaces() {
        if (this.f == 0) {
            return this.getLeftFaces();
        }
        if (this.f == 1) {
            return this.getRightFaces();
        }
        return null;
    }

    public NodeFaces getInsideFaces() {
        if (this.f == 0) {
            return this.getRightFaces();
        }
        if (this.f == 1) {
            return this.getLeftFaces();
        }
        return null;
    }

    public NodeFaces getFirstFaces() {
        if (this.isOutFirst()) {
            return this.getOutsideFaces();
        }
        return this.getInsideFaces();
    }

    public NodeFaces getLastFaces() {
        if (this.isOutFirst()) {
            return this.getInsideFaces();
        }
        return this.getOutsideFaces();
    }

    public boolean equals(Object object) {
        return object instanceof DefaultMutableTreeNode && (((DefaultMutableTreeNode)object).getUserObject() == this.getUserObject() || this.getUserObject() != null && this.getUserObject().equals(((DefaultMutableTreeNode)object).getUserObject())) || object == this.getUserObject() || this.getUserObject() != null && this.getUserObject().equals(object);
    }

    public Iterator leafIterator() {
        return new Iterator(this){
            public boolean a;
            public ClusterNode e;
            public ClusterNode b;
            public ClusterNode c;
            private final ClusterNode d;
            {
                this.d = clusterNode;
                this.a = false;
            }

            public boolean hasNext() {
                if (!this.a) {
                    this.b = this.d;
                    this.a = true;
                }
                if (this.c != null) {
                    return true;
                }
                if (this.b == null) {
                    return false;
                }
                while (this.b != null && !this.b.isLeaf()) {
                    this.e = this.b;
                    this.b = this.e.getFirstBranch();
                    this.b.setOutFirst(true);
                }
                if (this.b == null) {
                    return false;
                }
                this.c = this.b;
                if (this.e == null) {
                    System.err.println("ClusterNode.leafIterator got to parent==null (?)");
                    System.out.flush();
                    this.b = null;
                    return true;
                }
                while (this.e.getLastBranch() == this.b) {
                    this.b = this.e;
                    this.e = (ClusterNode)this.b.getParent();
                    if (this.e != null && this.b != this.d) continue;
                    this.b = null;
                    return true;
                }
                this.b = this.e.getLastBranch();
                this.b.setOutFirst(false);
                return true;
            }

            public Object next() {
                if (this.c == null && !this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ClusterNode clusterNode = this.c;
                this.c = null;
                return clusterNode;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Set rootSet(double d2) {
        HashSet hashSet = new HashSet();
        ClusterNode.rootSet(this, d2, hashSet);
        return hashSet;
    }

    public static void rootSet(ClusterNode clusterNode, double d2, Set hashSet) {
        if (hashSet == null) {
            hashSet = new HashSet<ClusterNode>();
        }
        if (clusterNode == null) {
            return;
        }
        if (!Double.isNaN(clusterNode.getDistanceBetweenChildren()) && clusterNode.getDistanceBetweenChildren() <= d2) {
            hashSet.add(clusterNode);
            return;
        }
        int n2 = clusterNode.getChildCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            ClusterNode.rootSet((ClusterNode)clusterNode.getChildAt(i2), d2, hashSet);
        }
    }

    public static void joinSet(ClusterNode clusterNode, int n2, Set hashSet) {
        if (hashSet == null) {
            hashSet = new HashSet();
        }
        if (clusterNode == null) {
            return;
        }
    }

    public static class AscendingDistanceBetweenChildrenComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            int n2;
            if (object == object2) {
                return 0;
            }
            double d2 = ((ClusterNode)object).getDistanceBetweenChildren() - ((ClusterNode)object2).getDistanceBetweenChildren();
            if (d2 < 0.0) {
                return -1;
            }
            if (d2 > 0.0) {
                return 1;
            }
            int n3 = object.toString().hashCode();
            if (n3 != (n2 = object2.toString().hashCode())) {
                return n3 - n2;
            }
            return -1;
        }
    }

    public class NodeFaces {
        public int b;
        public ClusterNode a;
        private final ClusterNode c;

        public NodeFaces(ClusterNode clusterNode, int n2) {
            this.c = clusterNode;
            if (n2 != 0 && n2 != 1) {
                throw new IllegalArgumentException("The branchType of a NodeFaces may be either LEFT or RIGHT, not " + n2 + ".");
            }
            this.b = n2;
            if (clusterNode.isLeaf() || clusterNode.getChildCount() == 1) {
                clusterNode.f = 0;
            }
            if (clusterNode.isLeaf()) {
                this.a = clusterNode;
            } else if (this.b == 0 && clusterNode.f != 1) {
                this.a = clusterNode.getLeftBranch();
            } else if (this.b == 1 && clusterNode.f != 0) {
                this.a = clusterNode.getRightBranch();
            }
        }

        public int size() {
            if (this.c.isLeaf() || this.c.getChildCount() == 1) {
                if (this.b == 0) {
                    return 1;
                }
                return 0;
            }
            if (this.a != null && (this.b == 0 && this.c.f == 1 || this.b == 1 && this.c.f == 0)) {
                this.a = null;
            }
            if (this.a == null) {
                return 0;
            }
            return this.a.getLeftFaces().size() + this.a.getRightFaces().size();
        }

        public ClusterNode get(int n2) {
            if (this.c.isLeaf()) {
                if (n2 == 0 && this.b == 0) {
                    return this.c;
                }
                throw new NoSuchElementException("\"" + this.c + "\"." + (this.b == 0 ? "leftFace" : "rightFace") + ".get( " + n2 + " ): ClusterNode is a leaf and either this is the not the first face or the index is out of range.");
            }
            if (this.c.getChildCount() == 1) {
                if (n2 == 0 && this.b == 0) {
                    return (ClusterNode)this.c.getChildAt(0);
                }
                throw new NoSuchElementException("\"" + this.c + "\"." + (this.b == 0 ? "leftFace" : "rightFace") + ".get( " + n2 + " ): ClusterNode has one child and either this is not the first face or the index is out of range.");
            }
            if (this.a != null && (this.b == 0 && this.c.f == 1 || this.b == 1 && this.c.f == 0)) {
                this.a = null;
            }
            if (this.a == null) {
                throw new NoSuchElementException("\"" + this.c + "\"." + (this.b == 0 ? "leftFace" : "rightFace") + ".get( " + n2 + " ): outsideBranch is null.  Orientation is " + (this.c.f == 0 ? "LEFT_BRANCH_OUTSIDE" : (this.c.f == 1 ? "RIGHT_BRANCH_OUTSIDE" : "UNDETERMINED")) + ".");
            }
            if (n2 < this.a.getLeftFaces().size()) {
                return this.a.getLeftFaces().get(n2);
            }
            return this.a.getRightFaces().get(n2 - this.a.getLeftFaces().size());
        }

        public boolean contains(ClusterNode clusterNode) {
            if (this.c.isLeaf()) {
                return this.b == 0 && clusterNode == this.c;
            }
            if (this.c.getChildCount() == 1) {
                return this.b == 0 && clusterNode.getParent() == this.c;
            }
            if (this.a != null && (this.b == 0 && this.c.f == 1 || this.b == 1 && this.c.f == 0)) {
                this.a = null;
            }
            if (this.a == null) {
                return false;
            }
            return this.a.getLeftFaces().contains(clusterNode) || this.a.getRightFaces().contains(clusterNode);
        }

        public void select(ClusterNode clusterNode, Set set) {
            if (this.a == null) {
                throw new IllegalStateException("\"" + this.c + "\"." + (this.b == 0 ? "leftFace" : "rightFace") + ": Unable to select( " + clusterNode + ", " + set + " ) because the orientation of this ClusterNode, " + this.c + " has already been determined to be " + (this.c.f == 0 ? "LEFT_BRANCH_OUTSIDE" : (this.c.f == 1 ? "RIGHT_BRANCH_OUTSIDE" : "UNDETERMINED")) + ".");
            }
            if (this.a.f != -1) {
                return;
            }
            HashSet<ClusterNode> hashSet = new HashSet<ClusterNode>();
            HashSet<ClusterNode> hashSet2 = new HashSet<ClusterNode>();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                ClusterNode clusterNode2 = (ClusterNode)iterator.next();
                if (this.a.getLeftFaces().contains(clusterNode2)) {
                    hashSet.add(clusterNode2);
                    continue;
                }
                if (!this.a.getRightFaces().contains(clusterNode2)) continue;
                hashSet2.add(clusterNode2);
            }
            if (hashSet.isEmpty() && hashSet2.isEmpty()) {
                throw new RuntimeException("ASSERTION FAILED: Both subsets are empty.");
            }
            if (hashSet.isEmpty()) {
                this.a.f = clusterNode == this.c ? 0 : 1;
                this.a.getRightFaces().select(clusterNode, hashSet2);
            } else if (hashSet2.isEmpty()) {
                this.a.f = clusterNode == this.c ? 1 : 0;
                this.a.getLeftFaces().select(clusterNode, hashSet);
            } else {
                this.a.getLeftFaces().select(clusterNode, hashSet);
                this.a.getRightFaces().select(clusterNode, hashSet2);
            }
        }
    }
}

