/*
 * Decompiled with CFR 0.152.
 */
package csplugins.expressionData;

import csplugins.expressionData.ExpressionRatioValues;
import csplugins.expressionData.Plot2D;
import csplugins.vectormath.MathVectorFactory;
import cytoscape.AbstractPlugin;
import cytoscape.CytoscapeWindow;
import cytoscape.GraphObjAttributes;
import cytoscape.data.ExpressionData;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

public class ExpressionProfileViewer
extends AbstractPlugin {
    private CytoscapeWindow a;

    public ExpressionProfileViewer(CytoscapeWindow cytoscapeWindow) {
        this.a = cytoscapeWindow;
        cytoscapeWindow.getOperationsMenu().add(new ExpressionProfileViewerAction(this));
    }

    public String describe() {
        return new String("Views expression profiles in a 2-D plot.");
    }

    public static CytoscapeWindow a(ExpressionProfileViewer expressionProfileViewer) {
        return expressionProfileViewer.a;
    }

    protected class ExpressionProfileViewerAction
    extends AbstractAction {
        private final ExpressionProfileViewer a;

        public ExpressionProfileViewerAction(ExpressionProfileViewer expressionProfileViewer) {
            super("Expression Profile Viewer...");
            this.a = expressionProfileViewer;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            ExpressionProfileViewer.a(this.a).setInteractivity(false);
            eI eI2 = ExpressionProfileViewer.a(this.a).getGraph();
            if (eI2 == null) {
                String string = "The current graph is empty...";
                JOptionPane.showMessageDialog(ExpressionProfileViewer.a(this.a).getMainFrame(), string);
                ExpressionProfileViewer.a(this.a).setInteractivity(true);
                return;
            }
            ExpressionData expressionData = ExpressionProfileViewer.a(this.a).getExpressionData();
            if (expressionData == null) {
                String string = "No expression matrix has been loaded....";
                JOptionPane.showMessageDialog(ExpressionProfileViewer.a(this.a).getMainFrame(), string);
                ExpressionProfileViewer.a(this.a).setInteractivity(true);
                return;
            }
            ap ap2 = eI2.B();
            if (ap2.g() < 1) {
                String string = "Please select one or more nodes and try again.";
                JOptionPane.showMessageDialog(ExpressionProfileViewer.a(this.a).getMainFrame(), string);
                ExpressionProfileViewer.a(this.a).setInteractivity(true);
                return;
            }
            ap2.f();
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            while (ap2.b()) {
                object = ap2.k();
                arrayList2.add(((hm)object).toString());
                String string = ExpressionProfileViewer.a(this.a).getCanonicalNodeName((hm)object);
                arrayList.add(string);
                ap2.c();
            }
            object = null;
            try {
                object = new Plot2D("expression profiles", "Condition", "Expression");
            }
            catch (Exception exception) {
                ExpressionProfileViewer.a(this.a).getLogger().severe("Could not create plotter window");
                exception.printStackTrace();
                ExpressionProfileViewer.a(this.a).setInteractivity(true);
                return;
            }
            int n2 = expressionData.getNumberOfConditions();
            GraphObjAttributes graphObjAttributes = ExpressionProfileViewer.a(this.a).getNodeAttributes();
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                String string = (String)arrayList.get(i2);
                ExpressionRatioValues expressionRatioValues = new ExpressionRatioValues(expressionData, string, graphObjAttributes);
                if (expressionRatioValues.size() != n2) continue;
                double[] dArray = MathVectorFactory.makeReadOnlyVector(expressionRatioValues).getNewDataArray();
                String string2 = (String)arrayList2.get(i2);
                try {
                    ((Plot2D)object).addData(string2, dArray);
                    continue;
                }
                catch (Exception exception) {
                    ExpressionProfileViewer.a(this.a).getLogger().severe("Error loading data into plotter window");
                    exception.printStackTrace();
                    ExpressionProfileViewer.a(this.a).setInteractivity(true);
                    return;
                }
            }
            ((Window)object).pack();
            ((Plot2D)object).placeInCenter();
            ((Window)object).show();
            ExpressionProfileViewer.a(this.a).setInteractivity(true);
        }
    }
}

