/*
 * Decompiled with CFR 0.152.
 */
package csplugins.expressionData;

import csplugins.expressionData.ExpressionCorrelation;
import cytoscape.AbstractPlugin;
import cytoscape.CytoscapeWindow;
import cytoscape.GraphObjAttributes;
import cytoscape.data.ExpressionData;
import cytoscape.visual.NodeAppearanceCalculator;
import cytoscape.visual.VisualMappingManager;
import cytoscape.visual.calculators.GenericNodeColorCalculator;
import cytoscape.visual.calculators.NodeColorCalculator;
import cytoscape.visual.mappings.BoundaryRangeValues;
import cytoscape.visual.mappings.ContinuousMapping;
import cytoscape.visual.mappings.LinearNumberToColorInterpolator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsConfiguration;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ExpressionCorrelationViewer
extends AbstractPlugin {
    private CytoscapeWindow b;
    private double a = 0.0;

    public ExpressionCorrelationViewer(CytoscapeWindow cytoscapeWindow) {
        this.b = cytoscapeWindow;
        cytoscapeWindow.getOperationsMenu().add(new ExpressionCorrelationViewerAction(this));
    }

    public String describe() {
        return new String("Provides visualization of the correlation of gene expression vectors with a sample expression vector.");
    }

    private void a(JFrame jFrame, double[] dArray, NodeColorCalculator nodeColorCalculator) {
        String string = "Restore previous display?";
        int n2 = 0;
        int n3 = JOptionPane.showConfirmDialog(jFrame, string, "", n2);
        if (n3 == 0) {
            VisualMappingManager visualMappingManager = this.b.getVizMapManager();
            NodeAppearanceCalculator nodeAppearanceCalculator = visualMappingManager.getVisualStyle().getNodeAppearanceCalculator();
            nodeAppearanceCalculator.setNodeFillColorCalculator(nodeColorCalculator);
            if (dArray != null) {
                GraphObjAttributes graphObjAttributes = this.b.getNodeAttributes();
                eI eI2 = this.b.getGraph();
                hm[] hmArray = eI2.R();
                for (int i2 = 0; i2 < eI2.K(); ++i2) {
                    String string2 = this.b.getCanonicalNodeName(hmArray[i2]);
                    graphObjAttributes.set("expressionCorrelation", string2, dArray[i2]);
                }
            }
            this.b.redrawGraph();
        }
        jFrame.dispose();
    }

    public void a(JFrame jFrame) {
        GraphicsConfiguration graphicsConfiguration = jFrame.getGraphicsConfiguration();
        int n2 = (int)graphicsConfiguration.getBounds().getHeight();
        int n3 = (int)graphicsConfiguration.getBounds().getWidth();
        int n4 = jFrame.getWidth();
        int n5 = jFrame.getHeight();
        jFrame.setLocation((n3 - n4) / 2, (n2 - n5) / 2);
    }

    public static CytoscapeWindow a(ExpressionCorrelationViewer expressionCorrelationViewer) {
        return expressionCorrelationViewer.b;
    }

    public static double a(ExpressionCorrelationViewer expressionCorrelationViewer, double d2) {
        expressionCorrelationViewer.a = d2;
        return expressionCorrelationViewer.a;
    }

    public static double b(ExpressionCorrelationViewer expressionCorrelationViewer) {
        return expressionCorrelationViewer.a;
    }

    public static void a(ExpressionCorrelationViewer expressionCorrelationViewer, JFrame jFrame, double[] dArray, NodeColorCalculator nodeColorCalculator) {
        expressionCorrelationViewer.a(jFrame, dArray, nodeColorCalculator);
    }

    protected class DismissAction
    extends AbstractAction {
        private JFrame b;
        private double[] c;
        private NodeColorCalculator d;
        private final ExpressionCorrelationViewer a;

        public DismissAction(ExpressionCorrelationViewer expressionCorrelationViewer, JFrame jFrame, double[] dArray, NodeColorCalculator nodeColorCalculator) {
            this.a = expressionCorrelationViewer;
            this.b = jFrame;
            this.c = dArray;
            this.d = nodeColorCalculator;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ExpressionCorrelationViewer.a(this.a, this.b, this.c, this.d);
        }
    }

    protected class ExpressionCorrelationDoneListener
    extends WindowAdapter {
        private JFrame a;
        private double[] b;
        private NodeColorCalculator c;
        private final ExpressionCorrelationViewer d;

        public ExpressionCorrelationDoneListener(ExpressionCorrelationViewer expressionCorrelationViewer, JFrame jFrame, double[] dArray, NodeColorCalculator nodeColorCalculator) {
            this.d = expressionCorrelationViewer;
            this.a = jFrame;
            this.b = dArray;
            this.c = nodeColorCalculator;
        }

        public void windowClosing(WindowEvent windowEvent) {
            ExpressionCorrelationViewer.a(this.d, this.a, this.b, this.c);
        }
    }

    protected class ExpressionCorrelationSelectionListener
    implements ActionListener {
        private eI a;
        private final ExpressionCorrelationViewer b;

        public ExpressionCorrelationSelectionListener(ExpressionCorrelationViewer expressionCorrelationViewer, eI eI2) {
            this.b = expressionCorrelationViewer;
            this.a = eI2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ExpressionCorrelationViewer.a(this.b).deselectAllNodes(false);
            hm[] hmArray = this.a.R();
            GraphObjAttributes graphObjAttributes = ExpressionCorrelationViewer.a(this.b).getNodeAttributes();
            for (int i2 = 0; i2 < hmArray.length; ++i2) {
                String string = graphObjAttributes.getCanonicalName(hmArray[i2]);
                Double d2 = (Double)graphObjAttributes.get("expressionCorrelation", string);
                if (d2 == null || !(Math.abs(d2) > ExpressionCorrelationViewer.b(this.b))) continue;
                this.a.a(hmArray[i2], true);
            }
            ExpressionCorrelationViewer.a(this.b).redrawGraph();
        }
    }

    protected class ExpressionCorrelationSliderListener
    implements ChangeListener {
        private ContinuousMapping a;
        private final ExpressionCorrelationViewer b;

        public ExpressionCorrelationSliderListener(ExpressionCorrelationViewer expressionCorrelationViewer, ContinuousMapping continuousMapping) {
            this.b = expressionCorrelationViewer;
            this.a = continuousMapping;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JSlider jSlider = (JSlider)changeEvent.getSource();
            if (!jSlider.getValueIsAdjusting()) {
                ExpressionCorrelationViewer.a(this.b, (double)jSlider.getValue() / 100.0);
                Set set = this.a.keySet();
                Iterator iterator = set.iterator();
                iterator.next();
                Object k2 = iterator.next();
                Object k3 = iterator.next();
                Object v2 = this.a.get(k2);
                Object v3 = this.a.get(k3);
                this.a.remove(k2);
                this.a.remove(k3);
                this.a.put(new Double(-ExpressionCorrelationViewer.b(this.b)), v2);
                this.a.put(new Double(ExpressionCorrelationViewer.b(this.b)), v3);
                ExpressionCorrelationViewer.a(this.b).redrawGraph();
            }
        }
    }

    protected class ExpressionCorrelationViewerAction
    extends AbstractAction {
        private final ExpressionCorrelationViewer a;

        public ExpressionCorrelationViewerAction(ExpressionCorrelationViewer expressionCorrelationViewer) {
            super("Expression Correlation Finder...");
            this.a = expressionCorrelationViewer;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            Object object2;
            Object object3;
            String[] stringArray;
            eI eI2 = ExpressionCorrelationViewer.a(this.a).getGraph();
            if (eI2 == null) {
                String string = "The current graph is empty...";
                JOptionPane.showMessageDialog(ExpressionCorrelationViewer.a(this.a).getMainFrame(), string);
                return;
            }
            ap ap2 = eI2.B();
            if (ap2.g() < 1) {
                String string = "Please select one or more nodes and try again.";
                JOptionPane.showMessageDialog(ExpressionCorrelationViewer.a(this.a).getMainFrame(), string);
                return;
            }
            ap2.f();
            ArrayList<String> arrayList = new ArrayList<String>();
            while (ap2.b()) {
                stringArray = ap2.k();
                object3 = ExpressionCorrelationViewer.a(this.a).getCanonicalNodeName((hm)stringArray);
                arrayList.add((String)object3);
                ap2.c();
            }
            stringArray = arrayList.toArray(new String[0]);
            object3 = ExpressionCorrelationViewer.a(this.a).getExpressionData();
            if (object3 == null) {
                String string = "No expression matrix has been loaded....";
                JOptionPane.showMessageDialog(ExpressionCorrelationViewer.a(this.a).getMainFrame(), string);
                return;
            }
            ExpressionCorrelation expressionCorrelation = new ExpressionCorrelation((ExpressionData)object3, ExpressionCorrelationViewer.a(this.a).getNodeAttributes());
            Map map = expressionCorrelation.buildCorrelationTable(stringArray);
            GraphObjAttributes graphObjAttributes = ExpressionCorrelationViewer.a(this.a).getNodeAttributes();
            hm[] hmArray = eI2.R();
            double[] dArray = null;
            if (graphObjAttributes.hasAttribute("expressionCorrelation")) {
                dArray = new double[hmArray.length];
                Arrays.fill(dArray, 0.0);
            }
            for (int i2 = 0; i2 < eI2.K(); ++i2) {
                object2 = graphObjAttributes.getCanonicalName(hmArray[i2]);
                if (dArray != null && (object = graphObjAttributes.getValue("expressionCorrelation", (String)object2)) != null && object instanceof Double) {
                    dArray[i2] = (Double)object;
                }
                graphObjAttributes.set("expressionCorrelation", (String)object2, map.get(object2));
            }
            VisualMappingManager visualMappingManager = ExpressionCorrelationViewer.a(this.a).getVizMapManager();
            object2 = visualMappingManager.getVisualStyle().getNodeAppearanceCalculator();
            object = ((NodeAppearanceCalculator)object2).getNodeFillColorCalculator();
            GenericNodeColorCalculator genericNodeColorCalculator = this.a();
            ((NodeAppearanceCalculator)object2).setNodeFillColorCalculator(genericNodeColorCalculator);
            NodeColorCalculator nodeColorCalculator = visualMappingManager.getCalculatorCatalog().getNodeColorCalculator("expressionCorrelation");
            if (nodeColorCalculator == null) {
                visualMappingManager.getCalculatorCatalog().addNodeColorCalculator(genericNodeColorCalculator);
            }
            ExpressionCorrelationViewer.a(this.a).redrawGraph();
            JSlider jSlider = new JSlider(0, 0, 100, 0);
            jSlider.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
            jSlider.setMajorTickSpacing(10);
            jSlider.setMinorTickSpacing(1);
            jSlider.setPaintTicks(true);
            jSlider.setPaintLabels(true);
            ContinuousMapping continuousMapping = (ContinuousMapping)genericNodeColorCalculator.getMapping(0);
            jSlider.addChangeListener(new ExpressionCorrelationSliderListener(this.a, continuousMapping));
            JButton jButton = new JButton("Select nodes above threshold");
            jButton.addActionListener(new ExpressionCorrelationSelectionListener(this.a, eI2));
            JFrame jFrame = new JFrame("Expression Correlation");
            Container container = jFrame.getContentPane();
            container.setLayout(new BorderLayout());
            String string = System.getProperty("line.separator");
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<html>");
            stringBuffer.append("The correlation of the normalized expression vector");
            stringBuffer.append(" for each gene<p>");
            stringBuffer.append("with the average of the normalized expression vectors<p>");
            stringBuffer.append("for your selection is shown.<br><br>");
            stringBuffer.append("Correlation values range from +1 (correlated) to");
            stringBuffer.append(" -1 (anti-correlated).<br><br>");
            stringBuffer.append("Red indicates high correlation, while green indicates<p>");
            stringBuffer.append(" anti-correlation (large negative values).<p><p>");
            stringBuffer.append("Use the slider below to set a threshold percent");
            stringBuffer.append(" correlation<p> (i.e., 50% == +/- 0.5).<p>");
            stringBuffer.append("Absolute values smaller than this threshold will be");
            stringBuffer.append(" colored white.<p></html>");
            JPanel jPanel = new JPanel();
            jPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
            jPanel.add((Component)new JLabel(stringBuffer.toString()), "Center");
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BorderLayout());
            jPanel2.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
            jPanel2.add((Component)jSlider, "Center");
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new BorderLayout());
            container.add((Component)jPanel3, "Center");
            jPanel3.add((Component)jPanel, "Center");
            jPanel3.add((Component)jPanel2, "South");
            JPanel jPanel4 = new JPanel();
            JButton jButton2 = new JButton("Dismiss");
            jButton2.addActionListener(new DismissAction(this.a, jFrame, dArray, (NodeColorCalculator)object));
            container.add((Component)jPanel4, "South");
            jPanel4.add(jButton);
            jPanel4.add(jButton2);
            jFrame.addWindowListener(new ExpressionCorrelationDoneListener(this.a, jFrame, dArray, (NodeColorCalculator)object));
            jFrame.pack();
            this.a.a(jFrame);
            jFrame.setVisible(true);
        }

        private GenericNodeColorCalculator a() {
            Color color = new Color(0, 255, 0);
            BoundaryRangeValues boundaryRangeValues = new BoundaryRangeValues(color, color, color);
            Color color2 = new Color(200, 255, 200);
            Color color3 = new Color(255, 255, 255);
            BoundaryRangeValues boundaryRangeValues2 = new BoundaryRangeValues(color2, color3, color3);
            Color color4 = new Color(255, 200, 200);
            BoundaryRangeValues boundaryRangeValues3 = new BoundaryRangeValues(color3, color3, color4);
            Color color5 = new Color(255, 0, 0);
            BoundaryRangeValues boundaryRangeValues4 = new BoundaryRangeValues(color5, color5, color5);
            LinearNumberToColorInterpolator linearNumberToColorInterpolator = new LinearNumberToColorInterpolator();
            ContinuousMapping continuousMapping = new ContinuousMapping(Color.WHITE, "expressionCorrelation", linearNumberToColorInterpolator, 1);
            continuousMapping.put(new Double(-1.001), boundaryRangeValues);
            continuousMapping.put(new Double(-0.001), boundaryRangeValues2);
            continuousMapping.put(new Double(0.001), boundaryRangeValues3);
            continuousMapping.put(new Double(1.001), boundaryRangeValues4);
            return new GenericNodeColorCalculator("expressionCorrelation", continuousMapping);
        }
    }
}

