/*
 * Decompiled with CFR 0.152.
 */
package csplugins.expressionData;

import csplugins.expressionData.ExpressionRatioValues;
import csplugins.vectormath.MathVector;
import csplugins.vectormath.MathVectorFactory;
import csplugins.vectormath.ReadOnlyMathVector;
import cytoscape.GraphObjAttributes;
import cytoscape.data.ExpressionData;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class ExpressionCorrelation {
    private ExpressionData b;
    private Map a = new HashMap();
    private GraphObjAttributes c;

    public ExpressionCorrelation() {
    }

    public ExpressionCorrelation(ExpressionData expressionData) {
        this.setExpressionData(expressionData);
    }

    public ExpressionCorrelation(ExpressionData expressionData, GraphObjAttributes graphObjAttributes) {
        this(expressionData);
        this.setNodeAttributes(graphObjAttributes);
    }

    public void setExpressionData(ExpressionData expressionData) {
        this.b = expressionData;
    }

    public void setNodeAttributes(GraphObjAttributes graphObjAttributes) {
        this.c = graphObjAttributes;
    }

    public Map buildCorrelationTable(String string) {
        this.a.clear();
        if (this.b == null) {
            return this.a;
        }
        ExpressionRatioValues expressionRatioValues = new ExpressionRatioValues(this.b, string, this.c);
        if (expressionRatioValues.size() == 0) {
            return this.a;
        }
        ReadOnlyMathVector readOnlyMathVector = MathVectorFactory.makeReadOnlyVector(expressionRatioValues);
        return this.buildCorrelationTable(readOnlyMathVector);
    }

    public Map buildCorrelationTable(String[] stringArray) {
        this.a.clear();
        if (this.b == null || stringArray == null || stringArray.length == 0) {
            return this.a;
        }
        int n2 = this.b.getNumberOfConditions();
        double[] dArray = new double[n2];
        Arrays.fill(dArray, 0.0);
        MathVector mathVector = MathVectorFactory.makeVector(dArray);
        int n3 = 0;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            ExpressionRatioValues expressionRatioValues = new ExpressionRatioValues(this.b, stringArray[i2], this.c);
            if (expressionRatioValues.size() == 0) continue;
            ReadOnlyMathVector readOnlyMathVector = MathVectorFactory.makeReadOnlyVector(expressionRatioValues);
            mathVector.add(readOnlyMathVector.copy().normalize());
            ++n3;
        }
        if (n3 == 0) {
            return this.a;
        }
        mathVector.times(1.0 / (double)n3);
        return this.buildCorrelationTable(mathVector);
    }

    public Map buildCorrelationTable(ReadOnlyMathVector readOnlyMathVector) {
        this.a.clear();
        int n2 = this.b.getNumberOfConditions();
        if (readOnlyMathVector.size() != n2) {
            return this.a;
        }
        String[] stringArray = null;
        if (this.c != null) {
            String[] stringArray2 = this.c.getObjectNames("metaNode");
            stringArray = new String[this.b.getNumberOfGenes() + stringArray2.length];
            System.arraycopy(this.b.getGeneNames(), 0, stringArray, 0, this.b.getNumberOfGenes());
            System.arraycopy(stringArray2, 0, stringArray, this.b.getNumberOfGenes(), stringArray2.length);
        } else {
            stringArray = this.b.getGeneNames();
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            ExpressionRatioValues expressionRatioValues = new ExpressionRatioValues(this.b, stringArray[i2], this.c);
            ReadOnlyMathVector readOnlyMathVector2 = MathVectorFactory.makeReadOnlyVector(expressionRatioValues);
            Double d2 = new Double(readOnlyMathVector.dotNorm(readOnlyMathVector2));
            this.a.put(stringArray[i2], d2);
        }
        return this.a;
    }

    public Map getCorrelationTable() {
        return this.a;
    }
}

