/*
 * Decompiled with CFR 0.152.
 */
package csplugins.expressionData;

import csplugins.expressionData.Plot2D;
import cytoscape.AbstractPlugin;
import cytoscape.CytoscapeWindow;
import cytoscape.data.ExpressionData;
import cytoscape.data.mRNAMeasurement;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class ConditionProfileViewer
extends AbstractPlugin {
    private CytoscapeWindow a;

    public ConditionProfileViewer(CytoscapeWindow cytoscapeWindow) {
        this.a = cytoscapeWindow;
        cytoscapeWindow.getOperationsMenu().add(new ConditionProfileViewerAction(this));
    }

    public String describe() {
        return new String("Comparing expression profiles for different experimental conditions.");
    }

    public static CytoscapeWindow a(ConditionProfileViewer conditionProfileViewer) {
        return conditionProfileViewer.a;
    }

    protected class ConditionProfileViewerAction
    extends AbstractAction {
        private final ConditionProfileViewer a;

        public ConditionProfileViewerAction(ConditionProfileViewer conditionProfileViewer) {
            super("ConditionProfileViewer");
            this.a = conditionProfileViewer;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            Object object2;
            eI eI2 = ConditionProfileViewer.a(this.a).getGraph();
            if (eI2 == null) {
                String string = "The current graph is empty...";
                JOptionPane.showMessageDialog(ConditionProfileViewer.a(this.a).getMainFrame(), string);
                return;
            }
            ExpressionData expressionData = ConditionProfileViewer.a(this.a).getExpressionData();
            if (expressionData == null) {
                String string = "No expression matrix has been loaded....";
                JOptionPane.showMessageDialog(ConditionProfileViewer.a(this.a).getMainFrame(), string);
                return;
            }
            ap ap2 = eI2.B();
            if (ap2.g() < 1) {
                String string = "Please select one or more nodes and try again.";
                JOptionPane.showMessageDialog(ConditionProfileViewer.a(this.a).getMainFrame(), string);
                return;
            }
            ap2.f();
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            while (ap2.b()) {
                object2 = ap2.k();
                arrayList2.add(((hm)object2).toString());
                String string = ConditionProfileViewer.a(this.a).getCanonicalNodeName((hm)object2);
                arrayList.add(string);
                ap2.c();
            }
            object2 = null;
            try {
                object2 = new Plot2D("condition profiles", "Gene", "Expression");
            }
            catch (Exception exception) {
                ConditionProfileViewer.a(this.a).getLogger().severe("Could not create plotter window");
                exception.printStackTrace();
                return;
            }
            int n2 = expressionData.getNumberOfConditions();
            String[] stringArray = expressionData.getConditionNames();
            for (int i2 = 0; i2 < n2; ++i2) {
                object = new double[arrayList.size()];
                for (int i3 = 0; i3 < arrayList.size(); ++i3) {
                    String string = (String)arrayList.get(i3);
                    mRNAMeasurement mRNAMeasurement2 = expressionData.getMeasurement(string, stringArray[i2]);
                    object[i3] = mRNAMeasurement2 == null ? (Object)0.0 : (Object)mRNAMeasurement2.getRatio();
                }
                try {
                    ((Plot2D)object2).addData(stringArray[i2], (double[])object);
                    continue;
                }
                catch (Exception exception) {
                    ConditionProfileViewer.a(this.a).getLogger().severe("Error loading data into plotter window");
                    exception.printStackTrace();
                    return;
                }
            }
            JFrame jFrame = new JFrame("condition profiles");
            jFrame.addWindowListener(new WindowAdapter(this, jFrame){
                private final JFrame b;
                private final ConditionProfileViewerAction a;
                {
                    this.a = conditionProfileViewerAction;
                    this.b = jFrame;
                }

                public void windowClosing(WindowEvent windowEvent) {
                    this.b.dispose();
                }
            });
            object = jFrame.getContentPane();
            ((Container)object).add(((JFrame)object2).getContentPane());
            jFrame.pack();
            jFrame.show();
        }
    }
}

