/*
 * Decompiled with CFR 0.152.
 */
package csplugins.dynamicXpr;

import csplugins.dynamicXpr.dialogs.DynamicExpressionDialog;
import cytoscape.CytoscapeWindow;
import cytoscape.GraphObjAttributes;
import cytoscape.data.ExpressionData;
import cytoscape.visual.NodeAppearanceCalculator;
import cytoscape.visual.VisualMappingManager;
import cytoscape.visual.calculators.GenericNodeColorCalculator;
import cytoscape.visual.calculators.NodeColorCalculator;
import cytoscape.visual.mappings.BoundaryRangeValues;
import cytoscape.visual.mappings.ContinuousMapping;
import cytoscape.visual.mappings.LinearNumberToColorInterpolator;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.Timer;

public class DynamicExpression
extends AbstractAction {
    public CytoscapeWindow f;
    public Timer c;
    public DisplayFramesAction e;
    public DynamicExpressionDialog d;
    public int k;
    public File b;
    public NodeColorCalculator h;
    public NodeColorCalculator j;
    public HashMap g;

    public DynamicExpression(CytoscapeWindow cytoscapeWindow) {
        super("Dynamic Expression...");
        this.f = cytoscapeWindow;
        this.b = new File(System.getProperty("user.dir"));
        this.k = -1;
    }

    public DynamicExpression(CytoscapeWindow cytoscapeWindow, JMenu jMenu) {
        this(cytoscapeWindow);
        if (jMenu != null) {
            jMenu.add(this);
        }
    }

    public void b() {
        GraphObjAttributes graphObjAttributes = this.f.getNodeAttributes();
        this.g = graphObjAttributes.getAttribute("node.fillColor");
        graphObjAttributes.deleteAttribute("node.fillColor");
        VisualMappingManager visualMappingManager = this.f.getVizMapManager();
        NodeAppearanceCalculator nodeAppearanceCalculator = visualMappingManager.getVisualStyle().getNodeAppearanceCalculator();
        this.h = nodeAppearanceCalculator.getNodeFillColorCalculator();
        if (this.j == null) {
            this.a();
        }
        nodeAppearanceCalculator.setNodeFillColorCalculator(this.j);
        NodeColorCalculator nodeColorCalculator = visualMappingManager.getCalculatorCatalog().getNodeColorCalculator("dynamicXpr");
        if (nodeColorCalculator == null) {
            visualMappingManager.getCalculatorCatalog().addNodeColorCalculator(this.j);
        }
    }

    public void adjustForNewExpressionData() {
    }

    public boolean expressionAttributeExists() {
        GraphObjAttributes graphObjAttributes = this.f.getNodeAttributes();
        return graphObjAttributes.hasAttribute("expression");
    }

    public NodeColorCalculator getDynamicXprColorCalculator() {
        return this.j;
    }

    public NodeColorCalculator a() {
        LinearNumberToColorInterpolator linearNumberToColorInterpolator = new LinearNumberToColorInterpolator();
        ContinuousMapping continuousMapping = new ContinuousMapping(new Color(204, 204, 204), "expression", linearNumberToColorInterpolator, 1);
        BoundaryRangeValues boundaryRangeValues = new BoundaryRangeValues();
        boundaryRangeValues.a = new Color(0, 0, 255);
        boundaryRangeValues.b = new Color(0, 0, 255);
        boundaryRangeValues.c = new Color(0, 0, 255);
        continuousMapping.put(new Double(-1.0), boundaryRangeValues);
        boundaryRangeValues = new BoundaryRangeValues();
        boundaryRangeValues.a = new Color(255, 255, 255);
        boundaryRangeValues.b = new Color(255, 255, 255);
        boundaryRangeValues.c = new Color(255, 255, 255);
        continuousMapping.put(new Double(0.0), boundaryRangeValues);
        boundaryRangeValues = new BoundaryRangeValues();
        boundaryRangeValues.a = new Color(255, 0, 0);
        boundaryRangeValues.b = new Color(255, 0, 0);
        boundaryRangeValues.c = new Color(255, 0, 0);
        continuousMapping.put(new Double(1.0), boundaryRangeValues);
        this.j = new GenericNodeColorCalculator("dynamicXpr", continuousMapping);
        return this.j;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.d == null) {
            this.d = new DynamicExpressionDialog(this, "Dynamic Expression");
        }
        this.b();
        this.d.pack();
        this.d.setLocationRelativeTo(this.f.getMainFrame());
        this.d.setVisible(true);
    }

    public void restoreOldNodeColorCalculator() {
        VisualMappingManager visualMappingManager = this.f.getVizMapManager();
        NodeAppearanceCalculator nodeAppearanceCalculator = visualMappingManager.getVisualStyle().getNodeAppearanceCalculator();
        nodeAppearanceCalculator.setNodeFillColorCalculator(this.h);
        if (this.g != null) {
            GraphObjAttributes graphObjAttributes = this.f.getNodeAttributes();
            Set set = this.g.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Object v2 = this.g.get(string);
                graphObjAttributes.set("node.fillColor", string, v2);
            }
        }
        this.f.redrawGraph(false, true);
    }

    public void play(int n2) {
        ExpressionData expressionData = this.f.getExpressionData();
        if (expressionData == null) {
            return;
        }
        if (this.e == null) {
            this.e = new DisplayFramesAction(this, expressionData.getConditionNames());
        }
        if (this.c != null) {
            this.c.stop();
        }
        this.c = new Timer(n2, this.e);
        this.c.setInitialDelay(0);
        this.c.start();
        this.k = 0;
    }

    public void setTimerDelay(int n2) {
        if (this.c == null) {
            return;
        }
        this.c.setDelay(n2);
    }

    public void displayCondition(String string) {
        ExpressionData expressionData = this.f.getExpressionData();
        GraphObjAttributes graphObjAttributes = this.f.getNodeAttributes();
        String[] stringArray = expressionData.getGeneNames();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            double d2 = expressionData.getMeasurement(stringArray[i2], string).getRatio();
            graphObjAttributes.set("expression", stringArray[i2], d2);
        }
        VisualMappingManager visualMappingManager = this.f.getVizMapManager();
        visualMappingManager.applyNodeFillColor();
        this.f.redrawGraph(false, false);
    }

    public static void displayCondition(CytoscapeWindow cytoscapeWindow, String string) {
        ExpressionData expressionData = cytoscapeWindow.getExpressionData();
        if (expressionData == null) {
            return;
        }
        GraphObjAttributes graphObjAttributes = cytoscapeWindow.getNodeAttributes();
        String[] stringArray = expressionData.getGeneNames();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            double d2 = expressionData.getMeasurement(stringArray[i2], string).getRatio();
            graphObjAttributes.set("expression", stringArray[i2], d2);
        }
        VisualMappingManager visualMappingManager = cytoscapeWindow.getVizMapManager();
        visualMappingManager.applyNodeFillColor();
        cytoscapeWindow.redrawGraph(false, false);
    }

    public void stop() {
        this.c.stop();
        this.e.reset();
        this.k = -1;
    }

    public void pause() {
        if (this.k == 1) {
            this.c.start();
            this.k = 0;
        } else if (this.k == 0) {
            this.c.stop();
            this.k = 1;
        }
    }

    public int isPaused() {
        return this.k;
    }

    public CytoscapeWindow getCytoscapeWindow() {
        return this.f;
    }

    public class DisplayFramesAction
    implements ActionListener {
        public String[] c;
        public int a;
        private final DynamicExpression b;

        public DisplayFramesAction(DynamicExpression dynamicExpression, String[] stringArray) {
            this.b = dynamicExpression;
            this.c = stringArray;
            this.a = 0;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.a < this.c.length) {
                this.b.d.updateConditionsSlider(this.a, this.c[this.a]);
                this.b.displayCondition(this.c[this.a]);
                ++this.a;
            } else {
                this.b.stop();
                this.b.d.conditionsSliderEnabled(true);
            }
        }

        public void reset() {
            this.a = 0;
        }
    }
}

